/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.spi.indexing.support;

import java.io.IOException;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.impl.indexing.FileObjectIndexable;
import org.netbeans.modules.parsing.impl.indexing.IndexFactoryImpl;
import org.netbeans.modules.parsing.impl.indexing.IndexImpl;
import org.netbeans.modules.parsing.impl.indexing.SPIAccessor;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public final class IndexingSupport {
    private static final Logger LOG = Logger.getLogger(IndexingSupport.class.getName());
    private final Context context;
    private final IndexFactoryImpl spiFactory;
    private final IndexImpl spiIndex;

    private IndexingSupport(Context context) throws IOException {
        IndexFactoryImpl indexFactoryImpl = SPIAccessor.getInstance().getIndexFactory(context);
        assert (indexFactoryImpl != null);
        this.context = context;
        this.spiFactory = indexFactoryImpl;
        this.spiIndex = this.spiFactory.createIndex(context);
    }

    public static IndexingSupport getInstance(Context context) throws IOException {
        Parameters.notNull((CharSequence)"context", (Object)context);
        IndexingSupport indexingSupport = SPIAccessor.getInstance().context_getAttachedIndexingSupport(context);
        if (indexingSupport == null) {
            indexingSupport = new IndexingSupport(context);
            SPIAccessor.getInstance().context_attachIndexingSupport(context, indexingSupport);
        }
        return indexingSupport;
    }

    public boolean isValid() {
        try {
            return this.spiIndex.isValid();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public IndexDocument createDocument(FileObject fileObject) {
        FileObject fileObject2 = this.context.getRoot();
        if (FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) {
            return this.createDocument(SPIAccessor.getInstance().create(new FileObjectIndexable(fileObject2, fileObject)));
        }
        throw new IllegalArgumentException(fileObject + " is not under the root " + fileObject2);
    }

    public IndexDocument createDocument(Indexable indexable) {
        Parameters.notNull((CharSequence)"indexable", (Object)indexable);
        return new IndexDocument(this.spiFactory.createDocument(indexable));
    }

    public void addDocument(IndexDocument indexDocument) {
        Parameters.notNull((CharSequence)"document", (Object)indexDocument.spi);
        this.spiIndex.addDocument(indexDocument.spi);
    }

    public void removeDocuments(Indexable indexable) {
        Parameters.notNull((CharSequence)"indexable", (Object)indexable);
        this.spiIndex.removeDocument(indexable.getRelativePath());
    }

    public void markDirtyDocuments(Indexable indexable) {
        Parameters.notNull((CharSequence)"indexable", (Object)indexable);
        this.spiIndex.fileModified(indexable.getRelativePath());
    }
}

