/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProxyIterable<T>
implements Iterable<T> {
    private final Collection<? extends Iterable<? extends T>> delegates;
    private final boolean allowDuplicates;

    public ProxyIterable(Collection<? extends Iterable<? extends T>> collection) {
        this(collection, true);
    }

    public ProxyIterable(Collection<? extends Iterable<? extends T>> collection, boolean bl) {
        assert (collection != null);
        this.delegates = collection;
        this.allowDuplicates = bl;
    }

    @Override
    public Iterator<T> iterator() {
        return new ProxyIterator(this.delegates.iterator(), this.allowDuplicates);
    }

    public String toString() {
        return "ProxyIterable@" + Integer.toHexString(System.identityHashCode(this)) + " [" + this.delegates + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ProxyIterator<T>
    implements Iterator<T> {
        private final Iterator<? extends Iterable<? extends T>> iterables;
        private final Set<T> seen;
        private Iterator<? extends T> currentIterator;
        private T currentObject;

        public ProxyIterator(Iterator<? extends Iterable<? extends T>> iterator, boolean bl) {
            assert (iterator != null);
            this.iterables = iterator;
            this.seen = bl ? null : new HashSet();
        }

        @Override
        public boolean hasNext() {
            return this.getCurrent(false) != null;
        }

        @Override
        public T next() {
            T t = this.getCurrent(true);
            if (t == null) {
                throw new NoSuchElementException();
            }
            return t;
        }

        private T getCurrent(boolean bl) {
            if (this.currentObject != null && !bl) {
                return this.currentObject;
            }
            T t = this.currentObject;
            while (true) {
                if (this.currentIterator != null) {
                    while (this.currentIterator.hasNext()) {
                        T t2 = this.currentIterator.next();
                        if (this.seen != null && !this.seen.add(t2)) continue;
                        this.currentObject = t2;
                        return t != null ? t : this.currentObject;
                    }
                }
                if (!this.iterables.hasNext()) break;
                this.currentIterator = this.iterables.next().iterator();
            }
            this.currentIterator = null;
            this.currentObject = null;
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

