/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.parsing.impl.indexing.EventKind;
import org.netbeans.modules.parsing.impl.indexing.PathKind;
import org.netbeans.modules.parsing.impl.indexing.PathRecognizerRegistry;
import org.netbeans.modules.parsing.impl.indexing.PathRegistryEvent;
import org.netbeans.modules.parsing.impl.indexing.PathRegistryListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PathRegistry
implements Runnable {
    private static final boolean FIRE_UNKNOWN_ALWAYS = false;
    private static PathRegistry instance;
    private static final RequestProcessor firer;
    private static final Logger LOGGER;
    private final RequestProcessor.Task firerTask;
    private final GlobalPathRegistry regs;
    private final List<PathRegistryEvent.Change> changes = new LinkedList<PathRegistryEvent.Change>();
    private Set<ClassPath> activeCps;
    private Map<URL, SourceForBinaryQuery.Result2> sourceResults;
    private Map<URL, URL[]> translatedRoots;
    private Map<URL, WeakValue> unknownRoots;
    private long timeStamp;
    private volatile Runnable debugCallBack;
    private volatile boolean useLibraries = true;
    private Collection<URL> sourcePaths;
    private Collection<URL> libraryPath;
    private Collection<URL> binaryLibraryPath;
    private Collection<URL> unknownSourcePath;
    private Map<URL, PathIds> rootPathIds;
    private Map<String, Set<URL>> pathIdToRoots;
    private final Listener listener;
    private final List<PathRegistryListener> listeners;

    private PathRegistry() {
        this.firerTask = firer.create((Runnable)this, true);
        this.regs = GlobalPathRegistry.getDefault();
        assert (this.regs != null);
        this.listener = new Listener();
        this.timeStamp = -1L;
        this.activeCps = Collections.emptySet();
        this.sourceResults = Collections.emptyMap();
        this.unknownRoots = new HashMap<URL, WeakValue>();
        this.translatedRoots = new HashMap<URL, URL[]>();
        this.listeners = new CopyOnWriteArrayList<PathRegistryListener>();
        this.regs.addGlobalPathRegistryListener((GlobalPathRegistryListener)WeakListeners.create(GlobalPathRegistryListener.class, (EventListener)this.listener, (Object)this.regs));
    }

    public static synchronized PathRegistry getDefault() {
        if (instance == null) {
            instance = new PathRegistry();
        }
        return instance;
    }

    void setDebugCallBack(Runnable runnable) {
        this.debugCallBack = runnable;
    }

    public void addPathRegistryListener(PathRegistryListener pathRegistryListener) {
        assert (pathRegistryListener != null);
        this.listeners.add(pathRegistryListener);
    }

    public void removePathRegistryListener(PathRegistryListener pathRegistryListener) {
        assert (pathRegistryListener != null);
        this.listeners.remove(pathRegistryListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] sourceForBinaryQuery(URL uRL, ClassPath classPath, boolean bl) {
        URL[] uRLArray = this.translatedRoots.get(uRL);
        if (uRLArray != null) {
            if (uRLArray.length > 0) {
                return uRLArray;
            }
            return null;
        }
        if (classPath != null) {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            Collection<URL> collection = PathRegistry.getSources(SourceForBinaryQuery.findSourceRoots2((URL)uRL), arrayList, null);
            if (collection.isEmpty()) {
                return null;
            }
            uRLArray = new URL[collection.size()];
            PathRegistry pathRegistry = this;
            synchronized (pathRegistry) {
                int n = 0;
                for (URL uRL2 : collection) {
                    uRLArray[n++] = uRL2;
                    this.unknownRoots.put(uRL2, new WeakValue(classPath, uRL2));
                }
            }
            return uRLArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerUnknownSourceRoots(ClassPath classPath, Iterable<? extends URL> iterable) {
        assert (classPath != null);
        assert (iterable != null);
        PathRegistry pathRegistry = this;
        synchronized (pathRegistry) {
            for (URL uRL : iterable) {
                this.unknownRoots.put(uRL, new WeakValue(classPath, uRL));
            }
            this.unknownSourcePath = new HashSet<URL>(this.unknownRoots.keySet());
            this.changes.add(new PathRegistryEvent.Change(EventKind.PATHS_ADDED, PathKind.UNKNOWN_SOURCE, null, Collections.singleton(classPath)));
        }
        LOGGER.log(Level.FINE, "registerUnknownSourceRoots: " + Arrays.asList(iterable));
        this.firerTask.schedule(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends URL> getSources() {
        Request request;
        Object object = this;
        synchronized (object) {
            if (this.sourcePaths != null) {
                return this.sourcePaths;
            }
            request = new Request(this.getTimeStamp(), this.getSourcePaths(), this.getLibraryPaths(), this.getBinaryLibraryPaths(), new HashSet<ClassPath>(this.activeCps), new HashMap<URL, SourceForBinaryQuery.Result2>(this.sourceResults), new HashMap<URL, WeakValue>(this.unknownRoots), this.listener, this.listener);
        }
        object = PathRegistry.createResources(request);
        if (this.debugCallBack != null) {
            this.debugCallBack.run();
        }
        PathRegistry pathRegistry = this;
        synchronized (pathRegistry) {
            if (this.getTimeStamp() == ((Result)object).timeStamp) {
                if (this.sourcePaths == null) {
                    this.sourcePaths = ((Result)object).sourcePath;
                    this.libraryPath = ((Result)object).libraryPath;
                    this.binaryLibraryPath = ((Result)object).binaryLibraryPath;
                    this.unknownSourcePath = ((Result)object).unknownSourcePath;
                    this.activeCps = ((Result)object).newCps;
                    this.sourceResults = ((Result)object).newSR;
                    this.translatedRoots = ((Result)object).translatedRoots;
                    this.unknownRoots = ((Result)object).unknownRoots;
                    this.rootPathIds = ((Result)object).rootPathIds;
                    this.pathIdToRoots = ((Result)object).pathIdToRoots;
                }
                return this.sourcePaths;
            }
            return ((Result)object).sourcePath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends URL> getLibraries() {
        Request request;
        Object object = this;
        synchronized (object) {
            if (this.libraryPath != null) {
                return this.libraryPath;
            }
            request = new Request(this.getTimeStamp(), this.getSourcePaths(), this.getLibraryPaths(), this.getBinaryLibraryPaths(), new HashSet<ClassPath>(this.activeCps), new HashMap<URL, SourceForBinaryQuery.Result2>(this.sourceResults), new HashMap<URL, WeakValue>(this.unknownRoots), this.listener, this.listener);
        }
        object = PathRegistry.createResources(request);
        if (this.debugCallBack != null) {
            this.debugCallBack.run();
        }
        PathRegistry pathRegistry = this;
        synchronized (pathRegistry) {
            if (this.getTimeStamp() == ((Result)object).timeStamp) {
                if (this.libraryPath == null) {
                    this.sourcePaths = ((Result)object).sourcePath;
                    this.libraryPath = ((Result)object).libraryPath;
                    this.binaryLibraryPath = ((Result)object).binaryLibraryPath;
                    this.unknownSourcePath = ((Result)object).unknownSourcePath;
                    this.activeCps = ((Result)object).newCps;
                    this.sourceResults = ((Result)object).newSR;
                    this.translatedRoots = ((Result)object).translatedRoots;
                    this.unknownRoots = ((Result)object).unknownRoots;
                    this.rootPathIds = ((Result)object).rootPathIds;
                    this.pathIdToRoots = ((Result)object).pathIdToRoots;
                }
                return this.libraryPath;
            }
            return ((Result)object).libraryPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends URL> getBinaryLibraries() {
        Request request;
        Object object = this;
        synchronized (object) {
            if (this.binaryLibraryPath != null) {
                return this.binaryLibraryPath;
            }
            request = new Request(this.getTimeStamp(), this.getSourcePaths(), this.getLibraryPaths(), this.getBinaryLibraryPaths(), new HashSet<ClassPath>(this.activeCps), new HashMap<URL, SourceForBinaryQuery.Result2>(this.sourceResults), new HashMap<URL, WeakValue>(this.unknownRoots), this.listener, this.listener);
        }
        object = PathRegistry.createResources(request);
        if (this.debugCallBack != null) {
            this.debugCallBack.run();
        }
        PathRegistry pathRegistry = this;
        synchronized (pathRegistry) {
            if (this.getTimeStamp() == ((Result)object).timeStamp) {
                if (this.binaryLibraryPath == null) {
                    this.sourcePaths = ((Result)object).sourcePath;
                    this.libraryPath = ((Result)object).libraryPath;
                    this.binaryLibraryPath = ((Result)object).binaryLibraryPath;
                    this.unknownSourcePath = ((Result)object).unknownSourcePath;
                    this.activeCps = ((Result)object).newCps;
                    this.sourceResults = ((Result)object).newSR;
                    this.translatedRoots = ((Result)object).translatedRoots;
                    this.unknownRoots = ((Result)object).unknownRoots;
                    this.rootPathIds = ((Result)object).rootPathIds;
                    this.pathIdToRoots = ((Result)object).pathIdToRoots;
                }
                return this.binaryLibraryPath;
            }
            return ((Result)object).binaryLibraryPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends URL> getUnknownRoots() {
        Request request;
        Object object = this;
        synchronized (object) {
            if (this.unknownSourcePath != null) {
                return this.unknownSourcePath;
            }
            request = new Request(this.getTimeStamp(), this.getSourcePaths(), this.getLibraryPaths(), this.getBinaryLibraryPaths(), new HashSet<ClassPath>(this.activeCps), new HashMap<URL, SourceForBinaryQuery.Result2>(this.sourceResults), new HashMap<URL, WeakValue>(this.unknownRoots), this.listener, this.listener);
        }
        object = PathRegistry.createResources(request);
        if (this.debugCallBack != null) {
            this.debugCallBack.run();
        }
        PathRegistry pathRegistry = this;
        synchronized (pathRegistry) {
            if (this.getTimeStamp() == ((Result)object).timeStamp) {
                if (this.unknownSourcePath == null) {
                    this.sourcePaths = ((Result)object).sourcePath;
                    this.libraryPath = ((Result)object).libraryPath;
                    this.binaryLibraryPath = ((Result)object).binaryLibraryPath;
                    this.unknownSourcePath = ((Result)object).unknownSourcePath;
                    this.activeCps = ((Result)object).newCps;
                    this.sourceResults = ((Result)object).newSR;
                    this.translatedRoots = ((Result)object).translatedRoots;
                    this.unknownRoots = ((Result)object).unknownRoots;
                    this.rootPathIds = ((Result)object).rootPathIds;
                    this.pathIdToRoots = ((Result)object).pathIdToRoots;
                }
                return this.unknownSourcePath;
            }
            return ((Result)object).unknownSourcePath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKnownRoot(URL uRL) {
        PathRegistry pathRegistry = this;
        synchronized (pathRegistry) {
            return this.rootPathIds != null && this.rootPathIds.containsKey(uRL) || this.unknownSourcePath != null && this.unknownSourcePath.contains(uRL);
        }
    }

    public Set<String> getSourceIdsFor(URL uRL) {
        PathIds pathIds = this.getRootPathIds().get(uRL);
        return pathIds != null ? pathIds.getSids() : null;
    }

    public Set<String> getLibraryIdsFor(URL uRL) {
        PathIds pathIds = this.getRootPathIds().get(uRL);
        return pathIds != null ? pathIds.getLids() : null;
    }

    public Set<URL> getRootsMarkedAs(String ... stringArray) {
        Map<String, Set<URL>> map = this.getPathIdToRoots();
        HashSet<URL> hashSet = new HashSet<URL>();
        for (String string : stringArray) {
            Set<URL> set = map.get(string);
            if (set == null) continue;
            hashSet.addAll(set);
        }
        return hashSet;
    }

    public Set<String> getMimeTypesFor(URL uRL) {
        PathIds pathIds = this.getRootPathIds().get(uRL);
        return pathIds != null ? pathIds.getMimeTypes() : null;
    }

    public boolean isFinished() {
        return this.firerTask.isFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<PathRegistryEvent.Change> arrayList;
        assert (firer.isRequestProcessorThread());
        long l = System.currentTimeMillis();
        try {
            LOGGER.log(Level.FINE, "resetCacheAndFire waiting for projects");
            OpenProjects.getDefault().openProjects().get();
            LOGGER.log(Level.FINE, "resetCacheAndFire blocked for {0} ms", System.currentTimeMillis() - l);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "resetCacheAndFire timeout", exception);
        }
        PathRegistry pathRegistry = this;
        synchronized (pathRegistry) {
            arrayList = new ArrayList<PathRegistryEvent.Change>(this.changes);
            this.changes.clear();
        }
        this.fire(arrayList);
        LOGGER.log(Level.FINE, "resetCacheAndFire, firing done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<URL, PathIds> getRootPathIds() {
        Request request;
        Object object = this;
        synchronized (object) {
            if (this.rootPathIds != null) {
                return this.rootPathIds;
            }
            request = new Request(this.getTimeStamp(), this.getSourcePaths(), this.getLibraryPaths(), this.getBinaryLibraryPaths(), new HashSet<ClassPath>(this.activeCps), new HashMap<URL, SourceForBinaryQuery.Result2>(this.sourceResults), new HashMap<URL, WeakValue>(this.unknownRoots), this.listener, this.listener);
        }
        object = PathRegistry.createResources(request);
        if (this.debugCallBack != null) {
            this.debugCallBack.run();
        }
        PathRegistry pathRegistry = this;
        synchronized (pathRegistry) {
            if (this.getTimeStamp() == ((Result)object).timeStamp) {
                if (this.rootPathIds == null) {
                    this.sourcePaths = ((Result)object).sourcePath;
                    this.libraryPath = ((Result)object).libraryPath;
                    this.binaryLibraryPath = ((Result)object).binaryLibraryPath;
                    this.unknownSourcePath = ((Result)object).unknownSourcePath;
                    this.activeCps = ((Result)object).newCps;
                    this.sourceResults = ((Result)object).newSR;
                    this.translatedRoots = ((Result)object).translatedRoots;
                    this.unknownRoots = ((Result)object).unknownRoots;
                    this.rootPathIds = ((Result)object).rootPathIds;
                    this.pathIdToRoots = ((Result)object).pathIdToRoots;
                }
                return this.rootPathIds;
            }
            return ((Result)object).rootPathIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<URL>> getPathIdToRoots() {
        Request request;
        Object object = this;
        synchronized (object) {
            if (this.pathIdToRoots != null) {
                return this.pathIdToRoots;
            }
            request = new Request(this.getTimeStamp(), this.getSourcePaths(), this.getLibraryPaths(), this.getBinaryLibraryPaths(), new HashSet<ClassPath>(this.activeCps), new HashMap<URL, SourceForBinaryQuery.Result2>(this.sourceResults), new HashMap<URL, WeakValue>(this.unknownRoots), this.listener, this.listener);
        }
        object = PathRegistry.createResources(request);
        if (this.debugCallBack != null) {
            this.debugCallBack.run();
        }
        PathRegistry pathRegistry = this;
        synchronized (pathRegistry) {
            if (this.getTimeStamp() == ((Result)object).timeStamp) {
                if (this.pathIdToRoots == null) {
                    this.sourcePaths = ((Result)object).sourcePath;
                    this.libraryPath = ((Result)object).libraryPath;
                    this.binaryLibraryPath = ((Result)object).binaryLibraryPath;
                    this.unknownSourcePath = ((Result)object).unknownSourcePath;
                    this.activeCps = ((Result)object).newCps;
                    this.sourceResults = ((Result)object).newSR;
                    this.translatedRoots = ((Result)object).translatedRoots;
                    this.unknownRoots = ((Result)object).unknownRoots;
                    this.rootPathIds = ((Result)object).rootPathIds;
                    this.pathIdToRoots = ((Result)object).pathIdToRoots;
                }
                return this.pathIdToRoots;
            }
            return ((Result)object).pathIdToRoots;
        }
    }

    private static Result createResources(Request request) {
        boolean bl;
        URL uRL;
        boolean bl2;
        ClassPath classPath;
        assert (request != null);
        HashSet<URL> hashSet = new HashSet<URL>();
        HashSet<URL> hashSet2 = new HashSet<URL>();
        HashSet<URL> hashSet3 = new HashSet<URL>();
        HashSet<URL> hashSet4 = new HashSet<URL>();
        HashMap<URL, URL[]> hashMap = new HashMap<URL, URL[]>();
        HashSet<ClassPath> hashSet5 = new HashSet<ClassPath>();
        HashMap<URL, SourceForBinaryQuery.Result2> hashMap2 = new HashMap<URL, SourceForBinaryQuery.Result2>();
        HashMap<URL, PathIds> hashMap3 = new HashMap<URL, PathIds>();
        HashMap<String, Set<URL>> hashMap4 = new HashMap<String, Set<URL>>();
        for (TaggedClassPath object : request.sourceCps) {
            classPath = object.getClasspath();
            bl2 = !request.oldCps.remove(classPath);
            for (ClassPath.Entry entry : classPath.entries()) {
                uRL = entry.getURL();
                hashSet.add(uRL);
                PathRegistry.updatePathIds(uRL, object, hashMap3, hashMap4);
            }
            bl = hashSet5.add(classPath);
            if (!bl2 || !bl) continue;
            classPath.addPropertyChangeListener(request.propertyListener);
        }
        for (TaggedClassPath taggedClassPath : request.libraryCps) {
            classPath = taggedClassPath.getClasspath();
            bl2 = !request.oldCps.remove(classPath);
            for (ClassPath.Entry entry : classPath.entries()) {
                uRL = entry.getURL();
                hashSet3.add(uRL);
                PathRegistry.updatePathIds(uRL, taggedClassPath, hashMap3, hashMap4);
            }
            bl = hashSet5.add(classPath);
            if (!bl2 || !bl) continue;
            classPath.addPropertyChangeListener(request.propertyListener);
        }
        for (TaggedClassPath taggedClassPath : request.binaryLibraryCps) {
            classPath = taggedClassPath.getClasspath();
            bl2 = !request.oldCps.remove(classPath);
            for (ClassPath.Entry entry : classPath.entries()) {
                boolean bl3;
                uRL = entry.getURL();
                if (hashMap.containsKey(uRL)) continue;
                PathRegistry.updatePathIds(uRL, taggedClassPath, hashMap3, hashMap4);
                SourceForBinaryQuery.Result2 result2 = request.oldSR.remove(uRL);
                if (result2 == null) {
                    result2 = SourceForBinaryQuery.findSourceRoots2((URL)uRL);
                    bl3 = true;
                } else {
                    bl3 = false;
                }
                assert (!hashMap2.containsKey(uRL));
                hashMap2.put(uRL, result2);
                LOGGER.log(Level.FINE, "{0}: preferSources={1}", new Object[]{uRL, result2.preferSources()});
                ArrayList<URL> arrayList = new ArrayList<URL>();
                Collection<URL> collection = PathRegistry.getSources(result2, arrayList, request.unknownRoots);
                if (collection.isEmpty()) {
                    hashSet4.add(uRL);
                } else {
                    hashSet3.addAll(collection);
                    PathRegistry.updateTranslatedPathIds(collection, taggedClassPath, hashMap3, hashMap4);
                }
                hashMap.put(uRL, arrayList.toArray(new URL[arrayList.size()]));
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("T: " + uRL + " -> " + arrayList);
                }
                if (!bl3) continue;
                result2.addChangeListener(request.changeListener);
            }
            bl = hashSet5.add(classPath);
            if (!bl2 || !bl) continue;
            classPath.addPropertyChangeListener(request.propertyListener);
        }
        for (ClassPath classPath2 : request.oldCps) {
            classPath2.removePropertyChangeListener(request.propertyListener);
        }
        for (Map.Entry entry : request.oldSR.entrySet()) {
            ((SourceForBinaryQuery.Result2)entry.getValue()).removeChangeListener(request.changeListener);
        }
        hashSet2.addAll(request.unknownRoots.keySet());
        return new Result(request.timeStamp, hashSet, hashSet3, hashSet4, hashSet2, hashSet5, hashMap2, hashMap, request.unknownRoots, hashMap3, hashMap4);
    }

    private static Collection<URL> getSources(SourceForBinaryQuery.Result2 result2, List<URL> list, Map<URL, WeakValue> map) {
        assert (result2 != null);
        if (result2.preferSources()) {
            FileObject[] fileObjectArray = result2.getRoots();
            assert (fileObjectArray != null);
            ArrayList<URL> arrayList = new ArrayList<URL>(fileObjectArray.length);
            for (int i = 0; i < fileObjectArray.length; ++i) {
                try {
                    URL uRL = fileObjectArray[i].getURL();
                    if (list != null) {
                        list.add(uRL);
                    }
                    if (map != null) {
                        map.remove(uRL);
                    }
                    arrayList.add(uRL);
                    continue;
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                }
            }
            return arrayList;
        }
        return Collections.emptySet();
    }

    private static void updatePathIds(URL uRL, TaggedClassPath taggedClassPath, Map<URL, PathIds> map, Map<String, Set<URL>> map2) {
        PathIds pathIds = map.get(uRL);
        if (pathIds == null) {
            pathIds = new PathIds();
            map.put(uRL, pathIds);
        }
        pathIds.addAll(taggedClassPath.getPathIds());
        for (String string : taggedClassPath.getPathIds().getAllIds()) {
            Set<URL> set = map2.get(string);
            if (set == null) {
                set = new HashSet<URL>();
                map2.put(string, set);
            }
            set.add(uRL);
        }
        LOGGER.log(Level.FINE, "Root {0} associated with {1}", new Object[]{uRL, taggedClassPath.getPathIds()});
    }

    private static void updateTranslatedPathIds(Collection<URL> collection, TaggedClassPath taggedClassPath, Map<URL, PathIds> map, Map<String, Set<URL>> map2) {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String object2 : taggedClassPath.getPathIds().getBlids()) {
            Object object3;
            object = PathRecognizerRegistry.getDefault().getSourceIdsForBinaryLibraryId(object2);
            if (object != null) {
                hashSet.addAll((Collection<String>)object);
            }
            if ((object3 = PathRecognizerRegistry.getDefault().getMimeTypesForBinaryLibraryId(object2)) == null) continue;
            hashSet2.addAll((Collection<String>)object3);
        }
        for (URL uRL : collection) {
            object = map.get(uRL);
            if (object == null) {
                object = new PathIds();
                map.put(uRL, (PathIds)object);
            }
            ((PathIds)object).getSids().addAll(hashSet);
            ((PathIds)object).getMimeTypes().addAll(hashSet2);
            for (String string : hashSet) {
                Set<URL> set = map2.get(string);
                if (set == null) {
                    set = new HashSet<URL>();
                    map2.put(string, set);
                }
                set.add(uRL);
            }
            LOGGER.log(Level.FINE, "Root {0} associated with {1}", new Object[]{uRL, taggedClassPath.getPathIds()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCacheAndFire(EventKind eventKind, PathKind pathKind, String string, Set<? extends ClassPath> set) {
        PathRegistry pathRegistry = this;
        synchronized (pathRegistry) {
            this.sourcePaths = null;
            this.libraryPath = null;
            this.binaryLibraryPath = null;
            this.unknownSourcePath = null;
            this.rootPathIds = null;
            this.pathIdToRoots = null;
            ++this.timeStamp;
            this.changes.add(new PathRegistryEvent.Change(eventKind, pathKind, string, set));
        }
        LOGGER.log(Level.FINE, "resetCacheAndFire");
        this.firerTask.schedule(0);
    }

    private void fire(Iterable<? extends PathRegistryEvent.Change> iterable) {
        PathRegistryEvent pathRegistryEvent = new PathRegistryEvent(this, iterable);
        for (PathRegistryListener pathRegistryListener : this.listeners) {
            pathRegistryListener.pathsChanged(pathRegistryEvent);
        }
    }

    private PathKind getPathKind(String string) {
        assert (string != null);
        if (string == null) {
            return null;
        }
        Set<String> set = PathRecognizerRegistry.getDefault().getSourceIds();
        if (set.contains(string)) {
            return PathKind.SOURCE;
        }
        Set<String> set2 = PathRecognizerRegistry.getDefault().getLibraryIds();
        if (set2.contains(string)) {
            return PathKind.LIBRARY;
        }
        Set<String> set3 = PathRecognizerRegistry.getDefault().getBinaryLibraryIds();
        if (set3.contains(string)) {
            return PathKind.BINARY_LIBRARY;
        }
        return null;
    }

    private Collection<TaggedClassPath> getSourcePaths() {
        return this.getPaths(PathKind.SOURCE);
    }

    private Collection<TaggedClassPath> getLibraryPaths() {
        return this.getPaths(PathKind.LIBRARY);
    }

    private Collection<TaggedClassPath> getBinaryLibraryPaths() {
        return this.getPaths(PathKind.BINARY_LIBRARY);
    }

    private Collection<TaggedClassPath> getPaths(PathKind pathKind) {
        Set<String> set;
        switch (pathKind) {
            case SOURCE: {
                set = PathRecognizerRegistry.getDefault().getSourceIds();
                break;
            }
            case LIBRARY: {
                set = PathRecognizerRegistry.getDefault().getLibraryIds();
                break;
            }
            case BINARY_LIBRARY: {
                set = PathRecognizerRegistry.getDefault().getBinaryLibraryIds();
                break;
            }
            default: {
                LOGGER.warning("Not expecting PathKind of " + (Object)((Object)pathKind));
                return Collections.emptySet();
            }
        }
        HashMap<ClassPath, TaggedClassPath> hashMap = new HashMap<ClassPath, TaggedClassPath>();
        for (String string : set) {
            for (ClassPath classPath : this.regs.getPaths(string)) {
                TaggedClassPath taggedClassPath = (TaggedClassPath)hashMap.get(classPath);
                if (taggedClassPath == null) {
                    taggedClassPath = new TaggedClassPath(classPath);
                    hashMap.put(classPath, taggedClassPath);
                }
                switch (pathKind) {
                    case SOURCE: {
                        taggedClassPath.associateWithSourceId(string);
                        taggedClassPath.associateWithMimeTypes(PathRecognizerRegistry.getDefault().getMimeTypesForSourceId(string));
                        break;
                    }
                    case LIBRARY: {
                        taggedClassPath.associateWithLibraryId(string);
                        taggedClassPath.associateWithMimeTypes(PathRecognizerRegistry.getDefault().getMimeTypesForLibraryId(string));
                        break;
                    }
                    case BINARY_LIBRARY: {
                        taggedClassPath.associateWithBinaryLibraryId(string);
                    }
                }
            }
        }
        return hashMap.values();
    }

    private long getTimeStamp() {
        return this.timeStamp;
    }

    static {
        firer = new RequestProcessor("Path Registry Request Processor");
        LOGGER = Logger.getLogger(PathRegistry.class.getName());
    }

    private class Listener
    implements GlobalPathRegistryListener,
    PropertyChangeListener,
    ChangeListener {
        private WeakReference<Object> lastPropagationId;

        private Listener() {
        }

        public void pathsAdded(GlobalPathRegistryEvent globalPathRegistryEvent) {
            String string = globalPathRegistryEvent.getId();
            PathKind pathKind = PathRegistry.this.getPathKind(string);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("pathsAdded: " + globalPathRegistryEvent.getId() + ", paths=" + globalPathRegistryEvent.getChangedPaths());
                LOGGER.fine("'" + string + "' -> '" + (Object)((Object)pathKind) + "'");
            }
            if (pathKind != null) {
                PathRegistry.this.resetCacheAndFire(EventKind.PATHS_ADDED, pathKind, string, globalPathRegistryEvent.getChangedPaths());
            }
        }

        public void pathsRemoved(GlobalPathRegistryEvent globalPathRegistryEvent) {
            String string = globalPathRegistryEvent.getId();
            PathKind pathKind = PathRegistry.this.getPathKind(string);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("pathsRemoved: " + globalPathRegistryEvent.getId() + ", paths=" + globalPathRegistryEvent.getChangedPaths());
                LOGGER.fine("'" + string + "' -> '" + (Object)((Object)pathKind) + "'");
            }
            if (pathKind != null) {
                PathRegistry.this.resetCacheAndFire(EventKind.PATHS_REMOVED, pathKind, string, globalPathRegistryEvent.getChangedPaths());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("propertyChange: " + propertyChangeEvent.getPropertyName() + ", old=" + propertyChangeEvent.getOldValue() + ", new=" + propertyChangeEvent.getNewValue());
            }
            if ("entries".equals(string = propertyChangeEvent.getPropertyName())) {
                PathRegistry.this.resetCacheAndFire(EventKind.PATHS_CHANGED, null, null, Collections.singleton((ClassPath)propertyChangeEvent.getSource()));
            } else if ("includes".equals(string)) {
                boolean bl;
                Object object = propertyChangeEvent.getPropagationId();
                Listener listener = this;
                synchronized (listener) {
                    bl = object == null || this.lastPropagationId == null || this.lastPropagationId.get() != object;
                    this.lastPropagationId = new WeakReference<Object>(object);
                }
                if (bl) {
                    PathRegistry.this.resetCacheAndFire(EventKind.PATHS_CHANGED, PathKind.SOURCE, null, Collections.singleton((ClassPath)propertyChangeEvent.getSource()));
                }
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("stateChanged: " + changeEvent);
            }
            PathRegistry.this.resetCacheAndFire(EventKind.PATHS_CHANGED, PathKind.BINARY_LIBRARY, null, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PathIds {
        private final Set<String> sourcePathIds = new HashSet<String>();
        private final Set<String> libraryPathIds = new HashSet<String>();
        private final Set<String> binaryLibraryPathIds = new HashSet<String>();
        private final Set<String> mimeTypes = new HashSet<String>();

        private PathIds() {
        }

        public Set<String> getSids() {
            return this.sourcePathIds;
        }

        public Set<String> getLids() {
            return this.libraryPathIds;
        }

        public Set<String> getBlids() {
            return this.binaryLibraryPathIds;
        }

        public Set<String> getMimeTypes() {
            return this.mimeTypes;
        }

        public Set<String> getAllIds() {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(this.sourcePathIds);
            hashSet.addAll(this.libraryPathIds);
            hashSet.addAll(this.binaryLibraryPathIds);
            return hashSet;
        }

        public void addAll(PathIds pathIds) {
            this.sourcePathIds.addAll(pathIds.getSids());
            this.libraryPathIds.addAll(pathIds.getLids());
            this.binaryLibraryPathIds.addAll(pathIds.getBlids());
            this.mimeTypes.addAll(pathIds.getMimeTypes());
        }

        public String toString() {
            return super.toString() + ";sids=" + this.sourcePathIds + ", lids=" + this.libraryPathIds + ", blids=" + this.binaryLibraryPathIds;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Request {
        final long timeStamp;
        final Collection<TaggedClassPath> sourceCps;
        final Collection<TaggedClassPath> libraryCps;
        final Collection<TaggedClassPath> binaryLibraryCps;
        final Set<ClassPath> oldCps;
        final Map<URL, SourceForBinaryQuery.Result2> oldSR;
        final Map<URL, WeakValue> unknownRoots;
        final PropertyChangeListener propertyListener;
        final ChangeListener changeListener;

        public Request(long l, Collection<TaggedClassPath> collection, Collection<TaggedClassPath> collection2, Collection<TaggedClassPath> collection3, Set<ClassPath> set, Map<URL, SourceForBinaryQuery.Result2> map, Map<URL, WeakValue> map2, PropertyChangeListener propertyChangeListener, ChangeListener changeListener) {
            assert (collection != null);
            assert (collection2 != null);
            assert (collection3 != null);
            assert (set != null);
            assert (map != null);
            assert (map2 != null);
            assert (propertyChangeListener != null);
            assert (changeListener != null);
            this.timeStamp = l;
            this.sourceCps = collection;
            this.libraryCps = collection2;
            this.binaryLibraryCps = collection3;
            this.oldCps = set;
            this.oldSR = map;
            this.unknownRoots = map2;
            this.propertyListener = propertyChangeListener;
            this.changeListener = changeListener;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Result {
        final long timeStamp;
        final Collection<URL> sourcePath;
        final Collection<URL> libraryPath;
        final Collection<URL> binaryLibraryPath;
        final Collection<URL> unknownSourcePath;
        final Set<ClassPath> newCps;
        final Map<URL, SourceForBinaryQuery.Result2> newSR;
        final Map<URL, URL[]> translatedRoots;
        final Map<URL, WeakValue> unknownRoots;
        final Map<URL, PathIds> rootPathIds;
        final Map<String, Set<URL>> pathIdToRoots;

        public Result(long l, Collection<URL> collection, Collection<URL> collection2, Collection<URL> collection3, Collection<URL> collection4, Set<ClassPath> set, Map<URL, SourceForBinaryQuery.Result2> map, Map<URL, URL[]> map2, Map<URL, WeakValue> map3, Map<URL, PathIds> map4, Map<String, Set<URL>> map5) {
            assert (collection != null);
            assert (collection2 != null);
            assert (collection3 != null);
            assert (collection4 != null);
            assert (set != null);
            assert (map != null);
            assert (map2 != null);
            assert (map4 != null);
            this.timeStamp = l;
            this.sourcePath = collection;
            this.libraryPath = collection2;
            this.binaryLibraryPath = collection3;
            this.unknownSourcePath = collection4;
            this.newCps = set;
            this.newSR = map;
            this.translatedRoots = map2;
            this.unknownRoots = map3;
            this.rootPathIds = map4;
            this.pathIdToRoots = map5;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TaggedClassPath {
        private final ClassPath classpath;
        private final PathIds pathIds = new PathIds();

        public TaggedClassPath(ClassPath classPath) {
            this.classpath = classPath;
        }

        public ClassPath getClasspath() {
            return this.classpath;
        }

        public PathIds getPathIds() {
            return this.pathIds;
        }

        public void associateWithSourceId(String string) {
            this.pathIds.getSids().add(string);
        }

        public void associateWithLibraryId(String string) {
            this.pathIds.getLids().add(string);
        }

        public void associateWithBinaryLibraryId(String string) {
            this.pathIds.getBlids().add(string);
        }

        public void associateWithMimeTypes(Set<String> set) {
            this.pathIds.getMimeTypes().addAll(set);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WeakValue
    extends WeakReference<ClassPath>
    implements Runnable {
        private URL key;

        public WeakValue(ClassPath classPath, URL uRL) {
            super(classPath, Utilities.activeReferenceQueue());
            assert (uRL != null);
            this.key = uRL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = false;
            PathRegistry pathRegistry = PathRegistry.this;
            synchronized (pathRegistry) {
                bl = PathRegistry.this.unknownRoots.remove(this.key) != null;
            }
        }
    }
}

