/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.netbeans.modules.parsing.impl.indexing.IndexableImpl;
import org.netbeans.modules.parsing.impl.indexing.ProxyIterable;
import org.netbeans.modules.parsing.impl.indexing.SPIAccessor;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClusteredIndexables {
    private final List<IndexableImpl> indexables;
    private final Map<String, List<Indexable>> mimeTypeClusters = new HashMap<String, List<Indexable>>();
    private static final String ALL_MIME_TYPES = "";

    public ClusteredIndexables(Collection<IndexableImpl> collection) {
        Parameters.notNull((CharSequence)"indexables", collection);
        this.indexables = new LinkedList<IndexableImpl>(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Indexable> getIndexablesFor(String string) {
        Map<String, List<Indexable>> map = this.mimeTypeClusters;
        synchronized (map) {
            List<Indexable> list;
            if (string == null) {
                string = ALL_MIME_TYPES;
            }
            if ((list = this.mimeTypeClusters.get(string)) == null) {
                list = new LinkedList<Indexable>();
                if (string.length() == 0) {
                    for (IndexableImpl indexableImpl : this.indexables) {
                        list.add(SPIAccessor.getInstance().create(indexableImpl));
                    }
                } else {
                    boolean bl = false;
                    ListIterator<IndexableImpl> listIterator = this.indexables.listIterator();
                    while (listIterator.hasNext()) {
                        IndexableImpl indexableImpl = listIterator.next();
                        if (!indexableImpl.isTypeOf(string)) continue;
                        listIterator.remove();
                        list.add(SPIAccessor.getInstance().create(indexableImpl));
                        bl = true;
                    }
                    if (bl) {
                        this.mimeTypeClusters.remove(ALL_MIME_TYPES);
                    }
                }
                this.mimeTypeClusters.put(string, list);
            }
            if (string.length() == 0) {
                return new ProxyIterable<Indexable>(this.mimeTypeClusters.values());
            }
            return list;
        }
    }
}

