/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.services;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.netbeans.core.windows.services.FileSelector;
import org.netbeans.core.windows.services.NbPresenter;
import org.netbeans.core.windows.view.ui.NbSheet;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeOperation;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.WeakSet;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class NodeOperationImpl
extends NodeOperation {
    private static WeakSet<Node[]> nodeCache = new WeakSet();
    private static WeakHashMap<Node[], Dialog> dialogCache = new WeakHashMap();

    public void explore(final Node node) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                ExplorerPanel explorerPanel = new ExplorerPanel(node);
                Mode mode = WindowManager.getDefault().findMode("explorer");
                if (mode != null) {
                    mode.dockInto((TopComponent)explorerPanel);
                }
                explorerPanel.open();
                explorerPanel.requestActive();
            }
        });
    }

    public boolean customize(Node node) {
        final Component component = node.getCustomizer();
        if (component == null) {
            return false;
        }
        return (Boolean)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                if (component instanceof NbPresenter) {
                    ((NbPresenter)component).pack();
                    ((NbPresenter)component).show();
                    return Boolean.TRUE;
                }
                if (component instanceof Window) {
                    ((Window)component).pack();
                    component.setVisible(true);
                    return Boolean.TRUE;
                }
                HelpFwdPanel helpFwdPanel = null;
                helpFwdPanel = component instanceof ExplorerManager.Provider ? new ExplorerProviderFwd(component, (ExplorerManager.Provider)component) : new HelpFwdPanel(component);
                helpFwdPanel.setLayout(new BorderLayout());
                helpFwdPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NodeOperationImpl.class, (String)"CTL_Customizer_dialog_title"));
                if (component.getClass().getName().startsWith("org.netbeans.modules.xml.catalog")) {
                    helpFwdPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
                }
                helpFwdPanel.add(component, "Center");
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)helpFwdPanel, NbBundle.getMessage(NodeOperationImpl.class, (String)"CTL_Customizer_dialog_title"));
                dialogDescriptor.setOptions(new Object[]{DialogDescriptor.CLOSED_OPTION});
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                dialog.pack();
                dialog.setVisible(true);
                return Boolean.TRUE;
            }
        });
    }

    public void showProperties(Node node) {
        Dialog dialog = NodeOperationImpl.findCachedPropertiesDialog(node);
        if (null == dialog) {
            Node[] nodeArray = new Node[]{node};
            NodeOperationImpl.openProperties(new NbSheet(), nodeArray);
        } else {
            dialog.setVisible(true);
            NbSheet nbSheet = this.findCachedSheet(dialog);
            if (null != nbSheet) {
                nbSheet.setNodes(new Node[]{node});
            }
            dialog.toFront();
            FocusTraversalPolicy focusTraversalPolicy = dialog.getFocusTraversalPolicy();
            if (null != focusTraversalPolicy && null != focusTraversalPolicy.getDefaultComponent(dialog)) {
                focusTraversalPolicy.getDefaultComponent(dialog).requestFocusInWindow();
            } else {
                dialog.requestFocusInWindow();
            }
        }
    }

    public void showProperties(Node[] nodeArray) {
        Dialog dialog = NodeOperationImpl.findCachedPropertiesDialog(nodeArray);
        if (null == dialog) {
            NodeOperationImpl.openProperties(new NbSheet(), nodeArray);
        } else {
            dialog.setVisible(true);
            NbSheet nbSheet = this.findCachedSheet(dialog);
            if (null != nbSheet) {
                nbSheet.setNodes(nodeArray);
            }
            dialog.toFront();
            FocusTraversalPolicy focusTraversalPolicy = dialog.getFocusTraversalPolicy();
            if (null != focusTraversalPolicy && null != focusTraversalPolicy.getDefaultComponent(dialog)) {
                focusTraversalPolicy.getDefaultComponent(dialog).requestFocusInWindow();
            } else {
                dialog.requestFocusInWindow();
            }
        }
    }

    private NbSheet findCachedSheet(Container container) {
        NbSheet nbSheet = null;
        int n = container.getComponentCount();
        for (int i = 0; i < n && nbSheet == null; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof NbSheet) {
                nbSheet = (NbSheet)((Object)component);
                continue;
            }
            if (!(component instanceof Container)) continue;
            nbSheet = this.findCachedSheet((Container)component);
        }
        return nbSheet;
    }

    private static Dialog findCachedPropertiesDialog(Node node) {
        return NodeOperationImpl.findCachedPropertiesDialog(new Node[]{node});
    }

    private static Dialog findCachedPropertiesDialog(Node[] nodeArray) {
        for (Node[] nodeArray2 : nodeCache) {
            if (nodeArray2.length != nodeArray.length) continue;
            boolean bl = true;
            for (int i = 0; i < nodeArray2.length; ++i) {
                if (nodeArray2[i].equals((Object)nodeArray[i])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return dialogCache.get(nodeArray2);
        }
        return null;
    }

    public Node[] select(String string, String string2, Node node, NodeAcceptor nodeAcceptor, Component component) throws UserCancelException {
        FileSelector fileSelector = new FileSelector(string2, node, nodeAcceptor, component);
        fileSelector.setBorder(new EmptyBorder(12, 12, 0, 12));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)fileSelector, string, true, fileSelector.getOptions(), fileSelector.getSelectOption(), 0, HelpCtx.DEFAULT_HELP, null);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object != fileSelector.getSelectOption()) {
            throw new UserCancelException();
        }
        return fileSelector.getNodes();
    }

    private static void openProperties(final NbSheet nbSheet, final Node[] nodeArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean bl = NbPresenter.currentModalDialog != null;
                Dialog dialog = DialogDisplayer.getDefault().createDialog(new DialogDescriptor((Object)nbSheet, nbSheet.getName(), bl, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, null, null));
                nbSheet.setNodes(nodeArray);
                SheetNodesListener sheetNodesListener = new SheetNodesListener(dialog, nbSheet);
                sheetNodesListener.attach(nodeArray);
                nodeCache.add((Object)nodeArray);
                dialogCache.put(nodeArray, dialog);
                dialog.setVisible(true);
            }
        });
    }

    private static class ExplorerPanel
    extends TopComponent
    implements ExplorerManager.Provider {
        private ExplorerManager manager = new ExplorerManager();

        public ExplorerPanel(Node node) {
            this.manager.setRootContext(node);
            ActionMap actionMap = this.getActionMap();
            actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
            actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
            actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
            actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true));
            this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)actionMap));
            this.setLayout(new BorderLayout());
            this.add((Component)new BeanTreeView());
            this.setName(node.getDisplayName());
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        public void addNotify() {
            super.addNotify();
            ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
        }

        public void removeNotify() {
            ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
            super.removeNotify();
        }

        public int getPersistenceType() {
            return 2;
        }
    }

    private static final class ExplorerProviderFwd
    extends HelpFwdPanel
    implements ExplorerManager.Provider {
        private ExplorerManager.Provider explProvider;

        private ExplorerProviderFwd(Component component, ExplorerManager.Provider provider) {
            super(component);
            this.explProvider = provider;
        }

        public ExplorerManager getExplorerManager() {
            return this.explProvider.getExplorerManager();
        }
    }

    private static class HelpFwdPanel
    extends JPanel
    implements HelpCtx.Provider {
        private Component innerComp;
        private boolean active = false;

        private HelpFwdPanel(Component component) {
            this.innerComp = component;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HelpCtx getHelpCtx() {
            try {
                if (this.active) {
                    HelpCtx helpCtx = null;
                    return helpCtx;
                }
                this.active = true;
                HelpCtx helpCtx = HelpCtx.findHelp((Component)this.innerComp);
                return helpCtx;
            }
            finally {
                this.active = false;
            }
        }
    }

    private static class SheetNodesListener
    extends NodeAdapter
    implements PropertyChangeListener {
        private Dialog dialog;
        private Set<Node> listenerSet;
        private TopComponent tc;

        SheetNodesListener(Dialog dialog, TopComponent topComponent) {
            this.dialog = dialog;
            this.tc = topComponent;
            topComponent.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("name".equals(propertyChangeEvent.getPropertyName())) {
                this.dialog.setTitle((String)propertyChangeEvent.getNewValue());
            }
        }

        public void attach(Node[] nodeArray) {
            this.listenerSet = new HashSet<Node>(nodeArray.length * 2);
            for (int i = 0; i < nodeArray.length; ++i) {
                this.listenerSet.add(nodeArray[i]);
                nodeArray[i].addNodeListener((NodeListener)this);
            }
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
            Node node = nodeEvent.getNode();
            node.removeNodeListener((NodeListener)this);
            this.listenerSet.remove(node);
            if (this.listenerSet.isEmpty()) {
                this.tc.removePropertyChangeListener((PropertyChangeListener)this);
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        SheetNodesListener.this.dialog.setVisible(false);
                        SheetNodesListener.this.dialog.dispose();
                        SheetNodesListener.this.dialog = null;
                    }
                });
            }
        }
    }
}

