/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.queries;

import java.net.URL;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.queries.SFBQImpl2Result;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public class SourceForBinaryQuery {
    private static final Logger LOG = Logger.getLogger(SourceForBinaryQuery.class.getName());
    private static final Lookup.Result<? extends SourceForBinaryQueryImplementation> implementations = Lookup.getDefault().lookupResult(SourceForBinaryQueryImplementation.class);
    private static final Result EMPTY_RESULT = new EmptyResult();
    private static final Result2 EMPTY_RESULT2 = new Result2(new SFBQImpl2Result(EMPTY_RESULT));

    private SourceForBinaryQuery() {
    }

    public static Result findSourceRoots(URL uRL) {
        SourceForBinaryQuery.checkPreconditions(uRL);
        for (SourceForBinaryQueryImplementation sourceForBinaryQueryImplementation : implementations.allInstances()) {
            Result result = sourceForBinaryQueryImplementation.findSourceRoots(uRL);
            if (result == null) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "findSourceRoots({0}) -> {1} from {2}", new Object[]{uRL, Arrays.asList(result.getRoots()), sourceForBinaryQueryImplementation});
            }
            return result;
        }
        LOG.log(Level.FINE, "findSourceRoots({0}) -> nil", uRL);
        return EMPTY_RESULT;
    }

    public static Result2 findSourceRoots2(URL uRL) {
        SourceForBinaryQuery.checkPreconditions(uRL);
        for (SourceForBinaryQueryImplementation sourceForBinaryQueryImplementation : implementations.allInstances()) {
            Result result;
            Result2 result2 = null;
            if (sourceForBinaryQueryImplementation instanceof SourceForBinaryQueryImplementation2) {
                result = ((SourceForBinaryQueryImplementation2)sourceForBinaryQueryImplementation).findSourceRoots2(uRL);
                if (result != null) {
                    result2 = new Result2((SourceForBinaryQueryImplementation2.Result)result);
                }
            } else {
                result = sourceForBinaryQueryImplementation.findSourceRoots(uRL);
                if (result != null) {
                    result2 = new Result2(new SFBQImpl2Result(result));
                }
            }
            if (result2 == null) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "findSourceRoots2({0}) -> {1} from {2}", new Object[]{uRL, Arrays.asList(result2.getRoots()), sourceForBinaryQueryImplementation});
            }
            return result2;
        }
        LOG.log(Level.FINE, "findSourceRoots2({0}) -> nil", uRL);
        return EMPTY_RESULT2;
    }

    private static void checkPreconditions(URL uRL) {
        if (FileUtil.isArchiveFile((URL)uRL)) {
            throw new IllegalArgumentException("File URL pointing to JAR is not valid classpath entry. Use jar: URL. Was: " + uRL);
        }
        if (!uRL.toExternalForm().endsWith("/")) {
            throw new IllegalArgumentException("Folder URL must end with '/'. Was: " + uRL);
        }
    }

    private static final class EmptyResult
    implements Result {
        private static final FileObject[] NO_ROOTS = new FileObject[0];

        EmptyResult() {
        }

        public FileObject[] getRoots() {
            return NO_ROOTS;
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }

    public static interface Result {
        public FileObject[] getRoots();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }

    public static class Result2
    implements Result {
        SourceForBinaryQueryImplementation2.Result delegate;
        private ChangeListener spiListener;
        private final ChangeSupport changeSupport;

        private Result2(SourceForBinaryQueryImplementation2.Result result) {
            assert (result != null);
            this.delegate = result;
            this.changeSupport = new ChangeSupport((Object)this);
        }

        public FileObject[] getRoots() {
            return this.delegate.getRoots();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            Parameters.notNull((CharSequence)"l", (Object)changeListener);
            Result2 result2 = this;
            synchronized (result2) {
                if (this.spiListener == null) {
                    this.spiListener = new ChangeListener(){

                        public void stateChanged(ChangeEvent changeEvent) {
                            Result2.this.changeSupport.fireChange();
                        }
                    };
                    this.delegate.addChangeListener(WeakListeners.change((ChangeListener)this.spiListener, (Object)this.delegate));
                }
            }
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            Parameters.notNull((CharSequence)"l", (Object)changeListener);
            this.changeSupport.removeChangeListener(changeListener);
        }

        public boolean preferSources() {
            return this.delegate.preferSources();
        }
    }
}

