/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.text.Collator;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Unit {
    UpdateUnit updateUnit = null;
    private boolean isVisible;
    private String filter;
    private String categoryName;
    private static Logger log = Logger.getLogger(Unit.class.getName());
    private String displayDate = null;

    protected abstract UpdateElement getRelevantElement();

    public abstract boolean isMarked();

    public abstract void setMarked(boolean var1);

    public abstract int getCompleteSize();

    Unit(String string) {
        this.categoryName = string;
    }

    public abstract UnitCategoryTableModel.Type getModelType();

    public void initState() {
        if (UnitCategoryTableModel.isMarkedAsDefault(this.getModelType()) && !this.isMarked() && this.canBeMarked()) {
            this.setMarked(true);
        }
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public boolean canBeMarked() {
        RequestProcessor.Task task = PluginManagerUI.getRunningTask();
        return task == null || task.isFinished();
    }

    public String getDisplayName() {
        return this.getRelevantElement().getDisplayName();
    }

    public final boolean isVisible(String string) {
        if (this.filter != null && this.filter.equals(string)) {
            return this.isVisible;
        }
        this.filter = string;
        Iterable<String> iterable = this.details();
        for (String string2 : iterable) {
            boolean bl = this.isVisible = string.length() == 0 || string2.toLowerCase().contains(string);
            if (!this.isVisible) continue;
            break;
        }
        return this.isVisible;
    }

    private Iterable<String> details() {
        Iterable<String> iterable = new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    int step = 0;

                    @Override
                    public boolean hasNext() {
                        return this.step <= 7;
                    }

                    @Override
                    public String next() {
                        String string = null;
                        switch (this.step++) {
                            case 0: {
                                string = Unit.this.getDisplayName();
                                break;
                            }
                            case 1: {
                                string = Unit.this.getCategoryName();
                                break;
                            }
                            case 2: {
                                string = Unit.this.getDescription();
                                break;
                            }
                            case 3: {
                                string = Unit.this.updateUnit.getCodeName();
                                break;
                            }
                            case 4: {
                                string = Unit.this.getDisplayVersion();
                                break;
                            }
                            case 5: {
                                string = Unit.this.getAuthor();
                                break;
                            }
                            case 6: {
                                string = Unit.this.getHomepage();
                                break;
                            }
                            case 7: {
                                string = Unit.this.getSource();
                            }
                        }
                        return string != null ? string : "";
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                };
            }
        };
        return iterable;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getDescription() {
        return this.getRelevantElement().getDescription();
    }

    public String getNotification() {
        return this.getRelevantElement().getNotification();
    }

    public String getAuthor() {
        return this.getRelevantElement().getAuthor();
    }

    public String getHomepage() {
        return this.getRelevantElement().getHomepage();
    }

    public String getSource() {
        return this.getRelevantElement().getSource();
    }

    public String getDisplayVersion() {
        return this.getRelevantElement().getSpecificationVersion();
    }

    public String getDisplayDate() {
        String string;
        if (this.displayDate == null && (string = this.getRelevantElement().getDate()) != null) {
            try {
                Date date = Utilities.DATE_FORMAT.parse(string);
                this.displayDate = DateFormat.getDateInstance(3, Locale.getDefault()).format(date);
            }
            catch (ParseException parseException) {
                log.log(Level.INFO, "ParseException while parsing date " + string, parseException);
            }
        }
        return this.displayDate;
    }

    public static int compareDisplayNames(Unit unit, Unit unit2) {
        return Utilities.getCategoryComparator().compare(unit.getDisplayName(), unit2.getDisplayName());
    }

    public static int compareCategories(Unit unit, Unit unit2) {
        return Utilities.getCategoryComparator().compare(unit.getCategoryName(), unit2.getCategoryName());
    }

    public static int compareSimpleFormatDates(Unit unit, Unit unit2) {
        Date date;
        Date date2;
        if (unit.getRelevantElement().getDate() == null) {
            if (unit2.getRelevantElement().getDate() == null) {
                return 0;
            }
            return -1;
        }
        if (unit2.getRelevantElement().getDate() == null) {
            return 1;
        }
        try {
            date2 = Utilities.DATE_FORMAT.parse(unit.getRelevantElement().getDate());
        }
        catch (ParseException parseException) {
            log.log(Level.INFO, "ParseException while parsing date " + unit.getRelevantElement().getDate(), parseException);
            return -1;
        }
        try {
            date = Utilities.DATE_FORMAT.parse(unit2.getRelevantElement().getDate());
        }
        catch (ParseException parseException) {
            log.log(Level.INFO, "ParseException while parsing date " + unit2.getRelevantElement().getDate(), parseException);
            return 1;
        }
        return date2.compareTo(date);
    }

    public static int compareDisplayVersions(Unit unit, Unit unit2) {
        if (unit.getDisplayVersion() == null) {
            if (unit2.getDisplayVersion() == null) {
                return 0;
            }
            return -1;
        }
        if (unit2.getDisplayVersion() == null) {
            return 1;
        }
        return new SpecificationVersion(unit.getDisplayVersion()).compareTo((Object)new SpecificationVersion(unit2.getDisplayVersion()));
    }

    public static int compareCompleteSizes(Unit unit, Unit unit2) {
        return Integer.valueOf(unit.getCompleteSize()).compareTo(unit2.getCompleteSize());
    }

    private static String getBundle(String string) {
        return NbBundle.getMessage(Unit.class, (String)string);
    }

    public static class Available
    extends Unit {
        private UpdateElement updateEl = null;
        private boolean isNbms;
        private int size = -1;

        public Available(UpdateUnit updateUnit, boolean bl, String string) {
            super(string);
            this.isNbms = bl;
            this.updateUnit = updateUnit;
            this.updateEl = (UpdateElement)updateUnit.getAvailableUpdates().get(0);
            assert (this.updateEl != null) : "Updateable UpdateUnit " + updateUnit + " has UpdateElement for update.";
            this.initState();
        }

        public boolean isMarked() {
            Object object = null;
            object = this.isNbms ? Containers.forAvailableNbms() : (UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT == this.updateUnit.getType() ? Containers.forCustomInstall() : Containers.forAvailable());
            return object.contains(this.updateEl);
        }

        public void setMarked(boolean bl) {
            assert (bl != this.isMarked());
            Object object = null;
            object = this.isNbms ? Containers.forAvailableNbms() : (UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT == this.updateUnit.getType() ? Containers.forCustomInstall() : Containers.forAvailable());
            if (bl) {
                object.add(this.updateUnit, this.updateEl);
            } else {
                object.remove(this.updateEl);
            }
        }

        public static int compareAvailableVersion(Unit unit, Unit unit2) {
            if (unit instanceof Available && unit2 instanceof Available) {
                Available available = (Available)unit;
                Available available2 = (Available)unit2;
                return new SpecificationVersion(available.getAvailableVersion()).compareTo((Object)new SpecificationVersion(available2.getAvailableVersion()));
            }
            return Unit.compareDisplayVersions(unit, unit2);
        }

        public static int compareSourceCategories(Unit unit, Unit unit2) {
            if (unit instanceof Available && unit2 instanceof Available) {
                Available available = (Available)unit;
                Available available2 = (Available)unit2;
                return Collator.getInstance().compare(available.getSourceCategory().name(), available2.getSourceCategory().name());
            }
            throw new IllegalStateException();
        }

        public String getAvailableVersion() {
            return this.updateEl.getSpecificationVersion();
        }

        public Integer getMyRating() {
            return null;
        }

        public String getSize() {
            return Utilities.getDownloadSizeAsString(this.updateEl.getDownloadSize());
        }

        public UpdateElement getRelevantElement() {
            return this.updateEl;
        }

        public int getCompleteSize() {
            if (this.size == -1) {
                this.size = 0;
                OperationContainer operationContainer = OperationContainer.createForDirectInstall();
                OperationContainer.OperationInfo operationInfo = operationContainer.add(this.getRelevantElement());
                Set set = operationInfo.getRequiredElements();
                for (UpdateElement updateElement : set) {
                    this.size += updateElement.getDownloadSize();
                }
                this.size += this.getRelevantElement().getDownloadSize();
                operationContainer.removeAll();
            }
            return this.size;
        }

        public UnitCategoryTableModel.Type getModelType() {
            return this.isNbms ? UnitCategoryTableModel.Type.LOCAL : UnitCategoryTableModel.Type.AVAILABLE;
        }

        public UpdateUnitProvider.CATEGORY getSourceCategory() {
            return this.updateEl.getSourceCategory();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Installed
    extends Unit {
        private UpdateElement installEl = null;
        private UpdateElement backupEl = null;
        private boolean uninstallationAllowed;
        private boolean deactivationAllowed;
        private boolean activationAllowed;

        public static boolean isOperationAllowed(UpdateUnit updateUnit, UpdateElement updateElement, OperationContainer<OperationSupport> operationContainer) {
            return operationContainer.canBeAdded(updateUnit, updateElement);
        }

        public Installed(UpdateUnit updateUnit, String string) {
            super(string);
            this.updateUnit = updateUnit;
            if (updateUnit.getInstalled() == null && updateUnit.isPending()) {
                this.installEl = (UpdateElement)updateUnit.getAvailableUpdates().get(0);
                assert (this.installEl != null) : "Pending UpdateUnit " + updateUnit + " has UpdateElement for update.";
            } else {
                this.installEl = updateUnit.getInstalled();
                assert (this.installEl != null) : "Installed UpdateUnit " + updateUnit + " has Installed UpdateElement.";
            }
            this.backupEl = updateUnit.getBackup();
            OperationContainer<OperationSupport> operationContainer = null;
            operationContainer = UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT == this.updateUnit.getType() ? Containers.forCustomUninstall() : Containers.forUninstall();
            this.uninstallationAllowed = Installed.isOperationAllowed(this.updateUnit, this.installEl, operationContainer);
            this.deactivationAllowed = Installed.isOperationAllowed(this.updateUnit, this.installEl, Containers.forDisable());
            this.activationAllowed = Installed.isOperationAllowed(this.updateUnit, this.installEl, Containers.forEnable());
            this.initState();
        }

        public boolean isUninstallAllowed() {
            return this.uninstallationAllowed;
        }

        public boolean isDeactivationAllowed() {
            return this.deactivationAllowed;
        }

        public boolean isActivationAllowed() {
            return this.activationAllowed;
        }

        @Override
        public boolean isMarked() {
            OperationContainer<OperationSupport> operationContainer = null;
            operationContainer = UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT == this.updateUnit.getType() ? Containers.forCustomUninstall() : Containers.forUninstall();
            boolean bl = operationContainer.contains(this.installEl);
            boolean bl2 = Containers.forDisable().contains(this.installEl);
            boolean bl3 = Containers.forEnable().contains(this.installEl);
            return bl2 || bl || bl3;
        }

        @Override
        public void setMarked(boolean bl) {
            OperationContainer<OperationSupport> operationContainer;
            assert (bl != this.isMarked());
            if (this.isUninstallAllowed()) {
                operationContainer = null;
                operationContainer = UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT == this.updateUnit.getType() ? Containers.forCustomUninstall() : Containers.forUninstall();
                if (bl) {
                    operationContainer.add(this.updateUnit, this.installEl);
                } else {
                    operationContainer.remove(this.installEl);
                }
            }
            if (this.isDeactivationAllowed()) {
                operationContainer = Containers.forDisable();
                if (bl) {
                    operationContainer.add(this.updateUnit, this.installEl);
                } else {
                    operationContainer.remove(this.installEl);
                }
            } else if (this.isActivationAllowed()) {
                operationContainer = Containers.forEnable();
                if (bl) {
                    operationContainer.add(this.updateUnit, this.installEl);
                } else {
                    operationContainer.remove(this.installEl);
                }
            }
        }

        public static int compareEnabledState(Unit unit, Unit unit2) {
            if (unit instanceof Installed && unit2 instanceof Installed) {
                Installed installed = (Installed)unit;
                Installed installed2 = (Installed)unit2;
                int n = Boolean.valueOf(installed.getRelevantElement().isEnabled()).compareTo(installed2.getRelevantElement().isEnabled());
                return n == 0 ? Boolean.valueOf(installed.updateUnit.isPending()).compareTo(installed2.updateUnit.isPending()) : n;
            }
            return Unit.compareDisplayVersions(unit, unit2);
        }

        public static int compareInstalledVersions(Unit unit, Unit unit2) {
            if (unit instanceof Installed && unit2 instanceof Installed) {
                Installed installed = (Installed)unit;
                Installed installed2 = (Installed)unit2;
                if (installed.getInstalledVersion() == null) {
                    if (installed2.getInstalledVersion() == null) {
                        return 0;
                    }
                    return -1;
                }
                if (installed2.getInstalledVersion() == null) {
                    return 1;
                }
                return new SpecificationVersion(installed.getInstalledVersion()).compareTo((Object)new SpecificationVersion(installed2.getInstalledVersion()));
            }
            return Unit.compareDisplayVersions(unit, unit2);
        }

        @Override
        public boolean canBeMarked() {
            return super.canBeMarked() && (this.isDeactivationAllowed() || this.isUninstallAllowed() || this.isActivationAllowed());
        }

        public String getInstalledVersion() {
            return this.installEl.getSpecificationVersion();
        }

        public String getBackupVersion() {
            return this.backupEl == null ? "-" : this.backupEl.getSpecificationVersion();
        }

        public Integer getMyRating() {
            return null;
        }

        @Override
        public UpdateElement getRelevantElement() {
            return this.installEl;
        }

        @Override
        public int getCompleteSize() {
            return -1;
        }

        @Override
        public UnitCategoryTableModel.Type getModelType() {
            return UnitCategoryTableModel.Type.INSTALLED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InternalUpdate
    extends Update {
        private List<UpdateUnit> internalUpdates;

        public InternalUpdate(UpdateUnit updateUnit, String string, boolean bl) {
            super(updateUnit, false, string);
        }

        public List<UpdateUnit> getUpdateUnits() {
            if (this.internalUpdates == null) {
                this.internalUpdates = new ArrayList<UpdateUnit>();
            }
            return this.internalUpdates;
        }

        public UpdateUnit getVisibleUnit() {
            return this.updateUnit;
        }

        @Override
        public UpdateElement getRelevantElement() {
            return this.updateUnit.getInstalled();
        }

        @Override
        public boolean isMarked() {
            OperationContainer<InstallSupport> operationContainer = Containers.forUpdate();
            for (UpdateUnit updateUnit : this.getUpdateUnits()) {
                if (operationContainer.contains((UpdateElement)updateUnit.getAvailableUpdates().get(0))) continue;
                return false;
            }
            return true;
        }

        @Override
        public String getAvailableVersion() {
            return this.getInstalledVersion() + " " + Unit.getBundle("Unit_InternalUpdates_Version");
        }

        @Override
        public void setMarked(boolean bl) {
            assert (bl != this.isMarked());
            OperationContainer<InstallSupport> operationContainer = Containers.forUpdate();
            for (UpdateUnit updateUnit : this.getUpdateUnits()) {
                if (bl) {
                    if (!operationContainer.canBeAdded(updateUnit, (UpdateElement)updateUnit.getAvailableUpdates().get(0))) continue;
                    operationContainer.add(updateUnit, (UpdateElement)updateUnit.getAvailableUpdates().get(0));
                    continue;
                }
                operationContainer.remove((UpdateElement)updateUnit.getAvailableUpdates().get(0));
            }
        }

        @Override
        public int getCompleteSize() {
            if (this.size == -1) {
                this.size = 0;
                for (UpdateUnit updateUnit : this.getUpdateUnits()) {
                    this.size += ((UpdateElement)updateUnit.getAvailableUpdates().get(0)).getDownloadSize();
                }
            }
            return this.size;
        }

        @Override
        public String getSize() {
            return Utilities.getDownloadSizeAsString(this.getCompleteSize());
        }

        @Override
        public UnitCategoryTableModel.Type getModelType() {
            return UnitCategoryTableModel.Type.UPDATE;
        }
    }

    public static class Update
    extends Unit {
        private UpdateElement installEl = null;
        private UpdateElement updateEl = null;
        private boolean isNbms;
        protected int size = -1;

        public Update(UpdateUnit updateUnit, boolean bl, String string) {
            super(string);
            this.isNbms = bl;
            this.updateUnit = updateUnit;
            this.installEl = updateUnit.getInstalled();
            assert (this.installEl != null) : "Updateable UpdateUnit " + updateUnit + " has Installed UpdateElement.";
            if (updateUnit.getAvailableUpdates().size() > 0) {
                this.updateEl = (UpdateElement)updateUnit.getAvailableUpdates().get(0);
                assert (this.updateEl != null) : "Updateable UpdateUnit " + updateUnit + " has UpdateElement for update.";
            }
            this.initState();
        }

        public boolean isMarked() {
            Object object = null;
            object = this.isNbms ? Containers.forUpdateNbms() : (UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT == this.updateUnit.getType() ? Containers.forCustomInstall() : Containers.forUpdate());
            return object.contains(this.updateEl);
        }

        public void setMarked(boolean bl) {
            assert (bl != this.isMarked());
            Object object = null;
            object = this.isNbms ? Containers.forUpdateNbms() : (UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT == this.updateUnit.getType() ? Containers.forCustomInstall() : Containers.forUpdate());
            if (bl) {
                object.add(this.updateUnit, this.updateEl);
            } else {
                object.remove(this.updateEl);
            }
        }

        public static int compareInstalledVersions(Unit unit, Unit unit2) {
            if (unit instanceof Update && unit2 instanceof Update) {
                Update update = (Update)unit;
                Update update2 = (Update)unit2;
                return new SpecificationVersion(update.getInstalledVersion()).compareTo((Object)new SpecificationVersion(update2.getInstalledVersion()));
            }
            return Unit.compareDisplayVersions(unit, unit2);
        }

        public static int compareAvailableVersions(Unit unit, Unit unit2) {
            if (unit instanceof Update && unit2 instanceof Update) {
                Update update = (Update)unit;
                Update update2 = (Update)unit2;
                return new SpecificationVersion(update.getAvailableVersion()).compareTo((Object)new SpecificationVersion(update2.getAvailableVersion()));
            }
            return Unit.compareDisplayVersions(unit, unit2);
        }

        public String getInstalledVersion() {
            return this.installEl.getSpecificationVersion();
        }

        public String getAvailableVersion() {
            return this.updateEl.getSpecificationVersion();
        }

        public String getSize() {
            return Utilities.getDownloadSizeAsString(this.updateEl.getDownloadSize());
        }

        public UpdateElement getRelevantElement() {
            return this.updateEl;
        }

        public int getCompleteSize() {
            if (this.size == -1) {
                this.size = 0;
                OperationContainer operationContainer = OperationContainer.createForDirectUpdate();
                OperationContainer.OperationInfo operationInfo = operationContainer.add(this.getRelevantElement());
                Set set = operationInfo.getRequiredElements();
                for (UpdateElement updateElement : set) {
                    this.size += updateElement.getDownloadSize();
                }
                this.size += this.getRelevantElement().getDownloadSize();
                operationContainer.removeAll();
            }
            return this.size;
        }

        public UnitCategoryTableModel.Type getModelType() {
            return this.isNbms ? UnitCategoryTableModel.Type.LOCAL : UnitCategoryTableModel.Type.UPDATE;
        }
    }
}

