/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.spiderchart;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public class SpiderChartIcon {
    private ImageIcon icon = null;
    private ImageIcon cachedImage = null;

    public ImageIcon getIcon() {
        if (this.icon == null) {
            try {
                this.icon = new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/components/spiderchart/spiderchart.png"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.icon;
    }

    public ImageIcon getIcon(int width) {
        if (this.cachedImage != null && this.cachedImage.getIconWidth() == width) {
            return this.cachedImage;
        }
        this.cachedImage = SpiderChartIcon.getFasterScaledInstance(this.getIcon(), width, -1);
        return this.cachedImage;
    }

    public ImageIcon getIcon(int width, int height) {
        if (this.cachedImage != null && this.cachedImage.getIconWidth() == width && this.cachedImage.getIconHeight() == height) {
            return this.cachedImage;
        }
        this.cachedImage = SpiderChartIcon.getFasterScaledInstance(this.getIcon(), width, height);
        return this.cachedImage;
    }

    public static ImageIcon getFasterScaledInstance(ImageIcon img, int targetWidth, int targetHeight) {
        if (img == null) {
            return null;
        }
        if (targetWidth == -1 && targetHeight > 0) {
            targetWidth = (int)((double)(img.getIconWidth() * targetHeight) * 1.0 / (double)img.getIconHeight());
        } else if (targetHeight == -1 && targetWidth > 0) {
            targetHeight = (int)((double)(img.getIconHeight() * targetWidth) * 1.0 / (double)img.getIconWidth());
        } else if (targetWidth <= 0 || targetHeight <= 0) {
            return img;
        }
        BufferedImage buf = new BufferedImage(img.getIconWidth(), img.getIconHeight(), 2);
        buf.createGraphics().drawImage(img.getImage(), 0, 0, null);
        BufferedImage newImg = SpiderChartIcon.getFasterScaledInstance(buf, targetWidth, targetHeight, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
        return new ImageIcon(newImg);
    }

    public static BufferedImage getFasterScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean progressiveBilinear) {
        int h;
        int w;
        boolean isTranslucent;
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        BufferedImage scratchImage = null;
        Graphics2D g2 = null;
        int prevW = ret.getWidth();
        int prevH = ret.getHeight();
        if (targetWidth > img.getWidth() || targetHeight > img.getHeight()) {
            progressiveBilinear = false;
        }
        boolean bl = isTranslucent = img.getTransparency() != 1;
        if (progressiveBilinear) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (progressiveBilinear && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (progressiveBilinear && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            if (scratchImage == null || isTranslucent) {
                scratchImage = new BufferedImage(w, h, type);
                g2 = scratchImage.createGraphics();
            }
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, 0, 0, prevW, prevH, null);
            prevW = w;
            prevH = h;
            ret = scratchImage;
        } while (w != targetWidth || h != targetHeight);
        if (g2 != null) {
            g2.dispose();
        }
        if (targetWidth != ret.getWidth() || targetHeight != ret.getHeight()) {
            scratchImage = new BufferedImage(targetWidth, targetHeight, type);
            g2 = scratchImage.createGraphics();
            g2.drawImage((Image)ret, 0, 0, null);
            g2.dispose();
            ret = scratchImage;
        }
        return ret;
    }
}

