/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Toolkit;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib.KitsTracker;
import org.netbeans.modules.editor.lib.SettingsConversions;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public class Formatter {
    private static final Map<Class, Formatter> kitClass2Formatter = new WeakHashMap<Class, Formatter>();
    private static final Map<MimePath, Formatter> mimePath2Formatter = new WeakHashMap<MimePath, Formatter>();
    private static final int ISC_MAX_TAB_SIZE = 16;
    private static final int ISC_MAX_INDENT_SIZE = 32;
    private static final String[][] indentStringCache = new String[16][];
    private final Class kitClass;
    private boolean inited;
    private int tabSize;
    private boolean customTabSize;
    private Integer shiftWidth;
    private boolean customShiftWidth;
    private boolean expandTabs;
    private boolean customExpandTabs;
    private int spacesPerTab;
    private boolean customSpacesPerTab;
    private final Preferences prefs;
    private final PreferenceChangeListener prefsListener = new PreferenceChangeListener(){

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            int n;
            String string;
            String string2 = string = preferenceChangeEvent == null ? null : preferenceChangeEvent.getKey();
            if (!(Formatter.this.inited && string != null && !"tab-size".equals(string) || Formatter.this.customTabSize)) {
                Formatter.this.tabSize = Formatter.this.prefs.getInt("tab-size", 8);
            }
            if (!Formatter.this.customShiftWidth && (n = Formatter.this.prefs.getInt("indent-shift-width", -1)) >= 0) {
                Formatter.this.shiftWidth = n;
            }
            if (!(Formatter.this.inited && string != null && !"expand-tabs".equals(string) || Formatter.this.customExpandTabs)) {
                Formatter.this.expandTabs = Formatter.this.prefs.getBoolean("expand-tabs", true);
            }
            if (!(Formatter.this.inited && string != null && !"spaces-per-tab".equals(string) || Formatter.this.customSpacesPerTab)) {
                Formatter.this.spacesPerTab = Formatter.this.prefs.getInt("spaces-per-tab", 4);
            }
            Formatter.this.inited = true;
            SettingsConversions.callSettingsChange(Formatter.this);
        }
    };
    private static ThreadLocal<Stack<Reference<Document>>> FORMATTING_CONTEXT_DOCUMENT = new ThreadLocal<Stack<Reference<Document>>>(){

        @Override
        protected Stack<Reference<Document>> initialValue() {
            return new Stack<Reference<Document>>();
        }
    };
    private static boolean noIndentUtils = false;
    private static WeakReference<Class> indentUtilsClassRef = null;

    public static synchronized Formatter getFormatter(Class clazz) {
        String string = KitsTracker.getInstance().findMimeType(clazz);
        if (string != null) {
            return Formatter.getFormatter(string);
        }
        Formatter formatter = kitClass2Formatter.get(clazz);
        if (formatter == null) {
            formatter = BaseKit.getKit(clazz).createFormatter();
            kitClass2Formatter.put(clazz, formatter);
        }
        return formatter;
    }

    public static synchronized Formatter getFormatter(String string) {
        MimePath mimePath = MimePath.parse((String)string);
        Formatter formatter = mimePath2Formatter.get(mimePath);
        if (formatter == null) {
            EditorKit editorKit = (EditorKit)MimeLookup.getLookup((MimePath)mimePath).lookup(EditorKit.class);
            formatter = editorKit instanceof BaseKit ? ((BaseKit)editorKit).createFormatter() : BaseKit.getKit(BaseKit.class).createFormatter();
            mimePath2Formatter.put(mimePath, formatter);
        }
        return formatter;
    }

    private static synchronized void setFormatter(String string, Formatter formatter) {
        mimePath2Formatter.put(MimePath.parse((String)string), formatter);
    }

    public static synchronized void setFormatter(Class clazz, Formatter formatter) {
        String string = KitsTracker.getInstance().findMimeType(clazz);
        if (string != null) {
            Formatter.setFormatter(string, formatter);
        } else {
            kitClass2Formatter.put(clazz, formatter);
        }
    }

    public Formatter(Class clazz) {
        this.kitClass = clazz;
        String string = BaseKit.getKit(clazz).getContentType();
        this.prefs = (Preferences)MimeLookup.getLookup((MimePath)MimePath.parse((String)string)).lookup(Preferences.class);
        this.prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefsListener, (Object)this.prefs));
    }

    public Class getKitClass() {
        return this.kitClass;
    }

    public int getTabSize() {
        Object object;
        Document document = Formatter.getFormattingContextDocument();
        if (document != null && (object = Formatter.callIndentUtils("tabSize", document)) instanceof Integer) {
            return (Integer)object;
        }
        if (!this.customTabSize && !this.inited) {
            this.prefsListener.preferenceChange(null);
        }
        return this.tabSize;
    }

    public void setTabSize(int n) {
        this.customTabSize = true;
        this.tabSize = n;
    }

    public int getShiftWidth() {
        Object object;
        Document document = Formatter.getFormattingContextDocument();
        if (document != null && (object = Formatter.callIndentUtils("indentLevelSize", document)) instanceof Integer) {
            return (Integer)object;
        }
        if (!this.customShiftWidth && !this.inited) {
            this.prefsListener.preferenceChange(null);
        }
        return this.shiftWidth != null ? this.shiftWidth.intValue() : this.getSpacesPerTab();
    }

    public void setShiftWidth(int n) {
        this.customShiftWidth = true;
        if (this.shiftWidth == null || this.shiftWidth != n) {
            this.shiftWidth = new Integer(n);
        }
    }

    public boolean expandTabs() {
        Object object;
        Document document = Formatter.getFormattingContextDocument();
        if (document != null && (object = Formatter.callIndentUtils("isExpandTabs", document)) instanceof Boolean) {
            return (Boolean)object;
        }
        if (!this.customExpandTabs && !this.inited) {
            this.prefsListener.preferenceChange(null);
        }
        return this.expandTabs;
    }

    public void setExpandTabs(boolean bl) {
        this.customExpandTabs = true;
        this.expandTabs = bl;
    }

    public int getSpacesPerTab() {
        Object object;
        Document document = Formatter.getFormattingContextDocument();
        if (document != null && (object = Formatter.callIndentUtils("indentLevelSize", document)) instanceof Integer) {
            return (Integer)object;
        }
        if (!this.customSpacesPerTab && !this.inited) {
            this.prefsListener.preferenceChange(null);
        }
        return this.spacesPerTab;
    }

    public void setSpacesPerTab(int n) {
        this.customSpacesPerTab = true;
        this.spacesPerTab = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIndentString(BaseDocument baseDocument, int n) {
        Formatter.pushFormattingContextDocument(baseDocument);
        try {
            String string = Formatter.getIndentString(n, this.expandTabs(), baseDocument.getTabSize());
            return string;
        }
        finally {
            Formatter.popFormattingContextDocument(baseDocument);
        }
    }

    public String getIndentString(int n) {
        return Formatter.getIndentString(n, this.expandTabs(), this.getTabSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTabString(final BaseDocument baseDocument, final int n) throws BadLocationException {
        Formatter.pushFormattingContextDocument(baseDocument);
        try {
            final BadLocationException[] badLocationExceptionArray = new BadLocationException[1];
            baseDocument.runAtomic(new Runnable(){

                public void run() {
                    try {
                        int n6;
                        int n2 = Utilities.getRowStart(baseDocument, n);
                        int n3 = Utilities.getFirstNonWhiteBwd(baseDocument, n, n2);
                        n3 = n3 >= 0 ? n3 + 1 : n2;
                        int n4 = Utilities.getVisualColumn(baseDocument, n3);
                        int n5 = Utilities.getNextTabColumn(baseDocument, n);
                        String string = Analyzer.getWhitespaceString(n4, n5, Formatter.this.expandTabs(), baseDocument.getTabSize());
                        char[] cArray = baseDocument.getChars(n3, n - n3);
                        for (n6 = 0; n6 < cArray.length && cArray[n6] == string.charAt(n6); ++n6) {
                        }
                        baseDocument.remove(n3 += n6, n - n3);
                        baseDocument.insertString(n3, string.substring(n6), null);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationExceptionArray[0] = badLocationException;
                    }
                }
            });
            if (badLocationExceptionArray[0] != null) {
                throw badLocationExceptionArray[0];
            }
        }
        finally {
            Formatter.popFormattingContextDocument(baseDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeRowIndent(final BaseDocument baseDocument, final int n, final int n2) throws BadLocationException {
        Formatter.pushFormattingContextDocument(baseDocument);
        try {
            final BadLocationException[] badLocationExceptionArray = new BadLocationException[1];
            baseDocument.runAtomic(new Runnable(){

                public void run() {
                    try {
                        int n5 = n2 < 0 ? 0 : n2;
                        int n22 = Utilities.getRowFirstNonWhite(baseDocument, n);
                        if (n22 == -1) {
                            n22 = Utilities.getRowEnd(baseDocument, n);
                        }
                        int n3 = Utilities.getRowStart(baseDocument, n);
                        int n4 = n22 - n3;
                        CharSequence charSequence = DocumentUtilities.getText((Document)baseDocument, (int)n3, (int)n4);
                        String string = Formatter.this.getIndentString(baseDocument, n5);
                        if (CharSequenceUtilities.startsWith((CharSequence)string, (CharSequence)charSequence)) {
                            string = string.substring(n4);
                            n3 += n4;
                            n4 = 0;
                        } else if (CharSequenceUtilities.endsWith((CharSequence)string, (CharSequence)charSequence)) {
                            string = string.substring(0, string.length() - n4);
                            n4 = 0;
                        }
                        if (n4 != 0) {
                            baseDocument.remove(n3, n4);
                        }
                        baseDocument.insertString(n3, string, null);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationExceptionArray[0] = badLocationException;
                    }
                }
            });
            if (badLocationExceptionArray[0] != null) {
                throw badLocationExceptionArray[0];
            }
        }
        finally {
            Formatter.popFormattingContextDocument(baseDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeBlockIndent(final BaseDocument baseDocument, final int n, final int n2, final int n3) throws BadLocationException {
        Formatter.pushFormattingContextDocument(baseDocument);
        try {
            GuardedDocument guardedDocument;
            GuardedDocument guardedDocument2 = guardedDocument = baseDocument instanceof GuardedDocument ? (GuardedDocument)baseDocument : null;
            if (guardedDocument != null) {
                for (int i = n; i < n2; ++i) {
                    if (!guardedDocument.isPosGuarded(i)) continue;
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
            final BadLocationException[] badLocationExceptionArray = new BadLocationException[1];
            baseDocument.runAtomic(new Runnable(){

                public void run() {
                    try {
                        int n5 = n3 * baseDocument.getShiftWidth();
                        int n22 = n2 > 0 && Utilities.getRowStart(baseDocument, n2) == n2 ? n2 - 1 : n2;
                        int n32 = Utilities.getRowStart(baseDocument, n);
                        for (int i = Utilities.getRowCount(baseDocument, n, n22); i > 0; --i) {
                            int n4 = Utilities.getRowIndent(baseDocument, n32);
                            if (Utilities.isRowWhite(baseDocument, n32)) {
                                n4 = -n5;
                            }
                            Formatter.this.changeRowIndent(baseDocument, n32, Math.max(n4 + n5, 0));
                            n32 = Utilities.getRowStart(baseDocument, n32, 1);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationExceptionArray[0] = badLocationException;
                    }
                }
            });
            if (badLocationExceptionArray[0] != null) {
                throw badLocationExceptionArray[0];
            }
        }
        finally {
            Formatter.popFormattingContextDocument(baseDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shiftLine(BaseDocument baseDocument, int n, boolean bl) throws BadLocationException {
        Formatter.pushFormattingContextDocument(baseDocument);
        try {
            int n2 = baseDocument.getShiftWidth();
            if (!bl) {
                n2 = -n2;
            }
            n2 = Utilities.isRowWhite(baseDocument, n) ? (n2 += Utilities.getVisualColumn(baseDocument, n)) : (n2 += Utilities.getRowIndent(baseDocument, n));
            n2 = Math.max(n2, 0);
            this.changeRowIndent(baseDocument, n, n2);
        }
        finally {
            Formatter.popFormattingContextDocument(baseDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reformat(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        Formatter.pushFormattingContextDocument(baseDocument);
        try {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            Writer writer = this.createWriter(baseDocument, n, charArrayWriter);
            String string = baseDocument.getText(n, n2 - n);
            writer.write(string);
            writer.close();
            String string2 = new String(charArrayWriter.toCharArray());
            if (!string2.equals(string)) {
                baseDocument.remove(n, n2 - n);
                baseDocument.insertString(n, string2, null);
                int n3 = string2.length();
                return n3;
            }
            int n4 = 0;
            return n4;
        }
        catch (IOException iOException) {
            Utilities.annotateLoggable(iOException);
            int n5 = 0;
            return n5;
        }
        finally {
            Formatter.popFormattingContextDocument(baseDocument);
        }
    }

    public int indentLine(Document document, int n) {
        return n;
    }

    public int indentNewLine(Document document, int n) {
        try {
            document.insertString(n, "\n", null);
            ++n;
        }
        catch (GuardedException guardedException) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (BadLocationException badLocationException) {
            Utilities.annotateLoggable(badLocationException);
        }
        return n;
    }

    public Writer createWriter(Document document, int n, Writer writer) {
        return writer;
    }

    public void indentLock() {
    }

    public void indentUnlock() {
    }

    public void reformatLock() {
    }

    public void reformatUnlock() {
    }

    private static Document getFormattingContextDocument() {
        Stack<Reference<Document>> stack = FORMATTING_CONTEXT_DOCUMENT.get();
        return stack.isEmpty() ? null : stack.peek().get();
    }

    static void pushFormattingContextDocument(Document document) {
        FORMATTING_CONTEXT_DOCUMENT.get().push(new WeakReference<Document>(document));
    }

    static void popFormattingContextDocument(Document document) {
        Stack<Reference<Document>> stack = FORMATTING_CONTEXT_DOCUMENT.get();
        assert (!stack.empty()) : "Calling popFormattingContextDocument without pushFormattingContextDocument";
        Reference<Document> reference = stack.pop();
        Document document2 = reference.get();
        assert (document2 == document) : "Popping " + document + ", but the stack contains " + document2;
        reference.clear();
    }

    private static Object callIndentUtils(String string, Document document) {
        Object object;
        Class<?> clazz;
        if (noIndentUtils) {
            return null;
        }
        Class<?> clazz2 = clazz = indentUtilsClassRef == null ? null : (Class<?>)indentUtilsClassRef.get();
        if (clazz == null) {
            try {
                object = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                clazz = ((ClassLoader)object).loadClass("org.netbeans.modules.editor.indent.api.IndentUtils");
                indentUtilsClassRef = new WeakReference(clazz);
            }
            catch (Exception exception) {
                noIndentUtils = true;
                return null;
            }
        }
        try {
            object = clazz.getDeclaredMethod(string, Document.class);
            return ((Method)object).invoke(null, document);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getIndentString(int n, boolean bl, int n2) {
        if (n <= 0) {
            return "";
        }
        if (bl) {
            n2 = 0;
        }
        String[][] stringArray = indentStringCache;
        synchronized (indentStringCache) {
            boolean bl2 = n2 >= indentStringCache.length || n > 32;
            String string = null;
            String[] stringArray2 = null;
            if (!bl2) {
                stringArray2 = indentStringCache[n2];
                if (stringArray2 == null) {
                    stringArray2 = new String[32];
                    Formatter.indentStringCache[n2] = stringArray2;
                }
                string = stringArray2[n - 1];
            }
            if (string == null) {
                string = Analyzer.getIndentString(n, bl, n2);
                if (!bl2) {
                    stringArray2[n - 1] = string;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return string;
        }
    }
}

