/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldStateChange;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.AtomicLockEvent;
import org.netbeans.editor.AtomicLockListener;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib.SettingsConversions;
import org.openide.util.WeakListeners;

public class BaseCaret
implements Caret,
MouseListener,
MouseMotionListener,
PropertyChangeListener,
DocumentListener,
ActionListener,
AtomicLockListener,
FoldHierarchyListener {
    public static final String BLOCK_CARET = "block-caret";
    public static final String LINE_CARET = "line-caret";
    public static final String THIN_LINE_CARET = "thin-line-caret";
    public static final String THICK_LINE_CARET = "thick-line-caret";
    private static final Logger LOG = Logger.getLogger(BaseCaret.class.getName());
    private final ListenerImpl listenerImpl;
    private Rectangle caretBounds;
    protected JTextComponent component;
    Point magicCaretPosition;
    MarkFactory.ContextMark caretMark = new MarkFactory.ContextMark(Position.Bias.Forward, false);
    MarkFactory.ContextMark selectionMark = new MarkFactory.ContextMark(Position.Bias.Forward, false);
    boolean caretVisible;
    boolean blinkVisible;
    boolean selectionVisible;
    protected EventListenerList listenerList = new EventListenerList();
    protected Timer flasher;
    String type;
    int width;
    boolean italic;
    private int[] xPoints = new int[4];
    private int[] yPoints = new int[4];
    private Action selectWordAction;
    private Action selectLineAction;
    protected ChangeEvent changeEvent;
    protected char[] dotChar = new char[]{' '};
    private boolean overwriteMode;
    private BaseDocument listenDoc;
    protected Font afterCaretFont;
    protected Font beforeCaretFont;
    protected Color textForeColor;
    protected Color textBackColor;
    private transient FocusListener focusListener;
    private transient boolean inAtomicLock = false;
    private transient boolean inAtomicUnlock = false;
    private transient boolean modified;
    private transient int undoOffset = -1;
    static final long serialVersionUID = -9113841520331402768L;
    private MouseEvent dndArmedEvent = null;
    private boolean updateAfterFoldHierarchyChange;
    private FoldHierarchyListener weakFHListener;
    private boolean typingModificationOccurred;
    private Preferences prefs = null;
    private final PreferenceChangeListener prefsListener = new PreferenceChangeListener(){

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            String string;
            String string2 = string = preferenceChangeEvent == null ? null : preferenceChangeEvent.getKey();
            if (string == null || "caret-blink-rate".equals(string)) {
                SettingsConversions.callSettingsChange(BaseCaret.this);
                int n = BaseCaret.this.prefs.getInt("caret-blink-rate", -1);
                if (n == -1) {
                    JTextComponent jTextComponent = BaseCaret.this.component;
                    Integer n2 = jTextComponent == null ? null : (Integer)jTextComponent.getClientProperty("nbeditor-default-swing-caret-blink-rate");
                    n = n2 != null ? n2 : 300;
                }
                BaseCaret.this.setBlinkRate(n);
                BaseCaret.this.refresh();
            }
        }
    };
    private PreferenceChangeListener weakPrefsListener = null;

    public BaseCaret() {
        this.listenerImpl = new ListenerImpl();
    }

    void updateType() {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null && this.prefs != null) {
            boolean bl;
            String string;
            int n = 0;
            Color color = Color.black;
            if (this.overwriteMode) {
                string = this.prefs.get("caret-type-overwrite-mode", BLOCK_CARET);
                bl = this.prefs.getBoolean("caret-italic-overwrite-mode", false);
            } else {
                string = this.prefs.get("caret-type-insert-mode", LINE_CARET);
                bl = this.prefs.getBoolean("caret-italic-insert-mode", false);
                n = this.prefs.getInt("thick-caret-width", 5);
            }
            FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((String)DocumentUtilities.getMimeType((JTextComponent)jTextComponent)).lookup(FontColorSettings.class);
            if (fontColorSettings != null) {
                if (this.overwriteMode) {
                    AttributeSet attributeSet = fontColorSettings.getFontColors("caret-color-overwrite-mode");
                    if (attributeSet != null) {
                        color = (Color)attributeSet.getAttribute(StyleConstants.Foreground);
                    }
                } else {
                    AttributeSet attributeSet = fontColorSettings.getFontColors("caret-color-insert-mode");
                    if (attributeSet != null) {
                        color = (Color)attributeSet.getAttribute(StyleConstants.Foreground);
                    }
                }
            }
            this.type = string;
            this.italic = bl;
            this.width = n;
            jTextComponent.setCaretColor(color);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Updating caret color:" + color + '\n');
            }
            this.resetBlink();
            this.dispatchUpdate(false);
        }
    }

    private boolean updateCaretBounds() {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            Rectangle rectangle;
            int n = this.getDot();
            try {
                rectangle = jTextComponent.getUI().modelToView(jTextComponent, n, Position.Bias.Forward);
                BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
                if (baseDocument != null) {
                    baseDocument.getChars(n, this.dotChar, 0, 1);
                }
            }
            catch (BadLocationException badLocationException) {
                rectangle = null;
                Utilities.annotateLoggable(badLocationException);
            }
            if (rectangle != null) {
                this.caretBounds = rectangle;
                return true;
            }
        }
        return false;
    }

    public void install(JTextComponent jTextComponent) {
        assert (SwingUtilities.isEventDispatchThread());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Installing to " + BaseCaret.s2s(jTextComponent));
        }
        this.component = jTextComponent;
        this.blinkVisible = true;
        BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
        if (baseDocument != null) {
            this.modelChanged(null, baseDocument);
        }
        this.updateCaretBounds();
        if (this.caretBounds == null) {
            this.component.addComponentListener(this.listenerImpl);
        }
        this.component.addPropertyChangeListener(this);
        this.component.addFocusListener(this.listenerImpl);
        this.component.addMouseListener(this);
        this.component.addMouseMotionListener(this);
        EditorUI editorUI = Utilities.getEditorUI(this.component);
        editorUI.addPropertyChangeListener(this);
        if (this.component.hasFocus()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Component has focus, calling BaseCaret.focusGained(); doc=" + this.component.getDocument().getProperty("title") + '\n');
            }
            this.listenerImpl.focusGained(null);
        }
        this.dispatchUpdate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deinstall(JTextComponent jTextComponent) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Deinstalling from " + BaseCaret.s2s(jTextComponent));
        }
        this.component = null;
        BaseCaret baseCaret = this;
        synchronized (baseCaret) {
            ListenerImpl listenerImpl = this.listenerImpl;
            synchronized (listenerImpl) {
                if (this.flasher != null) {
                    this.setBlinkRate(0);
                }
            }
        }
        jTextComponent.removeMouseMotionListener(this);
        jTextComponent.removeMouseListener(this);
        jTextComponent.removeFocusListener(this.listenerImpl);
        jTextComponent.removePropertyChangeListener(this);
        if (this.weakFHListener != null && (baseCaret = FoldHierarchy.get((JTextComponent)jTextComponent)) != null) {
            baseCaret.removeFoldHierarchyListener(this.weakFHListener);
        }
        this.modelChanged(this.listenDoc, null);
    }

    protected void modelChanged(BaseDocument baseDocument, BaseDocument baseDocument2) {
        if (baseDocument != null) {
            assert (baseDocument == this.listenDoc);
            DocumentUtilities.removeDocumentListener((Document)baseDocument, (DocumentListener)this, (DocumentListenerPriority)DocumentListenerPriority.CARET_UPDATE);
            baseDocument.removeAtomicLockListener(this);
            try {
                this.caretMark.remove();
                this.selectionMark.remove();
            }
            catch (InvalidMarkException invalidMarkException) {
                Utilities.annotateLoggable(invalidMarkException);
            }
            this.listenDoc = null;
            if (this.prefs != null && this.weakPrefsListener != null) {
                this.prefs.removePreferenceChangeListener(this.weakPrefsListener);
            }
        }
        if (baseDocument2 != null) {
            DocumentUtilities.addDocumentListener((Document)baseDocument2, (DocumentListener)this, (DocumentListenerPriority)DocumentListenerPriority.CARET_UPDATE);
            this.listenDoc = baseDocument2;
            baseDocument2.addAtomicLockListener(this);
            try {
                Utilities.insertMark(baseDocument2, this.caretMark, 0);
                Utilities.insertMark(baseDocument2, this.selectionMark, 0);
            }
            catch (InvalidMarkException invalidMarkException) {
                Utilities.annotateLoggable(invalidMarkException);
            }
            catch (BadLocationException badLocationException) {
                Utilities.annotateLoggable(badLocationException);
            }
            this.prefs = (Preferences)MimeLookup.getLookup((String)DocumentUtilities.getMimeType((Document)baseDocument2)).lookup(Preferences.class);
            if (this.prefs != null) {
                this.weakPrefsListener = (PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefsListener, (Object)this.prefs);
                this.prefs.addPreferenceChangeListener(this.weakPrefsListener);
            }
            Utilities.runInEventDispatchThread(new Runnable(){

                public void run() {
                    BaseCaret.this.updateType();
                }
            });
        }
    }

    public void paint(Graphics graphics) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent == null) {
            return;
        }
        EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
        if (this.getDot() != 0 && this.caretBounds == null) {
            this.update(true);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("BaseCaret.paint(): caretBounds=" + this.caretBounds + this.dumpVisibility() + '\n');
        }
        if (this.caretBounds != null && this.isVisible() && this.blinkVisible) {
            this.paintCustomCaret(graphics);
        }
    }

    protected void paintCustomCaret(Graphics graphics) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
            graphics.setColor(jTextComponent.getCaretColor());
            if (THIN_LINE_CARET.equals(this.type)) {
                int n = this.caretBounds.x;
                if (this.beforeCaretFont != null && this.beforeCaretFont.isItalic() && this.italic) {
                    n = (int)((double)n + Math.tan(this.beforeCaretFont.getItalicAngle()) * (double)this.caretBounds.height);
                }
                graphics.drawLine(n, this.caretBounds.y, this.caretBounds.x, this.caretBounds.y + this.caretBounds.height - 1);
            } else if (THICK_LINE_CARET.equals(this.type)) {
                Color color;
                int n = this.width;
                if (n <= 0) {
                    n = 5;
                }
                if (this.afterCaretFont != null) {
                    graphics.setFont(this.afterCaretFont);
                }
                if ((color = jTextComponent.getBackground()) != null) {
                    graphics.setXORMode(color);
                }
                graphics.fillRect(this.caretBounds.x, this.caretBounds.y, n, this.caretBounds.height - 1);
            } else if (BLOCK_CARET.equals(this.type)) {
                if (this.afterCaretFont != null) {
                    graphics.setFont(this.afterCaretFont);
                }
                if (this.afterCaretFont != null && this.afterCaretFont.isItalic() && this.italic) {
                    int n;
                    this.xPoints[0] = n = (int)((double)this.caretBounds.x + Math.tan(this.afterCaretFont.getItalicAngle()) * (double)this.caretBounds.height);
                    this.yPoints[0] = this.caretBounds.y;
                    this.xPoints[1] = n + this.caretBounds.width;
                    this.yPoints[1] = this.caretBounds.y;
                    this.xPoints[2] = this.caretBounds.x + this.caretBounds.width;
                    this.yPoints[2] = this.caretBounds.y + this.caretBounds.height - 1;
                    this.xPoints[3] = this.caretBounds.x;
                    this.yPoints[3] = this.caretBounds.y + this.caretBounds.height - 1;
                    graphics.fillPolygon(this.xPoints, this.yPoints, 4);
                } else {
                    graphics.fillRect(this.caretBounds.x, this.caretBounds.y, this.caretBounds.width, this.caretBounds.height);
                }
                if (!Character.isWhitespace(this.dotChar[0])) {
                    Color color = jTextComponent.getBackground();
                    if (color != null) {
                        graphics.setColor(color);
                    }
                    graphics.drawChars(this.dotChar, 0, 1, this.caretBounds.x, this.caretBounds.y + editorUI.getLineAscent());
                }
            } else {
                int n = 2;
                if (this.beforeCaretFont != null && this.beforeCaretFont.isItalic() && this.italic) {
                    int n2;
                    this.xPoints[0] = n2 = (int)((double)this.caretBounds.x + Math.tan(this.beforeCaretFont.getItalicAngle()) * (double)this.caretBounds.height);
                    this.yPoints[0] = this.caretBounds.y;
                    this.xPoints[1] = n2 + n;
                    this.yPoints[1] = this.caretBounds.y;
                    this.xPoints[2] = this.caretBounds.x + n;
                    this.yPoints[2] = this.caretBounds.y + this.caretBounds.height - 1;
                    this.xPoints[3] = this.caretBounds.x;
                    this.yPoints[3] = this.caretBounds.y + this.caretBounds.height - 1;
                    graphics.fillPolygon(this.xPoints, this.yPoints, 4);
                } else {
                    graphics.fillRect(this.caretBounds.x, this.caretBounds.y, n, this.caretBounds.height - 1);
                }
            }
        }
    }

    void dispatchUpdate(final boolean bl) {
        Utilities.runInEventDispatchThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BaseDocument baseDocument;
                JTextComponent jTextComponent = BaseCaret.this.component;
                if (jTextComponent != null && (baseDocument = Utilities.getDocument(jTextComponent)) != null) {
                    baseDocument.readLock();
                    try {
                        BaseCaret.this.update(bl);
                    }
                    finally {
                        baseDocument.readUnlock();
                    }
                }
            }
        });
    }

    protected void update(boolean bl) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
            EditorUI editorUI = baseTextUI.getEditorUI();
            BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
            if (baseDocument != null) {
                Rectangle rectangle = this.caretBounds;
                if (rectangle != null) {
                    if (this.italic) {
                        rectangle.width += rectangle.height;
                    }
                    jTextComponent.repaint(rectangle);
                }
                if (this.updateCaretBounds()) {
                    int n;
                    int n2;
                    JScrollBar jScrollBar;
                    Container container;
                    Serializable serializable;
                    Rectangle rectangle2 = new Rectangle(this.caretBounds);
                    if (rectangle == null && (serializable = jTextComponent.getParent()) instanceof JViewport && (container = ((Component)serializable).getParent()) instanceof JScrollPane && (jScrollBar = ((JScrollPane)container).getHorizontalScrollBar()) != null) {
                        n2 = jScrollBar.getPreferredSize().height;
                        Dimension dimension = ((JViewport)serializable).getExtentSize();
                        if (dimension.height >= this.caretBounds.height + n2) {
                            rectangle2.height += n2;
                        }
                    }
                    serializable = jTextComponent.getVisibleRect();
                    boolean bl2 = bl;
                    if (!(rectangle == null || bl && !this.updateAfterFoldHierarchyChange || (n = rectangle.y - ((Rectangle)serializable).y) < 0 || n >= ((Rectangle)serializable).height || rectangle.y == this.caretBounds.y && rectangle.x == this.caretBounds.x)) {
                        bl2 = true;
                        n2 = rectangle.x - ((Rectangle)serializable).x;
                        rectangle2.y = Math.max(this.caretBounds.y - n, 0);
                        rectangle2.height = ((Rectangle)serializable).height;
                    }
                    if (bl && (this.caretBounds.y > ((Rectangle)serializable).y + ((Rectangle)serializable).height + this.caretBounds.height || this.caretBounds.y + this.caretBounds.height < ((Rectangle)serializable).y - this.caretBounds.height)) {
                        rectangle2.y -= (((Rectangle)serializable).height - this.caretBounds.height) / 2;
                        rectangle2.height = ((Rectangle)serializable).height;
                    }
                    this.updateAfterFoldHierarchyChange = false;
                    if (bl2) {
                        jTextComponent.scrollRectToVisible(rectangle2);
                    }
                    this.resetBlink();
                    jTextComponent.repaint(this.caretBounds);
                }
            }
        }
    }

    private void updateSystemSelection() {
        Clipboard clipboard;
        if (this.getDot() != this.getMark() && this.component != null && (clipboard = this.getSystemSelection()) != null) {
            clipboard.setContents(new StringSelection(this.component.getSelectedText()), null);
        }
    }

    private Clipboard getSystemSelection() {
        return this.component.getToolkit().getSystemSelection();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    protected void fireStateChanged() {
        Runnable runnable = new Runnable(){

            public void run() {
                Object[] objectArray = BaseCaret.this.listenerList.getListenerList();
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != ChangeListener.class) continue;
                    if (BaseCaret.this.changeEvent == null) {
                        BaseCaret.this.changeEvent = new ChangeEvent(BaseCaret.this);
                    }
                    ((ChangeListener)objectArray[i + 1]).stateChanged(BaseCaret.this.changeEvent);
                }
            }
        };
        if (this.inAtomicUnlock) {
            SwingUtilities.invokeLater(runnable);
        } else {
            Utilities.runInEventDispatchThread(runnable);
        }
        this.updateSystemSelection();
    }

    public final boolean isVisible() {
        return this.caretVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setVisibleImpl(boolean bl) {
        Object object;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("BaseCaret.setVisible(" + bl + ")\n");
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.INFO, "", new Exception());
            }
        }
        boolean bl2 = this.isVisible();
        Object object2 = this;
        synchronized (object2) {
            object = this.listenerImpl;
            synchronized (object) {
                if (this.flasher != null) {
                    if (bl2) {
                        this.flasher.stop();
                    }
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer((bl ? "Starting" : "Stopping") + " the caret blinking timer: " + this.dumpVisibility() + '\n');
                    }
                    if (bl) {
                        this.flasher.start();
                    } else {
                        this.flasher.stop();
                    }
                }
            }
            this.caretVisible = bl;
        }
        object2 = this.component;
        if (object2 != null && this.caretBounds != null) {
            object = this.caretBounds;
            if (this.italic) {
                object = new Rectangle((Rectangle)object);
                ((Rectangle)object).width += ((Rectangle)object).height;
            }
            ((JComponent)object2).repaint((Rectangle)object);
        }
    }

    private String dumpVisibility() {
        return "visible=" + this.isVisible() + ", blinkVisible=" + this.blinkVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void resetBlink() {
        boolean bl = this.isVisible();
        ListenerImpl listenerImpl = this.listenerImpl;
        synchronized (listenerImpl) {
            if (this.flasher != null) {
                this.flasher.stop();
                this.blinkVisible = true;
                if (bl) {
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("Reset blinking (caret already visible) - starting the caret blinking timer: " + this.dumpVisibility() + '\n');
                    }
                    this.flasher.start();
                } else if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Reset blinking (caret not visible) - caret blinking timer not started: " + this.dumpVisibility() + '\n');
                }
            }
        }
    }

    public void setVisible(final boolean bl) {
        Utilities.runInEventDispatchThread(new Runnable(){

            public void run() {
                BaseCaret.this.setVisibleImpl(bl);
            }
        });
    }

    public final boolean isSelectionVisible() {
        return this.selectionVisible;
    }

    public void setSelectionVisible(boolean bl) {
        if (this.selectionVisible == bl) {
            return;
        }
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            this.selectionVisible = bl;
            BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
            try {
                baseTextUI.getEditorUI().repaintBlock(this.caretMark.getOffset(), this.selectionMark.getOffset());
            }
            catch (BadLocationException badLocationException) {
                Utilities.annotateLoggable(badLocationException);
            }
            catch (InvalidMarkException invalidMarkException) {
                Utilities.annotateLoggable(invalidMarkException);
            }
        }
    }

    public void setMagicCaretPosition(Point point) {
        this.magicCaretPosition = point;
    }

    public final Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setBlinkRate(int n) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("setBlinkRate(" + n + ")" + this.dumpVisibility() + '\n');
        }
        ListenerImpl listenerImpl = this.listenerImpl;
        synchronized (listenerImpl) {
            if (this.flasher == null && n > 0) {
                this.flasher = new Timer(n, new WeakTimerListener(this));
            }
            if (this.flasher != null) {
                if (n > 0) {
                    if (this.flasher.getDelay() != n) {
                        this.flasher.setDelay(n);
                    }
                } else {
                    this.flasher.stop();
                    this.flasher.removeActionListener(this);
                    this.flasher = null;
                    this.blinkVisible = true;
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("Zero blink rate - no blinking. flasher=null; blinkVisible=true");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getBlinkRate() {
        ListenerImpl listenerImpl = this.listenerImpl;
        synchronized (listenerImpl) {
            return this.flasher != null ? this.flasher.getDelay() : 0;
        }
    }

    public int getDot() {
        if (this.component != null) {
            try {
                return this.caretMark.getOffset();
            }
            catch (InvalidMarkException invalidMarkException) {
                // empty catch block
            }
        }
        return 0;
    }

    public int getMark() {
        if (this.component != null) {
            try {
                return this.selectionMark.getOffset();
            }
            catch (InvalidMarkException invalidMarkException) {
                // empty catch block
            }
        }
        return 0;
    }

    public void setDot(int n) {
        this.setDot(n, this.caretBounds, 0);
    }

    public void setDot(int n, boolean bl) {
        this.setDot(n, this.caretBounds, 0, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDot(int n, Rectangle rectangle, int n2, boolean bl) {
        JTextComponent jTextComponent;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("setDot: offset=" + n);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.INFO, "setDot call stack", new Exception());
            }
        }
        if ((jTextComponent = this.component) != null) {
            boolean bl2;
            block15: {
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                bl2 = false;
                baseDocument.readLock();
                try {
                    if (baseDocument == null || n < 0 || n > baseDocument.getLength()) break block15;
                    bl2 = true;
                    try {
                        Utilities.moveMark(baseDocument, this.caretMark, n);
                        Utilities.moveMark(baseDocument, this.selectionMark, n);
                        FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
                        if (this.weakFHListener == null) {
                            this.weakFHListener = (FoldHierarchyListener)WeakListeners.create(FoldHierarchyListener.class, (EventListener)this, (Object)foldHierarchy);
                            foldHierarchy.addFoldHierarchyListener(this.weakFHListener);
                        }
                        foldHierarchy.lock();
                        try {
                            Fold fold = null;
                            while (bl && (fold = FoldUtilities.findCollapsedFold((FoldHierarchy)foldHierarchy, (int)n, (int)n)) != null && fold.getStartOffset() < n && fold.getEndOffset() > n) {
                                foldHierarchy.expand(fold);
                            }
                        }
                        finally {
                            foldHierarchy.unlock();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        throw new IllegalStateException(badLocationException.toString());
                    }
                    catch (InvalidMarkException invalidMarkException) {
                        throw new IllegalStateException(invalidMarkException.toString());
                    }
                }
                finally {
                    baseDocument.readUnlock();
                }
            }
            if (bl2) {
                this.fireStateChanged();
                this.dispatchUpdate(true);
            }
        }
    }

    public void setDot(int n, Rectangle rectangle, int n2) {
        this.setDot(n, rectangle, n2, true);
    }

    public void moveDot(int n) {
        this.moveDot(n, this.caretBounds, 1);
    }

    public void moveDot(int n, Rectangle rectangle, int n2) {
        JTextComponent jTextComponent;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("moveDot: offset=" + n);
        }
        if ((jTextComponent = this.component) != null) {
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            if (baseDocument != null && n >= 0 && n <= baseDocument.getLength()) {
                try {
                    int n3 = this.getDot();
                    if (n == n3) {
                        return;
                    }
                    Utilities.moveMark(baseDocument, this.caretMark, n);
                    if (this.selectionVisible) {
                        Utilities.getEditorUI(jTextComponent).repaintBlock(n3, n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    throw new IllegalStateException(badLocationException.toString());
                }
                catch (InvalidMarkException invalidMarkException) {
                    throw new IllegalStateException(invalidMarkException.toString());
                }
            }
            this.fireStateChanged();
            this.dispatchUpdate(true);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            boolean bl;
            BaseDocument baseDocument = (BaseDocument)this.component.getDocument();
            BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
            if ((baseDocumentEvent.isInUndo() || baseDocumentEvent.isInRedo()) && this.component == Utilities.getLastActiveComponent() && !Boolean.TRUE.equals(DocumentUtilities.getEventProperty((DocumentEvent)documentEvent, (Object)"caretIgnore"))) {
                this.undoOffset = documentEvent.getOffset() + documentEvent.getLength();
                bl = true;
            } else {
                this.undoOffset = -1;
                bl = DocumentUtilities.isTypingModification((Document)this.component.getDocument());
            }
            this.modified = true;
            this.modifiedUpdate(bl);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            boolean bl;
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
            if ((baseDocumentEvent.isInUndo() || baseDocumentEvent.isInRedo()) && jTextComponent == Utilities.getLastActiveComponent() && !Boolean.TRUE.equals(DocumentUtilities.getEventProperty((DocumentEvent)documentEvent, (Object)"caretIgnore"))) {
                this.undoOffset = documentEvent.getOffset();
                bl = true;
            } else {
                this.undoOffset = -1;
                bl = DocumentUtilities.isTypingModification((Document)this.component.getDocument());
            }
            this.modified = true;
            this.modifiedUpdate(bl);
        }
    }

    private void modifiedUpdate(boolean bl) {
        if (!this.inAtomicLock) {
            JTextComponent jTextComponent = this.component;
            if (this.modified && jTextComponent != null) {
                if (this.undoOffset >= 0) {
                    this.setDot(this.undoOffset);
                } else {
                    this.fireStateChanged();
                    this.dispatchUpdate(jTextComponent.hasFocus() && bl);
                }
                this.modified = false;
            }
        } else {
            this.typingModificationOccurred |= bl;
        }
    }

    public void atomicLock(AtomicLockEvent atomicLockEvent) {
        this.inAtomicLock = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atomicUnlock(AtomicLockEvent atomicLockEvent) {
        this.inAtomicLock = false;
        this.inAtomicUnlock = true;
        try {
            this.modifiedUpdate(this.typingModificationOccurred);
        }
        finally {
            this.inAtomicUnlock = false;
            this.typingModificationOccurred = false;
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent == null) {
            this.dispatchUpdate(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mouseClicked(MouseEvent mouseEvent) {
        JTextComponent jTextComponent;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("mouseClicked: " + BaseCaret.logMouseEvent(mouseEvent));
        }
        if ((jTextComponent = this.component) == null) return;
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (mouseEvent.getClickCount() == 2) {
                BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
                int n = baseTextUI.viewToModel(jTextComponent, mouseEvent.getX(), mouseEvent.getY());
                FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
                Document document = jTextComponent.getDocument();
                if (!(document instanceof AbstractDocument)) return;
                AbstractDocument abstractDocument = (AbstractDocument)document;
                abstractDocument.readLock();
                try {
                    foldHierarchy.lock();
                    try {
                        Fold fold = FoldUtilities.findCollapsedFold((FoldHierarchy)foldHierarchy, (int)n, (int)n);
                        if (fold != null && fold.getStartOffset() <= n && fold.getEndOffset() >= n) {
                            foldHierarchy.expand(fold);
                            return;
                        }
                        if (this.selectWordAction == null) {
                            this.selectWordAction = ((BaseKit)baseTextUI.getEditorKit(jTextComponent)).getActionByName("select-word");
                        }
                        if (this.selectWordAction == null) return;
                        this.selectWordAction.actionPerformed(null);
                        return;
                    }
                    finally {
                        foldHierarchy.unlock();
                    }
                }
                finally {
                    abstractDocument.readUnlock();
                }
            } else {
                if (mouseEvent.getClickCount() != 3) return;
                if (this.selectLineAction == null) {
                    BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
                    this.selectLineAction = ((BaseKit)baseTextUI.getEditorKit(jTextComponent)).getActionByName("select-line");
                }
                if (this.selectLineAction == null) return;
                this.selectLineAction.actionPerformed(null);
            }
            return;
        }
        if (!SwingUtilities.isMiddleMouseButton(mouseEvent) || mouseEvent.getClickCount() != 1) return;
        if (jTextComponent == null) {
            return;
        }
        Toolkit toolkit = jTextComponent.getToolkit();
        Clipboard clipboard = this.getSystemSelection();
        if (clipboard == null) {
            return;
        }
        Transferable transferable = clipboard.getContents(null);
        if (transferable == null) {
            return;
        }
        final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        if (baseDocument == null) {
            return;
        }
        final int n = ((BaseTextUI)jTextComponent.getUI()).viewToModel(jTextComponent, mouseEvent.getX(), mouseEvent.getY());
        try {
            final String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            if (string == null) {
                return;
            }
            baseDocument.runAtomicAsUser(new Runnable(){

                public void run() {
                    try {
                        baseDocument.insertString(n, string, null);
                        BaseCaret.this.setDot(n + string.length());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
            return;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void mousePressedImpl(MouseEvent mouseEvent) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null && (SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isPopupTrigger() && (mouseEvent.getModifiers() & 0xC) == 0 || !this.isSelectionVisible() || this.getMark() == this.getDot())) {
            int n = ((BaseTextUI)jTextComponent.getUI()).viewToModel(jTextComponent, mouseEvent.getX(), mouseEvent.getY());
            if (n >= 0) {
                if ((mouseEvent.getModifiers() & 1) != 0) {
                    this.moveDot(n);
                } else {
                    this.setDot(n);
                }
                this.setMagicCaretPosition(null);
            }
            if (jTextComponent.isEnabled()) {
                jTextComponent.requestFocus();
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("mousePressed: " + BaseCaret.logMouseEvent(mouseEvent));
        }
        this.dndArmedEvent = null;
        if (this.isDragPossible(mouseEvent) && this.mapDragOperationFromModifiers(mouseEvent) != 0) {
            this.dndArmedEvent = mouseEvent;
            mouseEvent.consume();
            return;
        }
        this.mousePressedImpl(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("mouseReleased: " + BaseCaret.logMouseEvent(mouseEvent));
        }
        if (this.dndArmedEvent != null) {
            this.mousePressedImpl(mouseEvent);
        }
        this.dndArmedEvent = null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected int mapDragOperationFromModifiers(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiersEx();
        if ((n & 0x400) != 1024) {
            return 0;
        }
        return 3;
    }

    protected boolean isDragPossible(MouseEvent mouseEvent) {
        int n;
        Caret caret;
        int n2;
        JTextComponent jTextComponent;
        boolean bl;
        JComponent jComponent = this.getEventComponent(mouseEvent);
        boolean bl2 = jComponent == null ? false : (bl = jComponent.getTransferHandler() != null);
        if (bl && (jTextComponent = (JTextComponent)this.getEventComponent(mouseEvent)).getDragEnabled() && (n2 = (caret = jTextComponent.getCaret()).getDot()) != (n = caret.getMark())) {
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            int n3 = jTextComponent.viewToModel(point);
            int n4 = Math.min(n2, n);
            int n5 = Math.max(n2, n);
            if (n3 >= n4 && n3 < n5) {
                return true;
            }
        }
        return false;
    }

    protected JComponent getEventComponent(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof JComponent) {
            JComponent jComponent = (JComponent)object;
            return jComponent;
        }
        return null;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("mouseDragged: " + BaseCaret.logMouseEvent(mouseEvent));
        }
        if (this.dndArmedEvent != null) {
            mouseEvent.consume();
            return;
        }
        JTextComponent jTextComponent = this.component;
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && jTextComponent != null) {
            int n = ((BaseTextUI)jTextComponent.getUI()).viewToModel(jTextComponent, mouseEvent.getX(), mouseEvent.getY());
            if (n == -1) {
                n = 0;
            }
            if (n >= 0 && (mouseEvent.getModifiers() & 1) == 0) {
                this.moveDot(n);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private static final String logMouseEvent(MouseEvent mouseEvent) {
        return "x=" + mouseEvent.getX() + ", y=" + mouseEvent.getY() + ", component=" + BaseCaret.s2s(mouseEvent.getComponent()) + ", source=" + BaseCaret.s2s(mouseEvent.getSource());
    }

    private static final String s2s(Object object) {
        return object == null ? "null" : object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("document".equals(string)) {
            BaseDocument baseDocument = propertyChangeEvent.getNewValue() instanceof BaseDocument ? (BaseDocument)propertyChangeEvent.getNewValue() : null;
            this.modelChanged(this.listenDoc, baseDocument);
        } else if ("overwriteMode".equals(string)) {
            Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.overwriteMode = bl != null ? bl : false;
            this.updateType();
        } else if ("ancestor".equals(string) && propertyChangeEvent.getSource() == this.component) {
            JScrollPane jScrollPane;
            JScrollBar jScrollBar;
            Container container = this.component.getParent();
            if (container instanceof JViewport && (container = container.getParent()) instanceof JScrollPane && (jScrollBar = (jScrollPane = (JScrollPane)container).getHorizontalScrollBar()) != null) {
                jScrollBar.addComponentListener((ComponentListener)WeakListeners.create(ComponentListener.class, (EventListener)this.listenerImpl, (Object)jScrollBar));
            }
        } else if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
            Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (this.component.isFocusOwner()) {
                if (bl == Boolean.TRUE) {
                    if (this.component.isEditable()) {
                        this.setVisible(true);
                    }
                    this.setSelectionVisible(true);
                } else {
                    this.setVisible(false);
                    this.setSelectionVisible(false);
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            boolean bl = this.blinkVisible = !this.blinkVisible;
            if (this.caretBounds != null) {
                Rectangle rectangle = this.caretBounds;
                if (this.italic) {
                    rectangle = new Rectangle(rectangle);
                    rectangle.width += rectangle.height;
                }
                jTextComponent.repaint(rectangle);
            }
        }
    }

    public void foldHierarchyChanged(FoldHierarchyEvent foldHierarchyEvent) {
        boolean bl;
        int n = this.getDot();
        int n2 = foldHierarchyEvent.getAddedFoldCount();
        if (n2 > 0) {
            FoldHierarchy foldHierarchy = (FoldHierarchy)foldHierarchyEvent.getSource();
            Fold fold = null;
            while ((fold = FoldUtilities.findCollapsedFold((FoldHierarchy)foldHierarchy, (int)n, (int)n)) != null && fold.getStartOffset() < n && fold.getEndOffset() > n) {
                foldHierarchy.expand(fold);
            }
            bl = true;
        } else {
            int n3 = Integer.MAX_VALUE;
            if (foldHierarchyEvent.getAffectedStartOffset() <= n && foldHierarchyEvent.getAffectedEndOffset() >= n) {
                for (int i = 0; i < foldHierarchyEvent.getFoldStateChangeCount(); ++i) {
                    Fold fold;
                    FoldStateChange foldStateChange = foldHierarchyEvent.getFoldStateChange(i);
                    if (!foldStateChange.isCollapsedChanged() || !(fold = foldStateChange.getFold()).isCollapsed() || fold.getStartOffset() > n || fold.getEndOffset() < n || fold.getStartOffset() >= n3) continue;
                    n3 = fold.getStartOffset();
                }
                if (n3 != Integer.MAX_VALUE) {
                    this.setDot(n3, false);
                }
            }
            bl = false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BaseCaret.this.updateAfterFoldHierarchyChange = true;
                BaseCaret.this.dispatchUpdate(bl);
            }
        });
    }

    public final void refresh() {
        this.updateType();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BaseCaret.this.updateCaretBounds();
            }
        });
    }

    static {
        if (Boolean.getBoolean("netbeans.debug.editor.caret.focus") && LOG.getLevel().intValue() < Level.FINE.intValue()) {
            LOG.setLevel(Level.FINE);
        }
        if (Boolean.getBoolean("netbeans.debug.editor.caret.focus.extra") && LOG.getLevel().intValue() < Level.FINER.intValue()) {
            LOG.setLevel(Level.FINER);
        }
    }

    private class ListenerImpl
    extends ComponentAdapter
    implements FocusListener {
        ListenerImpl() {
        }

        public void focusGained(FocusEvent focusEvent) {
            JTextComponent jTextComponent;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("BaseCaret.focusGained(); doc=" + BaseCaret.this.component.getDocument().getProperty("title") + '\n');
            }
            if ((jTextComponent = BaseCaret.this.component) != null) {
                BaseCaret.this.updateType();
                if (BaseCaret.this.component.isEnabled()) {
                    if (BaseCaret.this.component.isEditable()) {
                        BaseCaret.this.setVisible(true);
                    }
                    BaseCaret.this.setSelectionVisible(true);
                }
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Caret visibility: " + BaseCaret.this.isVisible() + '\n');
                }
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Text component is null, caret will not be visible\n");
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("BaseCaret.focusLost(); doc=" + BaseCaret.this.component.getDocument().getProperty("title") + "\nFOCUS GAINER: " + focusEvent.getOppositeComponent() + '\n');
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("FOCUS EVENT: " + focusEvent + '\n');
                }
            }
            BaseCaret.this.setVisible(false);
            BaseCaret.this.setSelectionVisible(focusEvent.isTemporary());
        }

        public void componentShown(ComponentEvent componentEvent) {
            Component component = componentEvent.getComponent();
            if (component != BaseCaret.this.component) {
                Container container = component.getParent();
                if (BaseCaret.this.caretBounds != null && container instanceof JScrollPane) {
                    Rectangle rectangle = ((JScrollPane)container).getViewport().getViewRect();
                    Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y + rectangle.height, component.getWidth(), component.getHeight());
                    if (rectangle2.intersects(BaseCaret.this.caretBounds)) {
                        BaseCaret.this.dispatchUpdate(true);
                    }
                }
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            Component component = componentEvent.getComponent();
            if (component == BaseCaret.this.component && BaseCaret.this.caretBounds == null) {
                BaseCaret.this.dispatchUpdate(true);
                if (BaseCaret.this.caretBounds != null) {
                    component.removeComponentListener(this);
                }
            }
        }
    }
}

