/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.parser;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.CharInput;
import org.netbeans.api.languages.Language;
import org.netbeans.api.languages.TokenInput;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.parser.Parser;

public abstract class TokenInputUtils {
    public static TokenInput create(Language language, Parser parser, CharInput charInput) {
        return new TokenInputImpl(new TokenReader(language, parser, charInput), charInput);
    }

    public static TokenInput create(ASTToken[] aSTTokenArray) {
        return new ArrayInput(aSTTokenArray);
    }

    public static TokenInput create(List list) {
        return new ListInput(list);
    }

    private static class ArrayInput
    extends TokenInput {
        private ASTToken[] array;
        private int index = 0;
        private int length;

        private ArrayInput(ASTToken[] aSTTokenArray) {
            this.array = aSTTokenArray;
            this.length = aSTTokenArray.length;
        }

        public ASTToken read() {
            if (this.index < this.length) {
                return this.array[this.index++];
            }
            return null;
        }

        public void setIndex(int n) {
            this.index = n;
        }

        public int getIndex() {
            return this.index;
        }

        public int getOffset() {
            ASTToken aSTToken = null;
            if (this.eof()) {
                if (this.getIndex() == 0) {
                    return 0;
                }
                aSTToken = this.array[this.array.length - 1];
                return aSTToken.getOffset() + aSTToken.getLength();
            }
            aSTToken = this.next(1);
            return aSTToken.getOffset();
        }

        public boolean eof() {
            return this.index >= this.length;
        }

        public ASTToken next(int n) {
            if (this.index + n - 1 < this.length) {
                return this.array[this.index + n - 1];
            }
            return null;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.index;
            for (int i = 0; i < 10 && n < this.length; ++n, ++i) {
                stringBuilder.append(this.array[n]).append(" ");
            }
            return stringBuilder.toString();
        }
    }

    private static class ListInput
    extends TokenInput {
        private List list;
        private int index = 0;
        private int length;

        private ListInput(List list) {
            this.list = list;
            this.length = list.size();
        }

        public ASTToken read() {
            if (this.index < this.length) {
                return (ASTToken)this.list.get(this.index++);
            }
            return null;
        }

        public void setIndex(int n) {
            this.index = n;
        }

        public int getIndex() {
            return this.index;
        }

        public int getOffset() {
            ASTToken aSTToken = null;
            if (this.eof()) {
                if (this.getIndex() == 0) {
                    return 0;
                }
                aSTToken = (ASTToken)this.list.get(this.list.size() - 1);
                return aSTToken.getOffset() + aSTToken.getLength();
            }
            aSTToken = this.next(1);
            return aSTToken.getOffset();
        }

        public boolean eof() {
            return this.index >= this.length;
        }

        public ASTToken next(int n) {
            if (this.index + n - 1 < this.length) {
                return (ASTToken)this.list.get(this.index + n - 1);
            }
            return null;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.index;
            for (int i = 0; i < 10 && n < this.length; ++n, ++i) {
                stringBuilder.append(this.list.get(n)).append(" ");
            }
            return stringBuilder.toString();
        }
    }

    private static class TokenInputImpl
    extends TokenInput {
        private TokenReader tokenReader;
        private List<ASTToken> tokens = new ArrayList<ASTToken>();
        private int index = 0;
        private CharInput input;

        TokenInputImpl(TokenReader tokenReader, CharInput charInput) {
            this.input = charInput;
            this.tokenReader = tokenReader;
        }

        public ASTToken next(int n) {
            while (this.index + n - 1 >= this.tokens.size()) {
                this.tokens.add(this.tokenReader.readToken(this.input));
            }
            return this.tokens.get(this.index + n - 1);
        }

        public boolean eof() {
            return this.next(1) == null;
        }

        public int getIndex() {
            return this.index;
        }

        public int getOffset() {
            ASTToken aSTToken = null;
            if (this.eof()) {
                if (this.getIndex() == 0) {
                    return 0;
                }
                int n = this.tokens.size() - 1;
                while ((aSTToken = this.tokens.get(n--)) == null && n > 0) {
                }
                if (aSTToken == null) {
                    return 0;
                }
                return aSTToken.getOffset() + aSTToken.getLength();
            }
            aSTToken = this.next(1);
            return aSTToken.getOffset();
        }

        public ASTToken read() {
            ASTToken aSTToken = this.next(1);
            if (aSTToken != null) {
                ++this.index;
            }
            return aSTToken;
        }

        public void setIndex(int n) {
            if (n > this.tokens.size()) {
                throw new IndexOutOfBoundsException();
            }
            this.index = n;
        }

        public String getString(int n) {
            throw new InternalError();
        }

        public String toString() {
            return this.input.toString();
        }
    }

    private static class TokenReader {
        private Language language;
        private Parser parser;
        private CharInput input;
        private int state = -1;
        private Parser.Cookie cookie = new MyCookie();
        private ASTToken next;

        private TokenReader(Language language, Parser parser, CharInput charInput) {
            this.language = language;
            this.parser = parser;
            this.input = charInput;
        }

        public ASTToken nextToken(CharInput charInput) {
            if (this.next == null) {
                this.next = this.readToken(charInput);
            }
            return this.next;
        }

        public ASTToken readToken(CharInput charInput) {
            if (charInput.eof()) {
                return null;
            }
            if (this.next != null) {
                ASTToken aSTToken = this.next;
                this.next = null;
                return aSTToken;
            }
            ASTToken aSTToken = this.parser.read(this.cookie, charInput, this.language);
            if (aSTToken != null) {
                return aSTToken;
            }
            int n = charInput.getIndex();
            return ASTToken.create(this.language, "error", String.valueOf(charInput.read()), n, 1, null);
        }

        private class MyCookie
        implements Parser.Cookie {
            private MyCookie() {
            }

            public int getState() {
                return TokenReader.this.state;
            }

            public void setState(int n) {
                TokenReader.this.state = n;
            }

            public void setProperties(Feature feature) {
            }
        }
    }
}

