/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.JarClassLoader;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;

public class ProxyURLStreamHandlerFactory
implements URLStreamHandlerFactory,
LookupListener {
    private static final Logger LOG = Logger.getLogger(ProxyURLStreamHandlerFactory.class.getName());
    private static boolean proxyFactoryInitialized;
    private final URLStreamHandlerFactory delegate;
    private final URLStreamHandler originalJarHandler;
    private Lookup.Result<URLStreamHandlerFactory> r;
    private URLStreamHandlerFactory[] handlers;
    private boolean isWindows;

    public static synchronized void register() {
        if (!proxyFactoryInitialized) {
            URLStreamHandler uRLStreamHandler = null;
            try {
                Method method = URL.class.getDeclaredMethod("getURLStreamHandler", String.class);
                method.setAccessible(true);
                uRLStreamHandler = (URLStreamHandler)method.invoke(null, "jar");
            }
            catch (Throwable throwable) {
                LOG.log(Level.SEVERE, "No way to find original stream handler for jar protocol", throwable);
            }
            try {
                URL.setURLStreamHandlerFactory(new ProxyURLStreamHandlerFactory(null, uRLStreamHandler));
            }
            catch (Error error) {
                LOG.log(Level.CONFIG, "Problems registering URLStreamHandlerFactory, trying reflection", error);
                try {
                    Object object = null;
                    for (Field field : URL.class.getDeclaredFields()) {
                        LOG.log(Level.FINEST, "Found field {0}", field);
                        if (field.getType() != URLStreamHandlerFactory.class) continue;
                        LOG.log(Level.FINEST, "Clearing field {0}");
                        field.setAccessible(true);
                        object = (URLStreamHandlerFactory)field.get(null);
                        LOG.log(Level.CONFIG, "Previous value was {0}", object);
                        field.set(null, null);
                        LOG.config("Field is supposed to be empty");
                        break;
                    }
                    if (object != null && object.getClass().getName().equals(ProxyURLStreamHandlerFactory.class.getName())) {
                        object = null;
                    }
                    URL.setURLStreamHandlerFactory(new ProxyURLStreamHandlerFactory((URLStreamHandlerFactory)object, uRLStreamHandler));
                }
                catch (Throwable throwable) {
                    LOG.log(Level.SEVERE, "No way to register URLStreamHandlerFactory; NetBeans is unlikely to work", throwable);
                }
            }
            proxyFactoryInitialized = true;
        }
    }

    private ProxyURLStreamHandlerFactory(URLStreamHandlerFactory uRLStreamHandlerFactory, URLStreamHandler uRLStreamHandler) {
        this.delegate = uRLStreamHandlerFactory;
        this.originalJarHandler = uRLStreamHandler;
        this.isWindows = Utilities.isWindows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLStreamHandler createURLStreamHandler(String string) {
        URLStreamHandlerFactory[] uRLStreamHandlerFactoryArray;
        if (string.equals("jar")) {
            return new JarClassLoader.ResURLStreamHandler(this.originalJarHandler);
        }
        if (string.equals("file") && this.isWindows && System.getProperty("java.version").startsWith("1.5")) {
            LOG.fine("Registering UNCFileStreamHandler.");
            return UNCFileURLStreamHandler.getInstance();
        }
        if (string.equals("file") || string.equals("http") || string.equals("https") || string.equals("resource")) {
            return null;
        }
        if (this.delegate != null && (uRLStreamHandlerFactoryArray = this.delegate.createURLStreamHandler(string)) != null) {
            return uRLStreamHandlerFactoryArray;
        }
        URLStreamHandlerFactory[] uRLStreamHandlerFactoryArray2 = this;
        synchronized (this) {
            if (this.handlers == null) {
                this.r = Lookup.getDefault().lookupResult(URLStreamHandlerFactory.class);
                this.r.addLookupListener((LookupListener)this);
                this.resultChanged(null);
            }
            uRLStreamHandlerFactoryArray = this.handlers;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (URLStreamHandlerFactory uRLStreamHandlerFactory : uRLStreamHandlerFactoryArray) {
                URLStreamHandler uRLStreamHandler = uRLStreamHandlerFactory.createURLStreamHandler(string);
                if (uRLStreamHandler == null) continue;
                return uRLStreamHandler;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultChanged(LookupEvent lookupEvent) {
        Collection collection = this.r.allInstances();
        ProxyURLStreamHandlerFactory proxyURLStreamHandlerFactory = this;
        synchronized (proxyURLStreamHandlerFactory) {
            this.handlers = collection.toArray(new URLStreamHandlerFactory[0]);
        }
    }

    private static class UNCFileURLStreamHandler
    extends URLStreamHandler {
        private static final URLStreamHandler DELEGATE = UNCFileURLStreamHandler.getDelegate();
        private static final Method OPEN_CONNECTION_METHOD = UNCFileURLStreamHandler.getOpenConnectionMethod();
        private static UNCFileURLStreamHandler instance;

        private UNCFileURLStreamHandler() {
        }

        public static UNCFileURLStreamHandler getInstance() {
            if (instance == null && DELEGATE != null && OPEN_CONNECTION_METHOD != null) {
                instance = new UNCFileURLStreamHandler();
            }
            return instance;
        }

        private static URLStreamHandler getDelegate() {
            try {
                Class<?> clazz = Class.forName("sun.net.www.protocol.file.Handler");
                return (URLStreamHandler)clazz.newInstance();
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "Exception while instantiating sun.net.www.protocol.file.Handler.", exception);
                return null;
            }
        }

        private static Method getOpenConnectionMethod() {
            try {
                return DELEGATE.getClass().getMethod("openConnection", URL.class, Proxy.class);
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "Exception while getting method sun.net.www.protocol.file.Handler.openConnection.", exception);
                return null;
            }
        }

        protected void parseURL(URL uRL, String string, int n, int n2) {
            super.parseURL(uRL, string.replace(File.separatorChar, '/'), n, n2);
            if (uRL.getAuthority() != null && uRL.getPath().startsWith("//")) {
                try {
                    Field field = URL.class.getDeclaredField("authority");
                    field.setAccessible(true);
                    field.set(uRL, null);
                    Field field2 = URL.class.getDeclaredField("path");
                    field2.setAccessible(true);
                    field2.set(uRL, "//" + uRL.getPath());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        protected URLConnection openConnection(URL uRL) throws IOException {
            return this.openConnection(uRL, null);
        }

        protected URLConnection openConnection(URL uRL, Proxy proxy) throws IOException {
            try {
                return (URLConnection)OPEN_CONNECTION_METHOD.invoke((Object)DELEGATE, uRL, proxy);
            }
            catch (Exception exception) {
                IOException iOException = new IOException("openConnection " + uRL + " failed.");
                iOException.initCause(exception);
                throw iOException;
            }
        }
    }
}

