/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.netbeans.Archive;
import org.netbeans.Module;
import org.netbeans.PatchByteCode;
import org.netbeans.ProxyClassLoader;
import org.netbeans.ProxyURLStreamHandlerFactory;
import org.netbeans.Stamps;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarClassLoader
extends ProxyClassLoader {
    private static Stamps cache;
    static Archive archive;
    private static final Logger LOGGER;
    private final Source[] sources;
    private Module module;
    private Boolean patchingBytecode;

    static void initializeCache() {
        cache = Stamps.getModulesJARs();
        archive = new Archive(cache);
    }

    public static void saveArchive() {
        if (cache != null) {
            try {
                archive.save(cache);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, null, iOException);
            }
        } else {
            archive.stopGathering();
            archive.stopServing();
        }
    }

    public JarClassLoader(List<File> list, ClassLoader[] classLoaderArray) {
        this(list, classLoaderArray, true, null);
    }

    public JarClassLoader(List<File> list, ClassLoader[] classLoaderArray, boolean bl) {
        this(list, classLoaderArray, bl, null);
    }

    public JarClassLoader(List<File> list, ClassLoader[] classLoaderArray, boolean bl, Module module) {
        super(classLoaderArray, bl);
        this.module = module;
        ArrayList<Source> arrayList = new ArrayList<Source>(list.size());
        try {
            for (File file : list) {
                arrayList.add(Source.create(file, this));
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage());
        }
        this.sources = arrayList.toArray(new Source[arrayList.size()]);
        this.addCoveredPackages(JarClassLoader.getCoveredPackages(this.module, this.sources));
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        return Policy.getPolicy().getPermissions(codeSource);
    }

    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        if (manifest == null) {
            return this.definePackage(string, null, null, null, null, null, null, null);
        }
        String string2 = string.replace('.', '/').concat("/");
        Attributes attributes = manifest.getAttributes(string2);
        Attributes attributes2 = manifest.getMainAttributes();
        String string3 = JarClassLoader.getAttr(attributes, attributes2, Attributes.Name.SPECIFICATION_TITLE);
        String string4 = JarClassLoader.getAttr(attributes, attributes2, Attributes.Name.IMPLEMENTATION_TITLE);
        String string5 = JarClassLoader.getAttr(attributes, attributes2, Attributes.Name.SPECIFICATION_VERSION);
        String string6 = JarClassLoader.getAttr(attributes, attributes2, Attributes.Name.IMPLEMENTATION_VERSION);
        String string7 = JarClassLoader.getAttr(attributes, attributes2, Attributes.Name.SPECIFICATION_VENDOR);
        String string8 = JarClassLoader.getAttr(attributes, attributes2, Attributes.Name.IMPLEMENTATION_VENDOR);
        String string9 = JarClassLoader.getAttr(attributes, attributes2, Attributes.Name.SEALED);
        URL uRL2 = "true".equalsIgnoreCase(string9) ? uRL : null;
        return this.definePackage(string, string3, string5, string7, string4, string6, string8, uRL2);
    }

    private static String getAttr(Attributes attributes, Attributes attributes2, Attributes.Name name) {
        String string = null;
        if (attributes != null) {
            string = attributes.getValue(name);
        }
        if (string == null && attributes2 != null) {
            string = attributes2.getValue(name);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class doLoadClass(String string, String string2) {
        String string3 = string2.replace('.', '/').concat(".class");
        for (int i = 0; i < this.sources.length; ++i) {
            Source source = this.sources[i];
            byte[] byArray = source.getClassData(string3);
            if (byArray == null) continue;
            Object object = this.sources;
            synchronized (this.sources) {
                if (this.patchingBytecode == null) {
                    this.patchingBytecode = this.findResource("META-INF/.bytecodePatched") != null;
                    if (this.patchingBytecode.booleanValue()) {
                        LOGGER.log(Level.FINE, "Patching bytecode in {0}", this);
                    }
                }
                // ** MonitorExit[var7_7] (shouldn't be in output)
                if (this.patchingBytecode.booleanValue()) {
                    try {
                        byArray = PatchByteCode.patch(byArray);
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.INFO, "Could not bytecode-patch " + string2, exception);
                    }
                }
                if ((object = this.getPackageFast(string, true)) != null) {
                    if (((Package)object).isSealed() && !((Package)object).isSealed(source.getURL())) {
                        throw new SecurityException("sealing violation");
                    }
                } else {
                    Manifest manifest = this.module == null || source != this.sources[0] ? source.getManifest() : this.module.getManifest();
                    try {
                        this.definePackage(string, manifest, source.getURL());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        LOGGER.log(Level.FINE, null, illegalArgumentException);
                    }
                }
                return this.defineClass(string2, byArray, 0, byArray.length, source.getProtectionDomain());
            }
        }
        return null;
    }

    @Override
    public URL findResource(String string) {
        for (int i = 0; i < this.sources.length; ++i) {
            URL uRL = this.sources[i].getResource(string);
            if (uRL == null) continue;
            return uRL;
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String string) {
        Vector<URL> vector = new Vector<URL>(3);
        for (int i = 0; i < this.sources.length; ++i) {
            URL uRL = this.sources[i].getResource(string);
            if (uRL == null) continue;
            vector.add(uRL);
        }
        return vector.elements();
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            for (Source source : this.sources) {
                source.destroy();
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, null, iOException);
        }
    }

    void releaseJars() throws IOException {
        for (Source source : this.sources) {
            if (!(source instanceof JarSource)) continue;
            ((JarSource)source).doCloseJar();
        }
    }

    private static Iterable<String> getCoveredPackages(Module module, Source[] sourceArray) {
        Object object;
        Object object2;
        Manifest manifest;
        HashSet<String> hashSet = new HashSet<String>();
        Manifest manifest2 = manifest = module == null ? null : module.getManifest();
        if (manifest != null && (object2 = ((Attributes)(object = manifest.getMainAttributes())).getValue("Covered-Packages")) != null) {
            hashSet.addAll(Arrays.asList(((String)object2).split(",", -1)));
            return hashSet;
        }
        object = new StringBuffer();
        for (Source source : sourceArray) {
            source.listCoveredPackages(hashSet, (StringBuffer)object);
        }
        if (((StringBuffer)object).length() > 0) {
            ((StringBuffer)object).setLength(((StringBuffer)object).length() - 1);
        }
        if (manifest != null) {
            object2 = manifest.getMainAttributes();
            ((Attributes)object2).putValue("Covered-Packages", ((StringBuffer)object).toString());
        }
        return hashSet;
    }

    static {
        archive = new Archive();
        ProxyURLStreamHandlerFactory.register();
        LOGGER = Logger.getLogger(JarClassLoader.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DirSource
    extends Source {
        File dir;

        DirSource(File file) throws MalformedURLException {
            super(file.toURI().toURL());
            this.dir = file;
        }

        @Override
        public String getPath() {
            return this.dir.getPath();
        }

        @Override
        protected URL doGetResource(String string) throws MalformedURLException {
            File file = new File(this.dir, string);
            return file.exists() ? file.toURI().toURL() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected byte[] readClass(String string) throws IOException {
            File file = new File(this.dir, string.replace('/', File.separatorChar));
            if (!file.exists()) {
                return null;
            }
            int n = (int)file.length();
            byte[] byArray = new byte[n];
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                for (int i = 0; i < n; i += ((InputStream)fileInputStream).read(byArray, i, n - i)) {
                }
                byte[] byArray2 = byArray;
                return byArray2;
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }

        @Override
        protected void listCoveredPackages(Set<String> set, StringBuffer stringBuffer) {
            DirSource.appendAllChildren(set, stringBuffer, this.dir, "");
        }

        private static void appendAllChildren(Set<String> set, StringBuffer stringBuffer, File file, String string) {
            boolean bl = false;
            for (File file2 : file.listFiles()) {
                String string2;
                if (file2.isDirectory()) {
                    DirSource.appendAllChildren(set, stringBuffer, file2, string + file2.getName() + '.');
                    continue;
                }
                bl = true;
                if (!string.startsWith("META-INF.") || !set.add(string2 = string.substring(8).replace('.', '/').concat(file2.getName()))) continue;
                stringBuffer.append(string2).append(',');
            }
            if (bl) {
                Object object = string;
                if (((String)object).endsWith(".")) {
                    object = ((String)object).substring(0, ((String)object).length() - 1);
                }
                if (set.add((String)object)) {
                    stringBuffer.append((String)object).append(',');
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JarSource
    extends Source {
        private String resPrefix;
        private File file;
        private Future<JarFile> fjar;
        private boolean dead;
        private int requests;
        private int used;
        private final Set<String> nonexistentResources = Collections.synchronizedSet(new HashSet());
        private static final Map<JarSource, Future<JarFile>> sources = new HashMap<JarSource, Future<JarFile>>();
        private static int LIMIT = Integer.getInteger("org.netbeans.JarClassLoader.limit_fd", 300);

        JarSource(File file) throws IOException {
            this(file, JarSource.toURI(file));
        }

        private JarSource(File file, String string) throws IOException {
            super(new URL(string));
            this.resPrefix = string;
            this.file = file;
        }

        @Override
        public String getPath() {
            return this.file.getPath();
        }

        private static String toURI(File file) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class VFile
            extends File {
                final /* synthetic */ File val$file;

                public VFile(File file) {
                    this.val$file = file;
                    super(file.getPath());
                }

                @Override
                public boolean isDirectory() {
                    return false;
                }

                @Override
                public File getAbsoluteFile() {
                    return this;
                }
            }
            return "jar:" + new VFile(file).toURI() + "!/";
        }

        @Override
        public Manifest getManifest() {
            try {
                byte[] byArray = archive.getData(this, "META-INF/MANIFEST.MF");
                if (byArray == null) {
                    return null;
                }
                return new Manifest(new ByteArrayInputStream(byArray));
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Cannot read manifest for " + this.getPath(), iOException);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        JarFile getJarFile(final String string) throws IOException {
            FutureTask<JarFile> futureTask = null;
            Map<JarSource, Future<JarFile>> map = sources;
            synchronized (map) {
                ++this.requests;
                ++this.used;
                if (this.fjar == null) {
                    this.fjar = sources.get(this);
                    if (this.fjar == null) {
                        futureTask = new FutureTask<JarFile>(new Callable<JarFile>(){

                            @Override
                            public JarFile call() throws IOException {
                                long l = System.currentTimeMillis();
                                JarFile jarFile = new JarFile(JarSource.this.file, false);
                                long l2 = System.currentTimeMillis() - l;
                                JarSource.opened(JarSource.this, string);
                                if (l2 > 500L) {
                                    LOGGER.log(Level.WARNING, "Opening " + JarSource.this.file + " took " + l2 + " ms");
                                }
                                return jarFile;
                            }
                        });
                        this.fjar = futureTask;
                        sources.put(this, this.fjar);
                    }
                }
            }
            if (futureTask != null) {
                futureTask.run();
            }
            return this.callGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseJarFile() {
            Map<JarSource, Future<JarFile>> map = sources;
            synchronized (map) {
                assert (this.used > 0);
                --this.used;
            }
        }

        @Override
        protected URL doGetResource(String string) throws IOException {
            byte[] byArray = archive.getData(this, string);
            if (byArray == null) {
                return null;
            }
            LOGGER.log(Level.FINER, "Loading {0} from {1}", new Object[]{string, this.file.getPath()});
            try {
                return new URL(this.resPrefix + new URI(null, string, null).getRawPath());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw (IOException)new IOException(string + " in " + this.resPrefix + ": " + uRISyntaxException.toString()).initCause(uRISyntaxException);
            }
        }

        @Override
        protected byte[] readClass(String string) throws IOException {
            return archive.getData(this, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] resource(String string) throws IOException {
            JarFile jarFile;
            if (this.nonexistentResources.contains(string)) {
                return null;
            }
            try {
                jarFile = this.getJarFile(string);
            }
            catch (ZipException zipException) {
                LOGGER.log(Level.INFO, "Cannot open " + this.file, zipException);
                return null;
            }
            try {
                ZipEntry zipEntry = jarFile.getEntry(string);
                if (zipEntry == null) {
                    this.nonexistentResources.add(string);
                    byte[] byArray = null;
                    return byArray;
                }
                LOGGER.log(Level.FINER, "Loading {0} from {1}", new Object[]{string, this.file.getPath()});
                int n = (int)zipEntry.getSize();
                byte[] byArray = new byte[n];
                InputStream inputStream = jarFile.getInputStream(zipEntry);
                for (int i = 0; i < n; i += inputStream.read(byArray, i, n - i)) {
                }
                byte[] byArray2 = byArray;
                return byArray2;
            }
            finally {
                this.releaseJarFile();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void listCoveredPackages(Set<String> set, StringBuffer stringBuffer) {
            try {
                JarFile jarFile = this.getJarFile("pkg");
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    String string;
                    String string2;
                    JarEntry jarEntry = enumeration.nextElement();
                    if (jarEntry.isDirectory()) continue;
                    String string3 = jarEntry.getName();
                    int n = string3.lastIndexOf(47);
                    String string4 = string2 = n > 0 ? string3.substring(0, n).replace('/', '.') : "";
                    if (set.add(string2)) {
                        stringBuffer.append(string2).append(',');
                    }
                    if (!string3.startsWith("META-INF/") || !set.add(string = string3.substring(8))) continue;
                    stringBuffer.append(string).append(',');
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, null, iOException);
            }
            finally {
                this.releaseJarFile();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void destroy() throws IOException {
            String string;
            String string2;
            super.destroy();
            assert (!this.dead) : "Already had dead JAR: " + this.file;
            File file = this.file;
            if (!file.isFile()) {
                return;
            }
            String string3 = file.getName();
            int n = string3.lastIndexOf(46);
            if (n == -1) {
                string2 = string3;
                string = null;
            } else {
                string2 = string3.substring(0, n);
                string = string3.substring(n);
            }
            while (string2.length() < 3) {
                string2 = string2 + "x";
            }
            File file2 = File.createTempFile(string2, string);
            file2.deleteOnExit();
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                try {
                    int n2;
                    byte[] byArray = new byte[4096];
                    while ((n2 = ((InputStream)fileInputStream).read(byArray)) != -1) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                    }
                }
                finally {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
            this.doCloseJar();
            this.file = file2;
            this.dead = true;
            LOGGER.log(Level.FINE, "#21114: replacing {0} with {1}", new Object[]{file, file2});
        }

        private JarFile callGet() throws IOException {
            while (true) {
                try {
                    return this.fjar.get();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (ExecutionException executionException) {
                    Throwable throwable = executionException.getCause();
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    throw (IOException)new IOException().initCause(throwable);
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doCloseJar() throws IOException {
            JarFile jarFile = null;
            Map<JarSource, Future<JarFile>> map = sources;
            synchronized (map) {
                if (this.fjar != null) {
                    jarFile = this.callGet();
                    if (sources.remove(this) == null) {
                        LOGGER.warning("Can't remove " + this);
                    }
                    LOGGER.log(Level.FINE, "Closing JAR {0}", jarFile.getName());
                    this.fjar = null;
                    LOGGER.log(Level.FINE, "Remaining open JARs: {0}", sources.size());
                }
            }
            if (jarFile != null) {
                jarFile.close();
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.doCloseJar();
            if (this.dead) {
                LOGGER.log(Level.FINE, "#21114: closing and deleting temporary JAR {0}", this.file);
                if (this.file.isFile() && !this.file.delete()) {
                    LOGGER.log(Level.FINE, "(but failed to delete {0})", this.file);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void opened(JarSource jarSource, String string) {
            Map<JarSource, Future<JarFile>> map = sources;
            synchronized (map) {
                if (sources.size() > LIMIT) {
                    JarSource jarSource2 = JarSource.toClose();
                    try {
                        jarSource2.doCloseJar();
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.WARNING, null, iOException);
                    }
                }
                LOGGER.log(Level.FINE, "Opening module JAR {0} for {1}", new Object[]{jarSource.file, string});
                LOGGER.log(Level.FINE, "Currently open JARs: {0}", sources.size());
            }
        }

        private static JarSource toClose() {
            assert (Thread.holdsLock(sources));
            int n = Integer.MAX_VALUE;
            JarSource jarSource = null;
            for (JarSource jarSource2 : sources.keySet()) {
                jarSource2.requests = 5 * jarSource2.requests / 6;
                if (jarSource2.used > 0 || jarSource2.requests >= n) continue;
                n = jarSource2.requests;
                jarSource = jarSource2;
            }
            assert (jarSource != null);
            return jarSource;
        }

        public String getIdentifier() {
            return this.getURL().toExternalForm();
        }
    }

    private static class ResURLConnection
    extends JarURLConnection {
        private JarSource src;
        private final String name;
        private byte[] data;
        private InputStream iStream;

        private ResURLConnection(URL uRL, Source source, String string) throws MalformedURLException {
            super(uRL);
            this.src = (JarSource)source;
            this.name = string;
        }

        private boolean isFolder() {
            return this.name.length() == 0 || this.name.endsWith("/");
        }

        public void connect() throws IOException {
            if (this.isFolder()) {
                return;
            }
            if (this.data == null) {
                this.data = this.src.getClassData(this.name);
                if (this.data == null) {
                    throw new FileNotFoundException(this.getURL().toString());
                }
            }
        }

        public long getLastModified() {
            return Stamps.getModulesJARs().lastModified();
        }

        public String getContentType() {
            String string = ResURLConnection.guessContentTypeFromName(this.name);
            if (string == null) {
                string = "content/unknown";
            }
            return string;
        }

        public int getContentLength() {
            if (this.isFolder()) {
                return -1;
            }
            try {
                this.connect();
                return this.data.length;
            }
            catch (IOException iOException) {
                return -1;
            }
        }

        public InputStream getInputStream() throws IOException {
            if (this.isFolder()) {
                throw new IOException("Cannot open a folder");
            }
            this.connect();
            if (this.iStream == null) {
                this.iStream = new ByteArrayInputStream(this.data);
            }
            return this.iStream;
        }

        public JarFile getJarFile() throws IOException {
            return new JarFile(this.src.file);
        }
    }

    static class ResURLStreamHandler
    extends URLStreamHandler {
        private final URLStreamHandler originalJarHandler;

        ResURLStreamHandler(URLStreamHandler uRLStreamHandler) {
            this.originalJarHandler = uRLStreamHandler;
        }

        protected JarURLConnection openConnection(URL uRL) throws IOException {
            String string = uRL.getFile();
            int n = string.indexOf("!/");
            if (n == -1) {
                throw new IOException("Malformed JAR-protocol URL: " + uRL);
            }
            int n2 = string.startsWith("file:") ? (Utilities.isWindows() ? 6 : 5) : 0;
            String string2 = string.substring(n2, n).replace('/', File.separatorChar);
            Source source = (Source)Source.sources.get(string2);
            if (source == null) {
                try {
                    Method method = URLStreamHandler.class.getDeclaredMethod("openConnection", URL.class);
                    method.setAccessible(true);
                    return (JarURLConnection)method.invoke((Object)this.originalJarHandler, uRL);
                }
                catch (Exception exception) {
                    throw (IOException)new IOException(exception.toString()).initCause(exception);
                }
            }
            String string3 = string.substring(n + 2);
            try {
                string3 = new URI(string3).getPath();
            }
            catch (URISyntaxException uRISyntaxException) {
                throw (IOException)new IOException("Decoding " + uRL + ": " + uRISyntaxException).initCause(uRISyntaxException);
            }
            return new ResURLConnection(uRL, source, string3);
        }

        protected void parseURL(URL uRL, String string, int n, int n2) {
            if (string.startsWith("/")) {
                this.setURL(uRL, "jar", null, 0, null, null, uRL.getFile().replaceFirst("!/.+$", "!" + string), uRL.getQuery(), uRL.getRef());
            } else {
                super.parseURL(uRL, string, n, n2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Source {
        private URL url;
        private ProtectionDomain pd;
        protected JarClassLoader jcl;
        private static Map<String, Source> sources = new HashMap<String, Source>();

        public Source(URL uRL) {
            this.url = uRL;
        }

        public final URL getURL() {
            return this.url;
        }

        public abstract String getPath();

        public final ProtectionDomain getProtectionDomain() {
            if (this.pd == null) {
                CodeSource codeSource = new CodeSource(this.url, (Certificate[])null);
                this.pd = new ProtectionDomain(codeSource, this.jcl.getPermissions(codeSource));
            }
            return this.pd;
        }

        public final URL getResource(String string) {
            try {
                return this.doGetResource(string);
            }
            catch (Exception exception) {
                LOGGER.log(Level.FINE, null, exception);
                return null;
            }
        }

        protected abstract URL doGetResource(String var1) throws IOException;

        public final byte[] getClassData(String string) {
            try {
                return this.readClass(string);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, null, iOException);
                return null;
            }
        }

        protected abstract byte[] readClass(String var1) throws IOException;

        public Manifest getManifest() {
            return null;
        }

        protected abstract void listCoveredPackages(Set<String> var1, StringBuffer var2);

        protected void destroy() throws IOException {
            sources.values().remove(this);
        }

        static Source create(File file, JarClassLoader jarClassLoader) throws IOException {
            boolean bl = file.getName().endsWith("jar") ? false : file.isDirectory();
            Source source = bl ? new DirSource(file) : new JarSource(file);
            source.jcl = jarClassLoader;
            sources.put(source.getPath(), source);
            return source;
        }

        public String toString() {
            return this.url.toString();
        }
    }
}

