/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import java.util.Iterator;
import java.util.List;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Util;
import mondrian.recorder.MessageRecorder;
import mondrian.rolap.HierarchyUsage;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapStar;
import mondrian.rolap.aggmatcher.ExplicitRules;
import mondrian.rolap.aggmatcher.JdbcSchema;
import mondrian.rolap.aggmatcher.Recognizer;

class ExplicitRecognizer
extends Recognizer {
    private ExplicitRules.TableDef tableDef;
    private RolapCube cube;

    ExplicitRecognizer(ExplicitRules.TableDef tableDef, RolapStar star, RolapCube cube, JdbcSchema.Table dbFactTable, JdbcSchema.Table aggTable, MessageRecorder msgRecorder) {
        super(star, dbFactTable, aggTable, msgRecorder);
        this.tableDef = tableDef;
        this.cube = cube;
    }

    protected ExplicitRules.TableDef getTableDef() {
        return this.tableDef;
    }

    protected Recognizer.Matcher getIgnoreMatcher() {
        return this.getTableDef().getIgnoreMatcher();
    }

    protected Recognizer.Matcher getFactCountMatcher() {
        return this.getTableDef().getFactCountMatcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int checkMeasures() {
        this.msgRecorder.pushContextName("ExplicitRecognizer.checkMeasures");
        try {
            int measureColumnCounts = 0;
            for (JdbcSchema.Table.Column aggColumn : this.aggTable.getColumns()) {
                if (aggColumn.hasUsage(JdbcSchema.UsageType.IGNORE)) continue;
                String aggColumnName = aggColumn.getName();
                for (ExplicitRules.TableDef.Measure measure : this.getTableDef().getMeasures()) {
                    if (!measure.getColumnName().equalsIgnoreCase(aggColumnName)) continue;
                    String name = measure.getName();
                    List<Id.Segment> parts = Util.parseIdentifier(name);
                    String nameLast = parts.get((int)(parts.size() - 1)).name;
                    RolapStar.Measure m = this.star.getFactTable().lookupMeasureByName(this.cube.getName(), nameLast);
                    RolapAggregator agg = null;
                    if (m != null) {
                        agg = m.getAggregator();
                    }
                    this.makeMeasure(measure, agg, aggColumn);
                    ++measureColumnCounts;
                }
            }
            Iterator<JdbcSchema.Table.Column.Usage> it = this.dbFactTable.getColumnUsages(JdbcSchema.UsageType.MEASURE);
            while (it.hasNext()) {
                String aggFK;
                JdbcSchema.Table.Column.Usage factUsage = it.next();
                JdbcSchema.Table.Column factColumn = factUsage.getColumn();
                if (!factColumn.hasUsage(JdbcSchema.UsageType.FOREIGN_KEY) || (aggFK = this.getTableDef().getAggregateFK(factColumn.getName())) == null) continue;
                JdbcSchema.Table.Column aggColumn = this.aggTable.getColumn(aggFK);
                if (aggColumn == null) {
                    aggColumn = this.aggTable.getColumn(aggFK.toLowerCase());
                }
                if (aggColumn == null) {
                    aggColumn = this.aggTable.getColumn(aggFK.toUpperCase());
                }
                if (aggColumn == null) continue;
                this.makeMeasure(factUsage, aggColumn);
                ++measureColumnCounts;
            }
            int n = measureColumnCounts;
            return n;
        }
        finally {
            this.msgRecorder.popContextName();
        }
    }

    protected void makeMeasure(ExplicitRules.TableDef.Measure measure, RolapAggregator factAgg, JdbcSchema.Table.Column aggColumn) {
        RolapStar.Measure rm = measure.getRolapStarMeasure();
        JdbcSchema.Table.Column.Usage aggUsage = aggColumn.newUsage(JdbcSchema.UsageType.MEASURE);
        aggUsage.setSymbolicName(measure.getSymbolicName());
        RolapAggregator ra = factAgg == null ? this.convertAggregator(aggUsage, rm.getAggregator()) : this.convertAggregator(aggUsage, factAgg, rm.getAggregator());
        aggUsage.setAggregator(ra);
        aggUsage.rMeasure = rm;
    }

    protected int matchForeignKey(JdbcSchema.Table.Column.Usage factUsage) {
        JdbcSchema.Table.Column factColumn = factUsage.getColumn();
        String aggFK = this.getTableDef().getAggregateFK(factColumn.getName());
        if (aggFK == null) {
            return 0;
        }
        int matchCount = 0;
        for (JdbcSchema.Table.Column aggColumn : this.aggTable.getColumns()) {
            if (aggColumn.hasUsage(JdbcSchema.UsageType.IGNORE) || !aggFK.equals(aggColumn.getName())) continue;
            this.makeForeignKey(factUsage, aggColumn, aggFK);
            ++matchCount;
        }
        return matchCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean matchLevel(Hierarchy hierarchy, HierarchyUsage hierarchyUsage, RolapLevel rlevel) {
        this.msgRecorder.pushContextName("ExplicitRecognizer.matchLevel");
        try {
            String levelUniqueName = rlevel.getUniqueName();
            for (ExplicitRules.TableDef.Level level : this.getTableDef().getLevels()) {
                if (!level.getName().equals(levelUniqueName)) continue;
                String columnName = level.getColumnName();
                for (JdbcSchema.Table.Column aggColumn : this.aggTable.getColumns()) {
                    if (!aggColumn.getName().equals(columnName)) continue;
                    this.makeLevel(aggColumn, hierarchy, hierarchyUsage, this.getColumnName(rlevel.getKeyExp()), columnName, rlevel.getName());
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.msgRecorder.popContextName();
        }
    }
}

