/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.BatchTestCase;
import mondrian.rolap.FastBatchingCellReader;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapCube;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AggregationKey;
import mondrian.rolap.agg.GroupingSet;
import mondrian.rolap.agg.SegmentLoader;
import mondrian.spi.Dialect;
import mondrian.test.SqlPattern;
import mondrian.test.TestContext;

public class FastBatchingCellReaderTest
extends BatchTestCase {
    private RolapCube salesCube = (RolapCube)this.getTestContext().getConnection().getSchemaReader().getCubes()[0];

    protected void setUp() throws Exception {
        super.setUp();
        this.getTestContext().clearConnection();
    }

    public void testMissingSubtotalBugMetricFilter() {
        String query = "With Set [*NATIVE_CJ_SET] as 'NonEmptyCrossJoin({[Time].[Year].[1997]},                   NonEmptyCrossJoin({[Product].[All Products].[Drink]},{[Education Level].[All Education Levels].[Bachelors Degree]}))' Set [*METRIC_CJ_SET] as 'Filter([*NATIVE_CJ_SET],[Measures].[*Unit Sales_SEL~SUM] > 1000.0)' Set [*METRIC_MEMBERS_Education Level] as 'Generate([*METRIC_CJ_SET], {[Education Level].CurrentMember})' Member [Measures].[*Unit Sales_SEL~SUM] as '([Measures].[Unit Sales],[Time].CurrentMember,[Product].CurrentMember,[Education Level].CurrentMember)', SOLVE_ORDER=200 Member [Education Level].[*CTX_MEMBER_SEL~SUM] as 'Sum(Filter([*METRIC_MEMBERS_Education Level],[Measures].[*Unit Sales_SEL~SUM] > 1000.0))', SOLVE_ORDER=-102 Select {[Measures].[Unit Sales]} on columns, Non Empty Union(CrossJoin(Generate([*METRIC_CJ_SET], {([Time].CurrentMember,[Product].CurrentMember)}),{[Education Level].[*CTX_MEMBER_SEL~SUM]}),                Generate([*METRIC_CJ_SET], {([Time].CurrentMember,[Product].CurrentMember,[Education Level].CurrentMember)})) on rows From [Sales]";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Time].[1997], [Product].[All Products].[Drink], [Education Level].[*CTX_MEMBER_SEL~SUM]}\n{[Time].[1997], [Product].[All Products].[Drink], [Education Level].[All Education Levels].[Bachelors Degree]}\nRow #0: 6,423\nRow #1: 6,423\n";
        this.assertQueryReturns(query, FastBatchingCellReaderTest.fold(result));
    }

    public void testMissingSubtotalBugMultiLevelMetricFilter() {
        String query = "With Set [*NATIVE_CJ_SET] as 'NonEmptyCrossJoin([*BASE_MEMBERS_Product],[*BASE_MEMBERS_Education Level])' Set [*METRIC_CJ_SET] as 'Filter([*NATIVE_CJ_SET],[Measures].[*Store Cost_SEL~SUM] > 1000.0)' Set [*BASE_MEMBERS_Product] as '{[Product].[All Products].[Drink].[Beverages],[Product].[All Products].[Food].[Baked Goods]}' Set [*METRIC_MEMBERS_Product] as 'Generate([*METRIC_CJ_SET], {[Product].CurrentMember})' Set [*BASE_MEMBERS_Education Level] as '{[Education Level].[All Education Levels].[High School Degree],[Education Level].[All Education Levels].[Partial High School]}' Set [*METRIC_MEMBERS_Education Level] as 'Generate([*METRIC_CJ_SET], {[Education Level].CurrentMember})' Member [Measures].[*Store Cost_SEL~SUM] as '([Measures].[Store Cost],[Product].CurrentMember,[Education Level].CurrentMember)', SOLVE_ORDER=200 Member [Product].[All Products].[Drink].[*CTX_MEMBER_SEL~SUM] as 'Sum(Filter([*METRIC_MEMBERS_Product],[Product].CurrentMember.Parent = [Product].[All Products].[Drink]))', SOLVE_ORDER=-100 Member [Product].[All Products].[Food].[*CTX_MEMBER_SEL~SUM] as 'Sum(Filter([*METRIC_MEMBERS_Product],[Product].CurrentMember.Parent = [Product].[All Products].[Food]))', SOLVE_ORDER=-100 Member [Education Level].[*CTX_MEMBER_SEL~SUM] as 'Sum(Filter([*METRIC_MEMBERS_Education Level],[Measures].[*Store Cost_SEL~SUM] > 1000.0))', SOLVE_ORDER=-101 Select {[Measures].[Store Cost]} on columns, NonEmptyCrossJoin({[Product].[All Products].[Drink].[*CTX_MEMBER_SEL~SUM],[Product].[All Products].[Food].[*CTX_MEMBER_SEL~SUM]},{[Education Level].[*CTX_MEMBER_SEL~SUM]}) on rows From [Sales]";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Cost]}\nAxis #2:\n{[Product].[All Products].[Drink].[*CTX_MEMBER_SEL~SUM], [Education Level].[*CTX_MEMBER_SEL~SUM]}\n{[Product].[All Products].[Food].[*CTX_MEMBER_SEL~SUM], [Education Level].[*CTX_MEMBER_SEL~SUM]}\nRow #0: 6,535.30\nRow #1: 3,860.89\n";
        this.assertQueryReturns(query, FastBatchingCellReaderTest.fold(result));
    }

    public void testShouldUseGroupingFunctionOnPropertyTrueAndOnSupportedDB() {
        boolean oldValue = MondrianProperties.instance().EnableGroupingSets.get();
        MondrianProperties.instance().EnableGroupingSets.set(true);
        FastBatchingCellReader fbcr = new FastBatchingCellReader(this.salesCube){

            boolean doesDBSupportGroupingSets() {
                return true;
            }
        };
        FastBatchingCellReaderTest.assertTrue((boolean)fbcr.shouldUseGroupingFunction());
        MondrianProperties.instance().EnableGroupingSets.set(oldValue);
    }

    public void testShouldUseGroupingFunctionOnPropertyTrueAndOnNonSupportedDB() {
        boolean oldValue = MondrianProperties.instance().EnableGroupingSets.get();
        MondrianProperties.instance().EnableGroupingSets.set(true);
        FastBatchingCellReader fbcr = new FastBatchingCellReader(this.salesCube){

            boolean doesDBSupportGroupingSets() {
                return false;
            }
        };
        FastBatchingCellReaderTest.assertFalse((boolean)fbcr.shouldUseGroupingFunction());
        MondrianProperties.instance().EnableGroupingSets.set(oldValue);
    }

    public void testShouldUseGroupingFunctionOnPropertyFalseOnSupportedDB() {
        boolean oldValue = MondrianProperties.instance().EnableGroupingSets.get();
        MondrianProperties.instance().EnableGroupingSets.set(false);
        FastBatchingCellReader fbcr = new FastBatchingCellReader(this.salesCube){

            boolean doesDBSupportGroupingSets() {
                return true;
            }
        };
        FastBatchingCellReaderTest.assertFalse((boolean)fbcr.shouldUseGroupingFunction());
        MondrianProperties.instance().EnableGroupingSets.set(oldValue);
    }

    public void testShouldUseGroupingFunctionOnPropertyFalseOnNonSupportedDB() {
        boolean oldValue = MondrianProperties.instance().EnableGroupingSets.get();
        MondrianProperties.instance().EnableGroupingSets.set(false);
        FastBatchingCellReader fbcr = new FastBatchingCellReader(this.salesCube){

            boolean doesDBSupportGroupingSets() {
                return false;
            }
        };
        FastBatchingCellReaderTest.assertFalse((boolean)fbcr.shouldUseGroupingFunction());
        MondrianProperties.instance().EnableGroupingSets.set(oldValue);
    }

    public void testDoesDBSupportGroupingSets() {
        final Dialect dialect = this.getTestContext().getDialect();
        FastBatchingCellReader fbcr = new FastBatchingCellReader(this.salesCube){

            Dialect getDialect() {
                return dialect;
            }
        };
        switch (dialect.getDatabaseProduct()) {
            case ORACLE: 
            case TERADATA: 
            case DB2: 
            case DB2_AS400: 
            case DB2_OLD_AS400: {
                FastBatchingCellReaderTest.assertTrue((boolean)fbcr.doesDBSupportGroupingSets());
                break;
            }
            default: {
                FastBatchingCellReaderTest.assertFalse((boolean)fbcr.doesDBSupportGroupingSets());
            }
        }
    }

    public void testGroupBatchesForNonGroupableBatchesWithSorting() {
        FastBatchingCellReader fbcr;
        FastBatchingCellReader fastBatchingCellReader = fbcr = new FastBatchingCellReader(this.salesCube);
        fastBatchingCellReader.getClass();
        FastBatchingCellReader.Batch genderBatch = fastBatchingCellReader.new FastBatchingCellReader.Batch(this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", "gender", "F"));
        FastBatchingCellReader fastBatchingCellReader2 = fbcr;
        fastBatchingCellReader2.getClass();
        FastBatchingCellReader.Batch maritalStatusBatch = fastBatchingCellReader2.new FastBatchingCellReader.Batch(this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", "marital_status", "M"));
        ArrayList<FastBatchingCellReader.Batch> batchList = new ArrayList<FastBatchingCellReader.Batch>();
        batchList.add(genderBatch);
        batchList.add(maritalStatusBatch);
        List<FastBatchingCellReader.CompositeBatch> groupedBatches = fbcr.groupBatches(batchList);
        FastBatchingCellReaderTest.assertEquals((int)batchList.size(), (int)groupedBatches.size());
        FastBatchingCellReaderTest.assertEquals((Object)genderBatch, (Object)groupedBatches.get((int)0).detailedBatch);
        FastBatchingCellReaderTest.assertEquals((Object)maritalStatusBatch, (Object)groupedBatches.get((int)1).detailedBatch);
    }

    public void testGroupBatchesForNonGroupableBatchesWithConstraints() {
        FastBatchingCellReader fbcr = new FastBatchingCellReader(this.salesCube);
        ArrayList<String[]> compoundMembers = new ArrayList<String[]>();
        compoundMembers.add(new String[]{"USA", "CA"});
        compoundMembers.add(new String[]{"Canada", "BC"});
        BatchTestCase.CellRequestConstraint constraint = FastBatchingCellReaderTest.makeConstraintCountryState(compoundMembers);
        FastBatchingCellReader fastBatchingCellReader = fbcr;
        fastBatchingCellReader.getClass();
        FastBatchingCellReader.Batch genderBatch = fastBatchingCellReader.new FastBatchingCellReader.Batch(this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", "gender", "F", constraint));
        FastBatchingCellReader fastBatchingCellReader2 = fbcr;
        fastBatchingCellReader2.getClass();
        FastBatchingCellReader.Batch maritalStatusBatch = fastBatchingCellReader2.new FastBatchingCellReader.Batch(this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", "marital_status", "M", constraint));
        ArrayList<FastBatchingCellReader.Batch> batchList = new ArrayList<FastBatchingCellReader.Batch>();
        batchList.add(genderBatch);
        batchList.add(maritalStatusBatch);
        List<FastBatchingCellReader.CompositeBatch> groupedBatches = fbcr.groupBatches(batchList);
        FastBatchingCellReaderTest.assertEquals((int)batchList.size(), (int)groupedBatches.size());
        FastBatchingCellReaderTest.assertEquals((Object)genderBatch, (Object)groupedBatches.get((int)0).detailedBatch);
        FastBatchingCellReaderTest.assertEquals((Object)maritalStatusBatch, (Object)groupedBatches.get((int)1).detailedBatch);
    }

    public void testGroupBatchesForGroupableBatches() {
        FastBatchingCellReader fbcr;
        FastBatchingCellReader fastBatchingCellReader = fbcr = new FastBatchingCellReader(this.salesCube);
        fastBatchingCellReader.getClass();
        FastBatchingCellReader.Batch genderBatch = new FastBatchingCellReader.Batch(fastBatchingCellReader, this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", "gender", "F")){
            {
                FastBatchingCellReader fastBatchingCellReader = x0;
                fastBatchingCellReader.getClass();
                super(x1);
            }

            boolean canBatch(FastBatchingCellReader.Batch other) {
                return false;
            }
        };
        FastBatchingCellReader fastBatchingCellReader2 = fbcr;
        fastBatchingCellReader2.getClass();
        FastBatchingCellReader.Batch superBatch = new FastBatchingCellReader.Batch(fastBatchingCellReader2, this.createRequest("Sales", "[Measures].[Unit Sales]", new String[0], new String[0], new String[0])){
            {
                FastBatchingCellReader fastBatchingCellReader = x0;
                fastBatchingCellReader.getClass();
                super(x1);
            }

            boolean canBatch(FastBatchingCellReader.Batch batch) {
                return true;
            }
        };
        ArrayList<FastBatchingCellReader.Batch> batchList = new ArrayList<FastBatchingCellReader.Batch>();
        batchList.add(genderBatch);
        batchList.add(superBatch);
        List<FastBatchingCellReader.CompositeBatch> groupedBatches = fbcr.groupBatches(batchList);
        FastBatchingCellReaderTest.assertEquals((int)1, (int)groupedBatches.size());
        FastBatchingCellReaderTest.assertEquals((Object)superBatch, (Object)groupedBatches.get((int)0).detailedBatch);
        FastBatchingCellReaderTest.assertTrue((boolean)groupedBatches.get((int)0).summaryBatches.contains(genderBatch));
    }

    public void testGroupBatchesForGroupableBatchesAndNonGroupableBatches() {
        FastBatchingCellReader fbcr;
        FastBatchingCellReader fastBatchingCellReader = fbcr = new FastBatchingCellReader(this.salesCube);
        fastBatchingCellReader.getClass();
        final FastBatchingCellReader.Batch group1Agg2 = new FastBatchingCellReader.Batch(fastBatchingCellReader, this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", "gender", "F")){
            {
                FastBatchingCellReader fastBatchingCellReader = x0;
                fastBatchingCellReader.getClass();
                super(x1);
            }

            boolean canBatch(FastBatchingCellReader.Batch batch) {
                return false;
            }
        };
        FastBatchingCellReader fastBatchingCellReader2 = fbcr;
        fastBatchingCellReader2.getClass();
        final FastBatchingCellReader.Batch group1Agg1 = new FastBatchingCellReader.Batch(fastBatchingCellReader2, this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", "country", "F")){
            {
                FastBatchingCellReader fastBatchingCellReader = x0;
                fastBatchingCellReader.getClass();
                super(x1);
            }

            boolean canBatch(FastBatchingCellReader.Batch batch) {
                return batch.equals(group1Agg2);
            }
        };
        FastBatchingCellReader fastBatchingCellReader3 = fbcr;
        fastBatchingCellReader3.getClass();
        FastBatchingCellReader.Batch group1Detailed = new FastBatchingCellReader.Batch(fastBatchingCellReader3, this.createRequest("Sales", "[Measures].[Unit Sales]", new String[0], new String[0], new String[0])){
            {
                FastBatchingCellReader fastBatchingCellReader = x0;
                fastBatchingCellReader.getClass();
                super(x1);
            }

            boolean canBatch(FastBatchingCellReader.Batch batch) {
                return batch.equals(group1Agg1);
            }
        };
        FastBatchingCellReader fastBatchingCellReader4 = fbcr;
        fastBatchingCellReader4.getClass();
        final FastBatchingCellReader.Batch group2Agg1 = new FastBatchingCellReader.Batch(fastBatchingCellReader4, this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", "education", "F")){
            {
                FastBatchingCellReader fastBatchingCellReader = x0;
                fastBatchingCellReader.getClass();
                super(x1);
            }

            boolean canBatch(FastBatchingCellReader.Batch batch) {
                return false;
            }
        };
        FastBatchingCellReader fastBatchingCellReader5 = fbcr;
        fastBatchingCellReader5.getClass();
        FastBatchingCellReader.Batch group2Detailed = new FastBatchingCellReader.Batch(fastBatchingCellReader5, this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", "yearly_income", "")){
            {
                FastBatchingCellReader fastBatchingCellReader = x0;
                fastBatchingCellReader.getClass();
                super(x1);
            }

            boolean canBatch(FastBatchingCellReader.Batch batch) {
                return batch.equals(group2Agg1);
            }
        };
        ArrayList<FastBatchingCellReader.Batch> batchList = new ArrayList<FastBatchingCellReader.Batch>();
        batchList.add(group1Agg1);
        batchList.add(group1Agg2);
        batchList.add(group1Detailed);
        batchList.add(group2Agg1);
        batchList.add(group2Detailed);
        List<FastBatchingCellReader.CompositeBatch> groupedBatches = fbcr.groupBatches(batchList);
        FastBatchingCellReaderTest.assertEquals((int)2, (int)groupedBatches.size());
        FastBatchingCellReaderTest.assertEquals((Object)group1Detailed, (Object)groupedBatches.get((int)0).detailedBatch);
        FastBatchingCellReaderTest.assertTrue((boolean)groupedBatches.get((int)0).summaryBatches.contains(group1Agg1));
        FastBatchingCellReaderTest.assertTrue((boolean)groupedBatches.get((int)0).summaryBatches.contains(group1Agg2));
        FastBatchingCellReaderTest.assertEquals((Object)group2Detailed, (Object)groupedBatches.get((int)1).detailedBatch);
        FastBatchingCellReaderTest.assertTrue((boolean)groupedBatches.get((int)1).summaryBatches.contains(group2Agg1));
    }

    public void testGroupBatchesForTwoSetOfGroupableBatches() {
        String[] fieldValuesStoreType = new String[]{"Deluxe Supermarket", "Gourmet Supermarket", "HeadQuarters", "Mid-Size Grocery", "Small Grocery", "Supermarket"};
        String fieldStoreType = "store_type";
        String tableStore = "store";
        String[] fieldValuesWarehouseCountry = new String[]{"Canada", "Mexico", "USA"};
        String fieldWarehouseCountry = "warehouse_country";
        String tableWarehouse = "warehouse";
        FastBatchingCellReader fbcr = new FastBatchingCellReader(this.salesCube);
        FastBatchingCellReader.Batch batch1RollupOnGender = this.createBatch(fbcr, new String[]{"time_by_day", tableStore, "product_class"}, new String[]{"the_year", fieldStoreType, "product_family"}, new String[][]{this.fieldValuesYear, fieldValuesStoreType, this.fieldValuesProductFamily}, "Sales", "[Measures].[Unit Sales]");
        FastBatchingCellReader.Batch batch1RollupOnGenderAndProductDepartment = this.createBatch(fbcr, new String[]{"time_by_day", "product_class"}, new String[]{"the_year", "product_family"}, new String[][]{this.fieldValuesYear, this.fieldValuesProductFamily}, "Sales", "[Measures].[Unit Sales]");
        FastBatchingCellReader.Batch batch1RollupOnStoreTypeAndProductDepartment = this.createBatch(fbcr, new String[]{"time_by_day", "customer"}, new String[]{"the_year", this.fieldGender}, new String[][]{this.fieldValuesYear, this.fieldValuesGender}, "Sales", "[Measures].[Unit Sales]");
        FastBatchingCellReader.Batch batch1Detailed = this.createBatch(fbcr, new String[]{"time_by_day", tableStore, "product_class", "customer"}, new String[]{"the_year", fieldStoreType, "product_family", this.fieldGender}, new String[][]{this.fieldValuesYear, fieldValuesStoreType, this.fieldValuesProductFamily, this.fieldValuesGender}, "Sales", "[Measures].[Unit Sales]");
        String warehouseCube = "Warehouse";
        String measure2 = "[Measures].[Warehouse Sales]";
        FastBatchingCellReader.Batch batch2RollupOnStoreType = this.createBatch(fbcr, new String[]{tableWarehouse, "time_by_day", "product_class"}, new String[]{fieldWarehouseCountry, "the_year", "product_family"}, new String[][]{fieldValuesWarehouseCountry, this.fieldValuesYear, this.fieldValuesProductFamily}, warehouseCube, measure2);
        FastBatchingCellReader.Batch batch2RollupOnStoreTypeAndWareHouseCountry = this.createBatch(fbcr, new String[]{"time_by_day", "product_class"}, new String[]{"the_year", "product_family"}, new String[][]{this.fieldValuesYear, this.fieldValuesProductFamily}, warehouseCube, measure2);
        FastBatchingCellReader.Batch batch2RollupOnProductFamilyAndWareHouseCountry = this.createBatch(fbcr, new String[]{"time_by_day", tableStore}, new String[]{"the_year", fieldStoreType}, new String[][]{this.fieldValuesYear, fieldValuesStoreType}, warehouseCube, measure2);
        FastBatchingCellReader.Batch batch2Detailed = this.createBatch(fbcr, new String[]{tableWarehouse, "time_by_day", tableStore, "product_class"}, new String[]{fieldWarehouseCountry, "the_year", fieldStoreType, "product_family"}, new String[][]{fieldValuesWarehouseCountry, this.fieldValuesYear, fieldValuesStoreType, this.fieldValuesProductFamily}, warehouseCube, measure2);
        ArrayList<FastBatchingCellReader.Batch> batchList = new ArrayList<FastBatchingCellReader.Batch>();
        batchList.add(batch1RollupOnGender);
        batchList.add(batch2RollupOnStoreType);
        batchList.add(batch2RollupOnStoreTypeAndWareHouseCountry);
        batchList.add(batch2RollupOnProductFamilyAndWareHouseCountry);
        batchList.add(batch1RollupOnGenderAndProductDepartment);
        batchList.add(batch1RollupOnStoreTypeAndProductDepartment);
        batchList.add(batch2Detailed);
        batchList.add(batch1Detailed);
        List<FastBatchingCellReader.CompositeBatch> groupedBatches = fbcr.groupBatches(batchList);
        if (MondrianProperties.instance().UseAggregates.get() && MondrianProperties.instance().ReadAggregates.get() || Util.Retrowoven) {
            FastBatchingCellReaderTest.assertEquals((int)4, (int)groupedBatches.size());
        } else {
            FastBatchingCellReaderTest.assertEquals((int)2, (int)groupedBatches.size());
        }
    }

    public void testAddToCompositeBatchForBothBatchesNotPartOfCompositeBatch() {
        FastBatchingCellReader fbcr;
        FastBatchingCellReader fastBatchingCellReader = fbcr = new FastBatchingCellReader(this.salesCube);
        fastBatchingCellReader.getClass();
        FastBatchingCellReader.Batch batch1 = fastBatchingCellReader.new FastBatchingCellReader.Batch(this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", "country", "F"));
        FastBatchingCellReader fastBatchingCellReader2 = fbcr;
        fastBatchingCellReader2.getClass();
        FastBatchingCellReader.Batch batch2 = fastBatchingCellReader2.new FastBatchingCellReader.Batch(this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", "gender", "F"));
        HashMap<AggregationKey, FastBatchingCellReader.CompositeBatch> batchGroups = new HashMap<AggregationKey, FastBatchingCellReader.CompositeBatch>();
        fbcr.addToCompositeBatch(batchGroups, batch1, batch2);
        FastBatchingCellReaderTest.assertEquals((int)1, (int)batchGroups.size());
        FastBatchingCellReader.CompositeBatch compositeBatch = (FastBatchingCellReader.CompositeBatch)batchGroups.get(batch1.batchKey);
        FastBatchingCellReaderTest.assertEquals((Object)batch1, (Object)compositeBatch.detailedBatch);
        FastBatchingCellReaderTest.assertEquals((int)1, (int)compositeBatch.summaryBatches.size());
        FastBatchingCellReaderTest.assertTrue((boolean)compositeBatch.summaryBatches.contains(batch2));
    }

    public void testAddToCompositeBatchForDetailedBatchAlreadyPartOfACompositeBatch() {
        FastBatchingCellReader fbcr;
        FastBatchingCellReader fastBatchingCellReader = fbcr = new FastBatchingCellReader(this.salesCube);
        fastBatchingCellReader.getClass();
        FastBatchingCellReader.Batch detailedBatch = fastBatchingCellReader.new FastBatchingCellReader.Batch(this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", "country", "F"));
        FastBatchingCellReader fastBatchingCellReader2 = fbcr;
        fastBatchingCellReader2.getClass();
        FastBatchingCellReader.Batch aggBatch1 = fastBatchingCellReader2.new FastBatchingCellReader.Batch(this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", "gender", "F"));
        FastBatchingCellReader fastBatchingCellReader3 = fbcr;
        fastBatchingCellReader3.getClass();
        FastBatchingCellReader.Batch aggBatchAlreadyInCompisite = fastBatchingCellReader3.new FastBatchingCellReader.Batch(this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", "gender", "F"));
        HashMap<AggregationKey, FastBatchingCellReader.CompositeBatch> batchGroups = new HashMap<AggregationKey, FastBatchingCellReader.CompositeBatch>();
        FastBatchingCellReader fastBatchingCellReader4 = fbcr;
        fastBatchingCellReader4.getClass();
        FastBatchingCellReader.CompositeBatch existingCompositeBatch = fastBatchingCellReader4.new FastBatchingCellReader.CompositeBatch(detailedBatch);
        existingCompositeBatch.add(aggBatchAlreadyInCompisite);
        batchGroups.put(detailedBatch.batchKey, existingCompositeBatch);
        fbcr.addToCompositeBatch(batchGroups, detailedBatch, aggBatch1);
        FastBatchingCellReaderTest.assertEquals((int)1, (int)batchGroups.size());
        FastBatchingCellReader.CompositeBatch compositeBatch = (FastBatchingCellReader.CompositeBatch)batchGroups.get(detailedBatch.batchKey);
        FastBatchingCellReaderTest.assertEquals((Object)detailedBatch, (Object)compositeBatch.detailedBatch);
        FastBatchingCellReaderTest.assertEquals((int)2, (int)compositeBatch.summaryBatches.size());
        FastBatchingCellReaderTest.assertTrue((boolean)compositeBatch.summaryBatches.contains(aggBatch1));
        FastBatchingCellReaderTest.assertTrue((boolean)compositeBatch.summaryBatches.contains(aggBatchAlreadyInCompisite));
    }

    public void testAddToCompositeBatchForAggregationBatchAlreadyPartOfACompositeBatch() {
        FastBatchingCellReader fbcr;
        FastBatchingCellReader fastBatchingCellReader = fbcr = new FastBatchingCellReader(this.salesCube);
        fastBatchingCellReader.getClass();
        FastBatchingCellReader.Batch detailedBatch = fastBatchingCellReader.new FastBatchingCellReader.Batch(this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", "country", "F"));
        FastBatchingCellReader fastBatchingCellReader2 = fbcr;
        fastBatchingCellReader2.getClass();
        FastBatchingCellReader.Batch aggBatchToAddToDetailedBatch = fastBatchingCellReader2.new FastBatchingCellReader.Batch(this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", "gender", "F"));
        FastBatchingCellReader fastBatchingCellReader3 = fbcr;
        fastBatchingCellReader3.getClass();
        FastBatchingCellReader.Batch aggBatchAlreadyInComposite = fastBatchingCellReader3.new FastBatchingCellReader.Batch(this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", "city", "F"));
        HashMap<AggregationKey, FastBatchingCellReader.CompositeBatch> batchGroups = new HashMap<AggregationKey, FastBatchingCellReader.CompositeBatch>();
        FastBatchingCellReader fastBatchingCellReader4 = fbcr;
        fastBatchingCellReader4.getClass();
        FastBatchingCellReader.CompositeBatch existingCompositeBatch = fastBatchingCellReader4.new FastBatchingCellReader.CompositeBatch(aggBatchToAddToDetailedBatch);
        existingCompositeBatch.add(aggBatchAlreadyInComposite);
        batchGroups.put(aggBatchToAddToDetailedBatch.batchKey, existingCompositeBatch);
        fbcr.addToCompositeBatch(batchGroups, detailedBatch, aggBatchToAddToDetailedBatch);
        FastBatchingCellReaderTest.assertEquals((int)1, (int)batchGroups.size());
        FastBatchingCellReader.CompositeBatch compositeBatch = (FastBatchingCellReader.CompositeBatch)batchGroups.get(detailedBatch.batchKey);
        FastBatchingCellReaderTest.assertEquals((Object)detailedBatch, (Object)compositeBatch.detailedBatch);
        FastBatchingCellReaderTest.assertEquals((int)2, (int)compositeBatch.summaryBatches.size());
        FastBatchingCellReaderTest.assertTrue((boolean)compositeBatch.summaryBatches.contains(aggBatchToAddToDetailedBatch));
        FastBatchingCellReaderTest.assertTrue((boolean)compositeBatch.summaryBatches.contains(aggBatchAlreadyInComposite));
    }

    public void testAddToCompositeBatchForBothBatchAlreadyPartOfACompositeBatch() {
        FastBatchingCellReader fbcr;
        FastBatchingCellReader fastBatchingCellReader = fbcr = new FastBatchingCellReader(this.salesCube);
        fastBatchingCellReader.getClass();
        FastBatchingCellReader.Batch detailedBatch = fastBatchingCellReader.new FastBatchingCellReader.Batch(this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", "country", "F"));
        FastBatchingCellReader fastBatchingCellReader2 = fbcr;
        fastBatchingCellReader2.getClass();
        FastBatchingCellReader.Batch aggBatchToAddToDetailedBatch = fastBatchingCellReader2.new FastBatchingCellReader.Batch(this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", "gender", "F"));
        FastBatchingCellReader fastBatchingCellReader3 = fbcr;
        fastBatchingCellReader3.getClass();
        FastBatchingCellReader.Batch aggBatchAlreadyInCompositeOfAgg = fastBatchingCellReader3.new FastBatchingCellReader.Batch(this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", "city", "F"));
        FastBatchingCellReader fastBatchingCellReader4 = fbcr;
        fastBatchingCellReader4.getClass();
        FastBatchingCellReader.Batch aggBatchAlreadyInCompositeOfDetail = fastBatchingCellReader4.new FastBatchingCellReader.Batch(this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", "state_province", "F"));
        HashMap<AggregationKey, FastBatchingCellReader.CompositeBatch> batchGroups = new HashMap<AggregationKey, FastBatchingCellReader.CompositeBatch>();
        FastBatchingCellReader fastBatchingCellReader5 = fbcr;
        fastBatchingCellReader5.getClass();
        FastBatchingCellReader.CompositeBatch existingAggCompositeBatch = fastBatchingCellReader5.new FastBatchingCellReader.CompositeBatch(aggBatchToAddToDetailedBatch);
        existingAggCompositeBatch.add(aggBatchAlreadyInCompositeOfAgg);
        batchGroups.put(aggBatchToAddToDetailedBatch.batchKey, existingAggCompositeBatch);
        FastBatchingCellReader fastBatchingCellReader6 = fbcr;
        fastBatchingCellReader6.getClass();
        FastBatchingCellReader.CompositeBatch existingCompositeBatch = fastBatchingCellReader6.new FastBatchingCellReader.CompositeBatch(detailedBatch);
        existingCompositeBatch.add(aggBatchAlreadyInCompositeOfDetail);
        batchGroups.put(detailedBatch.batchKey, existingCompositeBatch);
        fbcr.addToCompositeBatch(batchGroups, detailedBatch, aggBatchToAddToDetailedBatch);
        FastBatchingCellReaderTest.assertEquals((int)1, (int)batchGroups.size());
        FastBatchingCellReader.CompositeBatch compositeBatch = (FastBatchingCellReader.CompositeBatch)batchGroups.get(detailedBatch.batchKey);
        FastBatchingCellReaderTest.assertEquals((Object)detailedBatch, (Object)compositeBatch.detailedBatch);
        FastBatchingCellReaderTest.assertEquals((int)3, (int)compositeBatch.summaryBatches.size());
        FastBatchingCellReaderTest.assertTrue((boolean)compositeBatch.summaryBatches.contains(aggBatchToAddToDetailedBatch));
        FastBatchingCellReaderTest.assertTrue((boolean)compositeBatch.summaryBatches.contains(aggBatchAlreadyInCompositeOfAgg));
        FastBatchingCellReaderTest.assertTrue((boolean)compositeBatch.summaryBatches.contains(aggBatchAlreadyInCompositeOfDetail));
    }

    public void testCanBatchForBatchWithSuperSetOfContraintColumnBitKeyAndAllValuesForAdditionalCondition() {
        FastBatchingCellReader fbcr = new FastBatchingCellReader(this.salesCube);
        FastBatchingCellReader.Batch aggregationBatch = this.createBatch(fbcr, new String[]{"time_by_day", "product_class", "product_class"}, new String[]{"the_year", "product_family", "product_department"}, new String[][]{this.fieldValuesYear, this.fieldValuesProductFamily, this.fieldValueProductDepartment}, "Sales", "[Measures].[Unit Sales]");
        FastBatchingCellReader.Batch detailedBatch = this.createBatch(fbcr, new String[]{"time_by_day", "product_class", "product_class", "customer"}, new String[]{"the_year", "product_family", "product_department", this.fieldGender}, new String[][]{this.fieldValuesYear, this.fieldValuesProductFamily, this.fieldValueProductDepartment, this.fieldValuesGender}, "Sales", "[Measures].[Unit Sales]");
        FastBatchingCellReaderTest.assertTrue((boolean)detailedBatch.canBatch(aggregationBatch));
        FastBatchingCellReaderTest.assertFalse((boolean)aggregationBatch.canBatch(detailedBatch));
    }

    public void testCanBatchForBatchWithConstraint() {
        FastBatchingCellReader fbcr = new FastBatchingCellReader(this.salesCube);
        ArrayList<String[]> compoundMembers = new ArrayList<String[]>();
        compoundMembers.add(new String[]{"USA", "CA"});
        compoundMembers.add(new String[]{"Canada", "BC"});
        BatchTestCase.CellRequestConstraint constraint = FastBatchingCellReaderTest.makeConstraintCountryState(compoundMembers);
        FastBatchingCellReader.Batch aggregationBatch = this.createBatch(fbcr, new String[]{"time_by_day", "product_class", "product_class"}, new String[]{"the_year", "product_family", "product_department"}, new String[][]{this.fieldValuesYear, this.fieldValuesProductFamily, this.fieldValueProductDepartment}, "Sales", "[Measures].[Unit Sales]", constraint);
        FastBatchingCellReader.Batch detailedBatch = this.createBatch(fbcr, new String[]{"time_by_day", "product_class", "product_class", "customer"}, new String[]{"the_year", "product_family", "product_department", this.fieldGender}, new String[][]{this.fieldValuesYear, this.fieldValuesProductFamily, this.fieldValueProductDepartment, this.fieldValuesGender}, "Sales", "[Measures].[Unit Sales]", constraint);
        FastBatchingCellReaderTest.assertTrue((boolean)detailedBatch.canBatch(aggregationBatch));
        FastBatchingCellReaderTest.assertFalse((boolean)aggregationBatch.canBatch(detailedBatch));
    }

    public void testCanBatchForBatchWithConstraint2() {
        FastBatchingCellReader fbcr = new FastBatchingCellReader(this.salesCube);
        ArrayList<String[]> compoundMembers1 = new ArrayList<String[]>();
        compoundMembers1.add(new String[]{"USA", "CA"});
        compoundMembers1.add(new String[]{"Canada", "BC"});
        BatchTestCase.CellRequestConstraint constraint1 = FastBatchingCellReaderTest.makeConstraintCountryState(compoundMembers1);
        ArrayList<String[]> compoundMembers2 = new ArrayList<String[]>();
        compoundMembers2.add(new String[]{"USA", "CA"});
        compoundMembers2.add(new String[]{"USA", "OR"});
        BatchTestCase.CellRequestConstraint constraint2 = FastBatchingCellReaderTest.makeConstraintCountryState(compoundMembers2);
        FastBatchingCellReader.Batch aggregationBatch = this.createBatch(fbcr, new String[]{"time_by_day", "product_class", "product_class"}, new String[]{"the_year", "product_family", "product_department"}, new String[][]{this.fieldValuesYear, this.fieldValuesProductFamily, this.fieldValueProductDepartment}, "Sales", "[Measures].[Unit Sales]", constraint1);
        FastBatchingCellReader.Batch detailedBatch = this.createBatch(fbcr, new String[]{"time_by_day", "product_class", "product_class", "customer"}, new String[]{"the_year", "product_family", "product_department", this.fieldGender}, new String[][]{this.fieldValuesYear, this.fieldValuesProductFamily, this.fieldValueProductDepartment, this.fieldValuesGender}, "Sales", "[Measures].[Unit Sales]", constraint2);
        FastBatchingCellReaderTest.assertTrue((boolean)detailedBatch.canBatch(aggregationBatch));
        FastBatchingCellReaderTest.assertFalse((boolean)aggregationBatch.canBatch(detailedBatch));
    }

    public void testCanBatchForBatchWithDistinctCountInDetailedBatch() {
        if (MondrianProperties.instance().UseAggregates.get() && MondrianProperties.instance().ReadAggregates.get()) {
            FastBatchingCellReader fbcr = new FastBatchingCellReader(this.salesCube);
            FastBatchingCellReader.Batch aggregationBatch = this.createBatch(fbcr, new String[]{"time_by_day", "product_class", "product_class"}, new String[]{"the_year", "product_family", "product_department"}, new String[][]{this.fieldValuesYear, this.fieldValuesProductFamily, this.fieldValueProductDepartment}, "Sales", "[Measures].[Unit Sales]");
            FastBatchingCellReader.Batch detailedBatch = this.createBatch(fbcr, new String[]{"time_by_day", "product_class", "product_class"}, new String[]{"the_year", "product_family", "product_department"}, new String[][]{this.fieldValuesYear, this.fieldValuesProductFamily, this.fieldValueProductDepartment}, "Sales", "[Measures].[Customer Count]");
            FastBatchingCellReaderTest.assertFalse((boolean)detailedBatch.canBatch(aggregationBatch));
            FastBatchingCellReaderTest.assertFalse((boolean)aggregationBatch.canBatch(detailedBatch));
        }
    }

    public void testCanBatchForBatchWithDistinctCountInAggregateBatch() {
        if (MondrianProperties.instance().UseAggregates.get() && MondrianProperties.instance().ReadAggregates.get()) {
            FastBatchingCellReader fbcr = new FastBatchingCellReader(this.salesCube);
            FastBatchingCellReader.Batch aggregationBatch = this.createBatch(fbcr, new String[]{"time_by_day", "product_class", "product_class"}, new String[]{"the_year", "product_family", "product_department"}, new String[][]{this.fieldValuesYear, this.fieldValuesProductFamily, this.fieldValueProductDepartment}, "Sales", "[Measures].[Customer Count]");
            FastBatchingCellReader.Batch detailedBatch = this.createBatch(fbcr, new String[]{"time_by_day", "product_class", "product_class"}, new String[]{"the_year", "product_family", "product_department"}, new String[][]{this.fieldValuesYear, this.fieldValuesProductFamily, this.fieldValueProductDepartment}, "Sales", "[Measures].[Unit Sales]");
            FastBatchingCellReaderTest.assertFalse((boolean)detailedBatch.canBatch(aggregationBatch));
            FastBatchingCellReaderTest.assertFalse((boolean)aggregationBatch.canBatch(detailedBatch));
        }
    }

    public void testCanBatchSummaryBatchWithDetailedBatchWithDistinctCount() {
        if (!MondrianProperties.instance().UseAggregates.get() && !MondrianProperties.instance().ReadAggregates.get()) {
            FastBatchingCellReader fbcr = new FastBatchingCellReader(this.salesCube);
            FastBatchingCellReader.Batch aggregationBatch = this.createBatch(fbcr, new String[]{"time_by_day"}, new String[]{"the_year"}, new String[][]{this.fieldValuesYear}, "Sales", "[Measures].[Customer Count]");
            FastBatchingCellReader.Batch detailedBatch = this.createBatch(fbcr, new String[]{"time_by_day", "product_class", "product_class"}, new String[]{"the_year", "product_family", "product_department"}, new String[][]{this.fieldValuesYear, this.fieldValuesProductFamily, this.fieldValueProductDepartment}, "Sales", "[Measures].[Unit Sales]");
            FastBatchingCellReaderTest.assertFalse((boolean)detailedBatch.canBatch(aggregationBatch));
            FastBatchingCellReaderTest.assertFalse((boolean)aggregationBatch.canBatch(detailedBatch));
        }
    }

    public void testCanBatchForBatchWithNonSuperSetOfContraintColumnBitKeyAndAllValuesForAdditionalCondition() {
        FastBatchingCellReader fbcr = new FastBatchingCellReader(this.salesCube);
        FastBatchingCellReader.Batch aggregationBatch = this.createBatch(fbcr, new String[]{"time_by_day", "product_class", "product_class"}, new String[]{"the_year", "product_family", "product_department"}, new String[][]{this.fieldValuesYear, this.fieldValuesProductFamily, this.fieldValueProductDepartment}, "Sales", "[Measures].[Unit Sales]");
        FastBatchingCellReader.Batch detailedBatch = this.createBatch(fbcr, new String[]{"product_class", "product_class", "customer"}, new String[]{"product_family", "product_department", this.fieldGender}, new String[][]{this.fieldValuesProductFamily, this.fieldValueProductDepartment, this.fieldValuesGender}, "Sales", "[Measures].[Unit Sales]");
        FastBatchingCellReaderTest.assertFalse((boolean)detailedBatch.canBatch(aggregationBatch));
        FastBatchingCellReaderTest.assertFalse((boolean)aggregationBatch.canBatch(detailedBatch));
    }

    public void testCanBatchForBatchWithSuperSetOfContraintColumnBitKeyAndNOTAllValuesForAdditionalCondition() {
        FastBatchingCellReader fbcr = new FastBatchingCellReader(this.salesCube);
        FastBatchingCellReader.Batch aggregationBatch = this.createBatch(fbcr, new String[]{"time_by_day", "product_class", "product_class"}, new String[]{"the_year", "product_family", "product_department"}, new String[][]{this.fieldValuesYear, this.fieldValuesProductFamily, this.fieldValueProductDepartment}, "Sales", "[Measures].[Unit Sales]");
        FastBatchingCellReader.Batch detailedBatch = this.createBatch(fbcr, new String[]{"time_by_day", "product_class", "product_class", "customer"}, new String[]{"the_year", "product_family", "product_department", this.fieldGender}, new String[][]{this.fieldValuesYear, this.fieldValuesProductFamily, this.fieldValueProductDepartment, {"M"}}, "Sales", "[Measures].[Unit Sales]");
        FastBatchingCellReaderTest.assertFalse((boolean)detailedBatch.canBatch(aggregationBatch));
        FastBatchingCellReaderTest.assertFalse((boolean)aggregationBatch.canBatch(detailedBatch));
    }

    public void testCanBatchForBatchesFromSameAggregationButDifferentRollupOption() {
        FastBatchingCellReader fbcr = new FastBatchingCellReader(this.salesCube);
        FastBatchingCellReader.Batch batch1 = this.createBatch(fbcr, new String[]{"time_by_day"}, new String[]{"the_year"}, new String[][]{this.fieldValuesYear}, "Sales", "[Measures].[Unit Sales]");
        FastBatchingCellReader.Batch batch2 = this.createBatch(fbcr, new String[]{"time_by_day", "time_by_day", "time_by_day"}, new String[]{"the_year", "quarter", "month_of_year"}, new String[][]{this.fieldValuesYear, {"Q1", "Q2", "Q3", "Q4"}, {"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"}}, "Sales", "[Measures].[Unit Sales]");
        if (MondrianProperties.instance().UseAggregates.get() && MondrianProperties.instance().ReadAggregates.get()) {
            FastBatchingCellReaderTest.assertFalse((boolean)batch2.canBatch(batch1));
            FastBatchingCellReaderTest.assertFalse((boolean)batch1.canBatch(batch2));
        } else if (!Util.Retrowoven) {
            FastBatchingCellReaderTest.assertTrue((boolean)batch2.canBatch(batch1));
        }
    }

    public void testCanBatchForBatchWithSuperSetOfContraintColumnBitKeyAndDifferentValuesForOverlappingColumns() {
        FastBatchingCellReader fbcr = new FastBatchingCellReader(this.salesCube);
        FastBatchingCellReader.Batch aggregationBatch = this.createBatch(fbcr, new String[]{"time_by_day", "product_class", "product_class"}, new String[]{"the_year", "product_family", "product_department"}, new String[][]{{"1997"}, this.fieldValuesProductFamily, this.fieldValueProductDepartment}, "Sales", "[Measures].[Unit Sales]");
        FastBatchingCellReader.Batch detailedBatch = this.createBatch(fbcr, new String[]{"time_by_day", "product_class", "product_class", "customer"}, new String[]{"the_year", "product_family", "product_department", this.fieldGender}, new String[][]{{"1998"}, this.fieldValuesProductFamily, this.fieldValueProductDepartment, this.fieldValuesGender}, "Sales", "[Measures].[Unit Sales]");
        FastBatchingCellReaderTest.assertFalse((boolean)detailedBatch.canBatch(aggregationBatch));
        FastBatchingCellReaderTest.assertFalse((boolean)aggregationBatch.canBatch(detailedBatch));
    }

    public void testCanBatchForBatchWithDifferentAggregationTable() {
        Dialect dialect = this.getTestContext().getDialect();
        Dialect.DatabaseProduct product = dialect.getDatabaseProduct();
        switch (product) {
            case TERADATA: 
            case INFOBRIGHT: {
                return;
            }
        }
        this.getTestContext().clearConnection();
        this.propSaver.set(this.propSaver.properties.UseAggregates, true);
        this.propSaver.set(this.propSaver.properties.ReadAggregates, true);
        FastBatchingCellReader fbcr = new FastBatchingCellReader(this.getCube("Sales"));
        FastBatchingCellReader.Batch summaryBatch = this.createBatch(fbcr, new String[]{"time_by_day"}, new String[]{"the_year"}, new String[][]{this.fieldValuesYear}, "Sales", "[Measures].[Unit Sales]");
        FastBatchingCellReader.Batch detailedBatch = this.createBatch(fbcr, new String[]{"time_by_day", "customer"}, new String[]{"the_year", this.fieldGender}, new String[][]{this.fieldValuesYear, this.fieldValuesGender}, "Sales", "[Measures].[Unit Sales]");
        FastBatchingCellReaderTest.assertFalse((boolean)detailedBatch.canBatch(summaryBatch));
        FastBatchingCellReaderTest.assertFalse((boolean)summaryBatch.canBatch(detailedBatch));
    }

    public void testCannotBatchTwoBatchesAtTheSameLevel() {
        FastBatchingCellReader fbcr = new FastBatchingCellReader(this.salesCube);
        FastBatchingCellReader.Batch firstBatch = this.createBatch(fbcr, new String[]{"time_by_day", "product_class", "product_class"}, new String[]{"the_year", "product_family", "product_department"}, new String[][]{this.fieldValuesYear, {"Food"}, this.fieldValueProductDepartment}, "Sales", "[Measures].[Customer Count]");
        FastBatchingCellReader.Batch secondBatch = this.createBatch(fbcr, new String[]{"time_by_day", "product_class", "product_class"}, new String[]{"the_year", "product_family", "product_department"}, new String[][]{this.fieldValuesYear, {"Drink"}, this.fieldValueProductDepartment}, "Sales", "[Measures].[Customer Count]");
        FastBatchingCellReaderTest.assertFalse((boolean)firstBatch.canBatch(secondBatch));
        FastBatchingCellReaderTest.assertFalse((boolean)secondBatch.canBatch(firstBatch));
    }

    public void testCompositeBatchLoadAggregation() {
        FastBatchingCellReader fbcr = new FastBatchingCellReader(this.salesCube);
        FastBatchingCellReader.Batch summaryBatch = this.createBatch(fbcr, new String[]{"time_by_day", "product_class", "product_class"}, new String[]{"the_year", "product_family", "product_department"}, new String[][]{this.fieldValuesYear, this.fieldValuesProductFamily, this.fieldValueProductDepartment}, "Sales", "[Measures].[Unit Sales]");
        FastBatchingCellReader.Batch detailedBatch = this.createBatch(fbcr, new String[]{"time_by_day", "product_class", "product_class", "customer"}, new String[]{"the_year", "product_family", "product_department", this.fieldGender}, new String[][]{this.fieldValuesYear, this.fieldValuesProductFamily, this.fieldValueProductDepartment, this.fieldValuesGender}, "Sales", "[Measures].[Unit Sales]");
        final ArrayList groupingSets = new ArrayList();
        FastBatchingCellReader fastBatchingCellReader = fbcr;
        fastBatchingCellReader.getClass();
        FastBatchingCellReader.CompositeBatch compositeBatch = new FastBatchingCellReader.CompositeBatch(fastBatchingCellReader, detailedBatch){
            {
                FastBatchingCellReader fastBatchingCellReader = x0;
                fastBatchingCellReader.getClass();
                super(x1);
            }

            SegmentLoader getSegmentLoader() {
                return new SegmentLoader(){

                    @Override
                    public void load(List<GroupingSet> sets, RolapAggregationManager.PinSet pinnedSegments, List<StarPredicate> compoundPredicateList) {
                        groupingSets.addAll(sets);
                        for (GroupingSet groupingSet : sets) {
                            groupingSet.setSegmentsFailed();
                        }
                    }
                };
            }
        };
        compositeBatch.add(summaryBatch);
        compositeBatch.loadAggregation();
        FastBatchingCellReaderTest.assertEquals((int)2, (int)groupingSets.size());
        FastBatchingCellReaderTest.assertEquals((Object)detailedBatch.getConstrainedColumnsBitKey(), (Object)((GroupingSet)groupingSets.get(0)).getLevelBitKey());
        FastBatchingCellReaderTest.assertEquals((Object)summaryBatch.getConstrainedColumnsBitKey(), (Object)((GroupingSet)groupingSets.get(1)).getLevelBitKey());
    }

    public void testLoadDistinctSqlMeasure() {
        Dialect dialect = this.getTestContext().getDialect();
        switch (dialect.getDatabaseProduct()) {
            case ORACLE: 
            case TERADATA: 
            case ACCESS: 
            case NETEZZA: {
                return;
            }
        }
        String cube = "<Cube name=\"Warehouse2\">   <Table name=\"warehouse\"/>   <DimensionUsage name=\"Store Type\" source=\"Store Type\" foreignKey=\"stores_id\"/>   <Measure name=\"Count Distinct of Warehouses (Large Owned)\" aggregator=\"distinct count\" formatString=\"#,##0\">       <MeasureExpression>       <SQL dialect=\"generic\">(select `warehouse_class`.`warehouse_class_id` AS `warehouse_class_id` from `warehouse_class` AS `warehouse_class` where `warehouse_class`.`warehouse_class_id` = `warehouse`.`warehouse_class_id` and `warehouse_class`.`description` = 'Large Owned')</SQL>       </MeasureExpression>   </Measure>   <Measure name=\"Count Distinct of Warehouses (Large Independent)\" aggregator=\"distinct count\" formatString=\"#,##0\">       <MeasureExpression>       <SQL dialect=\"generic\">(select `warehouse_class`.`warehouse_class_id` AS `warehouse_class_id` from `warehouse_class` AS `warehouse_class` where `warehouse_class`.`warehouse_class_id` = `warehouse`.`warehouse_class_id` and `warehouse_class`.`description` = 'Large Independent')</SQL>       </MeasureExpression>   </Measure>   <Measure name=\"Count All of Warehouses (Large Independent)\" aggregator=\"count\" formatString=\"#,##0\">       <MeasureExpression>           <SQL dialect=\"generic\">(select `warehouse_class`.`warehouse_class_id` AS `warehouse_class_id` from `warehouse_class` AS `warehouse_class` where `warehouse_class`.`warehouse_class_id` = `warehouse`.`warehouse_class_id` and `warehouse_class`.`description` = 'Large Independent')</SQL>       </MeasureExpression>   </Measure>   <Measure name=\"Count Distinct Store+Warehouse\" aggregator=\"distinct count\" formatString=\"#,##0\">       <MeasureExpression><SQL dialect=\"generic\">`store_id`+`warehouse_id`</SQL></MeasureExpression>   </Measure>   <Measure name=\"Count All Store+Warehouse\" aggregator=\"count\" formatString=\"#,##0\">       <MeasureExpression><SQL dialect=\"generic\">`store_id`+`warehouse_id`</SQL></MeasureExpression>   </Measure>   <Measure name=\"Store Count\" column=\"stores_id\" aggregator=\"count\" formatString=\"#,###\"/></Cube>";
        cube = cube.replaceAll("`", dialect.getQuoteIdentifierString());
        if (dialect.getDatabaseProduct() == Dialect.DatabaseProduct.ORACLE) {
            cube = cube.replaceAll(" AS ", " ");
        }
        String query = "select    [Store Type].Children on rows,    {[Measures].[Count Distinct of Warehouses (Large Owned)],    [Measures].[Count Distinct of Warehouses (Large Independent)],    [Measures].[Count All of Warehouses (Large Independent)],    [Measures].[Count Distinct Store+Warehouse],    [Measures].[Count All Store+Warehouse],    [Measures].[Store Count]} on columns from [Warehouse2]";
        TestContext testContext = TestContext.create(null, cube, null, null, null, null);
        testContext.assertQueryReturns(query, FastBatchingCellReaderTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Count Distinct of Warehouses (Large Owned)]}\n{[Measures].[Count Distinct of Warehouses (Large Independent)]}\n{[Measures].[Count All of Warehouses (Large Independent)]}\n{[Measures].[Count Distinct Store+Warehouse]}\n{[Measures].[Count All Store+Warehouse]}\n{[Measures].[Store Count]}\nAxis #2:\n{[Store Type].[All Store Types].[Deluxe Supermarket]}\n{[Store Type].[All Store Types].[Gourmet Supermarket]}\n{[Store Type].[All Store Types].[HeadQuarters]}\n{[Store Type].[All Store Types].[Mid-Size Grocery]}\n{[Store Type].[All Store Types].[Small Grocery]}\n{[Store Type].[All Store Types].[Supermarket]}\nRow #0: 1\nRow #0: 0\nRow #0: 0\nRow #0: 6\nRow #0: 6\nRow #0: 6\nRow #1: 1\nRow #1: 0\nRow #1: 0\nRow #1: 2\nRow #1: 2\nRow #1: 2\nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #3: 0\nRow #3: 1\nRow #3: 1\nRow #3: 4\nRow #3: 4\nRow #3: 4\nRow #4: 0\nRow #4: 1\nRow #4: 1\nRow #4: 4\nRow #4: 4\nRow #4: 4\nRow #5: 0\nRow #5: 1\nRow #5: 3\nRow #5: 8\nRow #5: 8\nRow #5: 8\n"));
        String loadCountDistinct_luciddb1 = "select \"store\".\"store_type\" as \"c0\", count(distinct (select \"warehouse_class\".\"warehouse_class_id\" AS \"warehouse_class_id\" from \"warehouse_class\" AS \"warehouse_class\" where \"warehouse_class\".\"warehouse_class_id\" = \"warehouse\".\"warehouse_class_id\" and \"warehouse_class\".\"description\" = 'Large Owned')) as \"m0\" from \"store\" as \"store\", \"warehouse\" as \"warehouse\" where \"warehouse\".\"stores_id\" = \"store\".\"store_id\" group by \"store\".\"store_type\"";
        String loadCountDistinct_luciddb2 = "select \"store\".\"store_type\" as \"c0\", count(distinct (select \"warehouse_class\".\"warehouse_class_id\" AS \"warehouse_class_id\" from \"warehouse_class\" AS \"warehouse_class\" where \"warehouse_class\".\"warehouse_class_id\" = \"warehouse\".\"warehouse_class_id\" and \"warehouse_class\".\"description\" = 'Large Independent')) as \"m0\" from \"store\" as \"store\", \"warehouse\" as \"warehouse\" where \"warehouse\".\"stores_id\" = \"store\".\"store_id\" group by \"store\".\"store_type\"";
        String loadOtherAggs_luciddb = "select \"store\".\"store_type\" as \"c0\", count((select \"warehouse_class\".\"warehouse_class_id\" AS \"warehouse_class_id\" from \"warehouse_class\" AS \"warehouse_class\" where \"warehouse_class\".\"warehouse_class_id\" = \"warehouse\".\"warehouse_class_id\" and \"warehouse_class\".\"description\" = 'Large Independent')) as \"m0\", count(distinct \"store_id\"+\"warehouse_id\") as \"m1\", count(\"store_id\"+\"warehouse_id\") as \"m2\", count(\"warehouse\".\"stores_id\") as \"m3\" from \"store\" as \"store\", \"warehouse\" as \"warehouse\" where \"warehouse\".\"stores_id\" = \"store\".\"store_id\" group by \"store\".\"store_type\"";
        String loadCountDistinct_derby1 = "select \"store\".\"store_type\" as \"c0\", count(distinct (select \"warehouse_class\".\"warehouse_class_id\" AS \"warehouse_class_id\" from \"warehouse_class\" AS \"warehouse_class\" where \"warehouse_class\".\"warehouse_class_id\" = \"warehouse\".\"warehouse_class_id\" and \"warehouse_class\".\"description\" = 'Large Owned')) as \"m0\" from \"store\" as \"store\", \"warehouse\" as \"warehouse\" where \"warehouse\".\"stores_id\" = \"store\".\"store_id\" group by \"store\".\"store_type\"";
        String loadCountDistinct_derby2 = "select \"store\".\"store_type\" as \"c0\", count(distinct (select \"warehouse_class\".\"warehouse_class_id\" AS \"warehouse_class_id\" from \"warehouse_class\" AS \"warehouse_class\" where \"warehouse_class\".\"warehouse_class_id\" = \"warehouse\".\"warehouse_class_id\" and \"warehouse_class\".\"description\" = 'Large Independent')) as \"m0\" from \"store\" as \"store\", \"warehouse\" as \"warehouse\" where \"warehouse\".\"stores_id\" = \"store\".\"store_id\" group by \"store\".\"store_type\"";
        String loadCountDistinct_derby3 = "select \"store\".\"store_type\" as \"c0\", count(distinct \"store_id\"+\"warehouse_id\") as \"m0\" from \"store\" as \"store\", \"warehouse\" as \"warehouse\" where \"warehouse\".\"stores_id\" = \"store\".\"store_id\" group by \"store\".\"store_type\"";
        String loadOtherAggs_derby = "select \"store\".\"store_type\" as \"c0\", count((select \"warehouse_class\".\"warehouse_class_id\" AS \"warehouse_class_id\" from \"warehouse_class\" AS \"warehouse_class\" where \"warehouse_class\".\"warehouse_class_id\" = \"warehouse\".\"warehouse_class_id\" and \"warehouse_class\".\"description\" = 'Large Independent')) as \"m0\", count(\"store_id\"+\"warehouse_id\") as \"m1\", count(\"warehouse\".\"stores_id\") as \"m2\" from \"store\" as \"store\", \"warehouse\" as \"warehouse\" where \"warehouse\".\"stores_id\" = \"store\".\"store_id\" group by \"store\".\"store_type\"";
        String load_mysql = "select `store`.`store_type` as `c0`, count(distinct (select `warehouse_class`.`warehouse_class_id` AS `warehouse_class_id` from `warehouse_class` AS `warehouse_class` where `warehouse_class`.`warehouse_class_id` = `warehouse`.`warehouse_class_id` and `warehouse_class`.`description` = 'Large Owned')) as `m0`, count(distinct (select `warehouse_class`.`warehouse_class_id` AS `warehouse_class_id` from `warehouse_class` AS `warehouse_class` where `warehouse_class`.`warehouse_class_id` = `warehouse`.`warehouse_class_id` and `warehouse_class`.`description` = 'Large Independent')) as `m1`, count((select `warehouse_class`.`warehouse_class_id` AS `warehouse_class_id` from `warehouse_class` AS `warehouse_class` where `warehouse_class`.`warehouse_class_id` = `warehouse`.`warehouse_class_id` and `warehouse_class`.`description` = 'Large Independent')) as `m2`, count(distinct `store_id`+`warehouse_id`) as `m3`, count(`store_id`+`warehouse_id`) as `m4`, count(`warehouse`.`stores_id`) as `m5` from `store` as `store`, `warehouse` as `warehouse` where `warehouse`.`stores_id` = `store`.`store_id` group by `store`.`store_type`";
        SqlPattern[] patterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.LUCIDDB, loadCountDistinct_luciddb1, loadCountDistinct_luciddb1), new SqlPattern(Dialect.DatabaseProduct.LUCIDDB, loadCountDistinct_luciddb2, loadCountDistinct_luciddb2), new SqlPattern(Dialect.DatabaseProduct.LUCIDDB, loadOtherAggs_luciddb, loadOtherAggs_luciddb), new SqlPattern(Dialect.DatabaseProduct.DERBY, loadCountDistinct_derby1, loadCountDistinct_derby1), new SqlPattern(Dialect.DatabaseProduct.DERBY, loadCountDistinct_derby2, loadCountDistinct_derby2), new SqlPattern(Dialect.DatabaseProduct.DERBY, loadCountDistinct_derby3, loadCountDistinct_derby3), new SqlPattern(Dialect.DatabaseProduct.DERBY, loadOtherAggs_derby, loadOtherAggs_derby), new SqlPattern(Dialect.DatabaseProduct.MYSQL, load_mysql, load_mysql)};
        this.assertQuerySql(testContext, query, patterns);
    }

    public void testAggregateDistinctCount() {
        this.assertQueryReturns("WITH MEMBER [Time].[1997 Q1 plus Q2] AS 'AGGREGATE({[Time].[1997].[Q1], [Time].[1997].[Q2]})', solve_order=1\nSELECT {[Measures].[Customer Count]} ON COLUMNS,\n      {[Time].[1997].[Q1], [Time].[1997].[Q2], [Time].[1997 Q1 plus Q2]} ON ROWS\nFROM Sales\nWHERE ([Store].[USA].[CA])", FastBatchingCellReaderTest.fold("Axis #0:\n{[Store].[All Stores].[USA].[CA]}\nAxis #1:\n{[Measures].[Customer Count]}\nAxis #2:\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q2]}\n{[Time].[1997 Q1 plus Q2]}\nRow #0: 1,110\nRow #1: 1,173\nRow #2: 1,854\n"));
    }

    public void testAggregateDistinctCount2() {
        this.assertQueryReturns("WITH MEMBER [Time].[1997 Q1 plus July] AS\n 'AGGREGATE({[Time].[1997].[Q1], [Time].[1997].[Q3].[7]})', solve_order=1\nSELECT {[Measures].[Unit Sales], [Measures].[Customer Count]} ON COLUMNS,\n      {[Time].[1997].[Q1],\n       [Time].[1997].[Q2],\n       [Time].[1997].[Q3].[7],\n       [Time].[1997 Q1 plus July]} ON ROWS\nFROM Sales\nWHERE ([Store].[USA].[CA])", FastBatchingCellReaderTest.fold("Axis #0:\n{[Store].[All Stores].[USA].[CA]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Customer Count]}\nAxis #2:\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q2]}\n{[Time].[1997].[Q3].[7]}\n{[Time].[1997 Q1 plus July]}\nRow #0: 16,890\nRow #0: 1,110\nRow #1: 18,052\nRow #1: 1,173\nRow #2: 5,403\nRow #2: 412\nRow #3: 22,293\nRow #3: 1,386\n"));
    }

    public void testAggregateDistinctCount3() {
        String mdxQuery = "WITH\n  MEMBER [Promotion Media].[TV plus Radio] AS 'AGGREGATE({[Promotion Media].[TV], [Promotion Media].[Radio]})', solve_order=1\n  MEMBER [Time].[1997 Q1 plus July] AS 'AGGREGATE({[Time].[1997].[Q1], [Time].[1997].[Q3].[7]})', solve_order=1\nSELECT {[Promotion Media].[TV plus Radio],\n        [Promotion Media].[TV],\n        [Promotion Media].[Radio]} ON COLUMNS,\n       {[Time].[1997],\n        [Time].[1997].[Q1],\n        [Time].[1997 Q1 plus July]} ON ROWS\nFROM Sales\nWHERE [Measures].[Customer Count]";
        this.assertQueryReturns(mdxQuery, FastBatchingCellReaderTest.fold("Axis #0:\n{[Measures].[Customer Count]}\nAxis #1:\n{[Promotion Media].[TV plus Radio]}\n{[Promotion Media].[All Media].[TV]}\n{[Promotion Media].[All Media].[Radio]}\nAxis #2:\n{[Time].[1997]}\n{[Time].[1997].[Q1]}\n{[Time].[1997 Q1 plus July]}\nRow #0: 455\nRow #0: 274\nRow #0: 186\nRow #1: 139\nRow #1: 99\nRow #1: 40\nRow #2: 139\nRow #2: 99\nRow #2: 40\n"));
        String oracleSql = "select \"time_by_day\".\"the_year\" as \"c0\", \"time_by_day\".\"quarter\" as \"c1\", \"promotion\".\"media_type\" as \"c2\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"time_by_day\" \"time_by_day\", \"sales_fact_1997\" \"sales_fact_1997\", \"promotion\" \"promotion\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"time_by_day\".\"quarter\" = 'Q1' and \"sales_fact_1997\".\"promotion_id\" = \"promotion\".\"promotion_id\" and \"promotion\".\"media_type\" in ('Radio', 'TV') group by \"time_by_day\".\"the_year\", \"time_by_day\".\"quarter\", \"promotion\".\"media_type\"";
        String mysqlSql = "select `time_by_day`.`the_year` as `c0`, `time_by_day`.`quarter` as `c1`, `promotion`.`media_type` as `c2`, count(distinct `sales_fact_1997`.`customer_id`) as `m0` from `time_by_day` as `time_by_day`, `sales_fact_1997` as `sales_fact_1997`, `promotion` as `promotion` where `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 and `time_by_day`.`quarter` = 'Q1' and `sales_fact_1997`.`promotion_id` = `promotion`.`promotion_id` and `promotion`.`media_type` in ('Radio', 'TV') group by `time_by_day`.`the_year`, `time_by_day`.`quarter`, `promotion`.`media_type`";
        String derbySql = "select \"time_by_day\".\"the_year\" as \"c0\", \"time_by_day\".\"quarter\" as \"c1\", \"promotion\".\"media_type\" as \"c2\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"time_by_day\" as \"time_by_day\", \"sales_fact_1997\" as \"sales_fact_1997\", \"promotion\" as \"promotion\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"time_by_day\".\"quarter\" = 'Q1' and \"sales_fact_1997\".\"promotion_id\" = \"promotion\".\"promotion_id\" and \"promotion\".\"media_type\" in ('Radio', 'TV') group by \"time_by_day\".\"the_year\", \"time_by_day\".\"quarter\", \"promotion\".\"media_type\"";
        this.assertQuerySql(mdxQuery, new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.ORACLE, "select \"time_by_day\".\"the_year\" as \"c0\", \"time_by_day\".\"quarter\" as \"c1\", \"promotion\".\"media_type\" as \"c2\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"time_by_day\" \"time_by_day\", \"sales_fact_1997\" \"sales_fact_1997\", \"promotion\" \"promotion\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"time_by_day\".\"quarter\" = 'Q1' and \"sales_fact_1997\".\"promotion_id\" = \"promotion\".\"promotion_id\" and \"promotion\".\"media_type\" in ('Radio', 'TV') group by \"time_by_day\".\"the_year\", \"time_by_day\".\"quarter\", \"promotion\".\"media_type\"", "select \"time_by_day\".\"the_year\" as \"c0\", \"time_by_day\".\"quarter\" as \"c1\", \"promotion\".\"media_type\" as \"c2\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"time_by_day\" \"time_by_day\", \"sales_fact_1997\" \"sales_fact_1997\", \"promotion\" \"promotion\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"time_by_day\".\"quarter\" = 'Q1' and \"sales_fact_1997\".\"promotion_id\" = \"promotion\".\"promotion_id\" and \"promotion\".\"media_type\" in ('Radio', 'TV') group by \"time_by_day\".\"the_year\", \"time_by_day\".\"quarter\", \"promotion\".\"media_type\""), new SqlPattern(Dialect.DatabaseProduct.MYSQL, "select `time_by_day`.`the_year` as `c0`, `time_by_day`.`quarter` as `c1`, `promotion`.`media_type` as `c2`, count(distinct `sales_fact_1997`.`customer_id`) as `m0` from `time_by_day` as `time_by_day`, `sales_fact_1997` as `sales_fact_1997`, `promotion` as `promotion` where `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 and `time_by_day`.`quarter` = 'Q1' and `sales_fact_1997`.`promotion_id` = `promotion`.`promotion_id` and `promotion`.`media_type` in ('Radio', 'TV') group by `time_by_day`.`the_year`, `time_by_day`.`quarter`, `promotion`.`media_type`", "select `time_by_day`.`the_year` as `c0`, `time_by_day`.`quarter` as `c1`, `promotion`.`media_type` as `c2`, count(distinct `sales_fact_1997`.`customer_id`) as `m0` from `time_by_day` as `time_by_day`, `sales_fact_1997` as `sales_fact_1997`, `promotion` as `promotion` where `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 and `time_by_day`.`quarter` = 'Q1' and `sales_fact_1997`.`promotion_id` = `promotion`.`promotion_id` and `promotion`.`media_type` in ('Radio', 'TV') group by `time_by_day`.`the_year`, `time_by_day`.`quarter`, `promotion`.`media_type`"), new SqlPattern(Dialect.DatabaseProduct.DERBY, "select \"time_by_day\".\"the_year\" as \"c0\", \"time_by_day\".\"quarter\" as \"c1\", \"promotion\".\"media_type\" as \"c2\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"time_by_day\" as \"time_by_day\", \"sales_fact_1997\" as \"sales_fact_1997\", \"promotion\" as \"promotion\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"time_by_day\".\"quarter\" = 'Q1' and \"sales_fact_1997\".\"promotion_id\" = \"promotion\".\"promotion_id\" and \"promotion\".\"media_type\" in ('Radio', 'TV') group by \"time_by_day\".\"the_year\", \"time_by_day\".\"quarter\", \"promotion\".\"media_type\"", "select \"time_by_day\".\"the_year\" as \"c0\", \"time_by_day\".\"quarter\" as \"c1\", \"promotion\".\"media_type\" as \"c2\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"time_by_day\" as \"time_by_day\", \"sales_fact_1997\" as \"sales_fact_1997\", \"promotion\" as \"promotion\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"time_by_day\".\"quarter\" = 'Q1' and \"sales_fact_1997\".\"promotion_id\" = \"promotion\".\"promotion_id\" and \"promotion\".\"media_type\" in ('Radio', 'TV') group by \"time_by_day\".\"the_year\", \"time_by_day\".\"quarter\", \"promotion\".\"media_type\"")});
    }

    public void testAggregateDistinctCount4() {
        String mdxQuery = "WITH\n  MEMBER [Store].[CA plus USA] AS 'AGGREGATE({[Store].[USA].[CA], [Store].[USA]})', solve_order=1\n  MEMBER [Time].[Q1 plus July] AS 'AGGREGATE({[Time].[1997].[Q1], [Time].[1997].[Q3].[7]})', solve_order=1\nSELECT {[Measures].[Customer Count], [Measures].[Unit Sales]} ON COLUMNS,\n      Union({[Store].[CA plus USA]} * {[Time].[Q1 plus July]},       Union({[Store].[USA].[CA]} * {[Time].[Q1 plus July]},      Union({[Store].[USA]} * {[Time].[Q1 plus July]},      Union({[Store].[CA plus USA]} * {[Time].[1997].[Q1]},            {[Store].[CA plus USA]} * {[Time].[1997].[Q3].[7]})))) ON ROWS\nFROM Sales";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Measures].[Customer Count]}\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[CA plus USA], [Time].[Q1 plus July]}\n{[Store].[All Stores].[USA].[CA], [Time].[Q1 plus July]}\n{[Store].[All Stores].[USA], [Time].[Q1 plus July]}\n{[Store].[CA plus USA], [Time].[1997].[Q1]}\n{[Store].[CA plus USA], [Time].[1997].[Q3].[7]}\nRow #0: 3,505\nRow #0: 112,347\nRow #1: 1,386\nRow #1: 22,293\nRow #2: 3,505\nRow #2: 90,054\nRow #3: 2,981\nRow #3: 83,181\nRow #4: 1,462\nRow #4: 29,166\n";
        this.assertQueryReturns("WITH\n  MEMBER [Store].[CA plus USA] AS 'AGGREGATE({[Store].[USA].[CA], [Store].[USA]})', solve_order=1\n  MEMBER [Time].[Q1 plus July] AS 'AGGREGATE({[Time].[1997].[Q1], [Time].[1997].[Q3].[7]})', solve_order=1\nSELECT {[Measures].[Customer Count], [Measures].[Unit Sales]} ON COLUMNS,\n      Union({[Store].[CA plus USA]} * {[Time].[Q1 plus July]},       Union({[Store].[USA].[CA]} * {[Time].[Q1 plus July]},      Union({[Store].[USA]} * {[Time].[Q1 plus July]},      Union({[Store].[CA plus USA]} * {[Time].[1997].[Q1]},            {[Store].[CA plus USA]} * {[Time].[1997].[Q3].[7]})))) ON ROWS\nFROM Sales", FastBatchingCellReaderTest.fold(result));
    }

    public void testAggregateDistinctCount5() {
        String query = "With Set [Products] as  '{[Product].[All Products].[Drink],    [Product].[All Products].[Food],    [Product].[All Products].[Non-Consumable]}' Member [Product].[Selected Products] as  'Aggregate([Products])', SOLVE_ORDER=2 Select  {[Store].[Store State].Members} on rows,  {[Measures].[Customer Count]} on columns From [Sales] Where ([Product].[Selected Products])";
        String derbySql = "select \"store\".\"store_state\" as \"c0\", \"time_by_day\".\"the_year\" as \"c1\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"store\" as \"store\", \"sales_fact_1997\" as \"sales_fact_1997\", \"time_by_day\" as \"time_by_day\" where \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\" and \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 group by \"store\".\"store_state\", \"time_by_day\".\"the_year\"";
        String mysqlSql = "select `store`.`store_state` as `c0`, `time_by_day`.`the_year` as `c1`, count(distinct `sales_fact_1997`.`customer_id`) as `m0` from `store` as `store`, `sales_fact_1997` as `sales_fact_1997`, `time_by_day` as `time_by_day` where `sales_fact_1997`.`store_id` = `store`.`store_id` and `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 group by `store`.`store_state`, `time_by_day`.`the_year`";
        SqlPattern[] patterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.DERBY, derbySql, derbySql), new SqlPattern(Dialect.DatabaseProduct.MYSQL, mysqlSql, mysqlSql)};
        this.assertQuerySql(query, patterns);
    }

    public void testAggregateDistinctCount6() {
        String mdxQuery = "WITH  MEMBER [Store].[Select Region] AS  'AGGREGATE({[Store].[USA].[CA], [Store].[Mexico], [Store].[Canada], [Store].[USA].[OR]})', solve_order=1\n MEMBER [Time].[Select Time Period] AS  'AGGREGATE({[Time].[1997].[Q1], [Time].[1997].[Q3].[7], [Time].[1997].[Q4], [Time].[1997]})', solve_order=1\nSELECT {[Measures].[Customer Count], [Measures].[Unit Sales]} ON COLUMNS,\n      Union({[Store].[Select Region]} * {[Time].[Select Time Period]},      Union({[Store].[Select Region]} * {[Time].[1997].[Q1]},      Union({[Store].[Select Region]} * {[Time].[1997].[Q3].[7]},      Union({[Store].[Select Region]} * {[Time].[1997].[Q4]},            {[Store].[Select Region]} * {[Time].[1997]})))) ON ROWS\nFROM Sales";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Measures].[Customer Count]}\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[Select Region], [Time].[Select Time Period]}\n{[Store].[Select Region], [Time].[1997].[Q1]}\n{[Store].[Select Region], [Time].[1997].[Q3].[7]}\n{[Store].[Select Region], [Time].[1997].[Q4]}\n{[Store].[Select Region], [Time].[1997]}\nRow #0: 3,753\nRow #0: 229,496\nRow #1: 1,877\nRow #1: 36,177\nRow #2: 845\nRow #2: 13,123\nRow #3: 2,073\nRow #3: 37,789\nRow #4: 3,753\nRow #4: 142,407\n";
        this.assertQueryReturns("WITH  MEMBER [Store].[Select Region] AS  'AGGREGATE({[Store].[USA].[CA], [Store].[Mexico], [Store].[Canada], [Store].[USA].[OR]})', solve_order=1\n MEMBER [Time].[Select Time Period] AS  'AGGREGATE({[Time].[1997].[Q1], [Time].[1997].[Q3].[7], [Time].[1997].[Q4], [Time].[1997]})', solve_order=1\nSELECT {[Measures].[Customer Count], [Measures].[Unit Sales]} ON COLUMNS,\n      Union({[Store].[Select Region]} * {[Time].[Select Time Period]},      Union({[Store].[Select Region]} * {[Time].[1997].[Q1]},      Union({[Store].[Select Region]} * {[Time].[1997].[Q3].[7]},      Union({[Store].[Select Region]} * {[Time].[1997].[Q4]},            {[Store].[Select Region]} * {[Time].[1997]})))) ON ROWS\nFROM Sales", FastBatchingCellReaderTest.fold(result));
    }

    public void testDistinctCountBug1785406() {
        String query = "With \nSet [*BASE_MEMBERS_Product] as {[Product].[All Products].[Food].[Deli]}\nSet [*BASE_MEMBERS_Store] as {[Store].[All Stores].[USA].[WA]}\nMember [Product].[*CTX_MEMBER_SEL~SUM] As Aggregate([*BASE_MEMBERS_Product])\nSelect\n{[Measures].[Customer Count]} on columns,\nNonEmptyCrossJoin([*BASE_MEMBERS_Store],{([Product].[*CTX_MEMBER_SEL~SUM])})\non rows\nFrom [Sales]\nwhere ([Time].[1997])";
        String expectedResult = "Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[Customer Count]}\nAxis #2:\n{[Store].[All Stores].[USA].[WA], [Product].[*CTX_MEMBER_SEL~SUM]}\nRow #0: 889\n";
        this.assertQueryReturns(query, FastBatchingCellReaderTest.fold(expectedResult));
        String mysqlSql = "select `store`.`store_state` as `c0`, `time_by_day`.`the_year` as `c1`, count(distinct `sales_fact_1997`.`customer_id`) as `m0` from `store` as `store`, `sales_fact_1997` as `sales_fact_1997`, `time_by_day` as `time_by_day`, `product_class` as `product_class`, `product` as `product` where `sales_fact_1997`.`store_id` = `store`.`store_id` and `store`.`store_state` = 'WA' and `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 and `sales_fact_1997`.`product_id` = `product`.`product_id` and `product`.`product_class_id` = `product_class`.`product_class_id` and (`product_class`.`product_department` = 'Deli' and `product_class`.`product_family` = 'Food') group by `store`.`store_state`, `time_by_day`.`the_year`";
        String accessSql = "select `d0` as `c0`, `d1` as `c1`, count(`m0`) as `c2` from (select distinct `store`.`store_state` as `d0`, `time_by_day`.`the_year` as `d1`, `sales_fact_1997`.`customer_id` as `m0` from `store` as `store`, `sales_fact_1997` as `sales_fact_1997`, `time_by_day` as `time_by_day`, `product_class` as `product_class`, `product` as `product` where `sales_fact_1997`.`store_id` = `store`.`store_id` and `store`.`store_state` = 'WA' and `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 and `sales_fact_1997`.`product_id` = `product`.`product_id` and `product`.`product_class_id` = `product_class`.`product_class_id` and (`product_class`.`product_department` = 'Deli' and `product_class`.`product_family` = 'Food')) as `dummyname` group by `d0`, `d1`";
        String derbySql = "select \"store\".\"store_state\" as \"c0\", \"time_by_day\".\"the_year\" as \"c1\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"store\" as \"store\", \"sales_fact_1997\" as \"sales_fact_1997\", \"time_by_day\" as \"time_by_day\", \"product_class\" as \"product_class\", \"product\" as \"product\" where \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\" and \"store\".\"store_state\" = 'WA' and \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\" and \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\" and (\"product_class\".\"product_department\" = 'Deli' and \"product_class\".\"product_family\" = 'Food') group by \"store\".\"store_state\", \"time_by_day\".\"the_year\"";
        SqlPattern[] patterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.ACCESS, accessSql, accessSql), new SqlPattern(Dialect.DatabaseProduct.DERBY, derbySql, derbySql), new SqlPattern(Dialect.DatabaseProduct.MYSQL, mysqlSql, mysqlSql)};
        this.assertQuerySql(query, patterns);
    }

    public void testDistinctCountBug1785406_2() {
        String query = "With Member [Product].[x] as 'Aggregate({Gender.CurrentMember})'\nmember [Measures].[foo] as '([Product].[x],[Measures].[Customer Count])'\nselect Filter([Gender].members,(Not IsEmpty([Measures].[foo]))) on 0 from Sales";
        String expectedResult = "Axis #0:\n{}\nAxis #1:\n{[Gender].[All Gender]}\n{[Gender].[All Gender].[F]}\n{[Gender].[All Gender].[M]}\nRow #0: 266,773\nRow #0: 131,558\nRow #0: 135,215\n";
        this.assertQueryReturns(query, FastBatchingCellReaderTest.fold(expectedResult));
        String mysqlSql = "select `time_by_day`.`the_year` as `c0`, count(distinct `sales_fact_1997`.`customer_id`) as `m0` from `time_by_day` as `time_by_day`, `sales_fact_1997` as `sales_fact_1997` where `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 group by `time_by_day`.`the_year`";
        String accessSql = "select `d0` as `c0`, count(`m0`) as `c1` from (select distinct `time_by_day`.`the_year` as `d0`, `sales_fact_1997`.`customer_id` as `m0` from `time_by_day` as `time_by_day`, `sales_fact_1997` as `sales_fact_1997` where `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997) as `dummyname` group by `d0`";
        String derbySql = "select \"time_by_day\".\"the_year\" as \"c0\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"time_by_day\" as \"time_by_day\", \"sales_fact_1997\" as \"sales_fact_1997\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 group by \"time_by_day\".\"the_year\"";
        SqlPattern[] patterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.ACCESS, accessSql, accessSql), new SqlPattern(Dialect.DatabaseProduct.DERBY, derbySql, derbySql), new SqlPattern(Dialect.DatabaseProduct.MYSQL, mysqlSql, mysqlSql)};
        this.assertQuerySql(query, patterns);
    }

    public void testAggregateDistinctCountInDimensionFilter() {
        String query = "With Set [Products] as '{[Product].[All Products].[Drink], [Product].[All Products].[Food]}' Set [States] as '{[Store].[All Stores].[USA].[CA], [Store].[All Stores].[USA].[OR]}' Member [Product].[Selected Products] as 'Aggregate([Products])', SOLVE_ORDER=2 Select Filter([States], not IsEmpty([Measures].[Customer Count])) on rows, {[Measures].[Customer Count]} on columns From [Sales] Where ([Product].[Selected Products])";
        String result = "Axis #0:\n{[Product].[Selected Products]}\nAxis #1:\n{[Measures].[Customer Count]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\nRow #0: 2,692\nRow #1: 1,036\n";
        this.assertQueryReturns(query, FastBatchingCellReaderTest.fold(result));
        String mysqlSql = "select `store`.`store_state` as `c0`, `time_by_day`.`the_year` as `c1`, count(distinct `sales_fact_1997`.`customer_id`) as `m0` from `store` as `store`, `sales_fact_1997` as `sales_fact_1997`, `time_by_day` as `time_by_day`, `product_class` as `product_class`, `product` as `product` where `sales_fact_1997`.`store_id` = `store`.`store_id` and `store`.`store_state` in ('CA', 'OR') and `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 and `sales_fact_1997`.`product_id` = `product`.`product_id` and `product`.`product_class_id` = `product_class`.`product_class_id` and `product_class`.`product_family` in ('Drink', 'Food') group by `store`.`store_state`, `time_by_day`.`the_year`";
        String derbySql = "select \"store\".\"store_state\" as \"c0\", \"time_by_day\".\"the_year\" as \"c1\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"store\" as \"store\", \"sales_fact_1997\" as \"sales_fact_1997\", \"time_by_day\" as \"time_by_day\", \"product_class\" as \"product_class\", \"product\" as \"product\" where \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\" and \"store\".\"store_state\" in ('CA', 'OR') and \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\" and \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\" and \"product_class\".\"product_family\" in ('Drink', 'Food') group by \"store\".\"store_state\", \"time_by_day\".\"the_year\"";
        SqlPattern[] patterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.DERBY, derbySql, derbySql), new SqlPattern(Dialect.DatabaseProduct.MYSQL, mysqlSql, mysqlSql)};
        this.assertQuerySql(query, patterns);
    }
}

