/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.FindInFilesOperator;
import org.netbeans.jellytools.OutputTabOperator;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JTreeOperator;

public class SearchResultsOperator
extends TopComponentOperator {
    private static final long SEARCH_TIME = 600000L;
    private static final String TITLE = Bundle.getString((String)"org.netbeans.modules.search.Bundle", (String)"TITLE_SEARCH_RESULTS");
    private JButtonOperator _btStop;
    private JButtonOperator _btShowDetails;
    private JButtonOperator _btModifySearch;
    private JTreeOperator _treeResult;

    public SearchResultsOperator() {
        super(TITLE);
    }

    public JButtonOperator btStopSearch() {
        if (this._btStop == null) {
            this._btStop = new JButtonOperator((ContainerOperator)this, Bundle.getStringTrimmed((String)"org.netbeans.modules.search.Bundle", (String)"TEXT_BUTTON_STOP"));
        }
        return this._btStop;
    }

    public JButtonOperator btShowDetails() {
        if (this._btShowDetails == null) {
            this._btShowDetails = new JButtonOperator((ContainerOperator)this, Bundle.getStringTrimmed((String)"org.netbeans.modules.search.Bundle", (String)"TEXT_BUTTON_FILL"));
        }
        return this._btShowDetails;
    }

    public JButtonOperator btModifySearch() {
        if (this._btModifySearch == null) {
            this._btModifySearch = new JButtonOperator((ContainerOperator)this, Bundle.getStringTrimmed((String)"org.netbeans.modules.search.Bundle", (String)"TEXT_BUTTON_CUSTOMIZE"));
        }
        return this._btModifySearch;
    }

    public JTreeOperator treeResult() {
        if (this._treeResult == null) {
            this._treeResult = new JTreeOperator((ContainerOperator)this);
        }
        return this._treeResult;
    }

    public void selectResult(String string) {
        new Node(this.treeResult(), string).select();
    }

    public void openResult(String string) {
        this.treeResult().clickOnPath(new Node(this.treeResult(), string).getTreePath(), 2);
    }

    public void stopSearch() {
        this.btStopSearch().push();
    }

    public OutputTabOperator showDetails() {
        this.btShowDetails().push();
        return new OutputTabOperator(TITLE);
    }

    public FindInFilesOperator modifySearch() {
        this.btModifySearch().pushNoBlock();
        return new FindInFilesOperator();
    }

    public void waitEndOfSearch() {
        Waiter waiter = new Waiter(new Waitable(){

            public Object actionProduced(Object object) {
                return SearchResultsOperator.this.btStopSearch().isEnabled() ? null : "";
            }

            public String getDescription() {
                return "Wait for a search to be finished";
            }
        });
        waiter.getTimeouts().setTimeout("Waiter.WaitingTime", this.getTimeouts().getTimeout("SearchResultsOperator.SearchTime"));
        try {
            waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Waiting has been interrupted", (Throwable)interruptedException);
        }
    }

    public void verify() {
        this.btStopSearch();
        this.btShowDetails();
        this.btModifySearch();
        this.treeResult();
    }

    static {
        Timeouts.initDefault((String)"SearchResultsOperator.SearchTime", (long)600000L);
    }
}

