/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.NameAndLicenseWizardPanel;
import org.netbeans.modules.kenai.ui.ProjectHandleImpl;
import org.netbeans.modules.kenai.ui.SourceAndIssuesWizardPanel;
import org.netbeans.modules.kenai.ui.SummaryWizardPanel;
import org.netbeans.modules.kenai.ui.spi.Dashboard;
import org.netbeans.modules.mercurial.api.Mercurial;
import org.netbeans.modules.subversion.api.Subversion;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewKenaiProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel[] panels;
    private transient int index;
    private Node[] activeNodes;
    public static final String PROP_PRJ_NAME = "projectName";
    public static final String PROP_PRJ_TITLE = "projectTitle";
    public static final String PROP_PRJ_DESC = "projectDescription";
    public static final String PROP_PRJ_LICENSE = "projectLicense";
    public static final String PROP_SCM_TYPE = "projectSCMType";
    public static final String PROP_SCM_NAME = "projectSCMName";
    public static final String PROP_SCM_URL = "projectSCMUrl";
    public static final String PROP_SCM_LOCAL = "projectSCMLocal";
    public static final String PROP_SCM_PREVIEW = "projectSCMPreview";
    public static final String PROP_ISSUES = "projectIssues";
    public static final String PROP_ISSUES_URL = "projectIssuesUrl";
    public static final String PROP_AUTO_COMMIT = "projectAutoCommit";
    public static final String PROP_CREATE_CHAT = "projectCreateChat";
    public static final String PROP_FOLDERS_TO_SHARE = "projectFoldersToShare";
    public static final String PROP_EXC_ERR_MSG = "exceptionErrorMessage";
    public static final String NO_REPO = "none";
    public static final String NO_ISSUES = "none";
    private Logger logger = Logger.getLogger("org.netbeans.modules.kenai");

    NewKenaiProjectWizardIterator(Node[] nodeArray) {
        this.activeNodes = nodeArray != null ? nodeArray : new Node[]{};
    }

    public Set<CreatedProjectInfo> instantiate(ProgressHandle progressHandle) throws IOException {
        String string;
        String string2;
        KenaiProject kenaiProject;
        progressHandle.start(6);
        String string3 = (String)this.wizard.getProperty(PROP_PRJ_NAME);
        String string4 = (String)this.wizard.getProperty(PROP_PRJ_TITLE);
        String string5 = (String)this.wizard.getProperty(PROP_PRJ_DESC);
        String string6 = (String)this.wizard.getProperty(PROP_PRJ_LICENSE);
        String string7 = (String)this.wizard.getProperty(PROP_SCM_TYPE);
        String string8 = (String)this.wizard.getProperty(PROP_SCM_NAME);
        String string9 = (String)this.wizard.getProperty(PROP_SCM_URL);
        String string10 = (String)this.wizard.getProperty(PROP_SCM_LOCAL);
        String string11 = (String)this.wizard.getProperty(PROP_ISSUES);
        String string12 = (String)this.wizard.getProperty(PROP_ISSUES_URL);
        boolean bl = Boolean.valueOf((String)this.wizard.getProperty(PROP_AUTO_COMMIT));
        Boolean bl2 = (Boolean)this.wizard.getProperty(PROP_CREATE_CHAT);
        List list = (List)this.wizard.getProperty(PROP_FOLDERS_TO_SHARE);
        if ("mercurial".equals(string7) && !Mercurial.isClientAvailable()) {
            ((JComponent)this.current().getComponent()).putClientProperty(PROP_EXC_ERR_MSG, NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.NoHgClient"));
            throw new IOException("Mercurial client is not available");
        }
        if ("subversion".equals(string7) && !Subversion.isClientAvailable((boolean)bl)) {
            ((JComponent)this.current().getComponent()).putClientProperty(PROP_EXC_ERR_MSG, "SVN client unavailable");
            throw new IOException("SVN client unavailable");
        }
        try {
            progressHandle.progress(NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.creatingProject"), 1);
            this.logger.log(Level.FINE, "Creating Kenai Project - Name: " + string3 + ", Title: " + string4 + ", Description: " + string5 + ", License: " + string6);
            Kenai.getDefault().createProject(string3, string4, string5, new String[]{string6}, null);
        }
        catch (KenaiException kenaiException) {
            String string13 = this.getErrorMessage(kenaiException, NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.projectCreationFailed"));
            ((JComponent)this.current().getComponent()).putClientProperty(PROP_EXC_ERR_MSG, string13);
            throw new IOException(string13);
        }
        boolean bl3 = false;
        if (!"none".equals(string7)) {
            try {
                progressHandle.progress(NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.creatingRepo"), 2);
                kenaiProject = this.getScmDisplayName(string7);
                string2 = this.getScmDescription(string7);
                string = "external_repository".equals(string7) ? string9 : null;
                this.logger.log(Level.FINE, "Creating SCM Repository - Name: " + string8 + ", Type: " + string7 + ", Ext. URL: " + string9 + ", Local Folder: " + string10);
                Kenai.getDefault().getProject(string3).createProjectFeature(string8, (String)kenaiProject, string2, string7, null, string, null);
                bl3 = "subversion".equals(string7) || "mercurial".equals(string7);
            }
            catch (KenaiException kenaiException) {
                String string14 = this.getErrorMessage(kenaiException, NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.repoCreationFailed"));
                ((JComponent)this.current().getComponent()).putClientProperty(PROP_EXC_ERR_MSG, string14);
                throw new IOException(string14);
            }
        } else {
            this.logger.log(Level.FINE, "SCM Repository creation skipped.");
        }
        if (!"none".equals(string11)) {
            try {
                progressHandle.progress(NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.creatingIssues"), 3);
                kenaiProject = this.getIssuesDisplayName(string11);
                string2 = this.getIssuesDescription(string11);
                string = "external_issues".equals(string11) ? string12 : null;
                this.logger.log(Level.FINE, "Creating Issue Tracking - Name: " + string11 + ", Ext. URL: " + string12);
                Kenai.getDefault().getProject(string3).createProjectFeature(string3 + string11, (String)kenaiProject, string2, string11, string, null, null);
            }
            catch (KenaiException kenaiException) {
                string2 = this.getErrorMessage(kenaiException, NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.issuesCreationFailed"));
                ((JComponent)this.current().getComponent()).putClientProperty(PROP_EXC_ERR_MSG, string2);
                throw new IOException(string2);
            }
        } else {
            this.logger.log(Level.FINE, "Issue Tracking creation skipped.");
        }
        if (bl3) {
            try {
                kenaiProject = Kenai.getDefault().getProject(string3).getFeatures(KenaiService.Type.SOURCE);
                string2 = null;
                string = null;
                for (Object object : kenaiProject) {
                    if (!string8.equals(object.getName())) continue;
                    string2 = object.getLocation();
                    string = object.getService();
                }
                if (string2 != null) {
                    progressHandle.progress(NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.repositoryCheckout"), 4);
                    this.logger.log(Level.FINE, "Checking out repository - Location: " + string2 + ", Local Folder: " + string10 + ", Service: " + string);
                    PasswordAuthentication passwordAuthentication = Kenai.getDefault().getPasswordAuthentication();
                    if (passwordAuthentication != null) {
                        Object object;
                        File file = new File(string10);
                        int n = NewKenaiProjectWizardIterator.isCommonParent(list, string10) ? 1 : 0;
                        if ("subversion".equals(string)) {
                            if (n == 0) {
                                this.copySharedItems(list, file);
                            }
                            Subversion.checkoutRepositoryFolder((String)string2, (String[])new String[]{"."}, (File)file, (String)passwordAuthentication.getUserName(), (String)new String(passwordAuthentication.getPassword()), (boolean)true, (boolean)false);
                            if (bl) {
                                object = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.initialRevision", (Object)string4);
                                progressHandle.progress(NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.repositoryCommit"), 5);
                                Subversion.commit((File[])new File[]{file}, (String)passwordAuthentication.getUserName(), (String)new String(passwordAuthentication.getPassword()), (String)object);
                            }
                        } else {
                            if (n != 0) {
                                object = NewKenaiProjectWizardIterator.createTempFolder();
                                Mercurial.cloneRepository((String)string2, (File)object, (String)file.getName(), (String)"", (String)"", (String)passwordAuthentication.getUserName(), (String)new String(passwordAuthentication.getPassword()), (boolean)false);
                                this.copy(FileUtil.toFileObject((File)new File((File)object, file.getName())), FileUtil.toFileObject((File)file.getParentFile()));
                                FileUtil.toFileObject((File)object).delete();
                            } else {
                                Mercurial.cloneRepository((String)string2, (File)file, (String)"", (String)"", (String)"", (String)passwordAuthentication.getUserName(), (String)new String(passwordAuthentication.getPassword()), (boolean)false);
                                this.copySharedItems(list, file);
                            }
                            if (bl) {
                                object = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.initialRevision", (Object)string4);
                                progressHandle.progress(NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.repositoryCommit"), 5);
                            }
                        }
                        if (n == 0) {
                            object = OpenProjects.getDefault().getMainProject();
                            ArrayList<Project> arrayList = new ArrayList<Project>();
                            ArrayList<Project> arrayList2 = new ArrayList<Project>();
                            for (SharedItem sharedItem : list) {
                                Project project = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)sharedItem.getRoot()));
                                if (project == null) continue;
                                arrayList.add(project);
                                File file2 = new File(file, sharedItem.getRoot().getName());
                                Project project2 = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)file2));
                                arrayList2.add(project2);
                                if (!project.equals(object)) continue;
                                object = project2;
                            }
                            arrayList.remove(null);
                            arrayList2.remove(null);
                            OpenProjects.getDefault().close(arrayList.toArray(new Project[arrayList.size()]));
                            OpenProjects.getDefault().open(arrayList2.toArray(new Project[arrayList2.size()]), false);
                            OpenProjects.getDefault().setMainProject((Project)object);
                        }
                    }
                }
            }
            catch (KenaiException kenaiException) {
                Exceptions.printStackTrace((Throwable)kenaiException);
            }
        }
        if (bl2.booleanValue()) {
            progressHandle.progress(NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"CTL_CreatingChatProgress"), 6);
            kenaiProject = Kenai.getDefault().getProject(string3);
            if (kenaiProject.getFeatures(KenaiService.Type.CHAT).length == 0) {
                string2 = kenaiProject.createProjectFeature(string3, NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"CTL_ChatRoomName", (Object)string3), NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"CTL_ChatRoomDescription", (Object)string3), "instant_messenger", null, null, null);
            }
        }
        kenaiProject = new HashSet();
        try {
            string2 = Kenai.getDefault().getProject(string3);
            Dashboard.getDefault().addProject(new ProjectHandleImpl((KenaiProject)string2), true, true);
            kenaiProject.add(new CreatedProjectInfo((KenaiProject)string2, string10));
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
        progressHandle.finish();
        return kenaiProject;
    }

    public static File createTempFolder() {
        File file;
        File file2 = new File(System.getProperty("java.io.tmpdir"));
        while ((file = new File(file2, "kenai-" + Long.toString(System.currentTimeMillis()))).exists() || !file.mkdirs()) {
        }
        file.deleteOnExit();
        return FileUtil.normalizeFile((File)file);
    }

    private void copySharedItems(List<SharedItem> list, File file) throws IOException {
        file.mkdirs();
        FileObject fileObject = FileUtil.toFileObject((File)file);
        for (SharedItem sharedItem : list) {
            FileObject fileObject2 = FileUtil.toFileObject((File)sharedItem.getRoot());
            this.copy(fileObject2, fileObject);
        }
    }

    private void copy(FileObject fileObject, FileObject fileObject2) throws IOException {
        if (fileObject.isFolder()) {
            FileObject[] fileObjectArray;
            FileObject fileObject3 = fileObject2.getFileObject(fileObject.getNameExt());
            if (fileObject3 == null) {
                fileObject3 = fileObject2.createFolder(fileObject.getNameExt());
            }
            for (FileObject fileObject4 : fileObjectArray = fileObject.getChildren()) {
                this.copy(fileObject4, fileObject3);
            }
        } else {
            fileObject.copy(fileObject2, fileObject.getName(), fileObject.getExt());
        }
    }

    static File getCommonParent(List<SharedItem> list) {
        File file = null;
        if (list.size() > 0) {
            file = list.get(0).getRoot().getParentFile();
            for (SharedItem sharedItem : list) {
                if (file.equals(sharedItem.getRoot().getParentFile())) continue;
                file = null;
                break;
            }
            if (file != null && file.list().length != list.size()) {
                file = null;
            }
        }
        return file;
    }

    static boolean isCommonParent(List<SharedItem> list, String string) {
        File file = new File(string);
        for (SharedItem sharedItem : list) {
            if (file.equals(sharedItem.getRoot().getParentFile())) continue;
            return false;
        }
        return file.list() != null && file.list().length == list.size();
    }

    public Set<?> instantiate() throws IOException {
        assert (false);
        return null;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizard = wizardDescriptor;
        this.panels = this.getPanels();
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public String name() {
        return NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.name");
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private String getErrorMessage(KenaiException kenaiException, String string) {
        String string2 = null;
        if (kenaiException instanceof KenaiException) {
            KenaiException kenaiException2 = kenaiException;
            Map map = kenaiException2.getErrors();
            StringBuffer stringBuffer = new StringBuffer();
            if (string != null) {
                stringBuffer.append(string + " ");
            }
            boolean bl = false;
            if (map != null) {
                for (String string3 : map.keySet()) {
                    stringBuffer.append((String)map.get(string3) + ". ");
                    bl = true;
                }
            }
            string2 = bl ? stringBuffer.substring(0, stringBuffer.length() - 2) : stringBuffer.toString();
        } else {
            string2 = kenaiException.getLocalizedMessage();
        }
        return string2;
    }

    private String getScmDisplayName(String string) {
        String string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.SourceCodeRepository");
        if ("subversion".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.SubversionRepository");
        } else if ("mercurial".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.MercurialRepository");
        } else if ("external_repository".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.ExternalRepository");
        }
        return string2;
    }

    private String getScmDescription(String string) {
        String string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.SourceCodeRepository");
        if ("subversion".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.SubversionSourceCodeRepository");
        } else if ("mercurial".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.MercurialSourceCodeRepository");
        } else if ("external_repository".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.ExternalSourceCodeRepository");
        }
        return string2;
    }

    private String getIssuesDisplayName(String string) {
        String string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.IssueTracking");
        if ("bugzilla".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.Bugzilla");
        } else if ("jira".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.JIRA");
        } else if ("external_issues".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.External");
        }
        return string2;
    }

    private String getIssuesDescription(String string) {
        String string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.IssueTracking");
        if ("bugzilla".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.BugzillaIssueTracking");
        } else if ("jira".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.JIRAIssueTracking");
        } else if ("external_issues".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.ExternalIssueTracking");
        }
        return string2;
    }

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = this.createPanels();
            String[] stringArray = new String[this.panels.length];
            for (int i = 0; i < this.panels.length; ++i) {
                Component component = this.panels[i].getComponent();
                stringArray[i] = component.getName();
                if (!(component instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)component;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    private WizardDescriptor.Panel[] createPanels() {
        List<SharedItem> list = this.getInitialItems(this.activeNodes);
        return new WizardDescriptor.Panel[]{new NameAndLicenseWizardPanel(list), new SourceAndIssuesWizardPanel(list), new SummaryWizardPanel()};
    }

    private List<SharedItem> getInitialItems(Node[] nodeArray) {
        ArrayList<SharedItem> arrayList = new ArrayList<SharedItem>();
        for (Node node : nodeArray) {
            File file;
            Project project = (Project)node.getLookup().lookup(Project.class);
            if (project == null || VersioningSupport.getOwner((File)(file = FileUtil.toFile((FileObject)project.getProjectDirectory()))) != null) continue;
            arrayList.add(new SharedItem(file));
        }
        return arrayList;
    }

    public static class CreatedProjectInfo {
        public KenaiProject project;
        public String localRepoPath;

        public CreatedProjectInfo(KenaiProject kenaiProject, String string) {
            this.project = kenaiProject;
            this.localRepoPath = string;
        }
    }

    public static class SharedItem {
        private final File root;

        public SharedItem(File file) {
            this.root = file;
        }

        public String toString() {
            return this.root.getName();
        }

        public File getRoot() {
            return this.root;
        }
    }
}

