/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.io.File;
import java.util.logging.Level;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.netbeans.libs.bugtracking.BugtrackingRuntime;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Plugin
implements ILog {
    private IPath stateLocation;

    public final Bundle getBundle() {
        return null;
    }

    public boolean isDebugging() {
        return false;
    }

    public void start(BundleContext bundleContext) throws Exception {
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }

    public final ILog getLog() {
        return this;
    }

    public final IPath getStateLocation() throws IllegalStateException {
        if (this.stateLocation == null) {
            File file = new File(BugtrackingRuntime.getInstance().getCacheStore(), "statelocation");
            this.stateLocation = new StateLocation(file);
        }
        return this.stateLocation;
    }

    public void log(IStatus iStatus) {
        Level level = null;
        switch (iStatus.getSeverity()) {
            case 8: {
                level = Level.OFF;
                break;
            }
            case 4: {
                level = Level.SEVERE;
                break;
            }
            case 1: {
                level = Level.INFO;
                break;
            }
            case 0: {
                level = Level.INFO;
                break;
            }
            case 2: {
                level = Level.WARNING;
                break;
            }
            default: {
                level = Level.INFO;
            }
        }
        BugtrackingRuntime.LOG.log(level, iStatus.getMessage() + " code: " + iStatus.getCode());
        BugtrackingRuntime.LOG.log(Level.INFO, null, iStatus.getException());
    }

    private class StateLocation
    implements IPath {
        private final File file;

        private StateLocation(File file) {
            this.file = file;
        }

        public IPath append(String string) {
            File file = new File(this.file, string);
            return new StateLocation(file);
        }

        public File toFile() {
            return this.file;
        }
    }
}

