/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.templates;

import com.jaspersoft.ireport.designer.templates.DefaultReportGenerator;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class DefaultSubreportGenerator
extends DefaultReportGenerator {
    public FileObject generateReport(WizardDescriptor wizard) {
        try {
            JasperDesign jasperDesign = this.generateDesign(wizard);
            int newPageWidth = jasperDesign.getPageWidth() - jasperDesign.getLeftMargin() - jasperDesign.getRightMargin();
            int newPageHeight = jasperDesign.getPageHeight() - jasperDesign.getTopMargin() - jasperDesign.getBottomMargin();
            jasperDesign.setTopMargin(0);
            jasperDesign.setBottomMargin(0);
            jasperDesign.setLeftMargin(0);
            jasperDesign.setRightMargin(0);
            jasperDesign.setPageWidth(newPageWidth);
            jasperDesign.setPageHeight(newPageHeight);
            File f = this.getFile(wizard);
            FileOutputStream os = new FileOutputStream(f);
            JRXmlWriter.writeReport((JRReport)jasperDesign, (OutputStream)os, (String)"UTF8");
            try {
                os.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            return FileUtil.toFileObject((File)f);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Misc.showErrorMessage("An error has occurred generating the subreport:\n" + ex.getMessage(), "Error", ex);
            return null;
        }
    }
}

