/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.jrtx;

import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.dnd.DnDUtilities;
import com.jaspersoft.ireport.designer.jrtx.JRTXEditorSupport;
import com.jaspersoft.ireport.designer.jrtx.StyleNode;
import com.jaspersoft.ireport.designer.jrtx.StylesChildren;
import com.jaspersoft.ireport.designer.jrtx.TemplateReferenceNode;
import com.jaspersoft.ireport.designer.outline.nodes.IRIndexedNode;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRSimpleTemplate;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTemplateReference;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class TemplateNode
extends IRIndexedNode {
    private static final String IMAGE_ICON_BASE = "com/jaspersoft/ireport/designer/resources/jasperreports_jrtx.png";
    private JRSimpleTemplate template = null;

    public TemplateNode(JRSimpleTemplate template, Lookup doLkp) {
        this(new StylesChildren(template, doLkp), template, doLkp);
    }

    public TemplateNode(StylesChildren pc, JRSimpleTemplate template, Lookup doLkp) {
        super((Children)pc, pc.getIndex(), (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.singleton((Object)template)}));
        this.template = template;
        this.setName("Styles");
        this.setIconBaseWithExtension(IMAGE_ICON_BASE);
        this.addNodeListener(new NodeListener(){

            public void childrenAdded(NodeMemberEvent ev) {
            }

            public void childrenRemoved(NodeMemberEvent ev) {
            }

            public void childrenReordered(NodeReorderEvent ev) {
                JRStyle[] styles = TemplateNode.this.getTemplate().getStyles();
                ArrayList<JRStyle> newList = new ArrayList<JRStyle>();
                ArrayList<JRStyle> newList2 = new ArrayList<JRStyle>();
                Node[] nodes = TemplateNode.this.getChildren().getNodes();
                for (int i = 0; i < nodes.length; ++i) {
                    JRStyle s;
                    if (nodes[i] instanceof StyleNode) {
                        s = ((StyleNode)nodes[i]).getStyle();
                        newList.add(s);
                        TemplateNode.this.getTemplate().removeStyle(s);
                        continue;
                    }
                    if (!(nodes[i] instanceof TemplateReferenceNode)) continue;
                    s = ((TemplateReferenceNode)nodes[i]).getReference();
                    newList2.add(s);
                    TemplateNode.this.getTemplate().removeIncludedTemplate((JRTemplateReference)s);
                }
                for (JRStyle s : newList) {
                    try {
                        TemplateNode.this.getTemplate().addStyle(s);
                    }
                    catch (JRException ex) {}
                }
                for (JRStyle s : newList2) {
                    TemplateNode.this.getTemplate().addIncludedTemplate((JRTemplateReference)s);
                }
                JRTXEditorSupport ed = (JRTXEditorSupport)((Object)TemplateNode.this.getLookup().lookup(JRTXEditorSupport.class));
                if (ed != null) {
                    ed.notifyModelChangeToTheView();
                }
                ((StylesChildren)TemplateNode.this.getChildren()).recalculateKeys();
            }

            public void nodeDestroyed(NodeEvent ev) {
            }

            public void propertyChange(PropertyChangeEvent evt) {
            }
        });
    }

    public boolean hasCustomizer() {
        return true;
    }

    public NewType[] getNewTypes() {
        return new NewType[]{new NewType(){

            public void create() throws IOException {
                JFileChooser jfc = new JFileChooser(Misc.findStartingDirectory());
                jfc.setDialogTitle("JRTX\u30d5\u30a1\u30a4\u30eb\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044....");
                jfc.setFileFilter(new FileFilter(){

                    public boolean accept(File file) {
                        String filename = file.getName();
                        return filename.endsWith(".jrtx") || file.isDirectory();
                    }

                    public String getDescription() {
                        return "JasperReports\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8(JRTX) *.jrtx";
                    }
                });
                jfc.setMultiSelectionEnabled(true);
                jfc.setDialogType(0);
                if (jfc.showOpenDialog(Misc.getMainFrame()) == 0) {
                    File[] files = jfc.getSelectedFiles();
                    for (int i = 0; i < files.length; ++i) {
                        JRTemplateReference reference = new JRTemplateReference();
                        reference.setLocation(files[i].getPath());
                        TemplateNode.this.template.addIncludedTemplate(reference);
                    }
                    ((StylesChildren)TemplateNode.this.getChildren()).recalculateKeys();
                    JRTXEditorSupport ed = (JRTXEditorSupport)((Object)TemplateNode.this.getLookup().lookup(JRTXEditorSupport.class));
                    if (ed != null) {
                        ed.notifyModelChangeToTheView();
                    }
                }
            }

            public String getName() {
                return "Template Reference";
            }
        }, new NewType(){

            public void create() throws IOException {
                JRDesignStyle style = new JRDesignStyle();
                ArrayList<String> names = new ArrayList<String>();
                JRStyle[] styles = TemplateNode.this.getTemplate().getStyles();
                for (int n = 0; n < styles.length; ++n) {
                    names.add(styles[n].getName());
                }
                int i = 1;
                while (names.contains("Style_" + i)) {
                    ++i;
                }
                style.setName("Style_" + i);
                try {
                    TemplateNode.this.template.addStyle((JRStyle)style);
                    ((StylesChildren)TemplateNode.this.getChildren()).recalculateKeys();
                }
                catch (JRException ex) {
                    // empty catch block
                }
                JRTXEditorSupport ed = (JRTXEditorSupport)((Object)TemplateNode.this.getLookup().lookup(JRTXEditorSupport.class));
                if (ed != null) {
                    ed.notifyModelChangeToTheView();
                }
            }

            public String getName() {
                return "Style";
            }
        }};
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(NewAction.class), SystemAction.get(PasteAction.class)};
    }

    public JRSimpleTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(JRSimpleTemplate template) {
        this.template = template;
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 2, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        JRDesignStyle style;
        Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        final int dropAction = DnDUtilities.getTransferAction(t);
        if (null != dropNode && null != (style = (JRDesignStyle)dropNode.getLookup().lookup(JRDesignStyle.class))) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    ArrayList<JRDesignStyle> list = new ArrayList<JRDesignStyle>();
                    JRStyle[] ss = TemplateNode.this.template.getStyles();
                    for (int i = 0; i < ss.length; ++i) {
                        list.add((JRDesignStyle)ss[i]);
                    }
                    int currentIndex = -1;
                    for (int i = 0; i < list.size(); ++i) {
                        JRDesignStyle s = (JRDesignStyle)list.get(i);
                        if (s != style) continue;
                        currentIndex = i;
                    }
                    System.out.println("Duplicating style in " + TemplateNode.this.getDisplayName() + " " + dropAction + " " + (dropAction & 6));
                    System.out.flush();
                    if ((dropAction & 6) != 0) {
                        int newIndex = -1;
                        if (currentIndex != -1) {
                            Node[] nodes = TemplateNode.this.getChildren().getNodes();
                            for (int i = 0; i < nodes.length; ++i) {
                                if (((StyleNode)nodes[i]).getStyle() != style) continue;
                                newIndex = i;
                                break;
                            }
                            list.remove(style);
                            if (newIndex == -1) {
                                list.add(style);
                                newIndex = list.indexOf(style);
                            } else {
                                list.add(newIndex, style);
                            }
                            JRTXEditorSupport ed = (JRTXEditorSupport)((Object)TemplateNode.this.getLookup().lookup(JRTXEditorSupport.class));
                            if (ed != null) {
                                ed.notifyModelChangeToTheView();
                            }
                        }
                    } else {
                        try {
                            JRDesignStyle newStyle = ModelUtils.cloneStyle(style);
                            ArrayList<String> names = new ArrayList<String>();
                            String base = newStyle.getName();
                            JRStyle[] styles = TemplateNode.this.getTemplate().getStyles();
                            for (int n = 0; n < styles.length; ++n) {
                                names.add(styles[n].getName());
                            }
                            int i = 1;
                            while (names.contains(base + i)) {
                                ++i;
                            }
                            newStyle.setName(base + i);
                            TemplateNode.this.template.addStyle((JRStyle)newStyle);
                            ((StylesChildren)TemplateNode.this.getChildren()).recalculateKeys();
                            JRTXEditorSupport ed = (JRTXEditorSupport)((Object)TemplateNode.this.getLookup().lookup(JRTXEditorSupport.class));
                            if (ed != null) {
                                ed.notifyModelChangeToTheView();
                            }
                        }
                        catch (JRException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    return null;
                }
            };
        }
        return null;
    }
}

