/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.jrctx.nodes.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.SeriesColorsProperty;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.chartthemes.simple.ColorProvider;
import net.sf.jasperreports.chartthemes.simple.PlotSettings;
import net.sf.jasperreports.engine.base.JRBaseChartPlot;

public final class PlotSeriesColorsProperty
extends SeriesColorsProperty {
    private final PlotSettings settings;

    public PlotSeriesColorsProperty(PlotSettings settings) {
        super("seriesColors", "Series Colors", "Series Colors");
        this.settings = settings;
    }

    public Object getValue() {
        ArrayList<JRBaseChartPlot.JRBaseSeriesColor> list = new ArrayList<JRBaseChartPlot.JRBaseSeriesColor>();
        if (this.settings.getSeriesColorSequence() != null) {
            for (int i = 0; i < this.settings.getSeriesColorSequence().size(); ++i) {
                list.add(new JRBaseChartPlot.JRBaseSeriesColor(i, ((ColorProvider)this.settings.getSeriesColorSequence().get(i)).getColor()));
            }
        }
        return list;
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.setPropertyValue(val);
    }

    private void setPropertyValue(Object val) {
        if (val instanceof List) {
            List oldValue = this.settings.getSeriesColorSequence();
            ArrayList<ColorProvider> colors = new ArrayList<ColorProvider>();
            if (oldValue == val) {
                return;
            }
            if (oldValue == null && val == null) {
                return;
            }
            if (val != null) {
                boolean update = false;
                if (oldValue == null || oldValue.size() != ((List)val).size()) {
                    update = true;
                } else {
                    for (int idx = 0; !update && idx < ((List)val).size(); ++idx) {
                        Color c1 = ((JRBaseChartPlot.JRBaseSeriesColor)((List)val).get(idx)).getColor();
                        Color c2 = ((ColorProvider)oldValue.get(idx)).getColor();
                        if (c1 == null && c1 != c2) {
                            update = true;
                            continue;
                        }
                        if (c1 == null || c1.equals(c2)) continue;
                        update = true;
                    }
                }
                if (!update) {
                    return;
                }
                Iterator it = ((List)val).iterator();
                while (it.hasNext()) {
                    colors.add(new ColorProvider(((JRBaseChartPlot.JRBaseSeriesColor)it.next()).getColor()));
                }
            }
            this.settings.setSeriesColorSequence(colors);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.settings, "SeriesColorSequence", List.class, oldValue, colors);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }
}

