/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.IntList;
import org.netbeans.core.output2.IntMap;
import org.netbeans.core.output2.LineInfo;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.SparseIntList;
import org.netbeans.core.output2.Storage;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.windows.IOColors;
import org.openide.windows.OutputListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractLines
implements Lines,
Runnable,
ActionListener {
    IntList lineStartList;
    IntMap lineWithListenerToInfo;
    IntMap linesToInfos;
    private int longestLineLen = 0;
    private int knownCharsPerLine = -1;
    private SparseIntList knownLogicalLineCounts = null;
    private int lastStorageSize = -1;
    private ChangeListener listener = null;
    private Timer timer = null;
    private final AtomicBoolean newEvent = new AtomicBoolean(false);
    private boolean dirty;
    private IntList importantLines = new IntList(10);
    private boolean lastLineFinished = true;
    private int lastLineLength = -1;
    static final Color[] DEF_COLORS;
    Color[] curDefColors;
    private static final int MAX_FIND_SIZE = 16384;
    private Pattern pattern;

    AbstractLines() {
        if (Controller.LOG) {
            Controller.log("Creating a new AbstractLines");
        }
        this.init();
    }

    protected abstract Storage getStorage();

    protected abstract boolean isDisposed();

    protected abstract void handleException(Exception var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] getText(int n, int n2, char[] cArray) {
        if (cArray == null) {
            cArray = new char[n2 - n];
        }
        if (n2 < n || n < 0) {
            throw new IllegalArgumentException("Illogical text range from " + n + " to " + n2);
        }
        if (n2 - n > cArray.length) {
            throw new IllegalArgumentException("Array size is too small");
        }
        Object object = this.readLock();
        synchronized (object) {
            if (this.isDisposed()) {
                for (int i = 0; i < n2 - n; ++i) {
                    cArray[i] = '\u0000';
                }
                return cArray;
            }
            int n3 = AbstractLines.toByteIndex(n);
            int n4 = AbstractLines.toByteIndex(n2 - n);
            try {
                CharBuffer charBuffer = this.getStorage().getReadBuffer(n3, n4).asCharBuffer();
                int n5 = Math.min(n2 - n, charBuffer.remaining());
                charBuffer.get(cArray, 0, n5);
                return cArray;
            }
            catch (Exception exception) {
                this.handleException(exception);
                return new char[0];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharBuffer getCharBuffer(int n, int n2) {
        if (n2 < 0 || n < 0) {
            throw new IllegalArgumentException("Illogical text range from " + n + " to " + (n + n2));
        }
        Object object = this.readLock();
        synchronized (object) {
            if (this.isDisposed()) {
                return null;
            }
            int n3 = AbstractLines.toByteIndex(n);
            int n4 = AbstractLines.toByteIndex(n2);
            int n5 = this.getStorage().size();
            if (n5 < n3 + n4) {
                throw new ArrayIndexOutOfBoundsException("Bytes from " + n3 + " to " + (n3 + n4) + " requested, " + "but storage is only " + n5 + " bytes long");
            }
            try {
                return this.getStorage().getReadBuffer(n3, n4).asCharBuffer();
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    @Override
    public String getText(int n, int n2) {
        CharBuffer charBuffer = this.getCharBuffer(n, n2 - n);
        return charBuffer != null ? charBuffer.toString() : new String(new char[n2 - n]);
    }

    void onDispose(int n) {
        this.lastStorageSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getByteSize() {
        Object object = this.readLock();
        synchronized (object) {
            if (this.lastStorageSize >= 0) {
                return this.lastStorageSize;
            }
            Storage storage = this.getStorage();
            int n = storage == null ? 0 : storage.size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listener = changeListener;
        AbstractLines abstractLines = this;
        synchronized (abstractLines) {
            if (this.getLineCount() > 0) {
                this.fire();
            }
        }
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listener == changeListener) {
            this.listener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.newEvent.set(false);
        this.fire();
        AtomicBoolean atomicBoolean = this.newEvent;
        synchronized (atomicBoolean) {
            if (!this.newEvent.get()) {
                this.timer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delayedFire() {
        this.newEvent.set(true);
        if (this.listener == null) {
            return;
        }
        if (this.timer == null) {
            this.timer = new Timer(200, this);
        }
        AtomicBoolean atomicBoolean = this.newEvent;
        synchronized (atomicBoolean) {
            if (this.newEvent.get() && !this.timer.isRunning()) {
                this.timer.start();
            }
        }
    }

    public void fire() {
        if (Controller.LOG) {
            Controller.log(this + ": Writer firing " + this.getStorage().size() + " bytes written");
        }
        if (this.listener != null) {
            Mutex.EVENT.readAccess((Runnable)this);
        }
    }

    @Override
    public void run() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    @Override
    public boolean hasListeners() {
        return this.firstListenerLine() != -1;
    }

    @Override
    public OutputListener getListener(int n, int[] nArray) {
        int n2 = this.getLineAt(n);
        int n3 = this.getLineStart(n2);
        n -= n3;
        LineInfo lineInfo = (LineInfo)this.lineWithListenerToInfo.get(n2);
        if (lineInfo == null) {
            return null;
        }
        int n4 = 0;
        for (LineInfo.Segment segment : lineInfo.getLineSegments()) {
            if (n < segment.getEnd()) {
                if (segment.getListener() != null) {
                    if (nArray != null) {
                        nArray[0] = n3 + n4;
                        nArray[1] = n3 + segment.getEnd();
                    }
                    return segment.getListener();
                }
                return null;
            }
            n4 = segment.getEnd();
        }
        return null;
    }

    @Override
    public boolean isListener(int n, int n2) {
        int[] nArray = new int[2];
        OutputListener outputListener = this.getListener(n, nArray);
        return outputListener == null ? false : nArray[0] == n && nArray[1] == n2;
    }

    private void init() {
        this.knownLogicalLineCounts = null;
        this.lineStartList = new IntList(100);
        this.lineStartList.add(0);
        this.linesToInfos = new IntMap();
        this.lineWithListenerToInfo = new IntMap();
        this.longestLineLen = 0;
        this.listener = null;
        this.dirty = false;
        this.curDefColors = (Color[])DEF_COLORS.clone();
    }

    @Override
    public boolean checkDirty(boolean bl) {
        if (this.isDisposed()) {
            return false;
        }
        boolean bl2 = this.dirty;
        if (bl) {
            this.dirty = false;
        }
        return bl2;
    }

    @Override
    public int[] getLinesWithListeners() {
        return this.lineWithListenerToInfo.getKeys();
    }

    @Override
    public int getCharCount() {
        return AbstractLines.toCharIndex(this.getByteSize());
    }

    @Override
    public String getLine(int n) throws IOException {
        int n2 = this.getCharLineStart(n);
        int n3 = AbstractLines.toCharIndex(n < this.lineStartList.size() - 1 ? this.lineStartList.get(n + 1) : this.getByteSize());
        return this.getText(n2, n3);
    }

    private int getByteLineLength(int n) {
        if (n == this.lineStartList.size() - 1) {
            return Math.max(0, AbstractLines.toByteIndex(this.lastLineLength));
        }
        int n2 = this.getByteLineStart(n);
        int n3 = n < this.lineStartList.size() - 1 ? this.lineStartList.get(n + 1) - 2 * "\n".length() : this.getByteSize();
        return n3 - n2;
    }

    @Override
    public boolean isLineStart(int n) {
        int n2 = AbstractLines.toByteIndex(n);
        return this.lineStartList.contains(n2) || n2 == 0 || n2 == this.getByteSize() && this.lastLineFinished;
    }

    @Override
    public int length(int n) {
        return AbstractLines.toCharIndex(this.getByteLineLength(n));
    }

    @Override
    public int getLineStart(int n) {
        return this.getCharLineStart(n);
    }

    private int getByteLineStart(int n) {
        if (n == this.lineStartList.size() && this.lastLineFinished) {
            return this.getByteSize();
        }
        return this.lineStartList.get(n);
    }

    private int getCharLineStart(int n) {
        return AbstractLines.toCharIndex(this.getByteLineStart(n));
    }

    @Override
    public int getLineAt(int n) {
        int n2 = AbstractLines.toByteIndex(n);
        if (n2 >= this.getByteSize()) {
            return this.getLineCount() - 1;
        }
        return this.lineStartList.findNearest(n2);
    }

    @Override
    public int getLineCount() {
        return this.lineStartList.size();
    }

    @Override
    public Collection<OutputListener> getListenersForLine(int n) {
        LineInfo lineInfo = (LineInfo)this.lineWithListenerToInfo.get(n);
        if (lineInfo == null) {
            return Collections.emptyList();
        }
        return lineInfo.getListeners();
    }

    @Override
    public int firstListenerLine() {
        if (this.isDisposed()) {
            return -1;
        }
        return this.lineWithListenerToInfo.isEmpty() ? -1 : this.lineWithListenerToInfo.first();
    }

    @Override
    public OutputListener nearestListener(int n, boolean bl, int[] nArray) {
        int n2 = this.getLineAt(n);
        int n3 = this.lineWithListenerToInfo.nearest(n2, bl);
        if (n3 < 0) {
            return null;
        }
        LineInfo lineInfo = (LineInfo)this.lineWithListenerToInfo.get(n3);
        int n4 = this.getLineStart(n3);
        OutputListener outputListener = null;
        int[] nArray2 = new int[2];
        if (n2 == n3) {
            if (bl) {
                lineInfo.getFirstListener(nArray2);
                if (nArray2[0] + n4 > n) {
                    n3 = this.lineWithListenerToInfo.nearest(n3 - 1, bl);
                    lineInfo = (LineInfo)this.lineWithListenerToInfo.get(n3);
                    n4 = this.getLineStart(n3);
                    outputListener = lineInfo.getLastListener(nArray2);
                }
            } else {
                lineInfo.getLastListener(nArray2);
                if (nArray2[1] + n4 <= n) {
                    n3 = this.lineWithListenerToInfo.nearest(n3 + 1, bl);
                    lineInfo = (LineInfo)this.lineWithListenerToInfo.get(n3);
                    n4 = this.getLineStart(n3);
                    outputListener = lineInfo.getFirstListener(nArray2);
                }
            }
        } else {
            n = n4;
            OutputListener outputListener2 = outputListener = bl ? lineInfo.getLastListener(nArray2) : lineInfo.getFirstListener(nArray2);
        }
        if (outputListener == null) {
            OutputListener outputListener3 = outputListener = bl ? lineInfo.getListenerBefore(n - n4, nArray2) : lineInfo.getListenerAfter(n - n4, nArray2);
        }
        if (outputListener != null) {
            nArray[0] = nArray2[0] + n4;
            nArray[1] = nArray2[1] + n4;
        }
        return outputListener;
    }

    @Override
    public int getLongestLineLength() {
        return this.longestLineLen;
    }

    @Override
    public void toPhysicalLineIndex(int[] nArray, int n) {
        int n2 = nArray[0];
        if (n2 <= 0) {
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = AbstractLines.lengthToLineCount(this.length(0), n);
            return;
        }
        if (n >= this.longestLineLen || this.getLineCount() < 1) {
            nArray[1] = 0;
            nArray[2] = 1;
            return;
        }
        int n3 = Math.min(this.findPhysicalLine(n2, n), this.getLineCount() - 1);
        int n4 = this.getLogicalLineCountAbove(n3, n);
        int n5 = this.length(n3);
        int n6 = AbstractLines.lengthToLineCount(n5, n);
        nArray[0] = n3;
        nArray[1] = n2 - n4;
        nArray[2] = n6;
    }

    private int findPhysicalLine(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        if (n2 != this.knownCharsPerLine || this.knownLogicalLineCounts == null) {
            this.calcLogicalLineCount(n2);
        }
        return this.knownLogicalLineCounts.getNextKey(n);
    }

    @Override
    public int getLogicalLineCountAbove(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        if (n2 >= this.longestLineLen) {
            return n;
        }
        if (n2 != this.knownCharsPerLine || this.knownLogicalLineCounts == null) {
            this.calcLogicalLineCount(n2);
        }
        return this.knownLogicalLineCounts.get(n - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLogicalLineCountIfWrappedAt(int n) {
        if (n >= this.longestLineLen) {
            return this.getLineCount();
        }
        int n2 = this.getLineCount();
        if (n == 0 || n2 == 0) {
            return 0;
        }
        Object object = this.readLock();
        synchronized (object) {
            if (n != this.knownCharsPerLine || this.knownLogicalLineCounts == null) {
                this.calcLogicalLineCount(n);
            }
            return this.knownLogicalLineCounts.get(n2 - 1);
        }
    }

    private void registerLineWithListener(int n, LineInfo lineInfo, boolean bl) {
        this.lineWithListenerToInfo.put(n, lineInfo);
        if (bl) {
            this.importantLines.add(n);
        }
    }

    @Override
    public int firstImportantListenerLine() {
        return this.importantLines.size() == 0 ? -1 : this.importantLines.get(0);
    }

    @Override
    public boolean isImportantLine(int n) {
        return this.importantLines.contains(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcLogicalLineCount(int n) {
        Object object = this.readLock();
        synchronized (object) {
            int n2 = this.getLineCount();
            this.knownLogicalLineCounts = new SparseIntList(30);
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                int n4 = this.length(i);
                if (n4 > n) {
                    this.knownLogicalLineCounts.add(i, n3 += AbstractLines.lengthToLineCount(n4, n));
                    continue;
                }
                ++n3;
            }
            this.knownCharsPerLine = n;
        }
    }

    static int lengthToLineCount(int n, int n2) {
        return n > n2 ? (n2 == 0 ? n : (n + n2 - 1) / n2) : 1;
    }

    void markDirty() {
        this.dirty = true;
    }

    boolean isLastLineFinished() {
        return this.lastLineFinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLastLine(int n, int n2) {
        Object object = this.readLock();
        synchronized (object) {
            boolean bl;
            this.longestLineLen = Math.max(this.longestLineLen, n2);
            if (this.knownLogicalLineCounts == null) {
                return;
            }
            boolean bl2 = bl = this.knownLogicalLineCounts.lastIndex() == n;
            if (bl) {
                assert (!this.lastLineFinished);
                if (n2 <= this.knownCharsPerLine) {
                    this.knownLogicalLineCounts.removeLast();
                } else {
                    int n3 = this.knownLogicalLineCounts.lastAdded() - AbstractLines.lengthToLineCount(this.lastLineLength, this.knownCharsPerLine) + AbstractLines.lengthToLineCount(n2, this.knownCharsPerLine);
                    this.knownLogicalLineCounts.updateLast(n, n3);
                }
            } else {
                if (n2 <= this.knownCharsPerLine) {
                    return;
                }
                int n4 = this.knownLogicalLineCounts.lastIndex() != -1 ? n - (this.knownLogicalLineCounts.lastIndex() + 1) + this.knownLogicalLineCounts.lastAdded() : Math.max(0, n - 1);
                this.knownLogicalLineCounts.add(n, n4 += AbstractLines.lengthToLineCount(n2, this.knownCharsPerLine));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineUpdated(int n, int n2, boolean bl) {
        Object object = this.readLock();
        synchronized (object) {
            int n3 = AbstractLines.toCharIndex(n2);
            if (bl) {
                --n3;
            }
            this.updateLastLine(this.lineStartList.size() - 1, n3);
            if (bl) {
                this.lineStartList.add(n + n2);
            }
            this.lastLineFinished = bl;
            this.lastLineLength = bl ? -1 : n3;
        }
        this.markDirty();
    }

    static int toByteIndex(int n) {
        return n << 1;
    }

    static int toCharIndex(int n) {
        assert (n % 2 == 0) : "bad index: " + n;
        return n >> 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAs(String string) throws IOException {
        Storage storage = this.getStorage();
        if (storage == null) {
            throw new IOException("Data has already been disposed");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        try {
            String string2 = System.getProperty("file.encoding");
            if (string2 == null) {
                string2 = "UTF-8";
            }
            Charset charset = Charset.forName(string2);
            CharsetEncoder charsetEncoder = charset.newEncoder();
            String string3 = System.getProperty("line.separator");
            FileChannel fileChannel = fileOutputStream.getChannel();
            ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(string3));
            for (int i = 0; i < this.getLineCount(); ++i) {
                int n = this.getCharLineStart(i);
                int n2 = this.length(i);
                CharBuffer charBuffer = this.getCharBuffer(n, n2);
                ByteBuffer byteBuffer2 = charsetEncoder.encode(charBuffer);
                fileChannel.write(byteBuffer2);
                if (i == this.getLineCount() - 1) continue;
                byteBuffer.rewind();
                fileChannel.write(byteBuffer);
            }
            fileChannel.close();
        }
        finally {
            fileOutputStream.close();
        }
    }

    @Override
    public void setDefColor(IOColors.OutputType outputType, Color color) {
        this.curDefColors[outputType.ordinal()] = color;
    }

    @Override
    public Color getDefColor(IOColors.OutputType outputType) {
        return this.curDefColors[outputType.ordinal()];
    }

    @Override
    public LineInfo getLineInfo(int n) {
        LineInfo lineInfo = (LineInfo)this.linesToInfos.get(n);
        if (lineInfo != null) {
            int n2 = this.length(n);
            if (n2 > lineInfo.getEnd()) {
                lineInfo.addSegment(n2, false, null, null, false);
            }
            return lineInfo;
        }
        return new LineInfo(this, this.length(n));
    }

    public LineInfo getExistingLineInfo(int n) {
        return (LineInfo)this.linesToInfos.get(n);
    }

    private boolean regExpChanged(String string, boolean bl) {
        return this.pattern != null && (!this.pattern.toString().equals(string) || this.pattern.flags() == 2 == bl);
    }

    @Override
    public int[] find(int n, String string, boolean bl, boolean bl2) {
        Storage storage = this.getStorage();
        if (storage == null) {
            return null;
        }
        if (bl && this.regExpChanged(string, bl2)) {
            this.pattern = null;
        }
        if (!bl && !bl2) {
            string = string.toLowerCase();
        }
        while (true) {
            int n2;
            if ((n2 = this.getCharCount() - n) > 16384) {
                int n3 = this.getLineAt(n + 16384);
                n2 = this.getLineStart(n3) + this.length(n3) - n;
            } else if (n2 <= 0) break;
            CharBuffer charBuffer = null;
            try {
                charBuffer = storage.getReadBuffer(AbstractLines.toByteIndex(n), AbstractLines.toByteIndex(n2)).asCharBuffer();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            if (charBuffer == null) break;
            if (bl) {
                Matcher matcher;
                if (this.pattern == null) {
                    Pattern pattern = this.pattern = bl2 ? Pattern.compile(string) : Pattern.compile(string, 2);
                }
                if ((matcher = this.pattern.matcher(charBuffer)).find()) {
                    return new int[]{n + matcher.start(), n + matcher.end()};
                }
            } else {
                int n4;
                int n5 = n4 = bl2 ? charBuffer.toString().indexOf(string) : charBuffer.toString().toLowerCase().indexOf(string);
                if (n4 != -1) {
                    return new int[]{n + n4, n + n4 + string.length()};
                }
            }
            n += charBuffer.length();
        }
        return null;
    }

    @Override
    public int[] rfind(int n, String string, boolean bl, boolean bl2) {
        block11: {
            int n2;
            Storage storage = this.getStorage();
            if (storage == null) {
                return null;
            }
            if (bl && this.regExpChanged(string, bl2)) {
                this.pattern = null;
            }
            if (!bl && !bl2) {
                string = string.toLowerCase();
            }
            while (true) {
                int n3;
                if ((n = (n3 = n) - 16384) < 0) {
                    n = 0;
                } else {
                    int n4 = this.getLineAt(n);
                    n = this.getLineStart(n4);
                }
                if (n == n3) break block11;
                CharBuffer charBuffer = null;
                try {
                    charBuffer = storage.getReadBuffer(AbstractLines.toByteIndex(n), AbstractLines.toByteIndex(n3 - n)).asCharBuffer();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                if (charBuffer == null) break block11;
                if (bl) {
                    if (this.pattern == null) {
                        this.pattern = bl2 ? Pattern.compile(string) : Pattern.compile(string, 2);
                    }
                    Matcher matcher = this.pattern.matcher(charBuffer);
                    int n5 = -1;
                    int n6 = -1;
                    while (matcher.find()) {
                        n5 = matcher.start();
                        n6 = matcher.end();
                    }
                    if (n5 == -1) continue;
                    return new int[]{n + n5, n + n6};
                }
                n2 = bl2 ? charBuffer.toString().lastIndexOf(string) : charBuffer.toString().toLowerCase().lastIndexOf(string);
                if (n2 != -1) break;
            }
            return new int[]{n + n2, n + n2 + string.length()};
        }
        return null;
    }

    public String toString() {
        return this.lineStartList.toString();
    }

    int addSegment(CharSequence charSequence, int n, int n2, int n3, OutputListener outputListener, boolean bl, boolean bl2, Color color) {
        int n4 = this.length(n2);
        if (n4 > 0) {
            LineInfo lineInfo = (LineInfo)this.linesToInfos.get(n2);
            if (lineInfo == null) {
                lineInfo = new LineInfo(this);
                this.linesToInfos.put(n2, lineInfo);
            }
            int n5 = lineInfo.getEnd();
            if (n3 > 0 && n3 != n5) {
                lineInfo.addSegment(n3, false, null, null, false);
                n5 = n3;
            }
            if (outputListener != null) {
                int n6;
                int n7 = Math.min(n5 + charSequence.length() - n, n4);
                int n8 = Math.min(charSequence.length(), n + n4);
                if (charSequence.charAt(n8 - 1) == '\n') {
                    --n8;
                }
                if (charSequence.charAt(n8 - 1) == '\r') {
                    --n8;
                }
                int n9 = 0;
                while (n9 + n < n8 && Character.isWhitespace(charSequence.charAt(n + n9))) {
                    ++n9;
                }
                if (n9 != n8) {
                    for (n6 = 0; n6 < n8 && Character.isWhitespace(charSequence.charAt(n8 - n6 - 1)); ++n6) {
                    }
                }
                if (n9 > 0) {
                    lineInfo.addSegment(n5 + n9, false, null, null, false);
                }
                lineInfo.addSegment(n7 - n6, bl2, outputListener, color, bl);
                if (n6 > 0) {
                    lineInfo.addSegment(n7, false, null, null, false);
                }
                this.registerLineWithListener(n2, lineInfo, bl);
            } else {
                lineInfo.addSegment(n4, bl2, outputListener, color, bl);
            }
        }
        return n4;
    }

    void updateLinesInfo(CharSequence charSequence, int n, int n2, OutputListener outputListener, boolean bl, boolean bl2, Color color) {
        int n3;
        int n4 = 0;
        CharSequence charSequence2 = charSequence;
        if (outputListener != null) {
            for (n3 = 0; n3 < charSequence.length(); ++n3) {
                if (charSequence.charAt(n3) != '\t') continue;
                StringBuilder stringBuilder = new StringBuilder(charSequence.length() + 100);
                int n5 = 0;
                for (int i = n3; i < charSequence.length(); ++i) {
                    if (charSequence.charAt(i) != '\t') continue;
                    stringBuilder.append(charSequence, n5, i);
                    stringBuilder.append("        ");
                    n5 = i + 1;
                }
                stringBuilder.append(charSequence, n5, charSequence.length());
                charSequence2 = stringBuilder;
                break;
            }
        }
        n3 = n2 - this.getLineStart(n);
        for (int i = n; i < this.getLineCount(); ++i) {
            n4 += this.addSegment(charSequence2, n4, i, n3, outputListener, bl, bl2, color) + 1;
            n3 = 0;
        }
    }

    void addLineInfo(int n, LineInfo lineInfo, boolean bl) {
        this.linesToInfos.put(n, lineInfo);
        if (!lineInfo.getListeners().isEmpty()) {
            this.registerLineWithListener(n, lineInfo, bl);
        }
    }

    static {
        Color color;
        Color color2;
        Color color3;
        Color color4 = UIManager.getColor("nb.output.foreground");
        if (color4 == null && (color4 = UIManager.getColor("textText")) == null) {
            color4 = Color.BLACK;
        }
        if ((color3 = UIManager.getColor("nb.output.err.foreground")) == null) {
            color3 = new Color(164, 0, 0);
        }
        if ((color2 = UIManager.getColor("nb.output.link.foreground")) == null) {
            color2 = Color.BLUE.darker();
        }
        if ((color = UIManager.getColor("nb.output.link.foreground.important")) == null) {
            color = color2;
        }
        DEF_COLORS = new Color[]{color4, color3, color2, color};
    }
}

