/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing.lexer;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.javascript.editing.lexer.JsCommentTokenId;
import org.netbeans.modules.javascript.editing.lexer.JsLexer;
import org.netbeans.modules.javascript.editing.lexer.JsStringTokenId;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JsTokenId implements TokenId
{
    ERROR(null, "error"),
    NEW("new", "keyword"),
    IDENTIFIER(null, "identifier"),
    REGEXP_LITERAL(null, "mod-regexp"),
    FLOAT_LITERAL(null, "number"),
    STRING_LITERAL(null, "string"),
    WHITESPACE(null, "whitespace"),
    EOL(null, "whitespace"),
    LINE_COMMENT(null, "comment"),
    BLOCK_COMMENT(null, "comment"),
    LPAREN("(", "separator"),
    RPAREN(")", "separator"),
    LBRACE("{", "separator"),
    RBRACE("}", "separator"),
    LBRACKET("[", "separator"),
    RBRACKET("]", "separator"),
    STRING_BEGIN(null, "string"),
    STRING_END(null, "string"),
    REGEXP_BEGIN(null, "mod-regexp"),
    REGEXP_END(null, "mod-regexp"),
    ANY_KEYWORD(null, "keyword"),
    ANY_OPERATOR(null, "operator"),
    DOT(null, "operator"),
    THIS("this", "keyword"),
    FOR("for", "keyword"),
    IF("if", "keyword"),
    ELSE("else", "keyword"),
    WHILE("while", "keyword"),
    CASE("case", "keyword"),
    DEFAULT("default", "keyword"),
    BREAK("break", "keyword"),
    SWITCH("switch", "keyword"),
    COLON(":", "operator"),
    SEMI(";", "operator"),
    FUNCTION("function", "keyword"),
    NONUNARY_OP(null, "operator");

    private final String fixedText;
    private final String primaryCategory;
    private static final Language<JsTokenId> language;
    public static final String JAVASCRIPT_MIME_TYPE = "text/javascript";
    public static final String JSON_MIME_TYPE = "text/x-json";

    private JsTokenId(String string2, String string3) {
        this.fixedText = string2;
        this.primaryCategory = string3;
    }

    public String fixedText() {
        return this.fixedText;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    public static Language<JsTokenId> language() {
        return language;
    }

    static {
        language = new LanguageHierarchy<JsTokenId>(){

            protected String mimeType() {
                return JsTokenId.JAVASCRIPT_MIME_TYPE;
            }

            protected Collection<JsTokenId> createTokenIds() {
                return EnumSet.allOf(JsTokenId.class);
            }

            protected Map<String, Collection<JsTokenId>> createTokenCategories() {
                HashMap<String, Collection<JsTokenId>> hashMap = new HashMap<String, Collection<JsTokenId>>();
                return hashMap;
            }

            protected Lexer<JsTokenId> createLexer(LexerRestartInfo<JsTokenId> lexerRestartInfo) {
                return JsLexer.create(lexerRestartInfo);
            }

            protected LanguageEmbedding<?> embedding(Token<JsTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                JsTokenId jsTokenId = (JsTokenId)token.id();
                if (jsTokenId == STRING_LITERAL) {
                    return LanguageEmbedding.create(JsStringTokenId.language(), (int)0, (int)0);
                }
                if (jsTokenId == BLOCK_COMMENT || jsTokenId == LINE_COMMENT) {
                    return LanguageEmbedding.create(JsCommentTokenId.language(), (int)0, (int)0);
                }
                return null;
            }
        }.language();
    }
}

