/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mozilla.nb.javascript.Node;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.JsUtils;
import org.netbeans.modules.javascript.editing.VariableVisitor;
import org.netbeans.modules.javascript.editing.embedding.JsEmbeddingProvider;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsSemanticAnalyzer
extends SemanticAnalyzer {
    private boolean cancelled;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights;

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void run(Parser.Result result, SchedulerEvent schedulerEvent) {
        this.resume();
        this.semanticHighlights = null;
        if (this.isCancelled()) {
            return;
        }
        JsParseResult jsParseResult = AstUtilities.getParseResult(result);
        if (jsParseResult == null) {
            return;
        }
        Node node = jsParseResult.getRootNode();
        if (node == null) {
            return;
        }
        this.semanticHighlights = this.analyzeFullTree(jsParseResult, node);
    }

    public int getPriority() {
        return 0;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    Map<OffsetRange, Set<ColoringAttributes>> analyzeFullTree(JsParseResult jsParseResult, Node node) {
        Object object2;
        ArrayList<Node> arrayList;
        boolean bl;
        Node node222;
        VariableVisitor variableVisitor = jsParseResult.getVariableVisitor();
        Object object3 = new HashMap<OffsetRange, EnumSet>(100);
        Collection<Node> collection = variableVisitor.getUnusedVars();
        for (Node node222 : collection) {
            OffsetRange offsetRange = AstUtilities.getNameRange(node222);
            object3.put(offsetRange, ColoringAttributes.UNUSED_SET);
        }
        List<Node> list = variableVisitor.getGlobalVars(false);
        node222 = jsParseResult.getSanitizedRange();
        boolean bl2 = bl = node222 != OffsetRange.NONE && node222.getLength() == 1;
        if (bl && (arrayList = jsParseResult.getSanitizedContents()) != null && ((String)((Object)arrayList)).length() > 0 && !Character.isLetter(((String)((Object)arrayList)).charAt(0))) {
            bl = false;
        }
        arrayList = list.iterator();
        while (arrayList.hasNext()) {
            object2 = (Node)arrayList.next();
            String object4 = object2.getString();
            if (JsEmbeddingProvider.isGeneratedIdentifier(object4) || object2.getSourceStart() == object2.getSourceEnd()) continue;
            OffsetRange offsetRange = AstUtilities.getNameRange((Node)object2);
            if (bl && offsetRange.getEnd() == node222.getStart()) continue;
            if (Character.isUpperCase(object4.charAt(0))) {
                object3.put(offsetRange, ColoringAttributes.CLASS_SET);
                continue;
            }
            object3.put(offsetRange, ColoringAttributes.GLOBAL_SET);
        }
        arrayList = new ArrayList<Node>();
        if (JsUtils.isEjsFile(jsParseResult.getSnapshot().getSource().getFileObject())) {
            AstUtilities.addNodesByType(node, new int[]{48, 164, 165}, arrayList);
        } else {
            AstUtilities.addNodesByType(node, new int[]{48, 164, 165, 174}, arrayList);
        }
        for (Node node2 : arrayList) {
            Object object;
            OffsetRange offsetRange = AstUtilities.getNameRange(node2);
            if (node2.isStringNode() && JsEmbeddingProvider.isGeneratedIdentifier(node2.getString())) continue;
            int n = node2.getType();
            if (n == 48) {
                object3.put(offsetRange, ColoringAttributes.REGEXP_SET);
                continue;
            }
            if (n == 165) {
                if (!AstUtilities.isLabelledFunction(node2)) continue;
                object3.put(offsetRange, ColoringAttributes.METHOD_SET);
                continue;
            }
            if (n == 164) {
                object3.put(offsetRange, ColoringAttributes.METHOD_SET);
                continue;
            }
            assert (n == 174);
            object3.put(offsetRange, ColoringAttributes.CUSTOM1_SET);
            Node node3 = node2.getFirstChild();
            if (node3 != null && node3.getType() == 41) {
                object = node3.getString();
                this.parseXml((Map<OffsetRange, Set<ColoringAttributes>>)object3, (String)object, node3.getSourceStart());
                continue;
            }
            object = new ArrayList();
            AstUtilities.addNodesByType(node2, new int[]{41}, (List<Node>)object);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Node node4 = (Node)iterator.next();
                boolean bl3 = true;
                for (Node node5 = node4.getParentNode(); node5 != null && node5 != node2; node5 = node5.getParentNode()) {
                    if (node5.getType() == 21) continue;
                    bl3 = false;
                }
                if (!bl3) continue;
                String string = node4.getString();
                this.parseXml((Map<OffsetRange, Set<ColoringAttributes>>)object3, string, node4.getSourceStart());
            }
        }
        if (this.isCancelled()) {
            return null;
        }
        if (object3.size() > 0) {
            object2 = new HashMap(2 * object3.size());
            for (Map.Entry entry : object3.entrySet()) {
                OffsetRange offsetRange = LexUtilities.getLexerOffsets(jsParseResult, (OffsetRange)entry.getKey());
                if (offsetRange == OffsetRange.NONE) continue;
                object2.put(offsetRange, entry.getValue());
            }
            object3 = object2;
            return object3;
        }
        return null;
    }

    private void parseXml(Map<OffsetRange, Set<ColoringAttributes>> map, String string, int n) {
        int n2 = 0;
        int n3 = 1;
        int n4 = string.length();
        for (int i = 0; i < n4; ++i) {
            OffsetRange offsetRange;
            char c = string.charAt(i);
            if (n3 == 1) {
                if (c != '<') continue;
                if (i > n2) {
                    offsetRange = new OffsetRange(n + n2, n + i);
                    map.put(offsetRange, ColoringAttributes.CUSTOM3_SET);
                }
                n3 = 2;
                continue;
            }
            if (n3 == 2) {
                if (c == '/') continue;
                n2 = i;
                n3 = 3;
                continue;
            }
            if (n3 == 3) {
                if (Character.isLetterOrDigit(c) || c == '_' || c == ':') continue;
                offsetRange = new OffsetRange(n + n2, n + i);
                map.put(offsetRange, ColoringAttributes.CUSTOM2_SET);
                if (c == '>') {
                    n3 = 1;
                    n2 = i + 1;
                    continue;
                }
                n3 = 4;
                continue;
            }
            if (n3 == 4) {
                if (c != '>') continue;
                n3 = 1;
                n2 = i + 1;
                continue;
            }
            assert (false) : n3;
        }
    }
}

