/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.mozilla.nb.javascript.Node;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.spi.CodeStylePreferences;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.JsFormatter;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.util.Exceptions;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsPretty {
    private final Logger LOG = Logger.getLogger(JsFormatter.class.getName());
    private final JsParseResult info;
    private final BaseDocument doc;
    private final TokenSequence<? extends JsTokenId> ts;
    private final int begin;
    private final int end;
    private final ArrayList<Diff> diffs = new ArrayList();
    private int indent;
    private int lastHandledOffset = -1;
    private final int indentSize;
    private final int continuationIndentSize;
    private final int tabSize;
    private final String NON_FORMATTED_KEYWORD_AFTER_RBRACE = "catch finally";
    private Stack<StackItem> stack = new Stack();
    private boolean isIncreasingLine = false;

    public JsPretty(JsParseResult jsParseResult, BaseDocument baseDocument, int n, int n2, int n3, int n4) {
        this.info = jsParseResult;
        this.doc = baseDocument;
        this.begin = n;
        this.end = n2;
        this.ts = LexUtilities.getPositionedSequence((Document)this.doc, 0, false);
        this.indentSize = n3;
        this.continuationIndentSize = n4;
        Preferences preferences = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
        this.tabSize = preferences.getInt("spaces-per-tab", 4);
    }

    public void format() {
        JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)this.info);
        Node node = jsParseResult.getRootNode();
        if (node != null) {
            this.walk(node);
        }
        this.acceptNode(null);
    }

    private void walk(Node node) {
        if (this.ignoredType(node.getType())) {
            return;
        }
        this.acceptNode(node);
        if (node.hasChildren()) {
            Node node2 = node.getFirstChild();
            switch (node.getType()) {
                case 128: {
                    if (node2.getType() == 7) {
                        this.visitIf(node);
                        break;
                    }
                    this.visitOtherBlock(node);
                    break;
                }
                case 131: {
                    JsTokenId jsTokenId = (JsTokenId)this.ts.token().id();
                    if (jsTokenId == JsTokenId.WHILE) {
                        this.visitWhile(node);
                        break;
                    }
                    if (jsTokenId == JsTokenId.FOR) {
                        this.visitOtherBlock(node);
                        break;
                    }
                    if (node2.getType() == 121) {
                        this.visitOtherBlock(node);
                        break;
                    }
                    this.visitDefault(node);
                    break;
                }
                case 133: {
                    this.visitContinuation(node);
                    break;
                }
                case 114: 
                case 115: {
                    this.visitCase(node);
                    break;
                }
                case 113: {
                    this.visitOtherBlock(node);
                    break;
                }
                case 66: {
                    this.visitObjectLit(node);
                    break;
                }
                case 122: {
                    this.visitWith(node);
                    break;
                }
                case 80: {
                    this.visitBlockWithoutIndenting(node);
                    break;
                }
                case 174: {
                    this.visitE4X(node);
                    break;
                }
                case 123: {
                    this.visitCatch(node);
                    break;
                }
                default: {
                    this.visitDefault(node);
                }
            }
        }
    }

    private Node next(Node node) {
        if (node == null) {
            return null;
        }
        while ((node = node.getNext()) != null && this.ignoredType(node.getType())) {
        }
        return node;
    }

    private boolean ignoredType(int n) {
        switch (n) {
            case 5: 
            case 130: 
            case 134: 
            case 165: {
                return true;
            }
        }
        return false;
    }

    private void visitDefault(Node node) {
        if (node.hasChildren()) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                this.walk(node2);
                node2 = this.next(node2);
            }
        }
        this.acceptOffset(node.getSourceEnd());
    }

    private void visitContinuation(Node node) {
        this.increaseContinuation("visitContinuation " + node);
        if (node.hasChildren()) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                this.walk(node2);
                node2 = this.next(node2);
            }
        }
        this.decreaseContinuation("visitContinuation");
        this.acceptOffset(node.getSourceEnd());
    }

    private void visitObjectLit(Node node) {
        this.increaseIndent("visitObjectLit");
        if (node.hasChildren()) {
            boolean bl = true;
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                if (node2.getType() == 165) {
                    if (bl) {
                        bl = false;
                    } else {
                        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getPositionedSequence((Document)this.doc, node2.getSourceStart());
                        tokenSequence.movePrevious();
                        Token<? extends JsTokenId> token = LexUtilities.findPrevious(tokenSequence, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.LINE_COMMENT, JsTokenId.BLOCK_COMMENT));
                        int n = node2.getSourceStart();
                        if (token.id() == JsTokenId.STRING_BEGIN && n > 0) {
                            --n;
                            token = LexUtilities.findPrevious(tokenSequence, Arrays.asList(JsTokenId.STRING_BEGIN, JsTokenId.WHITESPACE, JsTokenId.LINE_COMMENT, JsTokenId.BLOCK_COMMENT));
                        }
                        if (token != null && token.id() != JsTokenId.EOL) {
                            this.addDiff(n, n, "\n" + this.getIndent(), "visitObjectLit");
                        }
                    }
                }
                this.walk(node2);
            }
        }
        this.decreaseIndent("visitObjectLit");
        this.acceptOffset(node.getSourceEnd());
    }

    private void visitE4X(Node node) {
        if (node.hasChildren()) {
            Node node2 = node.getFirstChild();
            if (node2.getType() == 41) {
                String string = node2.getString();
                try {
                    InputSource inputSource = new InputSource(new StringReader(string));
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setValidating(false);
                    documentBuilderFactory.setExpandEntityReferences(false);
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    documentBuilder.setEntityResolver(new EntityResolver(){

                        public InputSource resolveEntity(String string, String string2) {
                            return new InputSource(new ByteArrayInputStream(new byte[0]));
                        }
                    });
                    org.w3c.dom.Document document = documentBuilder.parse(inputSource);
                    document.setStrictErrorChecking(false);
                    document.setXmlStandalone(true);
                    this.stripWhitespace(document.getDocumentElement());
                    OutputFormat outputFormat = new OutputFormat(document);
                    outputFormat.setIndenting(true);
                    int n = CodeStylePreferences.get((Document)this.doc).getPreferences().getInt("text-limit-width", 80);
                    int n2 = Utilities.getVisualColumn((BaseDocument)this.doc, (int)node2.getSourceStart());
                    if ((n -= n2) > 0) {
                        outputFormat.setLineWidth(n);
                    }
                    outputFormat.setIndent(IndentUtils.indentLevelSize((Document)this.doc));
                    outputFormat.setPreserveSpace(false);
                    outputFormat.setOmitDocumentType(true);
                    outputFormat.setOmitXMLDeclaration(true);
                    outputFormat.setStandalone(true);
                    outputFormat.setLineSeparator("\n");
                    XMLSerializer xMLSerializer = new XMLSerializer(outputFormat);
                    StringWriter stringWriter = new StringWriter();
                    xMLSerializer.setOutputCharStream((Writer)stringWriter);
                    xMLSerializer.serialize(document);
                    String string2 = IndentUtils.createIndentString((Document)this.doc, (int)n2);
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string3 : stringWriter.toString().split("\n")) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append("\n");
                            stringBuilder.append(string2);
                        }
                        stringBuilder.append(string3);
                    }
                    String string4 = stringBuilder.toString();
                    if (!string4.equals(string)) {
                        this.addDiff(node2.getSourceStart(), node2.getSourceStart() + string.length(), string4, "visitE4X");
                    }
                    this.lastHandledOffset = node2.getSourceStart() + string.length();
                    return;
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
                catch (SAXException sAXException) {
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    Exceptions.printStackTrace((Throwable)parserConfigurationException);
                }
            } else {
                this.visitDefault(node);
                return;
            }
        }
        this.acceptOffset(node.getSourceEnd());
    }

    private void stripWhitespace(org.w3c.dom.Node node) {
        Object object;
        String string;
        if (node.getNodeType() == 3 && (string = ((String)(object = node.getNodeValue())).trim()).length() < ((String)object).length()) {
            node.setNodeValue(string);
        }
        if (node.hasChildNodes()) {
            for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                this.stripWhitespace((org.w3c.dom.Node)object);
            }
        }
    }

    private void visitOtherBlock(Node node) {
        if (node.hasChildren()) {
            this.increaseIndent("visitOtherBlock");
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (node2.getSourceEnd() - node2.getSourceStart() > 0) {
                    this.walk(node2);
                }
                node2 = this.next(node2);
            }
            this.decreaseIndent("visitOtherBlock");
        }
        this.acceptOffset(node.getSourceEnd());
    }

    private void visitBlockWithoutIndenting(Node node) {
        if (node.hasChildren()) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                this.walk(node2);
                node2 = this.next(node2);
            }
        }
        this.acceptOffset(node.getSourceEnd());
    }

    private void visitCatch(Node node) {
        this.increaseIndent("visitCatch");
        if (node.hasChildren()) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (node2.getType() == 128) {
                    if (this.stack.isEmpty()) {
                        this.visitBlockWithoutIndenting(node2);
                    } else {
                        this.decreaseIndent("visitCatch-block");
                        this.walk(node2);
                        this.increaseIndent("visitCatch-block");
                    }
                } else {
                    this.walk(node2);
                }
                node2 = this.next(node2);
            }
        }
        this.decreaseIndent("visitCatch");
        this.acceptOffset(node.getSourceEnd());
    }

    private void visitWith(Node node) {
        if (node.hasChildren()) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (node2.getType() == 128) {
                    this.visitBlockWithoutIndenting(node2);
                } else {
                    this.walk(node2);
                }
                node2 = this.next(node2);
            }
        }
        this.acceptOffset(node.getSourceEnd());
    }

    private void visitCase(Node node) {
        this.increaseIndent("visitCase");
        if (node.hasChildren()) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (node2.getType() == 128) {
                    this.visitBlockWithoutIndenting(node2);
                } else {
                    this.walk(node2);
                }
                node2 = this.next(node2);
            }
        }
        this.decreaseIndent("visitCase");
        this.acceptOffset(node.getSourceEnd());
    }

    private void visitWhile(Node node) {
        Node node2 = node.getFirstChild();
        if (this.ignoredType(node2.getType())) {
            this.walk(node2);
            node2 = this.next(node2);
        }
        if (this.isWithoutBlock(node2)) {
            this.increaseIndent("visitWhile");
            this.walk(node2);
            this.decreaseIndent("visitWhile");
            node2 = this.next(node2);
        }
        while (node2 != null) {
            this.walk(node2);
            node2 = this.next(node2);
        }
    }

    private void visitIf(Node node) {
        Node node2 = node.getFirstChild();
        assert (node2.getType() == 7);
        this.walk(node2);
        node2 = this.next(node2);
        if (this.isWithoutBlock(node2)) {
            this.increaseIndent("visitIf 1");
            this.walk(node2);
            this.decreaseIndent("visitIf 1 after " + node2);
            node2 = this.next(node2);
        } else {
            this.walk(node2);
            node2 = this.next(node2);
        }
        if (node2 != null && node2.getType() != 128) {
            this.acceptToken(JsTokenId.ELSE);
            this.increaseIndent("visitIf 2");
            this.walk(node2);
            this.decreaseIndent("visitIf 2");
            node2 = this.next(node2);
        }
        while (node2 != null) {
            this.walk(node2);
            node2 = this.next(node2);
        }
    }

    private void acceptNode(Node node) {
        if (node == null) {
            node = new Node(-1);
        } else {
            if (node.getType() == 48 && node.getSourceEnd() > this.ts.offset()) {
                this.acceptOffset(node.getSourceStart());
                this.ts.move(node.getSourceEnd());
                this.ts.moveNext();
                return;
            }
            if (node.getSourceStart() < this.ts.offset()) {
                return;
            }
            Node node2 = node.getFirstChild();
            if (node2 != null) {
                if (node.getSourceStart() > node2.getSourceStart()) {
                    return;
                }
                if (node.getType() == 38) {
                    return;
                }
            }
        }
        int n = node.getSourceStart();
        do {
            Token token;
            int n2;
            Token<? extends JsTokenId> token2;
            TokenSequence<? extends JsTokenId> tokenSequence;
            Node node3;
            Token token3 = this.ts.token();
            int n3 = this.ts.offset();
            if (n3 >= n) {
                if (token3.id() != JsTokenId.EOL && token3.id() != JsTokenId.LBRACE) {
                    this.handleToken((Token<? extends JsTokenId>)token3, "1 acceptToken(" + node + ")");
                }
                return;
            }
            if (token3.id() == JsTokenId.SEMI && (node3 = node.getParentNode()) != null && node3.getType() != 131) {
                tokenSequence = LexUtilities.getPositionedSequence((Document)this.doc, n3);
                tokenSequence.moveNext();
                token2 = LexUtilities.findNext(tokenSequence, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.LINE_COMMENT, JsTokenId.BLOCK_COMMENT));
                n2 = tokenSequence.offset();
                tokenSequence.movePrevious();
                token = tokenSequence.token();
                if (token.id() == JsTokenId.WHITESPACE) {
                    this.remove(tokenSequence.offset(), tokenSequence.offset() + token.length(), "handleToken SEMI");
                }
                if (token2.id() != JsTokenId.EOL && token2.id() != JsTokenId.RBRACE) {
                    this.addDiff(n2, n2, "\n" + this.getIndent(), "handleToken SEMI");
                }
            }
            if (token3.id() == JsTokenId.COLON && (node3 = node.getParentNode()) != null && (node3 = node3.getParentNode()) != null && (node3.getType() == 114 || node3.getType() == 115)) {
                tokenSequence = LexUtilities.getPositionedSequence((Document)this.doc, n3);
                tokenSequence.moveNext();
                token2 = LexUtilities.findNext(tokenSequence, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.LINE_COMMENT, JsTokenId.BLOCK_COMMENT, JsTokenId.LBRACE));
                n2 = tokenSequence.offset();
                tokenSequence.movePrevious();
                token = tokenSequence.token();
                if (token.id() == JsTokenId.WHITESPACE) {
                    this.remove(tokenSequence.offset(), tokenSequence.offset() + token.length(), "handleToken SEMI");
                }
                if (token2.id() != JsTokenId.EOL) {
                    this.addDiff(n2, n2, "\n" + this.getIndent(), "handleToken COLON");
                } else if (token2.text().charAt(0) == ' ') {
                    int n4 = 1;
                    while (token2.text().charAt(n4) == ' ') {
                        ++n4;
                    }
                    this.remove(n2, n2 + n4, "handleToken COLON");
                }
            }
            this.handleToken((Token<? extends JsTokenId>)token3, "2 acceptToken(" + node + ")");
        } while (this.ts.moveNext());
    }

    private void acceptOffset(int n) {
        do {
            Token token = this.ts.token();
            int n2 = this.ts.offset();
            if (n2 >= n) {
                if (token.id() != JsTokenId.EOL && token.id() != JsTokenId.LBRACE) {
                    this.handleToken((Token<? extends JsTokenId>)token, "1 acceptToken(" + n + ")");
                }
                return;
            }
            this.handleToken((Token<? extends JsTokenId>)token, "2 acceptOffset(" + n + ")");
        } while (this.ts.moveNext());
    }

    private void acceptToken(JsTokenId jsTokenId) {
        do {
            Token token;
            JsTokenId jsTokenId2;
            if ((jsTokenId2 = (JsTokenId)(token = this.ts.token()).id()) == jsTokenId) {
                if (token.id() != JsTokenId.EOL && token.id() != JsTokenId.LBRACE) {
                    this.handleToken((Token<? extends JsTokenId>)token, "1 acceptToken(" + (Object)((Object)jsTokenId) + ")");
                }
                this.ts.moveNext();
                return;
            }
            this.handleToken((Token<? extends JsTokenId>)token, "2 acceptToken(" + (Object)((Object)jsTokenId) + ")");
        } while (this.ts.moveNext());
    }

    private void handleToken(Token<? extends JsTokenId> token, String string) {
        int n = this.ts.offset();
        if (n <= this.lastHandledOffset) {
            return;
        }
        this.lastHandledOffset = n;
        JsTokenId jsTokenId = (JsTokenId)token.id();
        int n2 = token.length();
        switch (jsTokenId) {
            case WHITESPACE: {
                if (n != 0) break;
                this.addDiff(n, n + n2, "", "handleToken WHITESPACE");
                break;
            }
            case EOL: {
                int n3 = n + n2;
                boolean bl = false;
                if (n3 < this.end) {
                    try {
                        int n4 = Utilities.getRowFirstNonWhite((BaseDocument)this.doc, (int)n3);
                        if (n4 != -1) {
                            int n5 = n4 - n3;
                            TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getPositionedSequence((Document)this.doc, n, false);
                            tokenSequence.moveNext();
                            Token<? extends JsTokenId> token2 = LexUtilities.findNextNonWsNonComment(tokenSequence);
                            String string2 = null;
                            if (this.indent > 0 && token2.id() == JsTokenId.LBRACE && !this.diffs.isEmpty()) {
                                bl = true;
                                string2 = this.diffs.get((int)(this.diffs.size() - 1)).text;
                            } else {
                                string2 = this.getIndent();
                            }
                            this.addDiff(n3, n3 + n5, string2, "handleToken EOL - " + this.ts.offset());
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
                if (bl) break;
                this.newLine("handleToken EOL");
                break;
            }
            case LPAREN: {
                this.increaseContinuation("handleToken LPAREN");
                break;
            }
            case RPAREN: {
                this.decreaseContinuation("handleToken RPAREN");
                break;
            }
            case LINE_COMMENT: 
            case BLOCK_COMMENT: {
                break;
            }
            case LBRACE: {
                TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getPositionedSequence((Document)this.doc, n);
                tokenSequence.moveNext();
                Token<? extends JsTokenId> token3 = tokenSequence.token();
                int n6 = tokenSequence.offset();
                token3 = LexUtilities.findNext(tokenSequence, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.LINE_COMMENT, JsTokenId.BLOCK_COMMENT));
                n6 = tokenSequence.offset();
                if (token3.id() == JsTokenId.EOL || token3.id() == JsTokenId.RBRACE) break;
                tokenSequence.movePrevious();
                Token token4 = tokenSequence.token();
                if (token4.id() == JsTokenId.WHITESPACE) {
                    this.remove(tokenSequence.offset(), tokenSequence.offset() + token4.length(), "handleToken SEMI");
                }
                this.addDiff(n6, n6, "\n" + this.getIndent(), "handleToken LBRACE");
                this.newLine("handleToken LBRACE");
                break;
            }
            case RBRACE: {
                int n7;
                TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getPositionedSequence((Document)this.doc, n);
                int n8 = tokenSequence.offset();
                tokenSequence.movePrevious();
                Token token5 = tokenSequence.token();
                Token token6 = LexUtilities.findPrevious(tokenSequence, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.LINE_COMMENT, JsTokenId.BLOCK_COMMENT));
                if (token6.id() != JsTokenId.EOL && token6.id() != JsTokenId.LBRACE && token6.id() != JsTokenId.RBRACE) {
                    n7 = 0;
                    this.addDiff(n8, n8, "\n" + this.getIndent(), "handleToken RBRACE");
                    this.newLine("handleToken RBRACE");
                    if (n7 != 0) {
                        this.increaseIndent("handleToken RBRACE");
                    }
                    if (token5.id() == JsTokenId.WHITESPACE) {
                        this.remove(n8 - token5.length(), n8, "handleToken RBRACE");
                    }
                }
                tokenSequence = LexUtilities.getPositionedSequence((Document)this.doc, n);
                tokenSequence.moveNext();
                Token<? extends JsTokenId> token7 = LexUtilities.findNext(tokenSequence, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.LINE_COMMENT, JsTokenId.BLOCK_COMMENT, JsTokenId.SEMI));
                n8 = tokenSequence.offset();
                tokenSequence.movePrevious();
                token6 = tokenSequence.token();
                if (token6.id() == JsTokenId.WHITESPACE) {
                    n7 = tokenSequence.offset();
                    int n9 = 0;
                    if (this.isNonFormattedAfterRBrace(token7)) {
                        n9 = 1;
                    }
                    this.remove(n7, n7 + token6.length() - n9, "handleToken RBRACE");
                }
                if (token7.id() == JsTokenId.EOL || this.isNonFormattedAfterRBrace(token7)) break;
                if (token7.id() == JsTokenId.RBRACE) {
                    this.decreaseIndent("handleToken RBRACE");
                }
                this.addDiff(n8, n8, "\n" + this.getIndent(), "handleToken RBRACE");
            }
        }
    }

    private boolean isNonFormattedAfterRBrace(Token<? extends JsTokenId> token) {
        String string = ((Object)token.text()).toString();
        JsTokenId jsTokenId = (JsTokenId)token.id();
        return jsTokenId == JsTokenId.ELSE || jsTokenId == JsTokenId.RPAREN || jsTokenId == JsTokenId.WHILE || jsTokenId == JsTokenId.NONUNARY_OP || jsTokenId == JsTokenId.LPAREN || jsTokenId == JsTokenId.DOT || jsTokenId == JsTokenId.COLON || jsTokenId == JsTokenId.RBRACKET || jsTokenId == JsTokenId.ANY_KEYWORD && "catch finally".contains(string) || jsTokenId == JsTokenId.ANY_OPERATOR && ",".equals(string);
    }

    private boolean isWithoutBlock(Node node) {
        boolean bl = false;
        if (node.getType() == 128) {
            int n = this.ts.offset();
            this.ts.move(node.getSourceStart());
            this.ts.moveNext();
            if (this.ts.token().id() != JsTokenId.LBRACE) {
                bl = true;
            }
            this.ts.move(n);
            this.ts.moveNext();
        } else {
            bl = true;
        }
        return bl;
    }

    private void newLine(String string) {
        this.isIncreasingLine = false;
    }

    private void increase(int n, String string) {
        if (!this.stack.isEmpty() && this.isIncreasingLine) {
            this.stack.peek().tip = false;
            this.indent -= this.stack.peek().indent;
        }
        this.indent += n;
        this.stack.push(new StackItem(n));
        this.isIncreasingLine = true;
    }

    private void decrease(String string) {
        StackItem stackItem;
        StackItem stackItem2 = stackItem = this.stack.empty() ? null : this.stack.pop();
        if (stackItem == null) {
            this.LOG.warning("Stack empty for decrease to " + this.indent + " - " + string + ", " + this.ts.offset());
            return;
        }
        if (this.isIncreasingLine) {
            this.indent -= stackItem.indent;
            assert (this.indent >= 0);
            if (!this.stack.isEmpty() && !this.stack.peek().tip) {
                this.stack.peek().tip = true;
                this.indent += this.stack.peek().indent;
            } else {
                this.isIncreasingLine = false;
            }
        } else if (stackItem.tip) {
            this.indent -= stackItem.indent;
            assert (this.indent >= 0);
        }
    }

    private void increaseIndent(String string) {
        this.increase(this.indentSize, string);
    }

    private void increaseContinuation(String string) {
        this.increase(this.continuationIndentSize, string);
    }

    private void decreaseIndent(String string) {
        this.decrease(string);
    }

    private void decreaseContinuation(String string) {
        this.decrease(string);
    }

    private String getIndent() {
        return IndentUtils.createIndentString((Document)this.doc, (int)this.indent);
    }

    private void addDiff(int n, int n2, String string, String string2) {
        if (n < this.begin || n2 > this.end) {
            return;
        }
        if (n2 < this.doc.getLength()) {
            this.diffs.add(new Diff(n, n2, string));
        }
    }

    private void remove(int n, int n2, String string) {
        this.diffs.add(new Diff(n, n2, ""));
    }

    ArrayList<Diff> getReverseDiffs() {
        return this.diffs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Diff
    implements Comparable<Diff> {
        final int start;
        final int end;
        final String text;

        Diff(int n, int n2, String string) {
            this.start = n;
            this.end = n2;
            this.text = string;
        }

        public String toString() {
            return "Diff<" + this.start + "," + this.end + ">: [" + this.text.replace("\n", "\\n") + "]";
        }

        @Override
        public int compareTo(Diff diff) {
            if (this.start != diff.start) {
                return this.start - diff.start;
            }
            return this.end - diff.end;
        }
    }

    private class StackItem {
        int indent;
        boolean tip = true;

        StackItem(int n) {
            this.indent = n;
        }

        public String toString() {
            return "[" + this.indent + "," + this.tip + "]";
        }
    }
}

