/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.ListIterator;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import org.mozilla.nb.javascript.CompilerEnvirons;
import org.mozilla.nb.javascript.ContextFactory;
import org.mozilla.nb.javascript.ErrorReporter;
import org.mozilla.nb.javascript.EvaluatorException;
import org.mozilla.nb.javascript.FunctionNode;
import org.mozilla.nb.javascript.Node;
import org.mozilla.nb.javascript.Parser;
import org.mozilla.nb.javascript.ScriptOrFnNode;
import org.netbeans.modules.csl.api.EditHistory;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.AstNodeAdapter;
import org.netbeans.modules.javascript.editing.AstPath;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.Element;
import org.netbeans.modules.javascript.editing.JsElement;
import org.netbeans.modules.javascript.editing.JsIndexer;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.JsUtils;
import org.netbeans.modules.javascript.editing.SupportedBrowsers;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JsParser
extends org.netbeans.modules.parsing.spi.Parser {
    static RuntimeException runtimeException;
    private JsParseResult lastResult;

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent sourceModificationEvent) throws ParseException {
        Context context = new Context(snapshot, sourceModificationEvent);
        final ArrayList arrayList = new ArrayList();
        context.errorHandler = new ParseErrorHandler(){

            public void error(Error error) {
                arrayList.add(error);
            }
        };
        this.lastResult = this.parseBuffer(context, Sanitize.NONE);
        this.lastResult.setErrors(arrayList);
    }

    public Parser.Result getResult(Task task) throws ParseException {
        assert (this.lastResult != null) : "getResult() called prior parse()";
        return this.lastResult;
    }

    public void cancel() {
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private static String asString(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return (String)charSequence;
        }
        return ((Object)charSequence).toString();
    }

    private boolean sanitizeSource(Context context, Sanitize sanitize) {
        block25: {
            if (sanitize == Sanitize.MISSING_END) {
                context.sanitizedSource = context.source + "}";
                int n = context.source.length();
                context.sanitizedRange = new OffsetRange(n, n + 4);
                context.sanitizedContents = "";
                return true;
            }
            int n = context.caretOffset;
            if (sanitize == Sanitize.ERROR_DOT || sanitize == Sanitize.ERROR_LINE) {
                n = context.errorOffset;
            }
            if (n == -1) {
                return false;
            }
            String string = context.source;
            if (n > string.length()) {
                return false;
            }
            try {
                int n2;
                int n3;
                int n4;
                StringBuilder stringBuilder;
                block27: {
                    boolean bl;
                    String string2;
                    block30: {
                        block29: {
                            block28: {
                                block26: {
                                    int n5;
                                    if ((GsfUtilities.isRowEmpty((CharSequence)string, (int)n) || GsfUtilities.isRowWhite((CharSequence)string, (int)n)) && (n = GsfUtilities.getRowStart((CharSequence)string, (int)n) - 1) < 0) {
                                        n = 0;
                                    }
                                    if (GsfUtilities.isRowEmpty((CharSequence)string, (int)n) || GsfUtilities.isRowWhite((CharSequence)string, (int)n)) break block25;
                                    if (sanitize == Sanitize.EDITED_LINE || sanitize == Sanitize.ERROR_LINE) {
                                        int n6 = GsfUtilities.getRowLastNonWhite((CharSequence)string, (int)n);
                                        if (n6 != -1) {
                                            StringBuilder stringBuilder2 = new StringBuilder(string.length());
                                            int n7 = GsfUtilities.getRowStart((CharSequence)string, (int)n);
                                            if (++n6 >= n7 + 2) {
                                                stringBuilder2.append(string.substring(0, n7));
                                                stringBuilder2.append("//");
                                                int n8 = n7 + 2;
                                                if (n8 < string.length()) {
                                                    stringBuilder2.append(string.substring(n8, string.length()));
                                                }
                                            } else {
                                                stringBuilder2.append(string.substring(0, n7));
                                                stringBuilder2.append(" ");
                                                int n9 = n7 + 1;
                                                if (n9 < string.length()) {
                                                    stringBuilder2.append(string.substring(n9, string.length()));
                                                }
                                            }
                                            assert (stringBuilder2.length() == string.length());
                                            context.sanitizedRange = new OffsetRange(n7, n6);
                                            context.sanitizedSource = stringBuilder2.toString();
                                            context.sanitizedContents = string.substring(n7, n6);
                                            return true;
                                        }
                                        break block25;
                                    }
                                    assert (sanitize == Sanitize.ERROR_DOT || sanitize == Sanitize.EDITED_DOT);
                                    int n10 = GsfUtilities.getRowStart((CharSequence)string, (int)n);
                                    for (n5 = n - 1; n5 >= n10 && n5 < string.length() && Character.isWhitespace(string.charAt(n5)); --n5) {
                                    }
                                    if (n5 <= n10) break block25;
                                    stringBuilder = new StringBuilder(string.length());
                                    string2 = string.substring(n10, n5 + 1);
                                    n4 = 0;
                                    n3 = n5 + 1;
                                    boolean bl2 = bl = GsfUtilities.getRowLastNonWhite((CharSequence)context.source, (int)n5) <= n5;
                                    if (!string2.endsWith(".")) break block26;
                                    n4 = 1;
                                    break block27;
                                }
                                if (!string2.endsWith("(")) break block28;
                                if (!bl) break block27;
                                n4 = 1;
                                break block27;
                            }
                            if (!string2.endsWith(",")) break block29;
                            if (bl) break block27;
                            n4 = 1;
                            break block27;
                        }
                        if (!string2.endsWith(", ")) break block30;
                        if (bl) break block27;
                        n4 = 2;
                        break block27;
                    }
                    if (string2.endsWith(",)")) {
                        n4 = 1;
                        --n3;
                    } else if (string2.endsWith(", )")) {
                        n4 = 1;
                        n3 -= 2;
                    } else {
                        String[] stringArray = JsUtils.JAVASCRIPT_KEYWORDS;
                        n2 = stringArray.length;
                        for (int i = 0; i < n2; ++i) {
                            String string3 = stringArray[i];
                            if (!string2.endsWith(string3) || "var".equals(string3) && !bl) continue;
                            n4 = 1;
                            break;
                        }
                    }
                }
                if (n4 == 0) {
                    return false;
                }
                int n11 = n3 - n4;
                stringBuilder.append(string.substring(0, n11));
                for (n2 = 0; n2 < n4; ++n2) {
                    stringBuilder.append(' ');
                }
                if (n3 < string.length()) {
                    stringBuilder.append(string.substring(n3, string.length()));
                }
                assert (stringBuilder.length() == string.length());
                context.sanitizedRange = new OffsetRange(n11, n3);
                context.sanitizedSource = stringBuilder.toString();
                context.sanitizedContents = string.substring(n11, n3);
                return true;
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return false;
    }

    private final int lexToAst(Snapshot snapshot, int n) {
        if (snapshot != null) {
            return snapshot.getEmbeddedOffset(n);
        }
        return n;
    }

    private final int astToLex(Snapshot snapshot, int n) {
        if (snapshot != null) {
            return snapshot.getOriginalOffset(n);
        }
        return n;
    }

    public JsParseResult parse(Snapshot snapshot, EditHistory editHistory, ParserResult parserResult) {
        if (editHistory == null) {
            return null;
        }
        if ("json".equals(snapshot.getSource().getFileObject().getExt())) {
            return null;
        }
        JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)parserResult);
        if (jsParseResult == null) {
            return null;
        }
        Node node = jsParseResult.getRootNode();
        if (node == null) {
            return null;
        }
        if (editHistory.getStart() == -1) {
            return jsParseResult;
        }
        int n = this.lexToAst(jsParseResult.getSnapshot(), editHistory.getStart());
        if (n == -1) {
            return null;
        }
        AstPath astPath = new AstPath(node, n);
        ListIterator<Node> listIterator = astPath.leafToRoot();
        FunctionNode functionNode = null;
        while (listIterator.hasNext()) {
            Node node2 = listIterator.next();
            if (node2.getType() != 108) continue;
            functionNode = (FunctionNode)node2;
            break;
        }
        if (functionNode == null) {
            return null;
        }
        final int n2 = functionNode.getSourceStart();
        int n3 = functionNode.getSourceEnd();
        int n4 = this.lexToAst(jsParseResult.getSnapshot(), editHistory.getOriginalEnd());
        if (n == -1) {
            return null;
        }
        if (n4 > n3) {
            return null;
        }
        int n5 = this.astToLex(jsParseResult.getSnapshot(), n3);
        if (n5 == -1) {
            return null;
        }
        int n6 = editHistory.convertOriginalToEdited(n5);
        int n7 = this.lexToAst(jsParseResult.getSnapshot(), n6);
        if (n7 == -1) {
            return null;
        }
        Context context = new Context(snapshot, null);
        int n8 = context.source.length();
        if (n7 > n8 || n7 <= 0) {
            return null;
        }
        if (context.source.charAt(n7 - 1) != '}') {
            return null;
        }
        if (n2 > n7) {
            return null;
        }
        String string = context.source.substring(n2, n7);
        Sanitize sanitize = Sanitize.NEVER;
        boolean bl = false;
        Parser parser = this.createParser(context, bl, sanitize);
        context.parser = parser;
        if (sanitize == Sanitize.NONE) {
            context.errorOffset = -1;
        }
        int n9 = 0;
        try {
            OffsetRange offsetRange;
            final ArrayList<DefaultError> arrayList = new ArrayList<DefaultError>();
            context.errorHandler = new ParseErrorHandler(){

                public void error(Error error) {
                    DefaultError defaultError = (DefaultError)error;
                    int n = defaultError.getStartPosition();
                    int n22 = defaultError.getEndPosition();
                    if (n != -1) {
                        n += n2;
                    }
                    if (n22 != -1) {
                        n22 += n2;
                    }
                    defaultError.setOffsets(n, n22);
                    arrayList.add(defaultError);
                }
            };
            String string2 = context.source;
            int n10 = context.caretOffset;
            context.source = string;
            if (context.caretOffset >= n2 && context.caretOffset <= n7) {
                context.caretOffset -= n2;
                boolean bl2 = this.sanitizeSource(context, Sanitize.EDITED_DOT);
                if (bl2) {
                    assert (context.sanitizedSource != null);
                    bl = true;
                    string = context.sanitizedSource;
                    context.sanitized = Sanitize.EDITED_DOT;
                }
            }
            context.source = string2;
            context.caretOffset = n10;
            FunctionNode functionNode2 = parser.parseFunction(string, context.snapshot.getSource().getFileObject().getNameExt(), n9);
            if (functionNode2 == null) {
                return null;
            }
            this.adjustOffsets((Node)functionNode2, 0, n2);
            int n11 = this.lexToAst(context.snapshot, editHistory.getOriginalEnd());
            if (n11 == -1) {
                return null;
            }
            int n12 = editHistory.getSizeDelta();
            this.adjustOffsets(node, n11, n12);
            this.setParentRefs((Node)functionNode2, functionNode.getParentNode());
            functionNode.getParentNode().replaceChild((Node)functionNode, (Node)functionNode2);
            if (functionNode.labelNode != null) {
                functionNode2.labelNode = functionNode.labelNode;
                functionNode.labelNode.setLabelledNode((Node)functionNode2);
            }
            context.sanitized = sanitize;
            AstNodeAdapter astNodeAdapter = new AstNodeAdapter(null, node);
            JsParseResult jsParseResult2 = this.createParseResult(context.snapshot, node);
            JsParseResult.IncrementalParse incrementalParse = new JsParseResult.IncrementalParse(functionNode, functionNode2, n2, n11, n12, jsParseResult);
            jsParseResult2.setIncrementalParse(incrementalParse);
            if (bl) {
                offsetRange = new OffsetRange(context.sanitizedRange.getStart() + n2, context.sanitizedRange.getEnd() + n2);
                jsParseResult2.setSanitized(context.sanitized, offsetRange, context.sanitizedContents);
            }
            jsParseResult2.setSource(string);
            for (Error error : jsParseResult.getDiagnostics()) {
                DefaultError defaultError = (DefaultError)error;
                int n13 = defaultError.getStartPosition();
                int n14 = defaultError.getEndPosition();
                if (n13 >= n2 && n13 <= n3) continue;
                if (n13 >= n11 || n14 >= n11) {
                    if (n13 >= n11) {
                        n13 += n12;
                    }
                    if (n14 >= n11) {
                        n14 += n12;
                    }
                    defaultError.setOffsets(n13, n14);
                }
                arrayList.add(defaultError);
            }
            jsParseResult2.setErrors(arrayList);
            while (functionNode.hasChildren()) {
                offsetRange = functionNode.getFirstChild();
                functionNode.removeChild((Node)offsetRange);
            }
            return jsParseResult2;
        }
        catch (IllegalStateException illegalStateException) {
            runtimeException = illegalStateException;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            JsParser.runtimeException = runtimeException;
        }
        return null;
    }

    public static void dumpTree(Node node) {
        JsParser.dumpTree(node, 0);
    }

    private static void dumpTree(Node node, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("    ");
        }
        System.out.println(node.toString());
        if (node.hasChildren()) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                JsParser.dumpTree(node2, n + 1);
            }
        }
    }

    private void adjustOffsets(Node node, int n, int n2) {
        int n3 = node.getSourceStart();
        int n4 = node.getSourceEnd();
        if (n3 >= n) {
            n3 += n2;
        }
        if (n4 >= n) {
            n4 += n2;
        }
        node.setSourceBounds(n3, n4);
        if (node.hasChildren()) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                if (node2.getSourceEnd() < n) continue;
                this.adjustOffsets(node2, n, n2);
            }
        }
    }

    private JsParseResult sanitize(Context context, Sanitize sanitize) {
        switch (sanitize) {
            case NEVER: {
                return this.createParseResult(context.snapshot, null);
            }
            case NONE: {
                if (context.caretOffset != -1) {
                    return this.parseBuffer(context, Sanitize.EDITED_DOT);
                }
            }
            case EDITED_DOT: {
                if (context.errorOffset != -1 && context.errorOffset != context.caretOffset) {
                    return this.parseBuffer(context, Sanitize.ERROR_DOT);
                }
            }
            case ERROR_DOT: {
                if (context.errorOffset != -1) {
                    return this.parseBuffer(context, Sanitize.ERROR_LINE);
                }
            }
            case ERROR_LINE: {
                if (context.caretOffset != -1) {
                    return this.parseBuffer(context, Sanitize.EDITED_LINE);
                }
            }
            case EDITED_LINE: {
                return this.parseBuffer(context, Sanitize.MISSING_END);
            }
        }
        return this.createParseResult(context.snapshot, null);
    }

    protected void notifyError(Context context, String string, String string2, int n, String string3, int n2, Sanitize sanitize, Severity severity, String string4, Object object) {
        if (JsIndexer.PREINDEXING && severity == Severity.ERROR && context.snapshot.getSource().getFileObject().getNameExt().startsWith("stub_")) {
            System.err.println("\n\n\n**********************************************************\n**********************************************************\nParsing error for " + string + ", sourceName= " + string2 + ", line= " + n + ", lineSource=" + string3 + ", lineOffset=" + n2 + ", key=" + string4 + "\n" + "**********************************************************\n**********************************************************\n");
            System.exit(0);
        }
        int n3 = context.parser.getTokenStream().getBufferOffset();
        if ("msg.unexpected.eof".equals(string4) && n3 > 0) {
            --n3;
        }
        DefaultError defaultError = new DefaultError(string4, string, null, context.snapshot.getSource().getFileObject(), n3, n3, severity);
        if (object != null) {
            if (object instanceof Object[]) {
                defaultError.setParameters((Object[])object);
            } else {
                defaultError.setParameters(new Object[]{object});
            }
        }
        if (context.errorHandler != null) {
            context.errorHandler.error((Error)defaultError);
        }
        if (sanitize == Sanitize.NONE) {
            context.errorOffset = n3;
        }
    }

    protected JsParseResult parseBuffer(Context context, Sanitize sanitize) {
        boolean bl = false;
        String string = context.source;
        if (sanitize != Sanitize.NONE && sanitize != Sanitize.NEVER) {
            boolean bl2 = this.sanitizeSource(context, sanitize);
            if (bl2) {
                assert (context.sanitizedSource != null);
                bl = true;
                string = context.sanitizedSource;
            } else {
                return this.sanitize(context, sanitize);
            }
        }
        Parser parser = this.createParser(context, bl, sanitize);
        if (sanitize == Sanitize.NONE) {
            context.errorOffset = -1;
        }
        int n = 0;
        ScriptOrFnNode scriptOrFnNode = null;
        try {
            scriptOrFnNode = this.isJson(context) ? parser.parseJson(string, JsParser.getSourceUri(context.snapshot.getSource()), n) : parser.parse(string, JsParser.getSourceUri(context.snapshot.getSource()), n);
        }
        catch (IllegalStateException illegalStateException) {
            runtimeException = illegalStateException;
            illegalStateException.printStackTrace();
        }
        catch (RuntimeException runtimeException) {
            JsParser.runtimeException = runtimeException;
            runtimeException.printStackTrace();
        }
        if (scriptOrFnNode != null) {
            this.setParentRefs((Node)scriptOrFnNode, null);
            context.sanitized = sanitize;
            AstNodeAdapter astNodeAdapter = new AstNodeAdapter(null, (Node)scriptOrFnNode);
            JsParseResult jsParseResult = this.createParseResult(context.snapshot, (Node)scriptOrFnNode);
            jsParseResult.setSanitized(context.sanitized, context.sanitizedRange, context.sanitizedContents);
            jsParseResult.setSource(string);
            return jsParseResult;
        }
        return this.sanitize(context, sanitize);
    }

    protected Parser createParser(final Context context, boolean bl, final Sanitize sanitize) {
        final boolean bl2 = bl;
        CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
        ErrorReporter errorReporter = new ErrorReporter(){

            public void error(String string, String string2, int n, String string3, int n2, String string4, Object object) {
                if (!bl2) {
                    JsParser.this.notifyError(context, string, string2, n, string3, n2, sanitize, Severity.ERROR, string4, object);
                }
            }

            public EvaluatorException runtimeError(String string, String string2, int n, String string3, int n2) {
                if (!bl2) {
                    JsParser.this.notifyError(context, string, string2, n, string3, n2, sanitize, Severity.ERROR, "", null);
                }
                return null;
            }

            public void warning(String string, String string2, int n, String string3, int n2, String string4, Object object) {
                if (!bl2) {
                    JsParser.this.notifyError(context, string, string2, n, string3, n2, sanitize, Severity.WARNING, string4, object);
                }
            }
        };
        RhinoContext rhinoContext = new RhinoContext();
        compilerEnvirons.initFromContext((org.mozilla.nb.javascript.Context)rhinoContext);
        compilerEnvirons.setErrorReporter(errorReporter);
        int n = SupportedBrowsers.getInstance().getLanguageVersion();
        compilerEnvirons.setLanguageVersion(n);
        boolean bl3 = n == 0 || n >= 170;
        compilerEnvirons.setXmlAvailable(bl3);
        compilerEnvirons.setStrictMode(true);
        compilerEnvirons.setGeneratingSource(false);
        compilerEnvirons.setGenerateDebugInfo(false);
        compilerEnvirons.setReservedKeywordAsIdentifier(true);
        Parser parser = new Parser(compilerEnvirons, errorReporter);
        context.parser = parser;
        return parser;
    }

    private boolean isJson(Context context) {
        FileObject fileObject = context.snapshot.getSource().getFileObject();
        if (fileObject != null) {
            return "json".equals(fileObject.getExt());
        }
        return false;
    }

    private JsParseResult createParseResult(Snapshot snapshot, Node node) {
        if (node != null) {
            return new JsParseResult(this, snapshot, node);
        }
        return new JsParseResult(this, snapshot, null);
    }

    private void setParentRefs(Node node, Node node2) {
        assert (node.getParentNode() == null);
        node.setParentNode(node2);
        if (node.hasChildren()) {
            for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                this.setParentRefs(node3, node);
            }
        }
    }

    public static Element resolveHandle(JsParseResult jsParseResult, ElementHandle elementHandle) {
        if (elementHandle instanceof AstElement) {
            AstElement astElement = (AstElement)elementHandle;
            JsParseResult jsParseResult2 = astElement.getParseResult();
            if (jsParseResult2 == jsParseResult) {
                return astElement;
            }
            Node node = astElement.getNode();
            Node node2 = jsParseResult2.getRootNode();
            Node node3 = jsParseResult.getRootNode();
            if (node3 == null) {
                return null;
            }
            Node node4 = JsParser.find(node2, node, node3);
            if (node4 != null) {
                AstElement astElement2 = AstElement.getElement(jsParseResult, node4);
                return astElement2;
            }
        } else if (elementHandle instanceof JsElement) {
            return (JsElement)elementHandle;
        }
        return null;
    }

    private static Node find(Node node, Node node2, Node node3) {
        if (node == node2) {
            return node3;
        }
        Node node4 = node.getFirstChild();
        Node node5 = node3.getFirstChild();
        if (node4 == null || node5 == null) {
            return null;
        }
        while (node4 != null) {
            if (node5 == null) {
                return null;
            }
            if (node4 == node2) {
                return node5;
            }
            Node node6 = JsParser.find(node4, node2, node5);
            if (node6 != null) {
                return node6;
            }
            node4 = node4.getNext();
            node5 = node5.getNext();
        }
        if (node5 != null) {
            return null;
        }
        return null;
    }

    private static String getSourceUri(Source source) {
        FileObject fileObject = source.getFileObject();
        if (fileObject != null) {
            return fileObject.getNameExt();
        }
        return "fileless";
    }

    public static class Context {
        private final Snapshot snapshot;
        private final SourceModificationEvent event;
        private String source;
        private int caretOffset;
        private Parser parser;
        private ParseErrorHandler errorHandler;
        private int errorOffset;
        private String sanitizedSource;
        private OffsetRange sanitizedRange = OffsetRange.NONE;
        private String sanitizedContents;
        private Sanitize sanitized = Sanitize.NONE;

        public Context(Snapshot snapshot, SourceModificationEvent sourceModificationEvent) {
            this.snapshot = snapshot;
            this.event = sourceModificationEvent;
            this.source = JsParser.asString(snapshot.getText());
            this.caretOffset = GsfUtilities.getLastKnownCaretOffset((Snapshot)snapshot, (EventObject)sourceModificationEvent);
            if (this.caretOffset >= 0) {
                this.caretOffset = snapshot.getEmbeddedOffset(this.caretOffset);
            }
        }

        public String toString() {
            return "JsParser.Context(" + this.snapshot.getSource().getFileObject() + ")";
        }

        public OffsetRange getSanitizedRange() {
            return this.sanitizedRange;
        }

        public Sanitize getSanitized() {
            return this.sanitized;
        }

        public String getSanitizedSource() {
            return this.sanitizedSource;
        }

        public int getErrorOffset() {
            return this.errorOffset;
        }
    }

    private static interface ParseErrorHandler {
        public void error(Error var1);
    }

    private static final class RhinoContext
    extends org.mozilla.nb.javascript.Context {
        public RhinoContext() {
            super(ContextFactory.getGlobal());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sanitize {
        NEVER,
        NONE,
        EDITED_DOT,
        ERROR_DOT,
        ERROR_LINE,
        EDITED_LINE,
        MISSING_END;

    }
}

