/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.javascript.editing.ClassCache;
import org.netbeans.modules.javascript.editing.DuplicateElementSet;
import org.netbeans.modules.javascript.editing.IndexedElement;
import org.netbeans.modules.javascript.editing.IndexedFunction;
import org.netbeans.modules.javascript.editing.IndexedPackage;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.Pair;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsIndex {
    private static final Logger LOG = Logger.getLogger(JsIndex.class.getName());
    static int MAX_SEARCH_ITEMS = 160;
    private static final boolean ALL_REACHABLE = !Boolean.getBoolean("javascript.checkincludes");
    private static final String FIELD_SOURCE_NAME = "_sn";
    private static final String[] TERMS_FQN = new String[]{"fqn", "sdocurl"};
    private static final String[] TERMS_BASE = new String[]{"base", "sdocurl"};
    private static final String[] TERMS_EXTEND = new String[]{"extend"};
    private static final JsIndex EMPTY = new JsIndex(null);
    private final QuerySupport querySupport;

    private JsIndex(QuerySupport querySupport) {
        this.querySupport = querySupport;
    }

    public static JsIndex get(Collection<FileObject> collection) {
        try {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("JsIndex for roots: " + collection);
            }
            return new JsIndex(QuerySupport.forRoots((String)"javascript", (int)8, (FileObject[])collection.toArray(new FileObject[collection.size()])));
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
            return EMPTY;
        }
    }

    private Collection<? extends IndexResult> query(String string, String string2, QuerySupport.Kind kind, String ... stringArray) {
        if (this.querySupport != null) {
            try {
                return this.querySupport.query(string, string2, kind, stringArray);
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
            }
        }
        return Collections.emptySet();
    }

    public Pair<Set<IndexedElement>, Boolean> getConstructors(String string, QuerySupport.Kind kind) {
        return this.getUnknownFunctions(string, kind, true, null, true, false);
    }

    public Set<IndexedElement> getAllNames(String string, QuerySupport.Kind kind, JsParseResult jsParseResult) {
        return this.getUnknownFunctions(string, kind, false, jsParseResult, true, true).getA();
    }

    public Pair<Set<IndexedElement>, Boolean> getAllNamesTruncated(String string, QuerySupport.Kind kind, JsParseResult jsParseResult) {
        return this.getUnknownFunctions(string, kind, false, jsParseResult, true, true);
    }

    public Map<String, String> getAllExtends() {
        Collection<? extends IndexResult> collection = this.query("extend", "", QuerySupport.Kind.CASE_INSENSITIVE_PREFIX, TERMS_EXTEND);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (IndexResult indexResult : collection) {
            String[] stringArray = indexResult.getValues("extend");
            if (stringArray == null) continue;
            for (String string : stringArray) {
                int n = string.indexOf(59) + 1;
                int n2 = string.indexOf(59, n) + 1;
                String string2 = string.substring(n, n2 - 1);
                String string3 = string.substring(n2);
                hashMap.put(string2, string3);
            }
        }
        return hashMap;
    }

    public String getExtends(String string) {
        Collection<? extends IndexResult> collection = this.query("extend", string.toLowerCase(), QuerySupport.Kind.CASE_INSENSITIVE_PREFIX, TERMS_EXTEND);
        String string2 = string.toLowerCase() + ";";
        for (IndexResult indexResult : collection) {
            String[] stringArray = indexResult.getValues("extend");
            if (stringArray == null) continue;
            for (String string3 : stringArray) {
                int n;
                int n2;
                if (!string3.startsWith(string2) || !string.equals(string3.substring(n2 = string2.length(), n = string3.indexOf(59, n2)))) continue;
                return string3.substring(n + 1);
            }
        }
        return null;
    }

    public Set<IndexedElement> getElements(String string, String string2, QuerySupport.Kind kind, JsParseResult jsParseResult) {
        return this.getByFqn(string, string2, kind, false, jsParseResult, true, true, false);
    }

    public Set<IndexedElement> getElementsByFqn(String string, QuerySupport.Kind kind, JsParseResult jsParseResult) {
        String string2 = string;
        int n = string2.lastIndexOf(46);
        String string3 = null;
        if (n != -1) {
            string3 = string2.substring(0, n);
            string2 = string2.substring(n + 1);
        }
        return this.getByFqn(string2, string3, kind, false, jsParseResult, true, true, false);
    }

    public Set<IndexedElement> getAllElements(String string, String string2, QuerySupport.Kind kind, JsParseResult jsParseResult) {
        return this.getByFqn(string, string2, kind, false, jsParseResult, true, true, true);
    }

    public Set<IndexedFunction> getFunctions(String string, String string2, QuerySupport.Kind kind, JsParseResult jsParseResult, boolean bl) {
        return this.getByFqn(string, string2, kind, false, jsParseResult, bl, false, false);
    }

    private Pair<Set<IndexedElement>, Boolean> getUnknownFunctions(String string, QuerySupport.Kind kind, boolean bl, JsParseResult jsParseResult, boolean bl2, boolean bl3) {
        String string2 = "base";
        String[] stringArray = TERMS_BASE;
        QuerySupport.Kind kind2 = kind;
        if (kind == QuerySupport.Kind.EXACT) {
            kind = QuerySupport.Kind.PREFIX;
        }
        String string3 = string.toLowerCase();
        Collection<? extends IndexResult> collection = this.query(string2, string3, kind, stringArray);
        HashSet<IndexedElement> hashSet = new HashSet<IndexedElement>();
        String string4 = null;
        if (jsParseResult != null) {
            try {
                string4 = jsParseResult.getSnapshot().getSource().getFileObject().getURL().toExternalForm();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        }
        for (IndexResult indexResult : collection) {
            String[] stringArray2 = indexResult.getValues(string2);
            if (stringArray2 == null) continue;
            if (jsParseResult != null) {
                String string5 = indexResult.getValue(FIELD_SOURCE_NAME);
                if (string4 == null || !string4.equals(string5)) {
                    int n;
                    int n2 = n = string5.indexOf("jsstubs") != -1 ? 1 : 0;
                    if (n == 0 && !this.isReachable(jsParseResult, string5)) continue;
                }
            }
            for (String string6 : stringArray2) {
                String string7;
                IndexedElement indexedElement;
                boolean bl4;
                block23: {
                    if (kind == QuerySupport.Kind.PREFIX && !string6.startsWith(string3) || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && !string6.regionMatches(true, 0, string3, 0, string3.length())) continue;
                    if (kind == QuerySupport.Kind.CASE_INSENSITIVE_REGEXP) {
                        int n = string6.indexOf(59);
                        assert (n != -1);
                        String string8 = string6.substring(0, n);
                        try {
                            if (!string8.matches(string3)) {
                                continue;
                            }
                            break block23;
                        }
                        catch (Exception exception) {
                            break block23;
                        }
                    }
                    if (kind2 == QuerySupport.Kind.EXACT && string6.length() > string3.length() && string6.charAt(string3.length()) != ';') continue;
                }
                String string9 = null;
                int n = string6.indexOf(59);
                assert (n != -1);
                string9 = string6.substring(0, n);
                String string10 = null;
                int n3 = string6.indexOf(59, ++n);
                assert (n3 != -1);
                if (n3 > n + 1) {
                    string10 = string6.substring(n, n3);
                }
                int n4 = ++n3;
                n3 = string6.indexOf(59, n4);
                assert (n3 != -1);
                if (n3 > n4) {
                    string9 = string6.substring(n4, n3);
                    if (kind == QuerySupport.Kind.PREFIX && !string9.startsWith(string) || kind == QuerySupport.Kind.EXACT && !string9.equals(string)) continue;
                }
                if (!bl2 && string10 != null || (bl4 = (indexedElement = IndexedElement.create(string6, string7 = null, string9, string10, ++n3, this, indexResult, false)) instanceof IndexedFunction) && !bl2) continue;
                if (bl) {
                    if (indexedElement.getKind() == ElementKind.PROPERTY && string10 == null && Character.isUpperCase(string9.charAt(0))) {
                        indexedElement.setKind(ElementKind.CONSTRUCTOR);
                    } else if (indexedElement.getKind() != ElementKind.CONSTRUCTOR) {
                        continue;
                    }
                } else if (!bl4 && !bl3) continue;
                hashSet.add(indexedElement);
                if (hashSet.size() != MAX_SEARCH_ITEMS) continue;
                return new Pair<Set<IndexedElement>, Boolean>(hashSet, true);
            }
        }
        return new Pair<Set<IndexedElement>, Boolean>(hashSet, false);
    }

    private Set<IndexedElement> getByFqn(String string, String string2, QuerySupport.Kind kind, boolean bl, JsParseResult jsParseResult, boolean bl2, boolean bl3, boolean bl4) {
        String string3 = "fqn";
        String[] stringArray = TERMS_FQN;
        QuerySupport.Kind kind2 = kind;
        if (kind == QuerySupport.Kind.EXACT) {
            kind = QuerySupport.Kind.PREFIX;
        }
        if (kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_REGEXP) {
            // empty if block
        }
        Set<IndexedElement> set = bl4 ? new DuplicateElementSet() : new HashSet();
        String string4 = null;
        if (jsParseResult != null) {
            try {
                if (jsParseResult.getSnapshot().getSource().getFileObject() != null) {
                    string4 = jsParseResult.getSnapshot().getSource().getFileObject().getURL().toExternalForm();
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string2);
        boolean bl5 = false;
        boolean bl6 = string2 == null;
        while (true) {
            String string5 = string2 != null && string2.length() > 0 ? string2 + "." + string : string;
            String string6 = string5.toLowerCase();
            Collection<? extends IndexResult> collection = this.query(string3, string6, kind, stringArray);
            for (IndexResult indexResult : collection) {
                String[] stringArray2 = indexResult.getValues(string3);
                if (stringArray2 == null) continue;
                if (jsParseResult != null) {
                    String string7 = indexResult.getValue(FIELD_SOURCE_NAME);
                    if (string4 == null || !string4.equals(string7)) {
                        int n;
                        int n2 = n = string7.indexOf("jsstubs") != -1 ? 1 : 0;
                        if (n == 0 && !this.isReachable(jsParseResult, string7)) continue;
                    }
                }
                for (String string8 : stringArray2) {
                    int n;
                    block32: {
                        if (kind == QuerySupport.Kind.PREFIX && !string8.startsWith(string6) || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && !string8.regionMatches(true, 0, string6, 0, string6.length())) continue;
                        if (kind == QuerySupport.Kind.CASE_INSENSITIVE_REGEXP) {
                            int n3 = string8.indexOf(59);
                            assert (n3 != -1);
                            String string9 = string8.substring(0, n3);
                            try {
                                if (!string9.matches(string6)) {
                                    continue;
                                }
                                break block32;
                            }
                            catch (Exception exception) {
                                break block32;
                            }
                        }
                        if (kind2 == QuerySupport.Kind.EXACT && string8.length() > string6.length() && string8.charAt(string6.length()) != ';') continue;
                    }
                    String string10 = null;
                    int n4 = string8.indexOf(59);
                    assert (n4 != -1) : string8;
                    string10 = string8.substring(0, n4);
                    String string11 = null;
                    int n5 = string8.indexOf(59, ++n4);
                    assert (n5 != -1) : string8;
                    int n6 = ++n5;
                    n5 = string8.indexOf(59, n6);
                    assert (n5 != -1);
                    if (n5 > n6) {
                        string10 = string8.substring(n6, n5);
                        if (kind == QuerySupport.Kind.PREFIX && !string10.startsWith(string5) || kind == QuerySupport.Kind.EXACT && !string10.equals(string5)) continue;
                    }
                    ++n5;
                    int n7 = string10.lastIndexOf(46);
                    IndexedElement indexedElement = null;
                    if (string.length() < n7) {
                        n = string10.indexOf(46, string5.length());
                        if (n != -1) {
                            String string12;
                            int n8 = IndexedElement.decode(string8, n5, 0);
                            ElementKind elementKind = ElementKind.PACKAGE;
                            int n9 = string10.indexOf(46, n + 1);
                            if (n9 == -1) {
                                elementKind = ElementKind.CLASS;
                            }
                            if (string2 != null && string2.length() > 0) {
                                string12 = string10.substring(string2.length() + 1, n);
                                indexedElement = new IndexedPackage(null, string12, null, this, indexResult, string8, n8, elementKind);
                            } else {
                                string12 = string10.substring(0, n);
                                indexedElement = new IndexedPackage(null, string12, null, this, indexResult, string8, n8, elementKind);
                            }
                        } else {
                            string11 = string10.substring(0, n7);
                            string10 = string10.substring(n7 + 1);
                        }
                    } else if (n7 != -1) {
                        string11 = string10.substring(0, n7);
                        string10 = string10.substring(n7 + 1);
                    }
                    if (indexedElement == null) {
                        indexedElement = IndexedElement.create(string8, null, string10, string11, n5, this, indexResult, false);
                    }
                    if ((n = indexedElement instanceof IndexedFunction) != 0 && !bl2 || n == 0 && !bl3 || bl && indexedElement.getKind() != ElementKind.CONSTRUCTOR) continue;
                    if (!bl5) {
                        indexedElement.setSmart(true);
                    }
                    if (!bl6) {
                        indexedElement.setInherited(false);
                    }
                    set.add(indexedElement);
                }
            }
            if (string2 == null || "Object".equals(string2)) break;
            if ((string2 = this.getExtends(string2)) == null) {
                string2 = "Object";
                bl5 = true;
            }
            if (hashSet.contains(string2)) break;
            hashSet.add(string2);
            bl6 = true;
        }
        return set;
    }

    public String getType(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return this.getSimpleType(string);
        }
        String string2 = string.substring(0, n);
        List<String> list = ClassCache.INSTANCE.getAncestors(string2, this);
        if (list.size() <= 1) {
            return this.getSimpleType(string);
        }
        String string3 = string.substring(n + 1);
        int n2 = string3.length();
        HashSet hashSet = new HashSet();
        String string4 = "base";
        String[] stringArray = TERMS_BASE;
        String string5 = string3.toLowerCase();
        assert (string5.length() == n2);
        Collection<? extends IndexResult> collection = this.query(string4, string5, QuerySupport.Kind.PREFIX, stringArray);
        for (IndexResult indexResult : collection) {
            String[] stringArray2 = indexResult.getValues(string4);
            if (stringArray2 == null) continue;
            for (String string6 : stringArray2) {
                if (!string6.startsWith(string5) || string6.charAt(n2) != ';') continue;
                assert (string6.charAt(n2) == ';');
                int n3 = n2 + 1;
                int n4 = string6.indexOf(59, n3);
                if (n4 == n3) continue;
                String string7 = string6.substring(n3, n4);
                for (String string8 : list) {
                    String string9;
                    if (!string8.equals(string7) || (string9 = JsIndex.getTypeInSignature(string6)) == null) continue;
                    return string9;
                }
            }
        }
        return null;
    }

    private static String getTypeInSignature(String string) {
        int n;
        int n2 = 0;
        int n3 = 8;
        for (n = 0; n < n3; ++n) {
            n2 = string.indexOf(59, n2 + 1);
        }
        if ((n = string.indexOf(59, ++n2)) > n2) {
            return string.substring(n2, n);
        }
        return null;
    }

    private String getSimpleType(String string) {
        String string2 = "fqn";
        String[] stringArray = TERMS_FQN;
        String string3 = string.toLowerCase();
        int n = string.length();
        Collection<? extends IndexResult> collection = this.query(string2, string3, QuerySupport.Kind.PREFIX, stringArray);
        for (IndexResult indexResult : collection) {
            String[] stringArray2 = indexResult.getValues(string2);
            if (stringArray2 == null) continue;
            for (String string4 : stringArray2) {
                String string5;
                if (!string4.startsWith(string3) || string4.charAt(n) != ';' || (string5 = JsIndex.getTypeInSignature(string4)) == null) continue;
                return string5;
            }
        }
        return null;
    }

    public boolean isReachable(JsParseResult jsParseResult, String string) {
        if (ALL_REACHABLE) {
            return true;
        }
        List<String> list = jsParseResult.getStructure().getImports();
        if (list.size() > 0) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                int n2;
                String string2 = list.get(i);
                if (string2.indexOf("../") != -1 && (string2 = string2.substring((n2 = string2.lastIndexOf("../")) + 3)).length() == 0 || !string.endsWith(string2)) continue;
                return true;
            }
        }
        return false;
    }
}

