/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.mozilla.nb.javascript.Node;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.html.parser.SyntaxElement;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.AstPath;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.CommentElement;
import org.netbeans.modules.javascript.editing.Element;
import org.netbeans.modules.javascript.editing.ElementUtilities;
import org.netbeans.modules.javascript.editing.IndexedElement;
import org.netbeans.modules.javascript.editing.IndexedFunction;
import org.netbeans.modules.javascript.editing.IndexedPackage;
import org.netbeans.modules.javascript.editing.JsAnalyzer;
import org.netbeans.modules.javascript.editing.JsCommentFormatter;
import org.netbeans.modules.javascript.editing.JsDeclarationFinder;
import org.netbeans.modules.javascript.editing.JsIndex;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.JsParser;
import org.netbeans.modules.javascript.editing.JsTypeAnalyzer;
import org.netbeans.modules.javascript.editing.JsUtils;
import org.netbeans.modules.javascript.editing.KeywordElement;
import org.netbeans.modules.javascript.editing.Pair;
import org.netbeans.modules.javascript.editing.SupportedBrowsers;
import org.netbeans.modules.javascript.editing.VariableVisitor;
import org.netbeans.modules.javascript.editing.lexer.Call;
import org.netbeans.modules.javascript.editing.lexer.JsCommentLexer;
import org.netbeans.modules.javascript.editing.lexer.JsCommentTokenId;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsCodeCompletion
implements CodeCompletionHandler {
    private static final Logger LOG = Logger.getLogger(JsCodeCompletion.class.getName());
    static int MAX_COMPLETION_ITEMS = JsIndex.MAX_SEARCH_ITEMS;
    private static ImageIcon keywordIcon;
    private boolean caseSensitive;
    private static final String[] REGEXP_WORDS;
    private static final String[] STRING_ESCAPES;
    private static final String[] CSS_WORDS;
    private static final String[] JSDOC_WORDS;
    private static int callLineStart;
    private static IndexedFunction callMethod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeCompletionResult complete(CodeCompletionContext codeCompletionContext) {
        Document document;
        ParserResult parserResult = codeCompletionContext.getParserResult();
        int n = codeCompletionContext.getCaretOffset();
        String string = codeCompletionContext.getPrefix();
        QuerySupport.Kind kind = codeCompletionContext.isPrefixMatch() ? QuerySupport.Kind.PREFIX : QuerySupport.Kind.EXACT;
        CodeCompletionHandler.QueryType queryType = codeCompletionContext.getQueryType();
        this.caseSensitive = codeCompletionContext.isCaseSensitive();
        if (string == null) {
            string = "";
        }
        if ((document = parserResult.getSnapshot().getSource().getDocument(false)) == null) {
            return CodeCompletionResult.NONE;
        }
        BaseDocument baseDocument = (BaseDocument)document;
        ArrayList<CompletionProposal> arrayList = new ArrayList<CompletionProposal>();
        DefaultCompletionResult defaultCompletionResult = new DefaultCompletionResult(arrayList, false);
        JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)parserResult);
        baseDocument.readLock();
        try {
            Node node = jsParseResult != null ? jsParseResult.getRootNode() : null;
            int n2 = AstUtilities.getAstOffset((Parser.Result)parserResult, n);
            if (n2 == -1) {
                try {
                    if (n >= baseDocument.getLength() || n <= 0 || !"\"\"".equals(baseDocument.getText(n - 1, 2))) {
                        CodeCompletionResult codeCompletionResult = CodeCompletionResult.NONE;
                        return codeCompletionResult;
                    }
                    n2 = 0;
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                    CodeCompletionResult codeCompletionResult = CodeCompletionResult.NONE;
                    return codeCompletionResult;
                }
            }
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            FileObject fileObject = parserResult.getSnapshot().getSource().getFileObject();
            Call call = Call.getCallType(baseDocument, (TokenHierarchy<Document>)tokenHierarchy, n);
            CompletionRequest completionRequest = new CompletionRequest();
            completionRequest.completionResult = defaultCompletionResult;
            completionRequest.result = jsParseResult;
            completionRequest.lexOffset = n;
            completionRequest.astOffset = n2;
            completionRequest.index = JsIndex.get(QuerySupport.findRoots((FileObject)fileObject, null, Collections.singleton("JavascriptBootClassPath"), Collections.emptySet()));
            completionRequest.doc = baseDocument;
            completionRequest.info = AstUtilities.getParseResult((Parser.Result)parserResult);
            completionRequest.prefix = string;
            completionRequest.th = tokenHierarchy;
            completionRequest.kind = kind;
            completionRequest.queryType = queryType;
            completionRequest.fileObject = fileObject;
            completionRequest.anchor = n - string.length();
            completionRequest.call = call;
            Token<? extends JsTokenId> token = LexUtilities.getToken((Document)baseDocument, n);
            if (token == null) {
                if (JsUtils.isJsFile(fileObject) || JsUtils.isJsonFile(fileObject)) {
                    if (baseDocument.getLength() == 0) {
                        this.completeKeywords(arrayList, completionRequest);
                        completionRequest.prefix = "a";
                        defaultCompletionResult.setTruncated(true);
                        this.completeFunctions(arrayList, completionRequest);
                    }
                    DefaultCompletionResult defaultCompletionResult2 = defaultCompletionResult;
                    return defaultCompletionResult2;
                }
                string = "";
                completionRequest.prefix = "";
            } else {
                TokenId tokenId = token.id();
                if (tokenId == JsTokenId.LINE_COMMENT) {
                    DefaultCompletionResult defaultCompletionResult3 = defaultCompletionResult;
                    return defaultCompletionResult3;
                }
                if (tokenId == JsTokenId.BLOCK_COMMENT) {
                    try {
                        this.completeComments(arrayList, completionRequest);
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                    DefaultCompletionResult defaultCompletionResult4 = defaultCompletionResult;
                    return defaultCompletionResult4;
                }
                if (tokenId == JsTokenId.STRING_LITERAL || tokenId == JsTokenId.STRING_END) {
                    this.completeStrings(arrayList, completionRequest);
                    defaultCompletionResult.setFilterable(false);
                    DefaultCompletionResult defaultCompletionResult5 = defaultCompletionResult;
                    return defaultCompletionResult5;
                }
                if (tokenId == JsTokenId.REGEXP_LITERAL || tokenId == JsTokenId.REGEXP_END) {
                    this.completeRegexps(arrayList, completionRequest);
                    defaultCompletionResult.setFilterable(false);
                    DefaultCompletionResult defaultCompletionResult6 = defaultCompletionResult;
                    return defaultCompletionResult6;
                }
            }
            if (node != null) {
                int n3 = n2;
                OffsetRange offsetRange = jsParseResult.getSanitizedRange();
                if (offsetRange != OffsetRange.NONE && offsetRange.containsInclusive(n3)) {
                    n3 = offsetRange.getStart();
                }
                AstPath astPath = new AstPath(node, n3);
                completionRequest.path = astPath;
                completionRequest.fqn = AstUtilities.getFqn(astPath, null, null);
                Node node2 = astPath.leaf();
                if (node2.getType() == 48) {
                    this.completeRegexps(arrayList, completionRequest);
                    defaultCompletionResult.setFilterable(false);
                    DefaultCompletionResult defaultCompletionResult7 = defaultCompletionResult;
                    return defaultCompletionResult7;
                }
                completionRequest.root = node;
                completionRequest.node = node2;
            }
            if (this.completeParameters(arrayList, completionRequest)) {
                DefaultCompletionResult defaultCompletionResult8 = defaultCompletionResult;
                return defaultCompletionResult8;
            }
            if (node == null) {
                this.completeKeywords(arrayList, completionRequest);
                DefaultCompletionResult defaultCompletionResult9 = defaultCompletionResult;
                return defaultCompletionResult9;
            }
            if (this.completeNew(arrayList, completionRequest)) {
                DefaultCompletionResult defaultCompletionResult10 = defaultCompletionResult;
                return defaultCompletionResult10;
            }
            if (call.getLhs() != null || completionRequest.call.getPrevCallParenPos() != -1) {
                this.completeObjectMethod(arrayList, completionRequest);
                DefaultCompletionResult defaultCompletionResult11 = defaultCompletionResult;
                return defaultCompletionResult11;
            }
            this.completeKeywords(arrayList, completionRequest);
            this.addLocals(arrayList, completionRequest);
            if (this.completeObjectMethod(arrayList, completionRequest)) {
                DefaultCompletionResult defaultCompletionResult12 = defaultCompletionResult;
                return defaultCompletionResult12;
            }
            if (string.length() == 0 && !completionRequest.inCall) {
                completionRequest.prefix = "a";
                defaultCompletionResult.setTruncated(true);
            }
            if (this.completeFunctions(arrayList, completionRequest)) {
                DefaultCompletionResult defaultCompletionResult13 = defaultCompletionResult;
                return defaultCompletionResult13;
            }
        }
        finally {
            baseDocument.readUnlock();
        }
        return defaultCompletionResult;
    }

    private void addLocals(List<CompletionProposal> list, CompletionRequest completionRequest) {
        Object object;
        Node node = completionRequest.node;
        String string = completionRequest.prefix;
        QuerySupport.Kind kind = completionRequest.kind;
        JsParseResult jsParseResult = completionRequest.result;
        VariableVisitor variableVisitor = jsParseResult.getVariableVisitor();
        Map<String, List<Node>> map = variableVisitor.getLocalVars(node);
        for (String string2 : map.keySet()) {
            if ((kind != QuerySupport.Kind.EXACT || !string.equals(string2)) && (kind == QuerySupport.Kind.EXACT || !this.startsWith(string2, string)) || (object = map.get(string2)) == null || object.size() <= 0) continue;
            AstElement astElement = AstElement.getElement(completionRequest.info, (Node)object.get(0));
            list.add(new JsCompletionItem(astElement, completionRequest));
        }
        String string3 = "arguments";
        if (this.startsWith(string3, string)) {
            for (String string2 = node; string2 != null; string2 = string2.getParentNode()) {
                if (string2.getType() != 108) continue;
                object = new KeywordElement(string3, ElementKind.VARIABLE);
                list.add(new JsCompletionItem((Element)object, completionRequest));
                break;
            }
        }
    }

    private void completeKeywords(List<CompletionProposal> list, CompletionRequest completionRequest) {
        KeywordItem keywordItem;
        String[] stringArray;
        if (completionRequest.call.getLhs() != null) {
            return;
        }
        String string = completionRequest.prefix;
        for (String string2 : stringArray = completionRequest.inCall ? JsUtils.CALL_KEYWORDS : JsUtils.JAVASCRIPT_KEYWORDS) {
            if (!this.startsWith(string2, string)) continue;
            keywordItem = new KeywordItem(string2, null, completionRequest);
            list.add(keywordItem);
        }
        if (!completionRequest.inCall) {
            for (String string2 : JsUtils.JAVASCRIPT_RESERVED_WORDS) {
                if (!this.startsWith(string2, string)) continue;
                keywordItem = new KeywordItem(string2, null, completionRequest);
                list.add(keywordItem);
            }
        }
    }

    private boolean startsWith(String string, String string2) {
        if (string2.length() == 0) {
            return true;
        }
        return this.caseSensitive ? string.startsWith(string2) : string.toLowerCase().startsWith(string2.toLowerCase());
    }

    private boolean completeRegexps(List<CompletionProposal> list, CompletionRequest completionRequest) {
        String string = completionRequest.prefix;
        int n = REGEXP_WORDS.length;
        for (int i = 0; i < n; i += 2) {
            String string2 = REGEXP_WORDS[i];
            String string3 = REGEXP_WORDS[i + 1];
            if (!this.startsWith(string2, string)) continue;
            KeywordItem keywordItem = new KeywordItem(string2, string3, completionRequest);
            list.add(keywordItem);
        }
        return true;
    }

    private boolean completeComments(List<CompletionProposal> list, CompletionRequest completionRequest) throws BadLocationException {
        int n;
        int n2;
        String string = completionRequest.prefix;
        BaseDocument baseDocument = completionRequest.doc;
        int n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)completionRequest.lexOffset);
        if (n3 == -1) {
            return false;
        }
        String string2 = baseDocument.getText(n3, Utilities.getRowEnd((BaseDocument)baseDocument, (int)completionRequest.lexOffset) - n3);
        int n4 = completionRequest.lexOffset - n3;
        for (n2 = n4 - 1; n2 >= 0 && !Character.isWhitespace((char)(n = string2.charAt(n2))) && (Character.isLetterOrDigit((char)n) || n == 64 || n == 46 || n == 95); --n2) {
        }
        string = string2.substring(++n2, n4);
        completionRequest.anchor = n3 + n2;
        for (String string3 : JSDOC_WORDS) {
            if (!this.startsWith(string3, string)) continue;
            KeywordItem keywordItem = new KeywordItem(string3, null, completionRequest);
            list.add(keywordItem);
        }
        return true;
    }

    private boolean completeStrings(List<CompletionProposal> list, CompletionRequest completionRequest) {
        String string;
        String string2 = completionRequest.prefix;
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getPositionedSequence((Document)completionRequest.doc, completionRequest.lexOffset);
        assert (tokenSequence != null);
        int n = tokenSequence.offset();
        while (tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            TokenId tokenId = token.id();
            if (tokenId == JsTokenId.IDENTIFIER) {
                string = ((Object)token.text()).toString();
                if (!string.startsWith("$") && !string.equals("getElementById") && !string.startsWith("getElementsByTagName") && !string.equals("getElementsByName") && !"addClass".equals(string) && !"toggleClass".equals(string)) break;
                int n2 = completionRequest.lexOffset;
                if (n2 > n) {
                    try {
                        string2 = completionRequest.doc.getText(n, n2 - n);
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                } else {
                    string2 = "";
                }
                completionRequest.anchor = n;
                boolean bl = false;
                if (string.equals("$")) {
                    for (String string3 : completionRequest.result.getStructure().getImports()) {
                        if (string3.indexOf("jquery") == -1) continue;
                        bl = true;
                    }
                    if (!bl) {
                        boolean bl2 = bl = completionRequest.index.getType("jQuery") != null;
                    }
                }
                if ("getElementById".equals(string) || !bl && ("$".equals(string) || "$F".equals(string))) {
                    this.addElementIds(list, completionRequest, string2);
                } else if ("getElementsByName".equals(string)) {
                    this.addElementClasses(list, completionRequest, string2);
                } else if ("addClass".equals(string) || "toggleClass".equals(string)) {
                    this.addElementClasses(list, completionRequest, string2);
                } else if (string.startsWith("getElementsByTagName")) {
                    this.addTagNames(list, completionRequest, string2);
                } else if ("$$".equals(string) || bl && "$".equals(string) && bl) {
                    int n3;
                    int n4;
                    int n5 = 1;
                    int n6 = 2;
                    int n7 = 3;
                    int n8 = 4;
                    int n9 = n6;
                    block10: for (n4 = string2.length() - 1; n4 >= 0; --n4) {
                        n3 = string2.charAt(n4);
                        switch (n3) {
                            case 46: 
                            case 91: {
                                n9 = n5;
                                break block10;
                            }
                            case 35: {
                                n9 = n7;
                                break block10;
                            }
                            case 58: {
                                n9 = n8;
                                if (n4 <= 0 || string2.charAt(n4 - 1) != ':') break block10;
                                --n4;
                                break block10;
                            }
                            case 32: 
                            case 43: 
                            case 44: 
                            case 47: 
                            case 62: 
                            case 126: {
                                n9 = n6;
                                break block10;
                            }
                            default: {
                                if (Character.isLetter((char)n3)) continue block10;
                                n9 = n6;
                                break block10;
                            }
                        }
                    }
                    if (n4 >= 0) {
                        string2 = string2.substring(n4 + 1);
                    }
                    completionRequest.anchor = n + n4 + 1;
                    if (n9 == n6) {
                        this.addTagNames(list, completionRequest, string2);
                    } else if (n9 == n7) {
                        this.addElementIds(list, completionRequest, string2);
                    } else if (n9 == n8) {
                        int n10 = CSS_WORDS.length;
                        for (n3 = 0; n3 < n10; n3 += 2) {
                            String string4 = CSS_WORDS[n3];
                            String string5 = CSS_WORDS[n3 + '\u0001'];
                            if (string4.startsWith(":") && string2.length() == 0 || !this.startsWith(string4, string2)) continue;
                            if (string4.startsWith(":")) {
                                string4 = string4.substring(1);
                            }
                            GenericItem genericItem = new GenericItem(string4, string5, completionRequest, ElementKind.RULE);
                            list.add(genericItem);
                        }
                    } else {
                        assert (n9 == n5);
                        this.addElementClasses(list, completionRequest, string2);
                    }
                }
                return true;
            }
            if (tokenId == JsTokenId.STRING_BEGIN) {
                n = tokenSequence.offset() + token.length();
                continue;
            }
            if (tokenId == JsTokenId.WHITESPACE || tokenId == JsTokenId.STRING_LITERAL || tokenId == JsTokenId.LPAREN) continue;
            break;
        }
        int n11 = STRING_ESCAPES.length;
        for (int i = 0; i < n11; i += 2) {
            string = STRING_ESCAPES[i];
            String string6 = STRING_ESCAPES[i + 1];
            if (!this.startsWith(string, string2)) continue;
            KeywordItem keywordItem = new KeywordItem(string, string6, completionRequest);
            list.add(keywordItem);
        }
        return true;
    }

    private void addElementClasses(final List<CompletionProposal> list, final CompletionRequest completionRequest, final String string) {
        Source source = completionRequest.info.getSnapshot().getSource();
        if (source.getMimeType().equals("text/html")) {
            try {
                ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        HtmlParserResult htmlParserResult = (HtmlParserResult)resultIterator.getParserResult();
                        List list2 = htmlParserResult.elementsList();
                        HashSet<String> hashSet = new HashSet<String>();
                        for (Object object : list2) {
                            int n;
                            String string3;
                            int n2;
                            if (object.type() != 4 || (n2 = (string3 = ((Object)object.text()).toString()).indexOf("class=\"")) == -1 || (n = string3.indexOf(34, n2 + 7)) == -1 || n <= n2 + 1) continue;
                            String string2 = string3.substring(n2 + 7, n);
                            hashSet.add(string2);
                        }
                        String string4 = completionRequest.fileObject.getNameExt();
                        for (String string3 : hashSet) {
                            if (!JsCodeCompletion.this.startsWith(string3, string)) continue;
                            GenericItem genericItem = new GenericItem(string3, string4, completionRequest, ElementKind.TAG);
                            list.add(genericItem);
                        }
                    }
                });
            }
            catch (ParseException parseException) {
                LOG.log(Level.WARNING, null, parseException);
            }
        }
    }

    private void addTagNames(final List<CompletionProposal> list, final CompletionRequest completionRequest, final String string) {
        Source source = completionRequest.info.getSnapshot().getSource();
        if (source.getMimeType().equals("text/html")) {
            try {
                ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        HtmlParserResult htmlParserResult = (HtmlParserResult)resultIterator.getParserResult();
                        List list2 = htmlParserResult.elementsList();
                        HashSet<String> hashSet = new HashSet<String>();
                        for (Object object : list2) {
                            if (object.type() != 4) continue;
                            String string3 = ((Object)object.text()).toString();
                            int n = 1;
                            int n2 = string3.indexOf(32);
                            if (n2 == -1) {
                                n2 = string3.length() - 1;
                            }
                            String string2 = string3.substring(n, n2);
                            hashSet.add(string2);
                        }
                        String string4 = completionRequest.fileObject.getNameExt();
                        for (String string3 : hashSet) {
                            if (!JsCodeCompletion.this.startsWith(string3, string)) continue;
                            GenericItem genericItem = new GenericItem(string3, string4, completionRequest, ElementKind.TAG);
                            list.add(genericItem);
                        }
                    }
                });
            }
            catch (ParseException parseException) {
                LOG.log(Level.WARNING, null, parseException);
            }
        }
    }

    private void addElementIds(final List<CompletionProposal> list, final CompletionRequest completionRequest, final String string) {
        Source source = completionRequest.info.getSnapshot().getSource();
        if (source.getMimeType().equals("text/html")) {
            try {
                ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        HtmlParserResult htmlParserResult = (HtmlParserResult)resultIterator.getParserResult();
                        HashSet<SyntaxElement.TagAttribute> hashSet = new HashSet<SyntaxElement.TagAttribute>(htmlParserResult.elementsList().size() / 10);
                        for (Object object : htmlParserResult.elementsList()) {
                            SyntaxElement.TagAttribute tagAttribute;
                            if (object.type() != 4 || (tagAttribute = ((SyntaxElement.Tag)object).getAttribute("id")) == null) continue;
                            hashSet.add(tagAttribute);
                        }
                        String string3 = completionRequest.fileObject.getNameExt();
                        for (SyntaxElement.TagAttribute tagAttribute : hashSet) {
                            String string2 = tagAttribute.getValue();
                            if (string2.length() > 2 && string2.startsWith("\"") && string2.endsWith("\"")) {
                                string2 = string2.substring(1, string2.length() - 1);
                            }
                            System.out.println("~~~ elementId: '" + string2 + "'");
                            if (!JsCodeCompletion.this.startsWith(string2, string)) continue;
                            GenericItem genericItem = new GenericItem(string2, string3, completionRequest, ElementKind.TAG);
                            list.add(genericItem);
                        }
                    }
                });
            }
            catch (ParseException parseException) {
                LOG.log(Level.WARNING, null, parseException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPrefix(ParserResult parserResult, int n, boolean bl) {
        try {
            BaseDocument baseDocument = (BaseDocument)parserResult.getSnapshot().getSource().getDocument(false);
            if (baseDocument == null) {
                return null;
            }
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            baseDocument.readLock();
            try {
                int n2;
                int n3;
                String string;
                int n4;
                int n5;
                TokenId tokenId;
                Token token;
                TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(tokenHierarchy, n);
                if (tokenSequence == null) {
                    String string2 = null;
                    return string2;
                }
                tokenSequence.move(n);
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    String string3 = null;
                    return string3;
                }
                if (tokenSequence.offset() == n) {
                    tokenSequence.movePrevious();
                }
                if ((token = tokenSequence.token()) != null && ((tokenId = token.id()) == JsTokenId.STRING_BEGIN || tokenId == JsTokenId.STRING_END || tokenId == JsTokenId.STRING_LITERAL || tokenId == JsTokenId.REGEXP_LITERAL || tokenId == JsTokenId.REGEXP_BEGIN || tokenId == JsTokenId.REGEXP_END) && n > 0) {
                    char c = baseDocument.getText(n - 1, 1).charAt(0);
                    if (c == '\\') {
                        String string4 = "\\";
                        return string4;
                    }
                    String string5 = "";
                    return string5;
                }
                int n6 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                if (n6 == -1) return null;
                int n7 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                String string6 = baseDocument.getText(n6, n7 - n6);
                int n8 = n5 = n - n6;
                if (n5 > 0) {
                    int n9 = n5 - 1;
                    while (n9 >= 0 && JsUtils.isIdentifierChar((char)(n4 = (int)string6.charAt(n9)))) {
                        n8 = n9--;
                    }
                }
                if (bl) {
                    string = string6.substring(n8, n5);
                } else if (n5 == string6.length()) {
                    string = string6.substring(n8);
                } else {
                    char c;
                    n4 = string6.length();
                    n3 = n5;
                    for (n2 = n5; n2 < n4 && JsUtils.isStrictIdentifierChar(c = string6.charAt(n2)); ++n2) {
                        n3 = n2 + 1;
                    }
                    string = string6.substring(n8, n3);
                }
                if (string.length() <= 0) return null;
                if (string.endsWith("::")) {
                    String string7 = "";
                    return string7;
                }
                if (string.endsWith(":") && string.length() > 1) {
                    String string8 = null;
                    return string8;
                }
                n4 = string.lastIndexOf("::");
                if (n4 != -1) {
                    string = string.substring(n4 + 2);
                }
                if (string.length() == 1) {
                    n3 = string.charAt(0);
                    if (!Character.isJavaIdentifierPart((char)n3) && n3 != 64 && n3 != 36 && n3 != 58) {
                        String string9 = null;
                        return string9;
                    }
                } else {
                    for (n3 = string.length() - 2; n3 >= 0; --n3) {
                        n2 = string.charAt(n3);
                        if (n3 == 0 && n2 == 58 || Character.isJavaIdentifierPart((char)n2) || n2 == 64 || n2 == 36) continue;
                        string = string.substring(n3 + 1);
                        break;
                    }
                }
                String string10 = string;
                return string10;
            }
            finally {
                baseDocument.readUnlock();
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return null;
    }

    private boolean completeFunctions(List<CompletionProposal> list, CompletionRequest completionRequest) {
        Set<IndexedElement> set;
        Set<IndexedElement> set2;
        boolean bl;
        JsIndex jsIndex = completionRequest.index;
        String string = completionRequest.prefix;
        TokenHierarchy tokenHierarchy = completionRequest.th;
        QuerySupport.Kind kind = completionRequest.kind;
        String string2 = completionRequest.fqn;
        JsParseResult jsParseResult = completionRequest.result;
        boolean bl2 = bl = !completionRequest.inCall;
        if (string2 != null) {
            set2 = jsIndex.getElements(string, string2, kind, jsParseResult);
        } else {
            set = jsIndex.getAllNamesTruncated(string, kind, jsParseResult);
            set2 = ((Pair)((Object)set)).getA();
            boolean bl3 = ((Pair)((Object)set)).getB();
            if (bl3) {
                completionRequest.completionResult.setTruncated(true);
                bl = false;
            }
        }
        if (bl && (set = jsIndex.getElements(string, null, kind, jsParseResult)).size() > 0) {
            set2.addAll(set);
        }
        for (IndexedElement indexedElement : set2) {
            if (indexedElement.isNoDoc()) continue;
            JsCompletionItem jsCompletionItem = indexedElement instanceof IndexedFunction ? new FunctionItem((IndexedFunction)indexedElement, completionRequest) : new JsCompletionItem(completionRequest, indexedElement);
            list.add(jsCompletionItem);
        }
        return true;
    }

    private boolean completeObjectMethod(List<CompletionProposal> list, CompletionRequest completionRequest) {
        JsIndex jsIndex = completionRequest.index;
        String string = completionRequest.prefix;
        int n = completionRequest.astOffset;
        int n2 = completionRequest.lexOffset;
        Node node = completionRequest.root;
        TokenHierarchy tokenHierarchy = completionRequest.th;
        AstPath astPath = completionRequest.path;
        QuerySupport.Kind kind = completionRequest.kind;
        Node node2 = completionRequest.node;
        JsParseResult jsParseResult = completionRequest.result;
        JsParseResult jsParseResult2 = completionRequest.info;
        String string2 = completionRequest.fqn;
        Call call = completionRequest.call;
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(tokenHierarchy, n2);
        if (jsIndex != null && tokenSequence != null) {
            Set<IndexedElement> set;
            Node node3;
            Object object;
            Object object2;
            Object object3;
            Node node4;
            boolean bl = true;
            if (call == Call.LOCAL || call == Call.NONE) {
                return false;
            }
            boolean bl2 = call.isMethodExpected();
            Set<Object> set2 = Collections.emptySet();
            String string3 = call.getType();
            String string4 = call.getLhs();
            if (string3 == null && (node4 = AstUtilities.findLocalScope(node2, astPath)) != null) {
                object3 = new ArrayList<Node>();
                AstUtilities.addNodesByType(node4, new int[]{172}, object3);
                if (object3.size() > 0) {
                    object2 = (Node)object3.get(0);
                    object = new JsTypeAnalyzer(jsParseResult2, jsIndex, node4, node2, n, n2);
                    string3 = ((JsTypeAnalyzer)object).getType(object2.getParentNode());
                }
            }
            if (string3 == null && call.getPrevCallParenPos() != -1) {
                assert (call.getType() == null);
                assert (call.getLhs() == null);
                int n3 = AstUtilities.getAstOffset((Parser.Result)jsParseResult2, call.getPrevCallParenPos());
                if (n3 != -1) {
                    object3 = new AstPath(node, n3);
                    object2 = ((AstPath)object3).leafToRoot();
                    while (object2.hasNext() && (object = (Node)object2.next()).getType() != 108) {
                        JsTypeAnalyzer jsTypeAnalyzer;
                        Node node5;
                        if (object.getType() == 38) {
                            node5 = AstUtilities.findLocalScope(node2, astPath);
                            if (node5 != null) {
                                jsTypeAnalyzer = new JsTypeAnalyzer(jsParseResult2, jsIndex, node5, node2, n, n2);
                                string3 = jsTypeAnalyzer.getType((Node)object);
                            }
                        } else {
                            if (object.getType() != 36) continue;
                            node5 = AstUtilities.findLocalScope(node2, astPath);
                            if (node5 != null) {
                                jsTypeAnalyzer = new JsTypeAnalyzer(jsParseResult2, jsIndex, node5, node2, n, n2);
                                string3 = jsTypeAnalyzer.getType((Node)object);
                            }
                        }
                        break;
                    }
                }
            } else if (string3 == null && string4 != null && node2 != null && (node4 = AstUtilities.findLocalScope(node2, astPath)) != null) {
                object3 = new JsTypeAnalyzer(jsParseResult2, jsIndex, node4, node2, n, n2);
                string3 = ((JsTypeAnalyzer)object3).getType(node2);
            }
            if (string3 == null && string4 != null && node2 != null && call.isSimpleIdentifier() && (node3 = AstUtilities.findLocalScope(node2, astPath)) != null) {
                object3 = new JsTypeAnalyzer(jsParseResult2, jsIndex, node3, node2, n, n2);
                string3 = ((JsTypeAnalyzer)object3).getType(string4);
            }
            if (string3 != null && string3.startsWith("XML<") && string3.endsWith(">")) {
                String string5 = string3.substring(4, string3.length() - 1);
                this.addXmlItems(string5, list, completionRequest);
                return true;
            }
            if (string3 != null && string3.length() > 0) {
                if ("this".equals(string4)) {
                    string3 = string2;
                    bl = false;
                }
                if (string3 != null && string3.length() > 0) {
                    Set<IndexedElement> set3;
                    while (set2.size() == 0 && string2 != null && !string2.equals(string3)) {
                        set2 = jsIndex.getElements(string, string2 + "." + string3, kind, jsParseResult);
                        int n4 = string2.lastIndexOf("::");
                        if (n4 == -1) break;
                        string2 = string2.substring(0, n4);
                    }
                    if ((set3 = jsIndex.getElements(string, string3, kind, jsParseResult)).size() > 0) {
                        set2 = set3;
                    }
                }
            } else if (string4 != null && string4.length() > 0 && (set = jsIndex.getElements(string, string4, kind, jsParseResult)).size() > 0) {
                set2 = set;
            }
            if (set2.size() == 0 && (string.length() > 0 || string3 == null)) {
                Pair<Set<IndexedElement>, Boolean> pair = jsIndex.getAllNamesTruncated(string, kind, jsParseResult);
                set2 = pair.getA();
                boolean bl3 = pair.getB();
                if (bl3) {
                    completionRequest.completionResult.setTruncated(true);
                }
            }
            for (IndexedElement indexedElement : set2) {
                if (list.size() >= MAX_COMPLETION_ITEMS) {
                    completionRequest.completionResult.setTruncated(true);
                    return true;
                }
                if (bl && indexedElement.isPrivate() || indexedElement.isNoDoc()) continue;
                if (indexedElement instanceof IndexedFunction) {
                    object2 = new FunctionItem((IndexedFunction)indexedElement, completionRequest);
                    list.add((CompletionProposal)object2);
                    continue;
                }
                object2 = new JsCompletionItem(completionRequest, indexedElement);
                list.add((CompletionProposal)object2);
            }
            return bl2;
        }
        return false;
    }

    private void addXmlItems(String string, List<CompletionProposal> list, CompletionRequest completionRequest) {
        JsAnalyzer.XmlStructureItem xmlStructureItem = JsAnalyzer.XmlStructureItem.get(string, 0);
        HashSet<String> hashSet = new HashSet<String>();
        this.addXmlItems(xmlStructureItem, hashSet);
        QuerySupport.Kind kind = completionRequest.kind;
        String string2 = completionRequest.prefix;
        for (String string3 : hashSet) {
            if ((kind != QuerySupport.Kind.EXACT || !string2.equals(string3)) && (kind == QuerySupport.Kind.EXACT || !this.startsWith(string3, string2))) continue;
            KeywordItem keywordItem = new KeywordItem(string3, null, completionRequest);
            keywordItem.setKind(ElementKind.TAG);
            list.add(keywordItem);
        }
    }

    private void addXmlItems(StructureItem structureItem, Set<String> set) {
        set.add(structureItem.getName());
        for (StructureItem structureItem2 : structureItem.getNestedItems()) {
            this.addXmlItems(structureItem2, set);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean completeNew(List<CompletionProposal> list, CompletionRequest completionRequest) {
        JsIndex jsIndex = completionRequest.index;
        String string = completionRequest.prefix;
        int n = completionRequest.lexOffset;
        TokenHierarchy tokenHierarchy = completionRequest.th;
        QuerySupport.Kind kind = completionRequest.kind;
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(tokenHierarchy, n);
        if (jsIndex != null && tokenSequence != null) {
            Token token;
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return false;
            }
            if (tokenSequence.offset() == n) {
                tokenSequence.movePrevious();
            }
            if ((token = tokenSequence.token()) != null) {
                TokenId tokenId = token.id();
                if (tokenId == JsTokenId.IDENTIFIER || tokenId.primaryCategory().equals("keyword")) {
                    if (!tokenSequence.movePrevious()) {
                        return false;
                    }
                    token = tokenSequence.token();
                    tokenId = token.id();
                }
                if (tokenId != JsTokenId.WHITESPACE && tokenId != JsTokenId.EOL) {
                    return false;
                }
                while (tokenSequence.movePrevious() && (token = tokenSequence.token()).id() == JsTokenId.WHITESPACE) {
                }
                if (token.id() == JsTokenId.NEW) {
                    Set<IndexedElement> set;
                    String string2;
                    Pair<Set<IndexedElement>, Boolean> pair = jsIndex.getConstructors(string, kind);
                    Set<IndexedElement> set2 = pair.getA();
                    if (pair.getB().booleanValue()) {
                        completionRequest.completionResult.setTruncated(true);
                    }
                    if ((string2 = completionRequest.call.getLhs()) != null && string2.length() > 0) {
                        set = jsIndex.getElements(string, string2, kind, null);
                        if (set.size() > 0) {
                            if (set2.size() == 0) {
                                set2 = new HashSet<IndexedElement>();
                            }
                            for (IndexedElement indexedElement : set) {
                                if (indexedElement.getKind() != ElementKind.CONSTRUCTOR && indexedElement.getKind() != ElementKind.PACKAGE) continue;
                                set2.add(indexedElement);
                            }
                        }
                    } else if (string.length() > 0 && (set = jsIndex.getElements(string, null, kind, null)).size() > 0) {
                        if (set2.size() == 0) {
                            set2 = new HashSet<IndexedElement>();
                        }
                        for (IndexedElement indexedElement : set) {
                            if (indexedElement.getKind() != ElementKind.CONSTRUCTOR && indexedElement.getKind() != ElementKind.PACKAGE) continue;
                            set2.add(indexedElement);
                        }
                    }
                    for (IndexedElement indexedElement : set2) {
                        void var16_26;
                        if (list.size() >= MAX_COMPLETION_ITEMS) {
                            completionRequest.completionResult.setTruncated(true);
                            return true;
                        }
                        if (string.length() > 0 && !indexedElement.getName().startsWith(string) || indexedElement.isNoDoc()) continue;
                        if (indexedElement instanceof IndexedFunction) {
                            FunctionItem functionItem = new FunctionItem((IndexedFunction)indexedElement, completionRequest);
                        } else {
                            JsCompletionItem jsCompletionItem = new JsCompletionItem(completionRequest, indexedElement);
                        }
                        list.add((CompletionProposal)var16_26);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean completeParameters(List<CompletionProposal> list, CompletionRequest completionRequest) {
        Object object;
        Object object222;
        Collection<String> collection;
        int n;
        int n2;
        IndexedFunction[] indexedFunctionArray = new IndexedFunction[1];
        Set[] setArray = new Set[1];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        JsParseResult jsParseResult = completionRequest.info;
        if (!JsCodeCompletion.computeMethodCall(jsParseResult, n2 = completionRequest.lexOffset, n = completionRequest.astOffset, indexedFunctionArray, nArray, nArray2, setArray)) {
            completionRequest.inCall = false;
            return false;
        }
        completionRequest.inCall = true;
        IndexedFunction indexedFunction = indexedFunctionArray[0];
        int n3 = nArray[0];
        CallItem callItem = new CallItem(indexedFunction, n3, completionRequest);
        list.add(callItem);
        if (setArray[0] != null) {
            collection = new HashSet();
            collection.add(indexedFunction.getSignature().substring(indexedFunction.getSignature().indexOf(35) + 1));
            for (Object object222 : setArray[0]) {
                if (object222 == indexedFunction || !((IndexedElement)object222).isDocumented() || ((IndexedElement)object222).isNoDoc() || collection.contains(object = ((IndexedFunction)object222).getSignature().substring(((IndexedFunction)object222).getSignature().indexOf(35) + 1))) continue;
                CallItem callItem2 = new CallItem((IndexedFunction)object222, n3, completionRequest);
                list.add(callItem2);
                collection.add((String)object);
            }
        }
        if ((collection = indexedFunction.getParameters()) == null || collection.size() == 0) {
            return false;
        }
        if (collection.size() <= n3) {
            n3 = collection.size() - 1;
        }
        Object object3 = null;
        object222 = completionRequest.path;
        object = ((AstPath)object222).leaf();
        int n4 = object.getType();
        if (n4 == 66 || n4 == 165) {
            Node node;
            int n5;
            if (n4 == 165) {
                object = object.getParentNode();
            }
            if ((n5 = (node = object.getParentNode()).getType()) == 38 || n5 == 30) {
                Object object2;
                String string3;
                Object object5;
                String string2;
                int n6 = collection.size() - 1;
                if (n3 > n6) {
                    n3 = n6;
                }
                if (n3 >= 0) {
                    string2 = (String)collection.get(n3);
                    int n7 = string2.indexOf(58);
                    if (n7 != -1) {
                        object5 = string2.substring(n7 + 1);
                        string2 = string2.substring(0, n7);
                        object3 = object5;
                    }
                    if ((object3 == null || "Object".equals(object3)) && indexedFunction.isDocumented()) {
                        object5 = completionRequest.prefix;
                        boolean bl = false;
                        List<String> list2 = ElementUtilities.getComments(jsParseResult, indexedFunction);
                        if (list2 != null && list2.size() > 0) {
                            StringBuilder stringBuilder = new StringBuilder();
                            for (String string3 : list2) {
                                stringBuilder.append(string3);
                                stringBuilder.append("\n");
                            }
                            stringBuilder.setLength(stringBuilder.length() - 1);
                            TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)stringBuilder.toString(), JsCommentTokenId.language());
                            string3 = tokenHierarchy.tokenSequence(JsCommentTokenId.language());
                            object2 = null;
                            while (string3 != null && string3.moveNext()) {
                                String string4;
                                String string5;
                                int n8;
                                Token token = string3.token();
                                TokenId tokenId = token.id();
                                if (tokenId != JsCommentTokenId.COMMENT_TAG) continue;
                                CharSequence charSequence = token.text();
                                if (TokenUtilities.textEquals((CharSequence)"@param", (CharSequence)charSequence) || TokenUtilities.textEquals((CharSequence)"@argument", (CharSequence)charSequence)) {
                                    n8 = string3.index();
                                    string5 = JsCommentLexer.nextType((TokenSequence<? extends JsCommentTokenId>)string3);
                                    if (string5 == null) {
                                        string3.moveIndex(n8);
                                        string3.moveNext();
                                    }
                                    if ((string4 = JsCommentLexer.nextIdent((TokenSequence<? extends JsCommentTokenId>)string3)) != null) {
                                        object2 = string4;
                                        continue;
                                    }
                                    string3.moveIndex(n8);
                                    string3.moveNext();
                                    continue;
                                }
                                if (!TokenUtilities.textEquals((CharSequence)"@config", (CharSequence)charSequence) && !TokenUtilities.textEquals((CharSequence)"@cfg", (CharSequence)charSequence)) continue;
                                n8 = string3.index();
                                string5 = JsCommentLexer.nextType((TokenSequence<? extends JsCommentTokenId>)string3);
                                if (string5 == null) {
                                    string3.moveIndex(n8);
                                    string3.moveNext();
                                }
                                if ((string4 = JsCommentLexer.nextIdent((TokenSequence<? extends JsCommentTokenId>)string3)) != null && (object2 == null || ((String)object2).equals(string2))) {
                                    int n9 = string3.index();
                                    StringBuilder stringBuilder2 = new StringBuilder();
                                    boolean bl2 = false;
                                    while (string3.moveNext() && ((charSequence = string3.token().text()).length() <= 0 || charSequence.charAt(0) != '@' || string3.token().id() != JsCommentTokenId.COMMENT_TAG)) {
                                        if (bl2) continue;
                                        stringBuilder2.append(charSequence);
                                        int n10 = 40;
                                        if (stringBuilder2.length() <= n10) continue;
                                        stringBuilder2.setLength(n10 - 3);
                                        stringBuilder2.append("...");
                                        bl2 = true;
                                        break;
                                    }
                                    String string6 = stringBuilder2.toString().trim();
                                    if (string5 != null) {
                                        string6 = string6.length() > 0 ? "{" + string5 + "} " + string6 : string5;
                                    }
                                    string3.moveIndex(n9);
                                    if (!this.startsWith(string4, (String)object5)) continue;
                                    GenericItem genericItem = new GenericItem(string4, string6, completionRequest, ElementKind.PARAMETER);
                                    genericItem.element = indexedFunction;
                                    list.add(genericItem);
                                    bl = true;
                                    continue;
                                }
                                string3.moveIndex(n8);
                                string3.moveNext();
                            }
                        }
                        if (bl) {
                            return true;
                        }
                    }
                }
                if (indexedFunction.getKind() == ElementKind.CONSTRUCTOR && (object3 == null || "Object".equals(object3))) {
                    object3 = !Character.isUpperCase(indexedFunction.getName().charAt(0)) && indexedFunction.getIn().length() > 0 ? indexedFunction.getIn() : indexedFunction.getFqn();
                }
                string2 = completionRequest.prefix;
                QuerySupport.Kind kind = completionRequest.kind;
                object5 = completionRequest.result;
                Set<IndexedElement> set = completionRequest.index.getElements(string2, (String)object3, kind, (JsParseResult)((Object)object5));
                boolean bl = false;
                for (IndexedElement indexedElement : set) {
                    if (indexedElement.isNoDoc() || indexedElement.getKind() == ElementKind.METHOD || indexedElement.getKind() == ElementKind.CONSTRUCTOR || Character.isUpperCase((string3 = indexedElement.getName()).charAt(0)) || indexedElement.isPrivate()) continue;
                    object2 = indexedElement instanceof IndexedFunction ? new FunctionItem((IndexedFunction)indexedElement, completionRequest) : new JsCompletionItem(completionRequest, indexedElement);
                    bl = true;
                    list.add((CompletionProposal)object2);
                }
                if (bl) {
                    return true;
                }
            }
        }
        return false;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent jTextComponent, String string) {
        char c = string.charAt(0);
        if (c == '\n' || c == '(' || c == '[' || c == '{' || c == ';') {
            return CodeCompletionHandler.QueryType.STOP;
        }
        if (c != '.') {
            return CodeCompletionHandler.QueryType.NONE;
        }
        int n = jTextComponent.getCaretPosition();
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        if (".".equals(string)) {
            TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence((Document)baseDocument, n);
            if (tokenSequence == null) {
                return CodeCompletionHandler.QueryType.NONE;
            }
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return CodeCompletionHandler.QueryType.NONE;
            }
            if (tokenSequence.offset() == n && !tokenSequence.movePrevious()) {
                return CodeCompletionHandler.QueryType.NONE;
            }
            Token token = tokenSequence.token();
            TokenId tokenId = token.id();
            if ("comment".equals(tokenId.primaryCategory()) || "string".equals(tokenId.primaryCategory()) || "mod-regexp".equals(tokenId.primaryCategory())) {
                return CodeCompletionHandler.QueryType.NONE;
            }
            return CodeCompletionHandler.QueryType.COMPLETION;
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    public static boolean isJsContext(BaseDocument baseDocument, int n) {
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence((Document)baseDocument, n);
        if (tokenSequence == null) {
            return false;
        }
        tokenSequence.move(n);
        if (!tokenSequence.movePrevious() && !tokenSequence.moveNext()) {
            return true;
        }
        TokenId tokenId = tokenSequence.token().id();
        return !"comment".equals(tokenId.primaryCategory()) && !"string".equals(tokenId.primaryCategory()) && !"mod-regexp".equals(tokenId.primaryCategory());
    }

    public String resolveTemplateVariable(String string, ParserResult parserResult, int n, String string2, Map map) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String document(ParserResult parserResult, ElementHandle elementHandle) {
        Object object;
        Object object2;
        JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)parserResult);
        if (jsParseResult == null) {
            return null;
        }
        Object object3 = ElementUtilities.getElement(jsParseResult, elementHandle);
        if (object3 == null) {
            return null;
        }
        if (object3 instanceof IndexedPackage) {
            return null;
        }
        if (object3 instanceof CommentElement) {
            String string = object3.getName();
            String[] stringArray = string.split("\n");
            StringBuilder stringBuilder = new StringBuilder();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                if (string2.startsWith("/**")) {
                    stringBuilder.append(string2.substring(3));
                    continue;
                }
                if (i == n - 1 && string2.trim().endsWith("*/")) {
                    stringBuilder.append(string2.substring(0, string2.length() - 2));
                    continue;
                }
                if (string2.startsWith("//")) {
                    stringBuilder.append(string2.substring(2));
                    continue;
                }
                if (string2.startsWith("/*")) {
                    stringBuilder.append(string2.substring(2));
                    continue;
                }
                if (string2.startsWith("*")) {
                    stringBuilder.append(string2.substring(1));
                    continue;
                }
                stringBuilder.append(string2);
            }
            String string3 = stringBuilder.toString();
            return string3;
        }
        if (object3 instanceof KeywordElement) {
            return null;
        }
        if (object3 instanceof IndexedElement && !((IndexedElement)(object2 = (IndexedElement)object3)).isDocumented() && (object = ((IndexedElement)object2).findDocumentedSibling()) != null) {
            object3 = object;
        }
        if ((object2 = ElementUtilities.getComments(jsParseResult, (Element)object3)) == null) {
            object = ElementUtilities.getSignature((Element)object3) + "\n<hr>\n<i>" + NbBundle.getMessage(JsCodeCompletion.class, (String)"NoCommentFound") + "</i>";
            return object;
        }
        object = new JsCommentFormatter((List<String>)object2);
        String string = object3.getName();
        if (string != null && string.length() > 0) {
            ((JsCommentFormatter)object).setSeqName(string);
        }
        String string4 = ((JsCommentFormatter)object).toHtml();
        string4 = ElementUtilities.getSignature((Element)object3) + "\n<hr>\n" + string4;
        return string4;
    }

    public Set<String> getApplicableTemplates(ParserResult parserResult, int n, int n2) {
        return Collections.emptySet();
    }

    public ParameterInfo parameters(ParserResult parserResult, int n, CompletionProposal completionProposal) {
        JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)parserResult);
        if (jsParseResult == null) {
            return ParameterInfo.NONE;
        }
        IndexedFunction[] indexedFunctionArray = new IndexedFunction[1];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n2 = AstUtilities.getAstOffset((Parser.Result)parserResult, n);
        if (!JsCodeCompletion.computeMethodCall(jsParseResult, n, n2, indexedFunctionArray, nArray, nArray2, null)) {
            return ParameterInfo.NONE;
        }
        IndexedFunction indexedFunction = indexedFunctionArray[0];
        if (indexedFunction == null) {
            return ParameterInfo.NONE;
        }
        int n3 = nArray[0];
        int n4 = nArray2[0];
        int n5 = LexUtilities.getLexerOffset(jsParseResult, n4);
        List<String> list = indexedFunction.getParameters();
        if (list != null && list.size() > 0) {
            return new ParameterInfo(list, n3, n5);
        }
        return ParameterInfo.NONE;
    }

    static boolean computeMethodCall(JsParseResult jsParseResult, int n, int n2, IndexedFunction[] indexedFunctionArray, int[] nArray, int[] nArray2, Set<IndexedFunction>[] setArray) {
        try {
            boolean bl;
            Node node;
            Object object;
            JsParseResult jsParseResult2;
            OffsetRange offsetRange;
            Node node2 = jsParseResult.getRootNode();
            if (node2 == null) {
                return false;
            }
            IndexedFunction indexedFunction = null;
            int n3 = -1;
            AstPath astPath = null;
            int n4 = n2;
            BaseDocument baseDocument = (BaseDocument)jsParseResult.getSnapshot().getSource().getDocument(false);
            if (baseDocument == null) {
                return false;
            }
            int n5 = LexUtilities.findSpaceBegin(baseDocument, n);
            if (n5 < n) {
                n2 -= n - n5;
            }
            if ((offsetRange = (jsParseResult2 = AstUtilities.getParseResult((Parser.Result)jsParseResult)).getSanitizedRange()) != OffsetRange.NONE && offsetRange.containsInclusive(n2) && n2 != offsetRange.getStart()) {
                n2 = offsetRange.getStart() - 1;
                if (n2 < 0) {
                    n2 = 0;
                }
                astPath = new AstPath(node2, n2);
            }
            if (astPath == null) {
                astPath = new AstPath(node2, n2);
            }
            int n6 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            if (callLineStart == -1 || n6 != callLineStart || (indexedFunction = callMethod) != null) {
                // empty if block
            }
            Node node3 = null;
            int n7 = -1;
            if (indexedFunction != null) {
                ListIterator<Node> listIterator = astPath.leafToRoot();
                object = indexedFunction.getName();
                while (listIterator.hasNext()) {
                    node = (Node)listIterator.next();
                }
            }
            boolean bl2 = bl = jsParseResult2.getSanitized() == JsParser.Sanitize.EDITED_DOT || jsParseResult2.getSanitized() == JsParser.Sanitize.ERROR_DOT;
            if (bl && jsParseResult2.getSanitizedContents().indexOf(44) == -1) {
                bl = false;
            }
            if (node3 == null) {
                int n8;
                object = astPath.leafToRoot();
                while (object.hasNext() && (n8 = (node = (Node)object.next()).getType()) != 108) {
                    if (n8 != 38 && n8 != 30) continue;
                    node3 = node;
                    n3 = AstUtilities.findArgumentIndex(node3, n2, astPath);
                    break;
                }
            }
            if (n3 != -1 && bl && node3 != null) {
                object = null;
                ++n3;
            }
            if (node3 == null || n3 == -1) {
                callLineStart = -1;
                callMethod = null;
                return false;
            }
            if (indexedFunction == null && (indexedFunction = new JsDeclarationFinder().findMethodDeclaration(jsParseResult, node3, astPath, setArray)) == null) {
                return false;
            }
            callLineStart = n6;
            indexedFunctionArray[0] = callMethod = indexedFunction;
            nArray[0] = n3;
            if (n7 == -1) {
                n7 = node3.getSourceStart();
            }
            nArray2[0] = n7;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return false;
        }
        return true;
    }

    public ElementHandle resolveLink(String string, ElementHandle elementHandle) {
        if (string.indexOf(58) != -1) {
            string = string.replace(':', '.');
            return new ElementHandle.UrlHandle(string);
        }
        return null;
    }

    static {
        REGEXP_WORDS = new String[]{"\\0", "The NUL character (\\u0000)", "\\t", "Tab (\\u0009)", "\\n", "Newline (\\u000A)", "\\v", "Vertical tab (\\u000B)", "\\f", "Form feed (\\u000C)", "\\r", "Carriage return (\\u000D)", "\\x", "\\x<i>nn</i>: The latin character in hex <i>nn</i>", "\\u", "\\u<i>xxxx</i>: The Unicode character in hex <i>xxxx</i>", "\\c", "\\c<i>X</i>: The control character ^<i>X</i>", "[]", "Any one character between the brackets", "[^]", "Any one character not between the brackets", "\\w", "Any ASCII word character; same as [0-9A-Za-z_]", "\\W", "Not a word character; same as [^0-9A-Za-z_]", "\\s", "Unicode space character", "\\S", "Non-space character", "\\d", "Digit character; same as [0-9]", "\\D", "Non-digit character; same as [^0-9]", "[\\b]", "Literal backspace", "^", "Start of line", "$", "End of line", "\\b", "Word boundary (if not in a range specification)", "\\B", "Non-word boundary", "*", "Zero or more repetitions of the preceding", "+", "One or more repetitions of the preceding", "{m,n}", "At least m and at most n repetitions of the preceding", "?", "At most one repetition of the preceding; same as {0,1}", "|", "Either preceding or next expression may match", "()", "Grouping"};
        STRING_ESCAPES = new String[]{"\\0", "The NUL character (\\u0000)", "\\b", "Backspace (0x08)", "\\t", "Tab (\\u0009)", "\\n", "Newline (\\u000A)", "\\v", "Vertical tab (\\u000B)", "\\f", "Form feed (\\u000C)", "\\r", "Carriage return (\\u000D)", "\\\"", "Double Quote (\\u0022)", "\\'", "Single Quote (\\u0027)", "\\\\", "Backslash (\\u005C)", "\\x", "\\x<i>nn</i>: The latin character in hex <i>nn</i>", "\\u", "\\u<i>xxxx</i>: The Unicode character in hex <i>xxxx</i>", "\\", "\\<i>ooo</i>: The latin character in octal <i>ooo</i>", "\\c", "\\c<i>X</i>: The control character ^<i>X</i>"};
        CSS_WORDS = new String[]{"nth-child()", "The n-th child of its parent", "first-child", "First child of its parent", "last-child", "Last child of its parent", "only-child", "Only child of its parent", "empty", "Has no children (including text nodes)", "enabled", "Element which is not disabled", "disabled", "Element which is disabled", "checked", "Element which is checked (checkbox, ...)", "selected", "Element which is selected (e.g. in a select)", "link", "Not yet visited hyperlink", "visited", "Already visited hyperlink", "active", "", "hover", "", "focus", "Element during user actions", "target", "Target of the referring URI", "lang()", "Element in given language", ":first-line", "The first formatted line", ":first-letter", "The first formatted letter", ":selection", "Portion currently highlighted by the user", ":before", "Generated content before an element", ":after", "Generated content after an element", "even", "Selects every other (even) element", "odd", "Selects every other (odd) element", "eq()", "Selects the Nth element", "nth()", "Selects the Nth element", "gt()", "Selects elements whose index is greater than N", "lt()", "Selects elements whose index is less than N", "first", "Equivalent to :eq(0)", "last", "Selects the last matched element", "parent", "Elements that have children (including text)", "contains('", "Elements which contain the specified text", "visible", "Selects all visible elements", "hidden", "Selects all hidden elements", "input", "All form elements", "text", "All text fields (type=\"text\")", "password", "All password fields (type=\"password\")", "radio", "All radio fields (type=\"radio\")", "checkbox", "All checkbox fields (type=\"checkbox\")", "submit", "All submit buttons (type=\"submit\")", "image", "All form images (type=\"image\")", "reset", "All reset buttons (type=\"reset\")", "button", "All other buttons (type=\"button\")", "file", "All file uploads (type=\"file\")"};
        JSDOC_WORDS = new String[]{"@augments", "@class", "@config", "@constructor", "@deprecated", "@description", "@event", "@example", "@exception", "@fileOverview", "@function", "@ignore", "@inherits", "@memberOf", "@name", "@namespace", "@param", "@private", "@property", "@return", "@scope", "@static", "@type"};
        callLineStart = -1;
    }

    private class CallItem
    extends FunctionItem {
        private int index;

        CallItem(IndexedFunction indexedFunction, int n, CompletionRequest completionRequest) {
            super(indexedFunction, completionRequest);
            this.index = n;
        }

        public ElementKind getKind() {
            return ElementKind.CALL;
        }

        public String getInsertPrefix() {
            return "";
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            ElementKind elementKind = this.getKind();
            htmlFormatter.name(elementKind, true);
            htmlFormatter.appendText(this.getName());
            List<String> list = this.function.getParameters();
            if (list != null && list.size() > 0) {
                htmlFormatter.appendHtml("(");
                if (this.index > 0 && this.index < list.size()) {
                    htmlFormatter.appendText("... , ");
                }
                htmlFormatter.active(true);
                htmlFormatter.appendText(list.get(Math.min(list.size() - 1, this.index)));
                htmlFormatter.active(false);
                if (this.index < list.size() - 1) {
                    htmlFormatter.appendText(", ...");
                }
                htmlFormatter.appendHtml(")");
            }
            htmlFormatter.name(elementKind, false);
            return htmlFormatter.getText();
        }

        public boolean isSmart() {
            return true;
        }

        public String getCustomInsertTemplate() {
            return null;
        }
    }

    private static class CompletionRequest {
        private DefaultCompletionResult completionResult;
        private TokenHierarchy<Document> th;
        private JsParseResult info;
        private AstPath path;
        private Node node;
        private Node root;
        private int anchor;
        private int lexOffset;
        private int astOffset;
        private BaseDocument doc;
        private String prefix;
        private JsIndex index;
        private QuerySupport.Kind kind;
        private JsParseResult result;
        private CodeCompletionHandler.QueryType queryType;
        private FileObject fileObject;
        private Call call;
        private boolean inCall;
        private String fqn;

        private CompletionRequest() {
        }
    }

    private class FunctionItem
    extends JsCompletionItem {
        protected IndexedFunction function;

        FunctionItem(IndexedFunction indexedFunction, CompletionRequest completionRequest) {
            super(completionRequest, indexedFunction);
            this.function = indexedFunction;
        }

        public String getInsertPrefix() {
            return this.getName();
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            boolean bl;
            boolean bl2;
            ElementKind elementKind = this.getKind();
            boolean bl3 = bl2 = !SupportedBrowsers.getInstance().isSupported(this.function.getCompatibility());
            if (!bl2 && this.function.isDeprecated()) {
                bl2 = true;
            }
            if (bl2) {
                htmlFormatter.deprecated(true);
            }
            boolean bl4 = bl = !this.function.isInherited();
            if (bl) {
                htmlFormatter.emphasis(true);
            }
            htmlFormatter.name(elementKind, true);
            htmlFormatter.appendText(this.getName());
            htmlFormatter.name(elementKind, false);
            if (bl) {
                htmlFormatter.emphasis(false);
            }
            if (bl2) {
                htmlFormatter.deprecated(false);
            }
            List<String> list = this.function.getParameters();
            htmlFormatter.appendHtml("(");
            if (list != null && list.size() > 0) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    htmlFormatter.parameters(true);
                    String string = (String)iterator.next();
                    int n = string.indexOf(58);
                    if (n != -1) {
                        htmlFormatter.type(true);
                        htmlFormatter.appendText(string, n + 1, string.length());
                        htmlFormatter.type(false);
                        htmlFormatter.appendHtml(" ");
                        htmlFormatter.appendText(string, 0, n);
                    } else {
                        htmlFormatter.appendText(string);
                    }
                    htmlFormatter.parameters(false);
                    if (!iterator.hasNext()) continue;
                    htmlFormatter.appendText(", ");
                }
            }
            htmlFormatter.appendHtml(")");
            if (this.indexedElement != null && this.indexedElement.getType() != null && this.indexedElement.getType() != Node.UNKNOWN_TYPE && this.indexedElement.getKind() != ElementKind.CONSTRUCTOR) {
                htmlFormatter.appendHtml(" : ");
                htmlFormatter.appendText(JsUtils.normalizeTypeString(this.indexedElement.getType()));
            }
            return htmlFormatter.getText();
        }

        public String getCustomInsertTemplate() {
            String string = this.getInsertPrefix();
            List<String> list = this.function.getParameters();
            String string2 = "(";
            String string3 = ")";
            int n = list.size();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append(string2);
            int n2 = 1;
            for (int i = 0; i < n; ++i) {
                String string4 = list.get(i);
                stringBuilder.append("${");
                stringBuilder.append("js-cc-");
                stringBuilder.append(Integer.toString(n2++));
                stringBuilder.append(" default=\"");
                int n3 = string4.indexOf(58);
                if (n3 != -1) {
                    stringBuilder.append(string4, 0, n3);
                } else {
                    stringBuilder.append(string4);
                }
                stringBuilder.append("\"");
                stringBuilder.append("}");
                if (i >= n - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(string3);
            stringBuilder.append("${cursor}");
            try {
                callLineStart = Utilities.getRowStart((BaseDocument)this.request.doc, (int)this.request.anchor);
                callMethod = this.function;
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GenericItem
    extends JsCompletionItem {
        private final String tag;
        private final String description;
        private String longDescription;
        private final ElementKind kind;

        GenericItem(String string, String string2, CompletionRequest completionRequest, ElementKind elementKind) {
            super(null, completionRequest);
            this.tag = string;
            this.description = string2;
            this.kind = elementKind;
        }

        void setLongDescription(String string) {
            this.longDescription = string;
        }

        @Override
        public String getName() {
            return this.tag;
        }

        @Override
        public ElementKind getKind() {
            return this.kind;
        }

        @Override
        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            if (this.description != null) {
                htmlFormatter.appendHtml("<i>");
                htmlFormatter.appendHtml(this.description);
                htmlFormatter.appendHtml("</i>");
                return htmlFormatter.getText();
            }
            return null;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ElementHandle getElement() {
            if (this.element == null) {
                this.element = this.longDescription != null && this.longDescription.length() > 0 ? new CommentElement(this.longDescription) : new KeywordElement(this.tag);
            }
            return this.element;
        }

        @Override
        public boolean isSmart() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JsCompletionItem
    implements CompletionProposal {
        protected CompletionRequest request;
        protected Element element;
        protected IndexedElement indexedElement;

        private JsCompletionItem(Element element, CompletionRequest completionRequest) {
            this.element = element;
            this.request = completionRequest;
        }

        private JsCompletionItem(CompletionRequest completionRequest, IndexedElement indexedElement) {
            this(indexedElement, completionRequest);
            this.indexedElement = indexedElement;
        }

        public int getAnchorOffset() {
            return this.request.anchor;
        }

        public String getName() {
            return this.element.getName();
        }

        public String getInsertPrefix() {
            if (this.getKind() == ElementKind.PACKAGE) {
                return this.getName() + ".";
            }
            return this.getName();
        }

        public String getSortText() {
            return this.getName();
        }

        public ElementHandle getElement() {
            return this.element;
        }

        public ElementKind getKind() {
            return this.element.getKind();
        }

        public ImageIcon getIcon() {
            return null;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            String string;
            boolean bl;
            ElementKind elementKind = this.getKind();
            boolean bl2 = elementKind != ElementKind.PACKAGE && this.indexedElement != null ? !this.indexedElement.isInherited() : (bl = false);
            if (bl) {
                htmlFormatter.emphasis(true);
            }
            boolean bl3 = false;
            if (this.indexedElement != null && (this.indexedElement.isDeprecated() || !SupportedBrowsers.getInstance().isSupported(this.indexedElement.getCompatibility()))) {
                bl3 = true;
            }
            if (bl3) {
                htmlFormatter.deprecated(true);
            }
            htmlFormatter.name(elementKind, true);
            htmlFormatter.appendText(this.getName());
            htmlFormatter.name(elementKind, false);
            if (bl3) {
                htmlFormatter.deprecated(false);
            }
            if (bl) {
                htmlFormatter.emphasis(false);
            }
            if (this.indexedElement != null && (string = this.indexedElement.getType()) != null && string != Node.UNKNOWN_TYPE) {
                htmlFormatter.appendHtml(" : ");
                htmlFormatter.appendText(JsUtils.normalizeTypeString(string));
            }
            return htmlFormatter.getText();
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            if (this.element.getKind() == ElementKind.PACKAGE || this.element.getKind() == ElementKind.CLASS) {
                String string;
                if (this.element instanceof IndexedElement && (string = ((IndexedElement)this.element).getOrigin()) != null) {
                    htmlFormatter.appendText(string);
                    return htmlFormatter.getText();
                }
                return null;
            }
            String string = this.element.getIn();
            if (string != null) {
                htmlFormatter.appendText(string);
                return htmlFormatter.getText();
            }
            if (this.element instanceof IndexedElement) {
                IndexedElement indexedElement = (IndexedElement)this.element;
                String string2 = indexedElement.getFilenameUrl();
                if (string2 != null) {
                    if (string2.indexOf("jsstubs") == -1) {
                        int n = string2.lastIndexOf(47);
                        if (n != -1) {
                            string2 = string2.substring(n + 1);
                        }
                        htmlFormatter.appendText(string2);
                        return htmlFormatter.getText();
                    }
                    String string3 = indexedElement.getOrigin();
                    if (string3 != null) {
                        htmlFormatter.appendText(string3);
                        return htmlFormatter.getText();
                    }
                }
                return null;
            }
            return null;
        }

        public Set<Modifier> getModifiers() {
            return this.element.getModifiers();
        }

        public String toString() {
            String string = this.getClass().getName();
            string = string.substring(string.lastIndexOf(46) + 1);
            return string + "(" + this.getKind() + "): " + this.getName();
        }

        public boolean isSmart() {
            return this.indexedElement != null ? this.indexedElement.isSmart() : true;
        }

        public String getCustomInsertTemplate() {
            return null;
        }

        public int getSortPrioOverride() {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeywordItem
    extends JsCompletionItem {
        private static final String Js_KEYWORD = "org/netbeans/modules/javascript/editing/javascript.png";
        private final String keyword;
        private final String description;
        private ElementKind kind;

        KeywordItem(String string, String string2, CompletionRequest completionRequest) {
            super(null, completionRequest);
            this.kind = ElementKind.KEYWORD;
            this.keyword = string;
            this.description = string2;
        }

        @Override
        public String getName() {
            return this.keyword;
        }

        @Override
        public ElementKind getKind() {
            return this.kind;
        }

        @Override
        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            return null;
        }

        @Override
        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            ElementKind elementKind = this.getKind();
            htmlFormatter.name(elementKind, true);
            htmlFormatter.appendText(this.keyword);
            htmlFormatter.appendText(" ");
            htmlFormatter.name(elementKind, false);
            if (this.description != null) {
                htmlFormatter.appendHtml(this.description);
            }
            return htmlFormatter.getText();
        }

        @Override
        public ImageIcon getIcon() {
            if (this.kind != ElementKind.KEYWORD) {
                return null;
            }
            if (keywordIcon == null) {
                keywordIcon = ImageUtilities.loadImageIcon((String)Js_KEYWORD, (boolean)false);
            }
            return keywordIcon;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ElementHandle getElement() {
            return new KeywordElement(this.keyword);
        }

        @Override
        public boolean isSmart() {
            return false;
        }

        private void setKind(ElementKind elementKind) {
            this.kind = elementKind;
        }
    }
}

