/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.List;
import org.mozilla.nb.javascript.Node;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.BrowserVersion;
import org.netbeans.modules.javascript.editing.Element;
import org.netbeans.modules.javascript.editing.FunctionElement;
import org.netbeans.modules.javascript.editing.IndexedElement;
import org.netbeans.modules.javascript.editing.JsCodeCompletion;
import org.netbeans.modules.javascript.editing.JsDeclarationFinder;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.JsParser;
import org.netbeans.modules.javascript.editing.SupportedBrowsers;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementUtilities {
    private ElementUtilities() {
    }

    public static Element getElement(JsParseResult jsParseResult, ElementHandle elementHandle) {
        Element element = null;
        if (elementHandle instanceof ElementHandle.UrlHandle) {
            String string = ((ElementHandle.UrlHandle)elementHandle).getUrl();
            DeclarationFinder.DeclarationLocation declarationLocation = new JsDeclarationFinder().findLinkedMethod(jsParseResult, string);
            if (declarationLocation != DeclarationFinder.DeclarationLocation.NONE) {
                ElementHandle elementHandle2 = declarationLocation.getElement();
                if (elementHandle != null) {
                    element = JsParser.resolveHandle(jsParseResult, elementHandle2);
                }
            }
        } else {
            element = JsParser.resolveHandle(jsParseResult, elementHandle);
        }
        return element;
    }

    public static List<String> getComments(JsParseResult jsParseResult, Element element) {
        JsParseResult[] jsParseResultArray;
        Node node;
        assert (jsParseResult != null || element instanceof IndexedElement);
        if (element == null) {
            return null;
        }
        if (element instanceof IndexedElement && ((node = (jsParseResultArray = (JsParseResult[])element).getComments()) != null || jsParseResultArray.getDocOffset() == -1)) {
            return node;
        }
        jsParseResultArray = new JsParseResult[1];
        node = ElementUtilities.getNode(jsParseResult, element, jsParseResultArray);
        jsParseResult = jsParseResultArray[0];
        if (node == null) {
            return null;
        }
        List<String> list = null;
        list = LexUtilities.gatherDocumentation(jsParseResult, node.getSourceStart());
        if (list == null || list.size() == 0) {
            return null;
        }
        return list;
    }

    public static String getSignature(Element element) {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        IndexedElement indexedElement = null;
        if (element instanceof IndexedElement) {
            indexedElement = (IndexedElement)element;
        }
        stringBuilder.append("<table width=\"100%\" border=\"0\"><tr>\n");
        stringBuilder.append("<td>");
        if (element.getIn() != null && (object2 = element.getIn()) != null && ((String)object2).length() > 0) {
            stringBuilder.append("<i>");
            stringBuilder.append((String)object2);
            stringBuilder.append("</i>");
            if (indexedElement != null && (object = indexedElement.getFilenameUrl()) != null) {
                if (((String)object).indexOf("jsstubs/stub_core_") != -1) {
                    stringBuilder.append(" (Core JavaScript)");
                } else if (((String)object).indexOf("jsstubs/stub_") != -1) {
                    stringBuilder.append(" (DOM)");
                }
            }
            stringBuilder.append("<br>");
        }
        stringBuilder.append("<b>");
        stringBuilder.append(element.getName());
        stringBuilder.append("</b>");
        if (element instanceof FunctionElement && (object = (object2 = (FunctionElement)element).getParameters()) != null && object.size() > 0) {
            stringBuilder.append("(");
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                int n = string.indexOf(58);
                if (n != -1) {
                    stringBuilder.append("<font color=\"#808080\">");
                    int n2 = string.length();
                    for (int i = n + 1; i < n2; ++i) {
                        char c = string.charAt(i);
                        if (c == '<') {
                            stringBuilder.append("&lt;");
                            continue;
                        }
                        if (c == '>') {
                            stringBuilder.append("&gt;");
                            continue;
                        }
                        stringBuilder.append(c);
                    }
                    stringBuilder.append("</font>");
                    stringBuilder.append(" ");
                    stringBuilder.append("<font color=\"#a06001\">");
                    stringBuilder.append(string, 0, n);
                    stringBuilder.append("</font>");
                } else {
                    stringBuilder.append("<font color=\"#a06001\">");
                    stringBuilder.append(string);
                    stringBuilder.append("</font>");
                }
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(")");
        }
        stringBuilder.append("</td>\n");
        if (indexedElement != null) {
            stringBuilder.append("<td width=\"125\">");
            object2 = indexedElement.getCompatibility();
            try {
                if (((AbstractCollection)object2).contains((Object)BrowserVersion.FF3)) {
                    ElementUtilities.appendImage(stringBuilder, "firefox20.png");
                } else {
                    ElementUtilities.appendImage(stringBuilder, "firefox20-disabled.png");
                }
                if (((AbstractCollection)object2).contains((Object)BrowserVersion.IE7)) {
                    ElementUtilities.appendImage(stringBuilder, "ie20.png");
                } else {
                    ElementUtilities.appendImage(stringBuilder, "ie20-disabled.png");
                }
                if (((AbstractCollection)object2).contains((Object)BrowserVersion.SAFARI3)) {
                    ElementUtilities.appendImage(stringBuilder, "safari20.png");
                } else {
                    ElementUtilities.appendImage(stringBuilder, "safari20-disabled.png");
                }
                if (((AbstractCollection)object2).contains((Object)BrowserVersion.OPERA)) {
                    ElementUtilities.appendImage(stringBuilder, "opera20.png");
                } else {
                    ElementUtilities.appendImage(stringBuilder, "opera20-disabled.png");
                }
                if (((AbstractCollection)object2).contains((Object)BrowserVersion.SAFARI3)) {
                    ElementUtilities.appendImage(stringBuilder, "chrome20.png");
                } else {
                    ElementUtilities.appendImage(stringBuilder, "chrome20-disabled.png");
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            stringBuilder.append("</td>");
        }
        stringBuilder.append("</tr></table>");
        if (indexedElement != null && indexedElement.getFilenameUrl() != null && indexedElement.getFilenameUrl().indexOf("jsstubs") == -1) {
            stringBuilder.append(NbBundle.getMessage(JsCodeCompletion.class, (String)"FileLabel"));
            stringBuilder.append(" <tt>");
            object2 = indexedElement.getFilenameUrl();
            int n = ((String)object2).lastIndexOf(47);
            if (n != -1) {
                object2 = ((String)object2).substring(n + 1);
            }
            stringBuilder.append((String)object2);
            stringBuilder.append("</tt><br>");
        }
        if (indexedElement != null && !SupportedBrowsers.getInstance().isSupported(indexedElement.getCompatibility())) {
            stringBuilder.append("<hr>");
            stringBuilder.append("<p style=\"background:#ffcccc\">");
            stringBuilder.append(NbBundle.getMessage(JsCodeCompletion.class, (String)"NotSupportedBr"));
            stringBuilder.append("\n");
            stringBuilder.append("<ul>");
            for (BrowserVersion browserVersion : BrowserVersion.ALL) {
                if (!SupportedBrowsers.getInstance().isSupported(browserVersion) || indexedElement.getCompatibility().contains((Object)browserVersion)) continue;
                stringBuilder.append("<li>");
                stringBuilder.append(browserVersion.getDisplayName());
                if (browserVersion != BrowserVersion.SAFARI3) continue;
                stringBuilder.append("<li>Chrome");
            }
            stringBuilder.append("</ul>\n");
            if (Utilities.isMac()) {
                stringBuilder.append(NbBundle.getMessage(JsCodeCompletion.class, (String)"EditTargetedBrOsx"));
            } else {
                stringBuilder.append(NbBundle.getMessage(JsCodeCompletion.class, (String)"EditTargetedBr"));
            }
            stringBuilder.append("\n");
            stringBuilder.append("</p>");
        }
        return stringBuilder.toString();
    }

    private static Node getNode(JsParseResult jsParseResult, Element element, @NonNull JsParseResult[] jsParseResultArray) {
        jsParseResultArray[0] = jsParseResult;
        Node node = null;
        if (element instanceof AstElement) {
            node = ((AstElement)element).getNode();
        } else if (element instanceof IndexedElement) {
            IndexedElement indexedElement = (IndexedElement)element;
            IndexedElement indexedElement2 = null;
            Node node2 = null;
            if (jsParseResult != null) {
                node2 = jsParseResult.getRootNode();
                indexedElement2 = ElementUtilities.findDocumentationEntry(node2, indexedElement);
            }
            if (indexedElement2 != null) {
                indexedElement = indexedElement2;
            }
            node = AstUtilities.getForeignNode(indexedElement, jsParseResultArray);
        } else assert (false) : element;
        return node;
    }

    private static IndexedElement findDocumentationEntry(Node node, IndexedElement indexedElement) {
        return indexedElement;
    }

    private static void appendImage(StringBuilder stringBuilder, String string) {
        stringBuilder.append("<img src=\"" + JsCodeCompletion.class.getResource("icons/" + string).toExternalForm() + "\">");
    }
}

