/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.navigator;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.FocusManager;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.navigator.NavigatorTC;
import org.netbeans.modules.navigator.ProviderRegistry;
import org.netbeans.spi.navigator.NavigatorLookupHint;
import org.netbeans.spi.navigator.NavigatorLookupPanelsPolicy;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.netbeans.spi.navigator.NavigatorPanelWithUndo;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NavigatorController
implements LookupListener,
ActionListener,
PropertyChangeListener,
NodeListener,
Runnable {
    static final int COALESCE_TIME = 100;
    private NavigatorTC navigatorTC;
    private RequestProcessor.Task nodeSetterTask;
    private final Object NODE_SETTER_LOCK = new Object();
    private final Object CUR_NODES_LOCK = new Object();
    private static final Lookup.Template<Node> CUR_NODES = new Lookup.Template(Node.class);
    private static final Lookup.Template<NavigatorLookupHint> CUR_HINTS = new Lookup.Template(NavigatorLookupHint.class);
    private Lookup.Result<Node> curNodesRes;
    private Lookup.Result<NavigatorLookupHint> curHintsRes;
    private Collection<? extends Node> curNodes = Collections.emptyList();
    private final ClientsLookup clientsLookup;
    private final Lookup panelLookup;
    private Lookup.Result<Node> panelLookupNodesResult;
    private final LookupListener panelLookupListener;
    private Reference<TopComponent> lastActivatedRef;
    private List<NodeListener> weakNodesL = Collections.emptyList();
    private boolean inUpdate;
    private static final Logger LOG = Logger.getLogger(NavigatorController.class.getName());

    public NavigatorController(NavigatorTC navigatorTC) {
        this.navigatorTC = navigatorTC;
        this.clientsLookup = new ClientsLookup();
        this.panelLookup = Lookups.proxy((Lookup.Provider)new PanelLookupWrapper());
        this.panelLookupListener = new PanelLookupListener();
    }

    public void navigatorTCOpened() {
        LOG.fine("Entering navigatorTCOpened");
        this.curNodesRes = Utilities.actionsGlobalContext().lookup(CUR_NODES);
        this.curNodesRes.addLookupListener((LookupListener)this);
        this.curHintsRes = Utilities.actionsGlobalContext().lookup(CUR_HINTS);
        this.curHintsRes.addLookupListener((LookupListener)this);
        this.navigatorTC.getPanelSelector().addActionListener(this);
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        this.panelLookupNodesResult = this.panelLookup.lookup(CUR_NODES);
        this.panelLookupNodesResult.addLookupListener(this.panelLookupListener);
        this.updateContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void navigatorTCClosed() {
        LOG.fine("Entering navigatorTCClosed");
        this.curNodesRes.removeLookupListener((LookupListener)this);
        this.curHintsRes.removeLookupListener((LookupListener)this);
        this.navigatorTC.getPanelSelector().removeActionListener(this);
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        this.panelLookupNodesResult.removeLookupListener(this.panelLookupListener);
        this.curNodesRes = null;
        this.curHintsRes = null;
        Object object = this.CUR_NODES_LOCK;
        synchronized (object) {
            this.curNodes = Collections.emptyList();
        }
        this.weakNodesL = Collections.emptyList();
        this.clientsLookup.lookup(Object.class);
        object = this.navigatorTC.getSelectedPanel();
        if (object != null) {
            object.panelDeactivated();
        }
        this.lastActivatedRef = null;
        this.navigatorTC.setPanels(null, null);
        this.panelLookupNodesResult = null;
        LOG.fine("navigatorTCClosed: activated nodes: " + this.navigatorTC.getActivatedNodes());
        if (this.navigatorTC.getActivatedNodes() != null) {
            LOG.fine("navigatorTCClosed: clearing act nodes...");
            this.navigatorTC.setActivatedNodes(new Node[0]);
        }
    }

    public Lookup getPanelLookup() {
        return this.panelLookup;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.navigatorTC.getPanelSelector().getSelectedIndex();
        if (n == -1) {
            return;
        }
        NavigatorPanel navigatorPanel = this.navigatorTC.getPanels().get(n);
        this.activatePanel(navigatorPanel);
    }

    public void activatePanel(NavigatorPanel navigatorPanel) {
        if (!this.navigatorTC.getPanels().contains(navigatorPanel)) {
            throw new IllegalArgumentException("Panel is not available for activation: " + navigatorPanel);
        }
        NavigatorPanel navigatorPanel2 = this.navigatorTC.getSelectedPanel();
        if (!navigatorPanel.equals(navigatorPanel2)) {
            if (navigatorPanel2 != null) {
                navigatorPanel2.panelDeactivated();
            }
            navigatorPanel.panelActivated((Lookup)this.clientsLookup);
            this.navigatorTC.setSelectedPanel(navigatorPanel);
            this.panelLookup.lookup(Object.class);
            this.cacheLastSelPanel(navigatorPanel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultChanged(LookupEvent lookupEvent) {
        if (!((Object)((Object)this.navigatorTC)).equals(WindowManager.getDefault().getRegistry().getActivated()) || this.curNodes == null || this.curNodes.isEmpty()) {
            ActNodeSetter actNodeSetter = new ActNodeSetter();
            Object object = this.NODE_SETTER_LOCK;
            synchronized (object) {
                if (this.nodeSetterTask != null) {
                    this.nodeSetterTask.cancel();
                }
                this.nodeSetterTask = RequestProcessor.getDefault().post((Runnable)actNodeSetter, 100);
                this.nodeSetterTask.addTaskListener((TaskListener)actNodeSetter);
            }
        }
    }

    private boolean shouldUpdate() {
        return TopComponent.getRegistry().getCurrentNodes() != null || Utilities.actionsGlobalContext().lookup(NavigatorLookupHint.class) != null;
    }

    private void updateContext() {
        this.updateContext(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateContext(boolean bl) {
        void var7_13;
        boolean bl2;
        Object object2;
        LOG.fine("updateContext entered, force: " + bl);
        if (this.inUpdate) {
            LOG.fine("Exit because inUpdate already, force: " + bl);
            return;
        }
        this.inUpdate = true;
        if (this.curNodesRes == null) {
            this.inUpdate = false;
            LOG.fine("Exit because curNodesRes is null, force: " + bl);
            return;
        }
        Collection collection = this.curNodesRes.allInstances();
        if (collection.isEmpty() && !this.shouldUpdate() && !bl) {
            this.inUpdate = false;
            LOG.fine("Exit because act nodes empty, force: " + bl);
            return;
        }
        List<NavigatorPanel> list = this.CUR_NODES_LOCK;
        synchronized (list) {
            object2 = this.weakNodesL.iterator();
            NodeListener nodeListener = this.curNodes.iterator();
            while (nodeListener.hasNext()) {
                nodeListener.next().removeNodeListener(object2.next());
            }
            this.weakNodesL = new ArrayList<NodeListener>(collection.size());
            this.curNodes = collection;
            LOG.fine("new CurNodes size " + this.curNodes.size());
            nodeListener = null;
            for (Node object3 : this.curNodes) {
                nodeListener = (NodeListener)WeakListeners.create(NodeListener.class, (EventListener)this, (Object)object3);
                this.weakNodesL.add(nodeListener);
                object3.addNodeListener(nodeListener);
            }
        }
        list = this.obtainProviders(collection);
        object2 = this.navigatorTC.getPanels();
        boolean bl3 = bl2 = list != null && !list.isEmpty();
        if (object2 == null && list == null) {
            this.inUpdate = false;
            LOG.fine("Exit because nav remain empty, force: " + bl);
            return;
        }
        NavigatorPanel navigatorPanel = this.navigatorTC.getSelectedPanel();
        if (object2 != null && object2.contains(navigatorPanel) && list != null && list.contains(navigatorPanel)) {
            this.clientsLookup.lookup(Node.class);
            if (!object2.equals(list)) {
                this.navigatorTC.getPanelSelector().removeActionListener(this);
                this.navigatorTC.setPanels(list, null);
                this.navigatorTC.setSelectedPanel(navigatorPanel);
                this.navigatorTC.getPanelSelector().addActionListener(this);
            }
            this.updateActNodesAndTitle();
            LOG.fine("Exit because same provider and panel, notified. Force: " + bl);
            this.inUpdate = false;
            return;
        }
        if (navigatorPanel != null) {
            if (!bl2 && !bl && null != list) {
                this.inUpdate = false;
                LOG.fine("Exit because no new providers, force: " + bl);
                return;
            }
            navigatorPanel.panelDeactivated();
        }
        this.clientsLookup.lookup(Node.class);
        Object var7_9 = null;
        if (bl2) {
            void var7_12;
            NavigatorPanel navigatorPanel2 = this.getLastSelPanel(list);
            if (navigatorPanel2 == null) {
                NavigatorPanel navigatorPanel3 = list.get(0);
            }
            var7_12.panelActivated((Lookup)this.clientsLookup);
        }
        this.navigatorTC.getPanelSelector().removeActionListener(this);
        this.navigatorTC.setPanels(list, (NavigatorPanel)var7_13);
        this.panelLookup.lookup(Object.class);
        this.navigatorTC.getPanelSelector().addActionListener(this);
        this.updateActNodesAndTitle();
        LOG.fine("Normal exit, change to new provider, force: " + bl);
        this.inUpdate = false;
    }

    private void updateActNodesAndTitle() {
        LOG.fine("updateActNodesAndTitle called...");
        Node[] nodeArray = this.obtainActivatedNodes();
        this.navigatorTC.setActivatedNodes(nodeArray);
        this.updateTCTitle(nodeArray);
    }

    private void updateTCTitle(Node[] nodeArray) {
        String string = nodeArray != null && nodeArray.length > 0 ? NbBundle.getMessage(NavigatorTC.class, (String)"FMT_Navigator", (Object)nodeArray[0].getDisplayName()) : NbBundle.getMessage(NavigatorTC.class, (String)"LBL_Navigator");
        this.navigatorTC.setDisplayName(string);
    }

    List<NavigatorPanel> obtainProviders(Collection<? extends Node> collection) {
        Lookup lookup = Utilities.actionsGlobalContext();
        NavigatorLookupPanelsPolicy navigatorLookupPanelsPolicy = (NavigatorLookupPanelsPolicy)lookup.lookup(NavigatorLookupPanelsPolicy.class);
        Object object2 = null;
        Collection collection2 = lookup.lookupAll(NavigatorLookupHint.class);
        for (Iterator iterator : collection2) {
            Collection<? extends NavigatorPanel> object4 = ProviderRegistry.getInstance().getProviders(iterator.getContentType());
            if (object4 == null || object4.isEmpty()) continue;
            if (object2 == null) {
                object2 = new ArrayList(object4.size() * collection2.size());
            }
            for (NavigatorPanel navigatorPanel : object4) {
                if (object2.contains(navigatorPanel)) continue;
                object2.add(navigatorPanel);
            }
        }
        if (navigatorLookupPanelsPolicy != null && navigatorLookupPanelsPolicy.getPanelsPolicy() == 1) {
            return object2;
        }
        Object object3 = null;
        for (Node node : collection) {
            NavigatorPanel navigatorPanel;
            DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
            while (dataObject instanceof DataShadow) {
                dataObject = ((DataShadow)dataObject).getOriginal();
            }
            if (dataObject == null) {
                object3 = null;
                break;
            }
            navigatorPanel = dataObject.getPrimaryFile();
            if (navigatorPanel.isVirtual()) {
                object3 = null;
                break;
            }
            String string = navigatorPanel.getMIMEType();
            Collection<? extends NavigatorPanel> collection3 = ProviderRegistry.getInstance().getProviders(string);
            if (collection3 == null || collection3.isEmpty()) {
                object3 = null;
                break;
            }
            LOG.fine("File mime type providers size: " + collection3.size());
            if (object3 == null) {
                object3 = new ArrayList(collection3.size());
                object3.addAll(collection3);
                continue;
            }
            object3.retainAll(collection3);
        }
        if (object2 != null) {
            if (object3 != null) {
                Iterator iterator;
                iterator = object3.iterator();
                while (iterator.hasNext()) {
                    NavigatorPanel navigatorPanel = (NavigatorPanel)iterator.next();
                    if (object2.contains(navigatorPanel)) continue;
                    object2.add(navigatorPanel);
                }
            }
        } else {
            object2 = object3;
        }
        return object2;
    }

    private Node[] obtainActivatedNodes() {
        Lookup lookup = this.getSelectedPanelLookup();
        if (lookup == null) {
            return this.curNodes.toArray(new Node[0]);
        }
        return lookup.lookupAll(Node.class).toArray(new Node[0]);
    }

    UndoRedo getUndoRedo() {
        NavigatorPanel navigatorPanel = this.navigatorTC.getSelectedPanel();
        if (navigatorPanel == null || !(navigatorPanel instanceof NavigatorPanelWithUndo)) {
            return UndoRedo.NONE;
        }
        return ((NavigatorPanelWithUndo)navigatorPanel).getUndoRedo();
    }

    public void installActions() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, true);
        this.navigatorTC.getInputMap(2).put(keyStroke, "return");
        this.navigatorTC.getActionMap().put("return", new ESCHandler());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("activated".equals(propertyChangeEvent.getPropertyName())) {
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            if (topComponent != null && topComponent != this.navigatorTC) {
                this.lastActivatedRef = new WeakReference<TopComponent>(topComponent);
            }
        } else if ("tcClosed".equals(propertyChangeEvent.getPropertyName())) {
            LOG.fine("Component closed, invoking update through invokeLater...");
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            if (topComponent == this.navigatorTC) {
                LOG.fine("navigator active, clearing its activated nodes");
                this.navigatorTC.setActivatedNodes(new Node[0]);
            }
            EventQueue.invokeLater(this);
        }
    }

    public void nodeDestroyed(NodeEvent nodeEvent) {
        LOG.fine("Node destroyed reaction...");
        if (((Object)((Object)this.navigatorTC)).equals(WindowManager.getDefault().getRegistry().getActivated())) {
            LOG.fine("NavigatorTC active, skipping node destroyed reaction.");
            return;
        }
        LOG.fine("invokeLater on updateContext from node destroyed reaction...");
        EventQueue.invokeLater(this);
    }

    public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
    }

    public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
    }

    public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
    }

    @Override
    public void run() {
        this.updateContext(true);
    }

    private void cacheLastSelPanel(NavigatorPanel navigatorPanel) {
        String string = this.findMimeForContext();
        if (string != null) {
            String string2 = navigatorPanel.getClass().getName();
            NbPreferences.forModule(NavigatorController.class).put(string, string2);
            LOG.fine("cached " + string2 + "for mime " + string);
        }
    }

    private NavigatorPanel getLastSelPanel(List<NavigatorPanel> list) {
        String string = this.findMimeForContext();
        if (string == null) {
            return null;
        }
        String string2 = NbPreferences.forModule(NavigatorController.class).get(string, null);
        if (string2 == null) {
            return null;
        }
        LOG.fine("found cached " + string2 + "for mime " + string);
        for (NavigatorPanel navigatorPanel : list) {
            if (!string2.equals(navigatorPanel.getClass().getName())) continue;
            LOG.fine("returning cached " + string2 + "for mime " + string);
            return navigatorPanel;
        }
        return null;
    }

    private String findMimeForContext() {
        Collection collection;
        if (this.curHintsRes != null && !(collection = this.curHintsRes.allInstances()).isEmpty()) {
            return ((NavigatorLookupHint)collection.iterator().next()).getContentType();
        }
        collection = (FileObject)this.getClientsLookup().lookup(FileObject.class);
        if (collection != null) {
            return collection.getMIMEType();
        }
        return null;
    }

    private Lookup getSelectedPanelLookup() {
        Lookup lookup;
        NavigatorPanel navigatorPanel = this.navigatorTC.getSelectedPanel();
        if (navigatorPanel != null && (lookup = navigatorPanel.getLookup()) != null) {
            return lookup;
        }
        return null;
    }

    ClientsLookup getClientsLookup() {
        return this.clientsLookup;
    }

    private class ActNodeSetter
    implements Runnable,
    TaskListener {
        private ActNodeSetter() {
        }

        public void run() {
            if (RequestProcessor.getDefault().isRequestProcessorThread()) {
                LOG.fine("invokeLater on updateContext from ActNodeSetter");
                SwingUtilities.invokeLater(this);
            } else {
                LOG.fine("Calling updateContext from ActNodeSetter");
                NavigatorController.this.updateContext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskFinished(Task task) {
            Object object = NavigatorController.this.NODE_SETTER_LOCK;
            synchronized (object) {
                if (task == NavigatorController.this.nodeSetterTask) {
                    NavigatorController.this.nodeSetterTask = null;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ClientsLookup
    extends ProxyLookup {
        ClientsLookup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void beforeLookup(Lookup.Template<?> template) {
            Lookup[] lookupArray;
            super.beforeLookup(template);
            Object object = NavigatorController.this.CUR_NODES_LOCK;
            synchronized (object) {
                lookupArray = new Lookup[NavigatorController.this.curNodes.size()];
                int n = 0;
                Iterator iterator = NavigatorController.this.curNodes.iterator();
                while (iterator.hasNext()) {
                    lookupArray[n] = ((Node)iterator.next()).getLookup();
                    ++n;
                }
            }
            this.setLookups(lookupArray);
        }

        Lookup[] obtainLookups() {
            return this.getLookups();
        }
    }

    private class ESCHandler
    extends AbstractAction {
        private ESCHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = FocusManager.getCurrentManager().getFocusOwner();
            if (NavigatorController.this.lastActivatedRef == null || component == null || !SwingUtilities.isDescendingFrom(component, (Component)((Object)NavigatorController.this.navigatorTC)) || component instanceof JComboBox) {
                return;
            }
            TopComponent topComponent = (TopComponent)NavigatorController.this.lastActivatedRef.get();
            if (topComponent != null) {
                topComponent.requestActive();
            }
        }
    }

    private final class PanelLookupListener
    implements LookupListener,
    Runnable {
        private PanelLookupListener() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            NavigatorController.this.updateActNodesAndTitle();
        }
    }

    private final class PanelLookupWrapper
    implements Lookup.Provider {
        private PanelLookupWrapper() {
        }

        public Lookup getLookup() {
            Lookup lookup = NavigatorController.this.getSelectedPanelLookup();
            return lookup != null ? lookup : Lookup.EMPTY;
        }
    }
}

