/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.CharProvider;
import org.netbeans.lib.lexer.PreprocessedTextStorage;
import org.netbeans.lib.lexer.TextLexerInputOperation;
import org.netbeans.lib.lexer.TokenList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PreprocessedTextLexerInputOperation<T extends TokenId>
extends TextLexerInputOperation<T> {
    private final PreprocessedTextStorage preprocessedText;
    private int prepStartIndex;
    private int prepEndIndex;
    private int tokenStartRawLengthShift;
    private int lastRawLengthShift;
    private int tokenEndRawLengthShift;
    private int tokenStartIndex;

    public PreprocessedTextLexerInputOperation(TokenList<T> tokenList, int n, Object object, PreprocessedTextStorage preprocessedTextStorage, int n2, int n3, int n4) {
        super(tokenList, n, object, n3, n4);
        this.preprocessedText = preprocessedTextStorage;
        int n5 = n3 - n2;
        if (n5 > 0) {
            this.lastRawLengthShift = this.tokenStartRawLengthShift = this.preprocessedText.rawLengthShift(n5);
        }
    }

    @Override
    public int read(int n) {
        if ((n += this.tokenStartIndex) < this.readEndIndex()) {
            int n2 = this.preprocessedText.rawLengthShift(n);
            if (n2 != this.lastRawLengthShift) {
                this.lastRawLengthShift = n2;
                if (this.prepStartIndex >= n) {
                    this.prepStartIndex = n;
                }
                this.prepEndIndex = n + 1;
            }
            return this.preprocessedText.charAt(n);
        }
        return -1;
    }

    @Override
    public void assignTokenLength(int n) {
        this.tokenEndRawLengthShift = this.preprocessedText.rawLengthShift(this.tokenStartIndex + n - 1);
    }

    protected void tokenApproved() {
        this.tokenStartRawLengthShift += this.tokenEndRawLengthShift;
        if (this.prepStartIndex != Integer.MAX_VALUE) {
            if (this.prepStartIndex < this.tokenLength()) {
                if (this.prepEndIndex <= this.tokenLength()) {
                    this.prepStartIndex = Integer.MAX_VALUE;
                } else {
                    this.prepStartIndex = 0;
                    this.prepEndIndex -= this.tokenLength();
                }
            } else {
                this.prepStartIndex -= this.tokenLength();
                this.prepEndIndex -= this.tokenLength();
            }
        }
    }

    public void collectExtraPreprocessedChars(CharProvider.ExtraPreprocessedChars extraPreprocessedChars, int n, int n2, int n3) {
        if (n < this.tokenLength()) {
            int n4;
            int n5 = Math.max(n - this.prepStartIndex, 0);
            if (this.prepEndIndex > this.tokenLength()) {
                n4 = this.tokenLength() - n2;
                if (n4 > 0) {
                    int n6 = this.tokenLength() - 2;
                    while (--n6 >= n && n4 > 0 && this.preprocessedText.rawLengthShift(n6 + this.tokenStartIndex) == this.tokenEndRawLengthShift) {
                        --n4;
                    }
                } else {
                    n4 = 0;
                }
            } else {
                n4 = this.prepEndIndex - n2;
            }
            assert (n5 >= 0 && n4 >= 0);
            extraPreprocessedChars.ensureExtraLength(n5 + n4);
            while (--n5 >= 0) {
                --n;
            }
            while (--n4 >= 0) {
                ++n2;
                ++n3;
            }
        }
    }
}

