/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.EventListener;
import java.util.WeakHashMap;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TableModelEvent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.RowModel;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertiesRowModel
implements RowModel {
    private Node.Property[] prop = new Node.Property[0];
    private Outline outline;
    private WeakHashMap<Node, PropertyChangeListener> nodesListenersCache = new WeakHashMap();
    private String[] names = new String[this.prop.length];
    private String[] descs = new String[this.prop.length];
    private PropertyChangeListener pcl = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            final int n = PropertiesRowModel.this.rowForNode((Node)propertyChangeEvent.getSource());
            if (n == -1) {
                return;
            }
            final int n2 = PropertiesRowModel.this.columnForProperty(propertyChangeEvent.getPropertyName());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (n2 == -1) {
                        PropertiesRowModel.this.outline.tableChanged(new TableModelEvent(PropertiesRowModel.this.outline.getModel(), n, n, -1, 0));
                    } else {
                        PropertiesRowModel.this.outline.tableChanged(new TableModelEvent(PropertiesRowModel.this.outline.getModel(), n, n, n2 + 1, 0));
                    }
                }
            });
        }
    };
    OutlineTooltipUpdater otu = new OutlineTooltipUpdater();
    NodeListener nl = new NodeListener(){

        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("shortDescription".equals(propertyChangeEvent.getPropertyName())) {
                int n = PropertiesRowModel.this.rowForNode((Node)propertyChangeEvent.getSource());
                PropertiesRowModel.this.otu.fireToolTipChanged(PropertiesRowModel.this.outline, n);
            }
            PropertiesRowModel.this.pcl.propertyChange(propertyChangeEvent);
        }
    };

    public void setOutline(Outline outline) {
        if (this.outline != null) {
            this.outline.removeMouseListener((MouseListener)this.otu);
            this.outline.removeMouseMotionListener((MouseMotionListener)this.otu);
        }
        this.outline = outline;
        outline.addMouseListener((MouseListener)this.otu);
        outline.addMouseMotionListener((MouseMotionListener)this.otu);
    }

    private int rowForNode(Node node) {
        TreeNode treeNode = Visualizer.findVisualizer(node);
        if (treeNode != null) {
            ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
            while (treeNode != null) {
                arrayList.add(treeNode);
                treeNode = treeNode.getParent();
            }
            Collections.reverse(arrayList);
            TreePath treePath = new TreePath(arrayList.toArray());
            int n = -1;
            try {
                n = this.outline.getLayoutCache().getRowForPath(treePath);
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
            return n;
        }
        return -1;
    }

    public Class getColumnClass(int n) {
        return Node.Property.class;
    }

    public int getColumnCount() {
        return this.prop.length;
    }

    public String getColumnName(int n) {
        assert (n < this.prop.length) : n + " must be bellow " + this.prop.length;
        if (this.names[n] == null) {
            String string = this.prop[n].getDisplayName();
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)string);
            this.names[n] = jLabel.getText();
        }
        return this.names[n];
    }

    public String getShortDescription(int n) {
        assert (n < this.prop.length) : n + " must be bellow " + this.prop.length;
        if (this.descs[n] == null) {
            String string = this.prop[n].getShortDescription();
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)string);
            this.descs[n] = jLabel.getText();
        }
        return this.descs[n];
    }

    public String getRawColumnName(int n) {
        return this.prop[n].getDisplayName();
    }

    public Object getValueFor(Object object, int n) {
        PropertyChangeListener propertyChangeListener;
        Node node = Visualizer.findNode(object);
        if (node == null) {
            throw new IllegalStateException("TreeNode must be VisualizerNode but was: " + object + " of class " + object.getClass().getName());
        }
        PropertyChangeListener propertyChangeListener2 = this.nodesListenersCache.get(node);
        if (propertyChangeListener2 == null) {
            propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this.pcl, (Object)node);
            this.nodesListenersCache.put(node, propertyChangeListener);
            node.addPropertyChangeListener(propertyChangeListener);
            NodeListener nodeListener = (NodeListener)WeakListeners.create(NodeListener.class, (EventListener)this.nl, (Object)node);
            node.addNodeListener(nodeListener);
        }
        propertyChangeListener = this.getPropertyFor(node, this.prop[n]);
        return propertyChangeListener;
    }

    public boolean isCellEditable(Object object, int n) {
        Node node = Visualizer.findNode(object);
        if (node == null) {
            throw new IllegalStateException("TreeNode must be VisualizerNode but was: " + object + " of class " + object.getClass().getName());
        }
        Node.Property property = this.getPropertyFor(node, this.prop[n]);
        if (property != null) {
            return property.canWrite();
        }
        return false;
    }

    protected Node.Property getPropertyFor(Node node, Node.Property property) {
        Node.PropertySet[] propertySetArray = node.getPropertySets();
        for (int i = 0; i < propertySetArray.length; ++i) {
            Node.Property[] propertyArray = propertySetArray[i].getProperties();
            for (int j = 0; j < propertyArray.length; ++j) {
                if (!property.equals((Object)propertyArray[j])) continue;
                return propertyArray[j];
            }
        }
        return null;
    }

    public void setValueFor(Object object, int n, Object object2) {
    }

    public void setProperties(Node.Property[] propertyArray) {
        this.prop = propertyArray;
        this.names = new String[this.prop.length];
        this.descs = new String[this.prop.length];
    }

    public static Object getValueFromProperty(Object object) {
        if (object instanceof Node.Property) {
            Node.Property property = (Node.Property)object;
            try {
                return property.getValue();
            }
            catch (Exception exception) {
                ErrorManager.getDefault().getInstance(PropertiesRowModel.class.getName()).notify(1, (Throwable)exception);
            }
        }
        return null;
    }

    private int columnForProperty(String string) {
        for (int i = 0; i < this.prop.length; ++i) {
            if (!this.prop[i].getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static void toggleBooleanProperty(Node.Property<Boolean> property) {
        if (property.getValueType() == Boolean.class || property.getValueType() == Boolean.TYPE) {
            if (!property.canWrite()) {
                return;
            }
            try {
                Boolean bl = (Boolean)property.getValue();
                if (Boolean.FALSE.equals(bl)) {
                    property.setValue((Object)Boolean.TRUE);
                } else {
                    property.setValue((Object)Boolean.FALSE);
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(16, (Throwable)exception);
            }
        }
    }

    private static class OutlineTooltipUpdater
    implements MouseMotionListener,
    MouseListener {
        private MouseEvent lastMouseMovedEvent = null;

        private OutlineTooltipUpdater() {
        }

        public void fireToolTipChanged(final Outline outline, final int n) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int n2;
                    if (OutlineTooltipUpdater.this.lastMouseMovedEvent != null && (n2 = outline.rowAtPoint(OutlineTooltipUpdater.this.lastMouseMovedEvent.getPoint())) == n) {
                        ToolTipManager.sharedInstance().mouseMoved(OutlineTooltipUpdater.this.lastMouseMovedEvent);
                    }
                }
            });
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.lastMouseMovedEvent = null;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.lastMouseMovedEvent = mouseEvent;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.lastMouseMovedEvent = null;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.lastMouseMovedEvent = null;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.lastMouseMovedEvent = null;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.lastMouseMovedEvent = null;
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.lastMouseMovedEvent = null;
        }
    }
}

