/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.util.LinkedList;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.openide.util.ChangeSupport;
import org.openide.util.Task;

public interface UndoRedo {
    public static final UndoRedo NONE = new Empty();

    public boolean canUndo();

    public boolean canRedo();

    public void undo() throws CannotUndoException;

    public void redo() throws CannotRedoException;

    public void addChangeListener(ChangeListener var1);

    public void removeChangeListener(ChangeListener var1);

    public String getUndoPresentationName();

    public String getRedoPresentationName();

    @Deprecated
    public static final class Empty
    implements UndoRedo {
        public boolean canUndo() {
            return false;
        }

        public boolean canRedo() {
            return false;
        }

        public void undo() throws CannotUndoException {
            throw new CannotUndoException();
        }

        public void redo() throws CannotRedoException {
            throw new CannotRedoException();
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        public String getUndoPresentationName() {
            return "";
        }

        public String getRedoPresentationName() {
            return "";
        }
    }

    public static class Manager
    extends UndoManager
    implements UndoRedo {
        static final long serialVersionUID = 6721367974521509720L;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private LinkedList<UndoableEditEvent> runus = new LinkedList();
        private Task task = Task.EMPTY;

        private void superUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
            super.undoableEditHappened(undoableEditEvent);
        }

        private void superDiscardAllEdits() {
            super.discardAllEdits();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            LinkedList<UndoableEditEvent> linkedList = this.runus;
            synchronized (linkedList) {
                this.runus.add(undoableEditEvent);
            }
            this.updateTask();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discardAllEdits() {
            LinkedList<UndoableEditEvent> linkedList = this.runus;
            synchronized (linkedList) {
                this.runus.add(null);
            }
            this.updateTask();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean canUndo() {
            boolean bl;
            LinkedList<UndoableEditEvent> linkedList = this.runus;
            synchronized (linkedList) {
                bl = this.runus.isEmpty();
            }
            if (!bl) {
                this.task.waitFinished();
            }
            return super.canUndo();
        }

        private void updateTask() {
            class R
            implements Runnable {
                R() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (true) {
                        UndoableEditEvent undoableEditEvent;
                        LinkedList linkedList = Manager.this.runus;
                        synchronized (linkedList) {
                            if (Manager.this.runus.isEmpty()) {
                                break;
                            }
                            undoableEditEvent = (UndoableEditEvent)Manager.this.runus.removeFirst();
                        }
                        if (undoableEditEvent == null) {
                            Manager.this.superDiscardAllEdits();
                        } else {
                            Manager.this.superUndoableEditHappened(undoableEditEvent);
                        }
                        Manager.this.cs.fireChange();
                    }
                }
            }
            R r = new R();
            r.run();
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }

        public String getUndoPresentationName() {
            return this.canUndo() ? super.getUndoPresentationName() : "";
        }

        public String getRedoPresentationName() {
            return this.canRedo() ? super.getRedoPresentationName() : "";
        }
    }
}

