/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import javax.swing.event.ChangeListener;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public abstract class StatusDisplayer {
    public static final int IMPORTANCE_ANNOTATION = 1000;
    public static final int IMPORTANCE_INCREMENTAL_FIND = 900;
    public static final int IMPORTANCE_FIND_OR_REPLACE = 800;
    public static final int IMPORTANCE_ERROR_HIGHLIGHT = 700;
    private static StatusDisplayer INSTANCE = null;

    protected StatusDisplayer() {
    }

    public static synchronized StatusDisplayer getDefault() {
        if (INSTANCE == null && (INSTANCE = (StatusDisplayer)Lookup.getDefault().lookup(StatusDisplayer.class)) == null) {
            INSTANCE = new Trivial();
        }
        return INSTANCE;
    }

    public abstract String getStatusText();

    public abstract void setStatusText(String var1);

    public Message setStatusText(final String string, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid importance value: " + n);
        }
        this.setStatusText(string);
        return new Message(){

            public void clear(int n) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        if (string == StatusDisplayer.this.getStatusText()) {
                            StatusDisplayer.this.setStatusText("");
                        }
                    }
                }, n);
            }

            protected void finalize() throws Throwable {
                if (string == StatusDisplayer.this.getStatusText()) {
                    StatusDisplayer.this.setStatusText("");
                }
            }
        };
    }

    public abstract void addChangeListener(ChangeListener var1);

    public abstract void removeChangeListener(ChangeListener var1);

    public static interface Message {
        public void clear(int var1);
    }

    private static final class Trivial
    extends StatusDisplayer {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private String text = "";

        private Trivial() {
        }

        public synchronized String getStatusText() {
            return this.text;
        }

        public synchronized void setStatusText(String string) {
            if (string.equals(this.text)) {
                return;
            }
            this.text = string;
            if (string.length() > 0) {
                System.err.println("(" + string + ")");
            }
            this.cs.fireChange();
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }
    }
}

