/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

@Deprecated
public class ListPane
extends JList {
    static final long serialVersionUID = 3828318151121500783L;
    private int fixedCellWidth = 100;
    private int fixedCellHeight = 100;
    private int visibleRowCount = 6;
    private int visibleColumnCount = 4;
    private int realRowCount = 1;
    private int realColumnCount = 1;
    ListDataListener dataL;
    PropertyChangeListener propertyL;
    InputListener inputL;
    ListSelectionListener selectionL;
    boolean updateLayoutStateNeeded = true;

    public ListPane(ListModel listModel) {
        super(listModel);
        this.addListListeners();
    }

    public ListPane(final Object[] objectArray) {
        this((ListModel)new AbstractListModel(){

            public int getSize() {
                return objectArray.length;
            }

            public Object getElementAt(int n) {
                return objectArray[n];
            }
        });
    }

    public ListPane(final Vector vector) {
        this((ListModel)new AbstractListModel(){

            public int getSize() {
                return vector.size();
            }

            public Object getElementAt(int n) {
                return vector.elementAt(n);
            }
        });
    }

    public ListPane() {
        this((ListModel)new AbstractListModel(){

            public int getSize() {
                return 0;
            }

            public Object getElementAt(int n) {
                return null;
            }
        });
    }

    public boolean isOpaque() {
        return true;
    }

    public int getVisibleColumnCount() {
        return this.visibleColumnCount;
    }

    public void setVisibleColumnCount(int n) {
        int n2 = this.visibleColumnCount;
        this.visibleColumnCount = Math.max(0, n);
        this.firePropertyChange("visibleColumnCount", n2, n);
    }

    public void ensureIndexIsVisible(int n) {
        Point point = this.indexToLocation(n);
        if (point != null) {
            Rectangle rectangle = new Rectangle(point.x, point.y, this.fixedCellWidth, this.fixedCellHeight);
            this.scrollRectToVisible(rectangle);
        }
    }

    public int locationToIndex(Point point) {
        int n = point.x / this.fixedCellWidth;
        if (n >= this.realColumnCount) {
            return -1;
        }
        int n2 = point.y / this.fixedCellHeight;
        if (n2 >= this.realRowCount) {
            return -1;
        }
        int n3 = n2 * this.realColumnCount + n;
        return n3 >= this.getModel().getSize() ? -1 : n3;
    }

    public Point indexToLocation(int n) {
        if (n >= this.getModel().getSize()) {
            return null;
        }
        int n2 = n / this.realColumnCount;
        int n3 = n % this.realColumnCount;
        return new Point(n3 * this.fixedCellWidth, n2 * this.fixedCellHeight);
    }

    public Rectangle getCellBounds(int n, int n2) {
        Point point = this.indexToLocation(n);
        Point point2 = this.indexToLocation(n2);
        int n3 = point.x;
        int n4 = point.y;
        int n5 = point2.x + this.fixedCellWidth;
        int n6 = point2.y + this.fixedCellHeight;
        if (point.y != point2.y) {
            n3 = 0;
            n5 = this.fixedCellWidth * this.realColumnCount;
        }
        return new Rectangle(n3, n4, n5 - n3, n6 - n4);
    }

    public Dimension getPreferredScrollableViewportSize() {
        Insets insets = this.getInsets();
        int n = insets.left + insets.right + this.visibleColumnCount * this.fixedCellWidth;
        int n2 = insets.top + insets.bottom + this.visibleRowCount * this.fixedCellHeight;
        Dimension dimension = new Dimension(n, n2);
        return dimension;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return 1;
        }
        int n3 = this.getFirstVisibleIndex();
        if (n3 == -1) {
            return 0;
        }
        if (n2 > 0) {
            Rectangle rectangle2 = this.getCellBounds(n3, n3);
            return rectangle2 == null ? 0 : rectangle2.height - (rectangle.y - rectangle2.y);
        }
        Rectangle rectangle3 = this.getCellBounds(n3, n3);
        if (rectangle3.y == rectangle.y && n3 == 0) {
            return 0;
        }
        if (rectangle3.y == rectangle.y) {
            Rectangle rectangle4 = this.getCellBounds(n3 - 1, n3 - 1);
            return rectangle4 == null ? 0 : rectangle4.height;
        }
        return rectangle.y - rectangle3.y;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return n == 1 ? rectangle.height : rectangle.width;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    protected void paintBackground(Graphics graphics) {
        if (this.isOpaque()) {
            Color color = graphics.getColor();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(color);
        }
    }

    private void paintCell(Graphics graphics, int n) {
        Object e = this.getModel().getElementAt(n);
        boolean bl = this.hasFocus() && n == this.getSelectionModel().getLeadSelectionIndex();
        boolean bl2 = this.getSelectionModel().isSelectedIndex(n);
        Component component = this.getCellRenderer().getListCellRendererComponent(this, e, n, bl2, bl);
        component.setSize(this.fixedCellWidth, this.fixedCellHeight);
        component.paint(graphics);
    }

    protected void paintComponent(Graphics graphics) {
        this.updateLayoutState();
        if (this.getCellRenderer() == null) {
            return;
        }
        this.paintBackground(graphics);
        int n = this.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            this.paintCell(graphics, i);
            if ((i + 1) % this.realColumnCount == 0) {
                n3 = -this.fixedCellWidth * (this.realColumnCount - 1);
                n2 = this.fixedCellHeight;
            } else {
                n3 = this.fixedCellWidth;
                n2 = 0;
            }
            graphics.translate(n3, n2);
        }
    }

    private void updateLayoutState() {
        int n;
        Dimension dimension = this.getSize();
        int n2 = dimension.width / this.fixedCellWidth;
        if (n2 < 1) {
            n2 = 1;
        }
        if (n2 != this.realColumnCount) {
            this.realColumnCount = n2;
            this.updateLayoutStateNeeded = true;
        }
        if ((n = dimension.height / this.fixedCellHeight) != this.realRowCount) {
            this.realRowCount = n;
            this.updateLayoutStateNeeded = true;
        }
        while (this.realRowCount * this.realColumnCount < this.getModel().getSize()) {
            ++this.realRowCount;
        }
        this.locationToIndex(this.getVisibleRect().getLocation());
        if (this.updateLayoutStateNeeded) {
            this.updateLayoutStateNeeded = false;
            this.revalidate();
        }
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        int n = this.getModel().getSize() - 1;
        if (n <= 0) {
            return new Dimension(this.fixedCellWidth, this.fixedCellHeight);
        }
        int n2 = n / this.realColumnCount + 1;
        int n3 = n < this.realColumnCount ? n + 1 : this.realColumnCount;
        int n4 = this.getParent().getSize().width;
        int n5 = this.getParent().getSize().height;
        int n6 = Math.max(n4, n3 * this.fixedCellWidth);
        int n7 = Math.max(n5, n2 * this.fixedCellHeight);
        Dimension dimension = new Dimension(n6, n7);
        return dimension;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.fixedCellWidth, this.fixedCellHeight);
    }

    private void addListListeners() {
        this.inputL = this.createInputListener();
        this.addMouseListener(this.inputL);
        this.addKeyListener(this.inputL);
        this.addFocusListener(this.inputL);
        this.propertyL = this.createPropertyListener();
        this.addPropertyChangeListener(this.propertyL);
        this.dataL = this.createDataListener();
        ListModel listModel = this.getModel();
        if (listModel != null) {
            listModel.addListDataListener(this.dataL);
        }
        if (this.selectionL == null) {
            this.selectionL = new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ListPane.this.repaint();
                }
            };
            ListSelectionModel listSelectionModel = this.getSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.addListSelectionListener(this.selectionL);
            }
        }
    }

    private InputListener createInputListener() {
        return new InputListener();
    }

    private ListDataListener createDataListener() {
        return new DataListener();
    }

    private PropertyChangeListener createPropertyListener() {
        return new PropertyListener();
    }

    private void mySetSelectionInterval(int n, int n2) {
        super.setSelectionInterval(n, n2);
    }

    private void myAddSelectionInterval(int n, int n2) {
        super.addSelectionInterval(n, n2);
    }

    private void myRemoveSelectionInterval(int n, int n2) {
        super.removeSelectionInterval(n, n2);
    }

    public void setSelectionInterval(int n, int n2) {
    }

    public void addSelectionInterval(int n, int n2) {
    }

    public void removeSelectionInterval(int n, int n2) {
    }

    private class DataListener
    implements ListDataListener,
    Serializable {
        static final long serialVersionUID = -2252515707418441L;

        DataListener() {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            ListPane.this.updateLayoutStateNeeded = true;
            int n = Math.min(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            int n2 = Math.max(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            ListSelectionModel listSelectionModel = ListPane.this.getSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.insertIndexInterval(n, n2 - n, true);
            }
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            ListPane.this.updateLayoutStateNeeded = true;
            ListSelectionModel listSelectionModel = ListPane.this.getSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.removeIndexInterval(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            }
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            ListPane.this.updateLayoutStateNeeded = true;
        }
    }

    private class InputListener
    extends MouseAdapter
    implements FocusListener,
    KeyListener,
    Serializable {
        static final long serialVersionUID = -7907848327510962576L;
        transient int dragFirstIndex = -1;
        transient int dragLastIndex = -1;

        InputListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.updateSelection(ListPane.this.locationToIndex(mouseEvent.getPoint()), mouseEvent);
            if (!ListPane.this.hasFocus()) {
                ListPane.this.requestFocus();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            this.repaintCellFocus();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.repaintCellFocus();
        }

        protected void repaintCellFocus() {
            ListPane.this.repaint();
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void keyPressed(KeyEvent keyEvent) {
            int n = ListPane.this.getLeadSelectionIndex();
            if (n < 0) {
                if (ListPane.this.getModel().getSize() <= 0) return;
                n = 0;
            } else {
                switch (keyEvent.getKeyCode()) {
                    case 37: {
                        --n;
                        break;
                    }
                    case 39: {
                        ++n;
                        break;
                    }
                    case 38: {
                        n -= ListPane.this.realColumnCount;
                        break;
                    }
                    case 40: {
                        n += ListPane.this.realColumnCount;
                        break;
                    }
                    case 36: {
                        n = 0;
                        break;
                    }
                    case 35: {
                        n = ListPane.this.getModel().getSize() - 1;
                        break;
                    }
                    case 33: {
                        n -= ListPane.this.realColumnCount * ListPane.this.realRowCount;
                        break;
                    }
                    case 34: {
                        n += ListPane.this.realColumnCount * ListPane.this.realRowCount;
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (n < 0) {
                n = 0;
            }
            if (n > ListPane.this.getModel().getSize() - 1) {
                n = ListPane.this.getModel().getSize() - 1;
            }
            if (n < 0) return;
            this.updateSelection(n, keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        protected void updateSelection(int n, InputEvent inputEvent) {
            ListSelectionModel listSelectionModel = ListPane.this.getSelectionModel();
            if (n != -1) {
                ListPane.this.setValueIsAdjusting(true);
                if (inputEvent.isShiftDown()) {
                    if (inputEvent.isControlDown()) {
                        if (this.dragFirstIndex == -1) {
                            ListPane.this.myAddSelectionInterval(n, n);
                        } else if (this.dragLastIndex == -1) {
                            ListPane.this.myAddSelectionInterval(this.dragFirstIndex, n);
                        } else {
                            ListPane.this.myRemoveSelectionInterval(this.dragFirstIndex, this.dragLastIndex);
                            ListPane.this.myAddSelectionInterval(this.dragFirstIndex, n);
                        }
                    } else if (this.dragFirstIndex == -1) {
                        ListPane.this.myAddSelectionInterval(n, n);
                    } else {
                        ListPane.this.mySetSelectionInterval(this.dragFirstIndex, n);
                    }
                    if (this.dragFirstIndex == -1) {
                        this.dragFirstIndex = n;
                        this.dragLastIndex = -1;
                    } else {
                        this.dragLastIndex = n;
                    }
                } else {
                    if (inputEvent.isControlDown()) {
                        if (ListPane.this.isSelectedIndex(n)) {
                            ListPane.this.myRemoveSelectionInterval(n, n);
                        } else {
                            ListPane.this.myAddSelectionInterval(n, n);
                        }
                    } else {
                        ListPane.this.mySetSelectionInterval(n, n);
                    }
                    this.dragFirstIndex = n;
                    this.dragLastIndex = -1;
                }
                ListPane.this.setValueIsAdjusting(false);
            } else {
                listSelectionModel.clearSelection();
            }
        }
    }

    private class PropertyListener
    implements PropertyChangeListener,
    Serializable {
        static final long serialVersionUID = -6765578311995604737L;

        PropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("model")) {
                ListModel listModel = (ListModel)propertyChangeEvent.getOldValue();
                ListModel listModel2 = (ListModel)propertyChangeEvent.getNewValue();
                if (listModel != null) {
                    listModel.removeListDataListener(ListPane.this.dataL);
                }
                if (listModel2 != null) {
                    listModel2.addListDataListener(ListPane.this.dataL);
                    ListPane.this.updateLayoutStateNeeded = true;
                    ListPane.this.repaint();
                }
            } else if (string.equals("selectionModel")) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)propertyChangeEvent.getOldValue();
                ListSelectionModel listSelectionModel2 = (ListSelectionModel)propertyChangeEvent.getNewValue();
                if (listSelectionModel != null) {
                    listSelectionModel.removeListSelectionListener(ListPane.this.selectionL);
                }
                if (listSelectionModel2 != null) {
                    listSelectionModel2.addListSelectionListener(ListPane.this.selectionL);
                }
                ListPane.this.updateLayoutStateNeeded = true;
                ListPane.this.repaint();
            } else if (string.equals("cellRenderer") || string.equals("font") || string.equals("fixedCellHeight") || string.equals("fixedCellWidth")) {
                ListPane.this.updateLayoutStateNeeded = true;
                ListPane.this.repaint();
            }
        }
    }
}

