/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openide.awt.SwingBrowserImpl;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class HtmlBrowser
extends JPanel {
    private static final long serialVersionUID = 2912844785502987960L;
    public static final int DEFAULT_WIDTH = 400;
    public static final int DEFAULT_HEIGHT = 600;
    private static Factory browserFactory;
    private static String homePage;
    final Impl browserImpl;
    private boolean everythinkIListenInCheckBoxIsUnimportant = false;
    private boolean toolbarVisible = false;
    private boolean statusLineVisible = false;
    private BrowserListener browserListener;
    private JButton bBack;
    private JButton bForward;
    private JButton bReload;
    private JButton bStop;
    private JTextField txtLocation;
    private JLabel lStatusLine;
    final Component browserComponent;
    private JPanel head;
    private RequestProcessor rp = new RequestProcessor();

    public HtmlBrowser() {
        this(true, true);
    }

    public HtmlBrowser(boolean bl, boolean bl2) {
        this(null, bl, bl2);
    }

    public HtmlBrowser(Factory factory, boolean bl, boolean bl2) {
        Impl impl = null;
        Component component = null;
        try {
            if (factory == null) {
                Impl[] implArray = new Impl[1];
                component = HtmlBrowser.findComponent(implArray);
                impl = implArray[0];
            } else {
                try {
                    impl = factory.createHtmlBrowserImpl();
                    component = impl.getComponent();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    Exceptions.printStackTrace((Throwable)unsupportedOperationException);
                    impl = new SwingBrowserImpl();
                    component = impl.getComponent();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            Exceptions.attachLocalizedMessage((Throwable)runtimeException, (String)NbBundle.getMessage(HtmlBrowser.class, (String)"EXC_Module"));
            Exceptions.printStackTrace((Throwable)runtimeException);
        }
        this.browserImpl = impl;
        this.browserComponent = component;
        this.setLayout(new BorderLayout(0, 2));
        this.add(this.browserComponent != null ? this.browserComponent : new JScrollPane(), "Center");
        this.browserListener = new BrowserListener();
        if (bl) {
            this.initToolbar();
        }
        if (bl2) {
            this.initStatusLine();
        }
        this.browserImpl.addPropertyChangeListener(this.browserListener);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HtmlBrowser.class, (String)"ACS_HtmlBrowser"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HtmlBrowser.class, (String)"ACSD_HtmlBrowser"));
    }

    public static void setHomePage(String string) {
        homePage = string;
    }

    public static String getHomePage() {
        if (homePage == null) {
            return NbBundle.getMessage(HtmlBrowser.class, (String)"PROP_HomePage");
        }
        return homePage;
    }

    @Deprecated
    public static void setFactory(Factory factory) {
        browserFactory = factory;
    }

    private static Component findComponent(Impl[] implArray) {
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(Factory.class));
        for (Factory factory : result.allInstances()) {
            try {
                Impl impl = factory.createHtmlBrowserImpl();
                Component component = impl != null ? impl.getComponent() : null;
                if (component == null) continue;
                implArray[0] = impl;
                return component;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        Factory factory = browserFactory;
        if (factory != null) {
            try {
                implArray[0] = factory.createHtmlBrowserImpl();
                return implArray[0].getComponent();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        implArray[0] = new SwingBrowserImpl();
        return implArray[0].getComponent();
    }

    private void initToolbar() {
        this.toolbarVisible = true;
        this.head = new JPanel(new GridBagLayout());
        this.bBack = new JButton();
        this.bBack.setBorder(BorderFactory.createEmptyBorder());
        this.bBack.setBorderPainted(false);
        this.bBack.setContentAreaFilled(false);
        this.bBack.setIcon(ImageUtilities.loadImageIcon((String)"org/openide/resources/html/back_normal.png", (boolean)true));
        this.bBack.setRolloverIcon(ImageUtilities.loadImageIcon((String)"org/openide/resources/html/back_hover.png", (boolean)true));
        this.bBack.setDisabledIcon(ImageUtilities.loadImageIcon((String)"org/openide/resources/html/back_disabled.png", (boolean)true));
        this.bBack.setSelectedIcon(this.bBack.getIcon());
        this.bBack.setToolTipText(NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_Back"));
        this.bForward = new JButton();
        this.bForward.setBorder(BorderFactory.createEmptyBorder());
        this.bForward.setBorderPainted(false);
        this.bForward.setContentAreaFilled(false);
        this.bForward.setIcon(ImageUtilities.loadImageIcon((String)"org/openide/resources/html/forward_normal.png", (boolean)true));
        this.bForward.setRolloverIcon(ImageUtilities.loadImageIcon((String)"org/openide/resources/html/forward_hover.png", (boolean)true));
        this.bForward.setDisabledIcon(ImageUtilities.loadImageIcon((String)"org/openide/resources/html/forward_disabled.png", (boolean)true));
        this.bForward.setSelectedIcon(this.bForward.getIcon());
        this.bForward.setToolTipText(NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_Forward"));
        this.bReload = new JButton();
        this.bReload.setBorder(BorderFactory.createEmptyBorder());
        this.bReload.setBorderPainted(false);
        this.bReload.setContentAreaFilled(false);
        this.bReload.setIcon(ImageUtilities.loadImageIcon((String)"org/openide/resources/html/refresh.png", (boolean)true));
        this.bReload.setRolloverIcon(ImageUtilities.loadImageIcon((String)"org/openide/resources/html/refresh_hover.png", (boolean)true));
        this.bReload.setDisabledIcon(ImageUtilities.loadImageIcon((String)"org/openide/resources/html/refresh.png", (boolean)true));
        this.bReload.setSelectedIcon(this.bReload.getIcon());
        this.bReload.setToolTipText(NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_Reload"));
        this.bReload.setFocusPainted(false);
        this.bStop = new JButton();
        this.bStop.setBorderPainted(false);
        this.bStop.setBorder(BorderFactory.createEmptyBorder());
        this.bStop.setContentAreaFilled(false);
        this.bStop.setIcon(ImageUtilities.loadImageIcon((String)"org/openide/resources/html/stop.png", (boolean)true));
        this.bStop.setRolloverIcon(ImageUtilities.loadImageIcon((String)"org/openide/resources/html/stop_hover.png", (boolean)true));
        this.bStop.setDisabledIcon(ImageUtilities.loadImageIcon((String)"org/openide/resources/html/stop.png", (boolean)true));
        this.bStop.setSelectedIcon(this.bStop.getIcon());
        this.bStop.setToolTipText(NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_Stop"));
        this.bStop.setFocusPainted(false);
        this.txtLocation = new JTextField();
        this.txtLocation.setEditable(true);
        this.txtLocation.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 1) {
                    if (null != HtmlBrowser.this.txtLocation.getSelectedText() || HtmlBrowser.this.txtLocation.isFocusOwner()) {
                        return;
                    }
                    HtmlBrowser.this.txtLocation.selectAll();
                }
            }
        });
        this.head.add((Component)this.bBack, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 1), 0, 0));
        this.head.add((Component)this.bForward, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 4), 0, 0));
        this.head.add((Component)this.txtLocation, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 4), 0, 0));
        this.head.add((Component)this.bReload, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 4), 0, 0));
        this.head.add((Component)this.bStop, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.head.setBorder(BorderFactory.createEmptyBorder(8, 10, 8, 10));
        if (this.browserImpl != null) {
            this.bBack.setEnabled(this.browserImpl.isBackward());
            this.bForward.setEnabled(this.browserImpl.isForward());
        }
        this.txtLocation.addActionListener(this.browserListener);
        this.bBack.addActionListener(this.browserListener);
        this.bForward.addActionListener(this.browserListener);
        this.bReload.addActionListener(this.browserListener);
        this.bStop.addActionListener(this.browserListener);
        this.bBack.getAccessibleContext().setAccessibleName(this.bBack.getToolTipText());
        this.bForward.getAccessibleContext().setAccessibleName(this.bForward.getToolTipText());
        this.bReload.getAccessibleContext().setAccessibleName(this.bReload.getToolTipText());
        this.bStop.getAccessibleContext().setAccessibleName(this.bStop.getToolTipText());
        this.txtLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HtmlBrowser.class, (String)"ACSD_HtmlBrowser_Location"));
        this.add((Component)this.head, "North");
    }

    private void destroyToolbar() {
        this.remove(this.head);
        this.head = null;
        this.toolbarVisible = false;
    }

    private void initStatusLine() {
        this.statusLineVisible = true;
        this.lStatusLine = new JLabel(NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_Loading"));
        this.add((Component)this.lStatusLine, "South");
        this.lStatusLine.setLabelFor(this);
    }

    private void destroyStatusLine() {
        this.remove(this.lStatusLine);
        this.lStatusLine = null;
        this.statusLineVisible = false;
    }

    public void setURL(String string) {
        if (null != string) {
            try {
                string = new URL(string).toExternalForm();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.browserImpl.setLocation(string);
    }

    public void setURL(final URL uRL) {
        if (uRL == null) {
            this.txtLocation.setText(null);
            return;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class URLSetter
        implements Runnable {
            private boolean sameHosts = false;

            URLSetter() {
            }

            @Override
            public void run() {
                if (!SwingUtilities.isEventDispatchThread()) {
                    this.sameHosts = "nbfs".equals(uRL.getProtocol()) ? true : uRL.getHost() != null && HtmlBrowser.this.browserImpl.getURL() != null && uRL.getHost().equals(HtmlBrowser.this.browserImpl.getURL().getHost());
                    SwingUtilities.invokeLater(this);
                } else if (uRL.equals(HtmlBrowser.this.browserImpl.getURL()) && this.sameHosts) {
                    HtmlBrowser.this.browserImpl.reloadDocument();
                } else {
                    HtmlBrowser.this.browserImpl.setURL(uRL);
                }
            }
        }
        this.rp.post((Runnable)new URLSetter());
    }

    public final URL getDocumentURL() {
        return this.browserImpl.getURL();
    }

    public final void setEnableHome(boolean bl) {
    }

    public final void setEnableLocation(boolean bl) {
        this.txtLocation.setEnabled(bl);
        this.txtLocation.setVisible(bl);
    }

    public boolean isStatusLineVisible() {
        return this.statusLineVisible;
    }

    public void setStatusLineVisible(boolean bl) {
        if (bl == this.statusLineVisible) {
            return;
        }
        if (bl) {
            this.initStatusLine();
        } else {
            this.destroyStatusLine();
        }
    }

    public boolean isToolbarVisible() {
        return this.toolbarVisible;
    }

    public void setToolbarVisible(boolean bl) {
        if (bl == this.toolbarVisible) {
            return;
        }
        if (bl) {
            this.initToolbar();
        } else {
            this.destroyToolbar();
        }
    }

    public final Impl getBrowserImpl() {
        return this.browserImpl;
    }

    public final Component getBrowserComponent() {
        return this.browserComponent;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.max(400, dimension.width), Math.max(600, dimension.height));
    }

    private void updateLocationBar() {
        if (this.toolbarVisible) {
            this.everythinkIListenInCheckBoxIsUnimportant = true;
            String string = this.browserImpl.getLocation();
            this.txtLocation.setText(string);
            this.everythinkIListenInCheckBoxIsUnimportant = false;
        }
    }

    public void requestFocus() {
        if (this.browserComponent != null) {
            boolean bl = false;
            if (this.browserComponent instanceof JComponent) {
                bl = ((JComponent)this.browserComponent).requestDefaultFocus();
            }
            if (!bl) {
                this.browserComponent.requestFocus();
            }
        } else {
            super.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        if (this.browserComponent != null) {
            boolean bl = false;
            if (this.browserComponent instanceof JComponent) {
                bl = ((JComponent)this.browserComponent).requestDefaultFocus();
            }
            if (!bl) {
                return this.browserComponent.requestFocusInWindow();
            }
            return true;
        }
        return super.requestFocusInWindow();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleHtmlBrowser();
        }
        return this.accessibleContext;
    }

    static {
        homePage = null;
    }

    private class AccessibleHtmlBrowser
    extends JPanel.AccessibleJPanel {
        AccessibleHtmlBrowser() {
            super(HtmlBrowser.this);
        }

        public void setAccessibleName(String string) {
            super.setAccessibleName(string);
            if (HtmlBrowser.this.browserComponent instanceof Accessible) {
                HtmlBrowser.this.browserComponent.getAccessibleContext().setAccessibleName(string);
            }
        }

        public void setAccessibleDescription(String string) {
            super.setAccessibleDescription(string);
            if (HtmlBrowser.this.browserComponent instanceof Accessible) {
                HtmlBrowser.this.browserComponent.getAccessibleContext().setAccessibleDescription(string);
            }
        }
    }

    private class BrowserListener
    implements ActionListener,
    PropertyChangeListener {
        BrowserListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null) {
                return;
            }
            if (string.equals("url") || string.equals("title")) {
                HtmlBrowser.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
            if (string.equals("url")) {
                HtmlBrowser.this.updateLocationBar();
            } else if (string.equals("statusMessage")) {
                String string2 = HtmlBrowser.this.browserImpl.getStatusMessage();
                if (string2 == null || string2.length() < 1) {
                    string2 = NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_Document_done");
                }
                if (HtmlBrowser.this.lStatusLine != null) {
                    HtmlBrowser.this.lStatusLine.setText(string2);
                }
            } else if (string.equals("forward") && HtmlBrowser.this.bForward != null) {
                HtmlBrowser.this.bForward.setEnabled(HtmlBrowser.this.browserImpl.isForward());
            } else if (string.equals("backward") && HtmlBrowser.this.bBack != null) {
                HtmlBrowser.this.bBack.setEnabled(HtmlBrowser.this.browserImpl.isBackward());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == HtmlBrowser.this.txtLocation) {
                if (HtmlBrowser.this.everythinkIListenInCheckBoxIsUnimportant) {
                    return;
                }
                String string = HtmlBrowser.this.txtLocation.getText();
                if (string == null || string.length() == 0) {
                    return;
                }
                HtmlBrowser.this.setURL(string);
            } else if (actionEvent.getSource() == HtmlBrowser.this.bBack) {
                HtmlBrowser.this.browserImpl.backward();
            } else if (actionEvent.getSource() == HtmlBrowser.this.bForward) {
                HtmlBrowser.this.browserImpl.forward();
            } else if (actionEvent.getSource() == HtmlBrowser.this.bReload) {
                HtmlBrowser.this.updateLocationBar();
                HtmlBrowser.this.browserImpl.reloadDocument();
            } else if (actionEvent.getSource() == HtmlBrowser.this.bStop) {
                HtmlBrowser.this.browserImpl.stopLoading();
            }
        }
    }

    public static interface Factory {
        public Impl createHtmlBrowserImpl();
    }

    public static abstract class Impl {
        static final long serialVersionUID = 2912844785502962114L;
        public static final String PROP_STATUS_MESSAGE = "statusMessage";
        public static final String PROP_URL = "url";
        public static final String PROP_TITLE = "title";
        public static final String PROP_FORWARD = "forward";
        public static final String PROP_BACKWARD = "backward";
        public static final String PROP_HISTORY = "history";

        public abstract Component getComponent();

        public abstract void reloadDocument();

        public abstract void stopLoading();

        public abstract void setURL(URL var1);

        public abstract URL getURL();

        public String getLocation() {
            URL uRL = this.getURL();
            return null == uRL ? null : uRL.toString();
        }

        public void setLocation(String string) {
            URL uRL;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    uRL = new URL("http://" + string);
                }
                catch (MalformedURLException malformedURLException2) {
                    String string2 = NbBundle.getMessage(SwingBrowserImpl.class, (String)"FMT_InvalidURL", (Object[])new Object[]{string});
                    if (this instanceof SwingBrowserImpl) {
                        ((SwingBrowserImpl)this).setStatusText(string2);
                    } else {
                        Logger.getLogger(HtmlBrowser.class.getName()).log(Level.INFO, string2, malformedURLException);
                    }
                    return;
                }
            }
            this.setURL(uRL);
        }

        public abstract String getStatusMessage();

        public abstract String getTitle();

        public abstract boolean isForward();

        public abstract void forward();

        public abstract boolean isBackward();

        public abstract void backward();

        public abstract boolean isHistory();

        public abstract void showHistory();

        public abstract void addPropertyChangeListener(PropertyChangeListener var1);

        public abstract void removePropertyChangeListener(PropertyChangeListener var1);

        public void dispose() {
        }
    }

    private static final class TrivialURLDisplayer
    extends URLDisplayer {
        public void showURL(URL uRL) {
            HtmlBrowser htmlBrowser = new HtmlBrowser();
            htmlBrowser.setURL(uRL);
            JFrame jFrame = new JFrame();
            jFrame.setDefaultCloseOperation(2);
            jFrame.getContentPane().add(htmlBrowser);
            jFrame.pack();
            jFrame.setVisible(true);
        }
    }

    public static abstract class URLDisplayer {
        protected URLDisplayer() {
        }

        public static URLDisplayer getDefault() {
            URLDisplayer uRLDisplayer = (URLDisplayer)Lookup.getDefault().lookup(URLDisplayer.class);
            if (uRLDisplayer == null) {
                uRLDisplayer = new TrivialURLDisplayer();
            }
            return uRLDisplayer;
        }

        public abstract void showURL(URL var1);

        public void showURLExternal(URL uRL) {
            this.showURL(uRL);
        }
    }
}

