/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import org.openide.awt.ContextActionEnabler;
import org.openide.awt.ContextActionPerformer;
import org.openide.awt.ContextManager;
import org.openide.awt.ContextSelection;
import org.openide.awt.GeneralAction;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ContextAction<T>
implements Action,
ContextAwareAction {
    private final Class<T> type;
    final ContextSelection selectMode;
    private final Performer<? super T> performer;
    private final ContextManager global;
    private PropertyChangeSupport support;
    private boolean previousEnabled;

    public ContextAction(Performer<? super T> performer, ContextSelection contextSelection, Lookup lookup, Class<T> clazz, boolean bl) {
        if (performer == null) {
            throw new NullPointerException("Has to provide a key!");
        }
        this.type = clazz;
        this.selectMode = contextSelection;
        this.performer = performer;
        this.global = ContextManager.findManager(lookup, bl);
    }

    public String toString() {
        return super.toString() + "[type=" + this.type + ", performer=" + this.performer + "]";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.global.actionPerformed(actionEvent, this.performer, this.type, this.selectMode);
    }

    @Override
    public boolean isEnabled() {
        boolean bl;
        assert (EventQueue.isDispatchThread());
        this.previousEnabled = bl = this.global.isEnabled(this.type, this.selectMode, this.performer);
        return bl;
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        boolean bl = false;
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
            bl = true;
        }
        this.support.addPropertyChangeListener(propertyChangeListener);
        if (bl) {
            this.global.registerListener(this.type, this);
        }
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (null != this.support) {
            this.support.removePropertyChangeListener(propertyChangeListener);
            if (!this.support.hasListeners(null)) {
                this.global.unregisterListener(this.type, this);
                this.support = null;
            }
        }
    }

    @Override
    public void putValue(String string, Object object) {
    }

    @Override
    public Object getValue(String string) {
        if ("enabler".equals(string)) {
            assert (EventQueue.isDispatchThread());
            this.updateState();
        }
        return null;
    }

    @Override
    public void setEnabled(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateState() {
        PropertyChangeSupport propertyChangeSupport;
        ContextAction contextAction = this;
        synchronized (contextAction) {
            propertyChangeSupport = this.support;
        }
        boolean bl = this.previousEnabled;
        if (propertyChangeSupport != null && bl != this.isEnabled()) {
            propertyChangeSupport.firePropertyChange("enabled", (Object)bl, (Object)(!bl ? 1 : 0));
        }
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ContextAction<T>(this.performer, this.selectMode, lookup, this.type, this.global.isSurvive());
    }

    public int hashCode() {
        int n = this.type.hashCode();
        int n2 = this.selectMode.hashCode();
        int n3 = this.performer.hashCode();
        return (n << 2) + (n2 << 1) + n3;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ContextAction) {
            ContextAction contextAction = (ContextAction)object;
            return this.type.equals(contextAction.type) && this.selectMode.equals((Object)contextAction.selectMode) && this.performer.equals(contextAction.performer);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Performer<Data> {
        final Map delegate;

        public Performer(Map map) {
            this.delegate = map;
        }

        public Performer(ContextActionPerformer<Data> contextActionPerformer, ContextActionEnabler<Data> contextActionEnabler) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("delegate", contextActionPerformer);
            hashMap.put("enabler", contextActionEnabler);
            this.delegate = hashMap;
        }

        public void actionPerformed(ActionEvent actionEvent, List<? extends Data> list, Lookup.Provider provider) {
            Object v = this.delegate.get("delegate");
            if (v instanceof ContextActionPerformer) {
                ContextActionPerformer contextActionPerformer = (ContextActionPerformer)v;
                contextActionPerformer.actionPerformed(actionEvent, list);
                return;
            }
            if (v instanceof Performer) {
                Performer performer = (Performer)v;
                performer.actionPerformed(actionEvent, list, provider);
                return;
            }
            if (v instanceof ContextAwareAction) {
                Action action = ((ContextAwareAction)v).createContextAwareInstance(provider.getLookup());
                action.actionPerformed(actionEvent);
                return;
            }
            GeneralAction.LOG.warning("No 'delegate' for " + this.delegate);
        }

        public boolean enabled(List<? extends Object> list) {
            Object v = this.delegate.get("enabler");
            if (v == null) {
                return true;
            }
            if (v instanceof ContextActionEnabler) {
                ContextActionEnabler contextActionEnabler = (ContextActionEnabler)v;
                return contextActionEnabler.enabled(list);
            }
            GeneralAction.LOG.warning("Wrong enabler for " + this.delegate + ":" + v);
            return false;
        }

        public int hashCode() {
            return ((Object)this.delegate).hashCode() + 117;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Performer) {
                Performer performer = (Performer)object;
                return ((Object)this.delegate).equals(performer.delegate);
            }
            return false;
        }
    }
}

