/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.palette;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.html.palette.HtmlPaletteActions;
import org.netbeans.modules.html.palette.api.HtmlPaletteFolderProvider;
import org.netbeans.spi.palette.DragAndDropHandler;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.ExTransferable;

public final class HtmlPaletteFactory {
    static final String DEFAULT_HTML_PALETTE_FOLDER = "HTMLPalette";
    private static Map<String, PaletteController> PALETTES = new HashMap<String, PaletteController>();

    public static PaletteController getPalette() throws IOException {
        return HtmlPaletteFactory.getOrCreatePalette(DEFAULT_HTML_PALETTE_FOLDER);
    }

    public static PaletteController getPalette(FileObject fileObject) throws IOException {
        String string;
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)fileObject.getMIMEType()));
        HtmlPaletteFolderProvider htmlPaletteFolderProvider = (HtmlPaletteFolderProvider)lookup.lookup(HtmlPaletteFolderProvider.class);
        if (htmlPaletteFolderProvider == null) {
            htmlPaletteFolderProvider = new PaletteNameProvider();
        }
        if ((string = htmlPaletteFolderProvider.getPaletteFolderName(fileObject)) == null) {
            string = DEFAULT_HTML_PALETTE_FOLDER;
        }
        return HtmlPaletteFactory.getOrCreatePalette(string);
    }

    private static PaletteController getOrCreatePalette(String string) throws IOException {
        PaletteController paletteController = PALETTES.get(string);
        if (paletteController == null) {
            paletteController = PaletteFactory.createPalette((String)string, (PaletteActions)new HtmlPaletteActions(), null, (DragAndDropHandler)new HtmlDragAndDropHandler());
            PALETTES.put(string, paletteController);
        }
        return paletteController;
    }

    private static class HtmlDragAndDropHandler
    extends DragAndDropHandler {
        public HtmlDragAndDropHandler() {
            super(true);
        }

        public void customize(ExTransferable exTransferable, Lookup lookup) {
        }
    }

    public static class PaletteNameProvider
    implements HtmlPaletteFolderProvider {
        public String getPaletteFolderName(FileObject fileObject) {
            return HtmlPaletteFactory.DEFAULT_HTML_PALETTE_FOLDER;
        }
    }
}

