/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.languages.yaml.YamlLexer;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.LanguageProvider;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum YamlTokenId implements TokenId
{
    TEXT("identifier"),
    COMMENT("comment"),
    RUBYCOMMENT("comment"),
    RUBY_EXPR("ruby"),
    RUBY("ruby"),
    DELIMITER("ruby-delimiter"),
    PHP("php");

    private final String primaryCategory;
    private static final Language<YamlTokenId> language;
    public static final String YAML_MIME_TYPE = "text/x-yaml";

    private YamlTokenId(String string2) {
        this.primaryCategory = string2;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    public static boolean isRuby(TokenId tokenId) {
        return tokenId == RUBY || tokenId == RUBY_EXPR || tokenId == RUBYCOMMENT;
    }

    public static Language<YamlTokenId> language() {
        return language;
    }

    static {
        language = new LanguageHierarchy<YamlTokenId>(){

            protected String mimeType() {
                return YamlTokenId.YAML_MIME_TYPE;
            }

            protected Collection<YamlTokenId> createTokenIds() {
                return EnumSet.allOf(YamlTokenId.class);
            }

            protected Map<String, Collection<YamlTokenId>> createTokenCategories() {
                HashMap<String, Collection<YamlTokenId>> hashMap = new HashMap<String, Collection<YamlTokenId>>();
                return hashMap;
            }

            protected Lexer<YamlTokenId> createLexer(LexerRestartInfo<YamlTokenId> lexerRestartInfo) {
                return new YamlLexer(lexerRestartInfo);
            }

            protected LanguageEmbedding<? extends TokenId> embedding(Token<YamlTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                switch ((YamlTokenId)token.id()) {
                    case RUBY_EXPR: 
                    case RUBY: {
                        LanguageProvider languageProvider;
                        Language language = null;
                        Collection collection = Lookup.getDefault().lookupAll(LanguageProvider.class);
                        Iterator iterator = collection.iterator();
                        while (iterator.hasNext() && (language = (languageProvider = (LanguageProvider)iterator.next()).findLanguage("text/x-ruby")) == null) {
                        }
                        return language != null ? LanguageEmbedding.create(language, (int)0, (int)0, (boolean)false) : null;
                    }
                    case PHP: {
                        LanguageProvider languageProvider;
                        Language language = null;
                        Collection collection = Lookup.getDefault().lookupAll(LanguageProvider.class);
                        Iterator iterator = collection.iterator();
                        while (iterator.hasNext() && (language = (languageProvider = (LanguageProvider)iterator.next()).findLanguage("text/x-php5")) == null) {
                        }
                        return language != null ? LanguageEmbedding.create(language, (int)0, (int)0, (boolean)false) : null;
                    }
                }
                return null;
            }
        }.language();
    }
}

