/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jvyamlb.Position;
import org.jvyamlb.Positionable;
import org.jvyamlb.nodes.Node;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.languages.yaml.YamlParser;
import org.netbeans.modules.languages.yaml.YamlScanner;
import org.netbeans.modules.parsing.api.Snapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlParserResult
extends ParserResult {
    private final List<Error> errors = new ArrayList<Error>();
    private List<Node> nodes;
    private List<? extends StructureItem> items;
    private int[] byteToUtf8;
    private int[] utf8ToByte;

    public YamlParserResult(List<Node> list, YamlParser yamlParser, Snapshot snapshot, boolean bl, int[] nArray, int[] nArray2) {
        super(snapshot);
        assert (list != null);
        this.nodes = list;
        this.byteToUtf8 = nArray;
        this.utf8ToByte = nArray2;
    }

    public List<Node> getRootNodes() {
        return this.nodes;
    }

    public void addError(Error error) {
        this.errors.add(error);
    }

    public List<? extends Error> getDiagnostics() {
        return Collections.unmodifiableList(this.errors);
    }

    protected void invalidate() {
    }

    public synchronized List<? extends StructureItem> getItems() {
        if (this.items == null) {
            this.items = new YamlScanner().scanStructure(this);
        }
        return this.items;
    }

    public void setItems(List<? extends StructureItem> list) {
        this.items = list;
    }

    public int convertUtf8ToByte(int n) {
        if (this.utf8ToByte == null) {
            return n;
        }
        if (n < this.utf8ToByte.length) {
            return this.utf8ToByte[n];
        }
        return this.utf8ToByte.length;
    }

    public int convertByteToUtf8(int n) {
        if (this.byteToUtf8 == null) {
            return n;
        }
        if (n < this.byteToUtf8.length) {
            return this.byteToUtf8[n];
        }
        return this.byteToUtf8.length;
    }

    public OffsetRange getAstRange(Position.Range range) {
        int n = range.start.offset;
        int n2 = range.end.offset;
        if (this.byteToUtf8 == null) {
            return new OffsetRange(n, n2);
        }
        int n3 = n >= this.byteToUtf8.length ? this.byteToUtf8.length : this.byteToUtf8[n];
        int n4 = n2 >= this.byteToUtf8.length ? this.byteToUtf8.length : this.byteToUtf8[n2];
        return new OffsetRange(n3, n4);
    }

    public OffsetRange getAstRange(Node node) {
        return this.getAstRange(((Positionable)node).getRange());
    }
}

