/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.viewmodel.Column;
import org.netbeans.modules.viewmodel.DefaultColumn;
import org.netbeans.modules.viewmodel.HyperCompoundModel;
import org.netbeans.modules.viewmodel.TreeModelNode;
import org.netbeans.modules.viewmodel.TreeModelRoot;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.etable.ETableColumnModel;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;
import org.openide.awt.Actions;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.OutlineView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.nodes.PropertySupport;
import org.openide.windows.TopComponent;

public class OutlineTable
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private final Logger logger = Logger.getLogger(OutlineTable.class.getName());
    private ExplorerManager explorerManager;
    private final MyTreeTable treeTable;
    Node.Property[] columns;
    private TableColumn[] tableColumns;
    private int[] columnVisibleMap;
    private boolean isDefaultColumnAdded;
    private int defaultColumnIndex;
    private boolean ignoreMove;
    TreeModelRoot currentTreeModelRoot;

    public OutlineTable() {
        this.setLayout(new BorderLayout());
        this.treeTable = new MyTreeTable();
        this.treeTable.getOutline().setRootVisible(false);
        this.treeTable.setVerticalScrollBarPolicy(22);
        this.treeTable.setHorizontalScrollBarPolicy(30);
        this.add((Component)((Object)this.treeTable), "Center");
        this.treeTable.getTable().getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                if (OutlineTable.this.logger.isLoggable(Level.FINE)) {
                    OutlineTable.this.logger.fine("columnAdded(" + tableColumnModelEvent + ") to = " + tableColumnModelEvent.getToIndex());
                    TableColumnModel tableColumnModel = (TableColumnModel)tableColumnModelEvent.getSource();
                    OutlineTable.this.logger.fine(" column header = '" + tableColumnModel.getColumn(tableColumnModelEvent.getToIndex()).getHeaderValue() + "'");
                    OutlineTable.this.dumpColumnVisibleMap();
                }
                if (OutlineTable.this.tableColumns != null && tableColumnModelEvent.getToIndex() >= 0) {
                    int n;
                    int n2;
                    int n3;
                    int n4 = tableColumnModelEvent.getToIndex();
                    int n5 = -1;
                    TableColumnModel tableColumnModel = OutlineTable.this.treeTable.getTable().getColumnModel();
                    ETableColumnModel eTableColumnModel = (ETableColumnModel)tableColumnModel;
                    for (n3 = 0; n3 < OutlineTable.this.tableColumns.length; ++n3) {
                        if (OutlineTable.this.tableColumns[n3] == null) continue;
                        n2 = OutlineTable.this.columns[n3].isHidden();
                        n = eTableColumnModel.isColumnHidden(OutlineTable.this.tableColumns[n3]);
                        if (n2 != 1 || n != 0) continue;
                        n5 = n3;
                        break;
                    }
                    OutlineTable.this.logger.fine("  to index = " + n4 + ", column index = " + n5);
                    if (n5 != -1) {
                        int n6;
                        n2 = n3 = OutlineTable.this.columnVisibleMap[n5];
                        n = OutlineTable.this.getColumnOrder(OutlineTable.this.columns[n5]);
                        for (n6 = 0; n6 < OutlineTable.this.columnVisibleMap.length; ++n6) {
                            if (OutlineTable.this.columnVisibleMap[n6] != n3 || n <= OutlineTable.this.getColumnOrder(OutlineTable.this.columns[n6]) || OutlineTable.this.columns[n6].isHidden()) continue;
                            ++n3;
                            break;
                        }
                        OutlineTable.this.logger.fine("  to index = " + n4 + ", column = " + OutlineTable.this.columns[n5].getDisplayName() + ", columnVisibleIndex = " + n2 + ", prefferedVisibleIndex = " + n3);
                        OutlineTable.this.columns[n5].setHidden(false);
                        ((OutlineTable)OutlineTable.this).columnVisibleMap[n5] = n3;
                        for (n6 = 0; n6 < OutlineTable.this.columnVisibleMap.length; ++n6) {
                            if (OutlineTable.this.columnVisibleMap[n6] < n2 || n6 == n5 || OutlineTable.this.getColumnOrder(OutlineTable.this.columns[n6]) < n) continue;
                            int[] nArray = OutlineTable.this.columnVisibleMap;
                            int n7 = n6;
                            nArray[n7] = nArray[n7] + 1;
                        }
                        if (n3 >= 0 && n3 != n4) {
                            OutlineTable.this.logger.fine("moveColumn(" + n4 + ", " + n3 + ")");
                            OutlineTable.this.ignoreMove = true;
                            try {
                                OutlineTable.this.treeTable.getTable().getColumnModel().moveColumn(n4, n3);
                            }
                            finally {
                                OutlineTable.this.ignoreMove = false;
                            }
                        }
                    }
                }
                if (OutlineTable.this.logger.isLoggable(Level.FINE)) {
                    OutlineTable.this.dumpColumnVisibleMap();
                }
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                if (OutlineTable.this.logger.isLoggable(Level.FINE)) {
                    OutlineTable.this.logger.fine("columnRemoved(" + tableColumnModelEvent + ") from = " + tableColumnModelEvent.getFromIndex());
                    OutlineTable.this.dumpColumnVisibleMap();
                }
                if (OutlineTable.this.tableColumns != null && tableColumnModelEvent.getFromIndex() >= 0) {
                    int n = tableColumnModelEvent.getFromIndex();
                    OutlineTable.this.logger.fine("  from index = " + n);
                    int n2 = OutlineTable.this.getColumnIndex(n);
                    if (n2 != -1) {
                        OutlineTable.this.columns[n2].setHidden(true);
                        for (int i = 0; i < OutlineTable.this.columnVisibleMap.length; ++i) {
                            if (OutlineTable.this.columnVisibleMap[i] < n || OutlineTable.this.columnVisibleMap[i] <= 0) continue;
                            int[] nArray = OutlineTable.this.columnVisibleMap;
                            int n3 = i;
                            nArray[n3] = nArray[n3] - 1;
                        }
                    }
                }
                if (OutlineTable.this.logger.isLoggable(Level.FINE)) {
                    OutlineTable.this.dumpColumnVisibleMap();
                }
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                int n;
                if (OutlineTable.this.tableColumns == null || OutlineTable.this.ignoreMove) {
                    return;
                }
                int n2 = tableColumnModelEvent.getFromIndex();
                if (n2 == (n = tableColumnModelEvent.getToIndex())) {
                    return;
                }
                int n3 = OutlineTable.this.getColumnIndex(n2);
                int n4 = OutlineTable.this.getColumnIndex(n);
                if (OutlineTable.this.logger.isLoggable(Level.FINE)) {
                    OutlineTable.this.logger.fine("columnMoved(" + tableColumnModelEvent + ") from = " + n2 + ", to = " + n);
                    OutlineTable.this.logger.fine("  from = " + n2 + ", to = " + n);
                    OutlineTable.this.logger.fine("  fc = " + n3 + ", tc = " + n4);
                    TableColumnModel tableColumnModel = (TableColumnModel)tableColumnModelEvent.getSource();
                    OutlineTable.this.logger.fine(" column headers = '" + tableColumnModel.getColumn(tableColumnModelEvent.getFromIndex()).getHeaderValue() + "' => '" + tableColumnModel.getColumn(tableColumnModelEvent.getToIndex()).getHeaderValue() + "'");
                    OutlineTable.this.dumpColumnVisibleMap();
                }
                int n5 = OutlineTable.this.getColumnOrder(OutlineTable.this.columns[n4]);
                if (n2 < n) {
                    for (int i = n2 + 1; i <= n; ++i) {
                        for (int j = 0; j < OutlineTable.this.columnVisibleMap.length; ++j) {
                            int n6;
                            if (j == n3 || i != OutlineTable.this.columnVisibleMap[j] || (n6 = OutlineTable.this.getColumnOrder(OutlineTable.this.columns[j])) > n5 || n6 <= OutlineTable.this.getColumnOrder(OutlineTable.this.columns[n3])) continue;
                            OutlineTable.this.setColumnOrder(OutlineTable.this.columns[j], n6 - 1);
                            int[] nArray = OutlineTable.this.columnVisibleMap;
                            int n7 = j;
                            nArray[n7] = nArray[n7] - 1;
                        }
                    }
                } else {
                    for (int i = n2 - 1; i >= n; --i) {
                        for (int j = 0; j < OutlineTable.this.columnVisibleMap.length; ++j) {
                            int n8;
                            if (i != OutlineTable.this.columnVisibleMap[j] || (n8 = OutlineTable.this.getColumnOrder(OutlineTable.this.columns[j])) >= OutlineTable.this.getColumnOrder(OutlineTable.this.columns[n3]) || n8 < n5) continue;
                            OutlineTable.this.setColumnOrder(OutlineTable.this.columns[j], OutlineTable.this.getColumnOrder(OutlineTable.this.columns[j]) + 1);
                            int[] nArray = OutlineTable.this.columnVisibleMap;
                            int n9 = j;
                            nArray[n9] = nArray[n9] + 1;
                        }
                    }
                }
                OutlineTable.this.setColumnOrder(OutlineTable.this.columns[n3], n5);
                ((OutlineTable)OutlineTable.this).columnVisibleMap[n3] = n;
                if (OutlineTable.this.logger.isLoggable(Level.FINE)) {
                    OutlineTable.this.logger.fine("After move:");
                    OutlineTable.this.dumpColumnVisibleMap();
                }
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
        ActionMap actionMap = this.getActionMap();
        ExplorerManager explorerManager = this.getExplorerManager();
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)explorerManager));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)explorerManager));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)explorerManager));
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)explorerManager, (boolean)false));
        this.setFocusable(false);
    }

    private void dumpColumnVisibleMap() {
        this.logger.fine("");
        this.logger.fine("Column Visible Map (" + this.columnVisibleMap.length + "):");
        for (int i = 0; i < this.columnVisibleMap.length; ++i) {
            this.logger.fine(" map[" + i + "] = " + this.columnVisibleMap[i] + "; columnOrder[" + i + "] = " + this.getColumnOrder(this.columns[i]));
        }
        this.logger.fine("");
    }

    private int getColumnOrder(Node.Property property) {
        Integer n = (Integer)property.getValue("OrderNumberOutline");
        if (n == null) {
            return -1;
        }
        return n;
    }

    private void setColumnOrder(Node.Property property, int n) {
        property.setValue("OrderNumberOutline", (Object)n);
    }

    private int getColumnIndex(int n) {
        for (int i = 0; i < this.columnVisibleMap.length; ++i) {
            if (n != this.columnVisibleMap[i] || this.columns[i].isHidden()) continue;
            return i;
        }
        return -1;
    }

    public void setModel(Models.CompoundModel compoundModel) {
        this.saveWidths();
        this.saveSortedState();
        if (this.currentTreeModelRoot != null) {
            this.currentTreeModelRoot.destroy();
        }
        if (compoundModel == null) {
            this.getExplorerManager().setRootContext((Node)new AbstractNode(Children.LEAF));
            return;
        }
        String[] stringArray = new String[]{null};
        ColumnModel[] columnModelArray = compoundModel.getColumns();
        Node.Property[] propertyArray = this.createColumns(columnModelArray, stringArray);
        this.treeTable.setNodesColumnName(stringArray[0]);
        this.currentTreeModelRoot = new TreeModelRoot(compoundModel, (OutlineView)this.treeTable);
        TreeModelNode treeModelNode = this.currentTreeModelRoot.getRootNode();
        this.getExplorerManager().setRootContext((Node)treeModelNode);
        this.treeTable.setProperties(propertyArray);
        this.updateTableColumns(propertyArray);
        this.updateColumnWidthsAndSorting();
    }

    public void setModel(HyperCompoundModel hyperCompoundModel) {
        this.saveWidths();
        this.saveSortedState();
        if (this.currentTreeModelRoot != null) {
            this.currentTreeModelRoot.destroy();
        }
        if (hyperCompoundModel == null) {
            this.getExplorerManager().setRootContext((Node)new AbstractNode(Children.LEAF));
            return;
        }
        String[] stringArray = new String[]{null};
        ColumnModel[] columnModelArray = hyperCompoundModel.getColumns();
        Node.Property[] propertyArray = this.createColumns(columnModelArray, stringArray);
        this.treeTable.setNodesColumnName(stringArray[0]);
        this.currentTreeModelRoot = new TreeModelRoot(hyperCompoundModel, (OutlineView)this.treeTable);
        TreeModelNode treeModelNode = this.currentTreeModelRoot.getRootNode();
        this.getExplorerManager().setRootContext((Node)treeModelNode);
        this.treeTable.setProperties(propertyArray);
        this.updateTableColumns(propertyArray);
        this.updateColumnWidthsAndSorting();
    }

    public ExplorerManager getExplorerManager() {
        if (this.explorerManager == null) {
            this.explorerManager = new ExplorerManager();
        }
        return this.explorerManager;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
        if (topComponent == null) {
            return;
        }
        if (string.equals("currentNodes")) {
            ExplorerUtils.activateActions((ExplorerManager)this.getExplorerManager(), (boolean)this.equalNodes());
        } else if (string.equals("selectedNodes")) {
            topComponent.setActivatedNodes((Node[])propertyChangeEvent.getNewValue());
        }
    }

    private boolean equalNodes() {
        Node[] nodeArray;
        Node[] nodeArray2 = TopComponent.getRegistry().getCurrentNodes();
        if (nodeArray2 == (nodeArray = this.getExplorerManager().getSelectedNodes())) {
            return true;
        }
        if (nodeArray2 == null || nodeArray == null) {
            return false;
        }
        if (nodeArray2.length != nodeArray.length) {
            return false;
        }
        int n = nodeArray2.length;
        for (int i = 0; i < n; ++i) {
            if (nodeArray2[i].equals((Object)nodeArray[i])) continue;
            return false;
        }
        return true;
    }

    private Node.Property[] createColumns(ColumnModel[] columnModelArray, String[] stringArray) {
        int n;
        Object[] objectArray;
        int n2;
        int n3 = columnModelArray.length;
        this.columns = new Column[n3];
        this.columnVisibleMap = new int[n3];
        this.isDefaultColumnAdded = false;
        boolean bl = true;
        ArrayList<PropertySupport.ReadWrite[]> arrayList = new ArrayList<PropertySupport.ReadWrite[]>(n3);
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            this.columns[n2] = objectArray = new Column(columnModelArray[n2]);
            int n5 = columnModelArray[n2].getCurrentOrderNumber();
            if (n5 == -1) {
                n5 = n2;
            }
            this.columnVisibleMap[n2] = n5 += n4;
            if (columnModelArray[n2].getType() != null) {
                arrayList.add((PropertySupport.ReadWrite[])objectArray);
                continue;
            }
            stringArray[0] = Actions.cutAmpersand((String)columnModelArray[n2].getDisplayName());
            bl = false;
            this.defaultColumnIndex = n2;
            if (columnModelArray[n2].getCurrentOrderNumber() != -1) continue;
            this.columnVisibleMap[n2] = 0;
            n = 0;
            while (n < n2) {
                int n6 = n++;
                this.columnVisibleMap[n6] = this.columnVisibleMap[n6] + 1;
            }
            n4 = 1;
        }
        if (bl) {
            objectArray = new PropertySupport.ReadWrite[this.columns.length + 1];
            System.arraycopy(this.columns, 0, objectArray, 1, this.columns.length);
            objectArray[0] = new DefaultColumn();
            stringArray[0] = objectArray[0].getDisplayName();
            this.columns = objectArray;
            int[] nArray = new int[this.columnVisibleMap.length + 1];
            nArray[0] = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2 + 1] = this.columnVisibleMap[n2] + 1;
            }
            this.columnVisibleMap = nArray;
            this.isDefaultColumnAdded = true;
            this.defaultColumnIndex = 0;
        }
        this.checkOrder(this.columnVisibleMap);
        objectArray = new int[this.columnVisibleMap.length];
        System.arraycopy(this.columnVisibleMap, 0, objectArray, 0, objectArray.length);
        for (n2 = 0; n2 < this.columnVisibleMap.length; ++n2) {
            this.setColumnOrder(this.columns[n2], (int)objectArray[n2]);
            if (!this.columns[n2].isHidden()) continue;
            PropertySupport.ReadWrite readWrite = objectArray[n2];
            for (n = 0; n < this.columnVisibleMap.length; ++n) {
                if (objectArray[n] < readWrite || this.columnVisibleMap[n] <= 0) continue;
                int n7 = n;
                this.columnVisibleMap[n7] = this.columnVisibleMap[n7] - 1;
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("createColumns:");
            this.dumpColumnVisibleMap();
        }
        Node.Property[] propertyArray = arrayList.toArray(new Node.Property[0]);
        this.tableColumns = null;
        return propertyArray;
    }

    private void checkOrder(int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.logger.isLoggable(Level.FINE)) {
            StringBuilder stringBuilder = new StringBuilder("checkOrder(");
            for (n4 = 0; n4 < nArray.length; ++n4) {
                stringBuilder.append(nArray[n4]);
                stringBuilder.append(", ");
            }
            stringBuilder.append("\b\b)");
            this.logger.fine(stringBuilder.toString());
        }
        int n5 = nArray.length;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = Integer.MAX_VALUE;
            for (n2 = 0; n2 < n5 && n4 != nArray[n2]; ++n2) {
                if (nArray[n2] <= n4) continue;
                n3 = Math.min(n3, nArray[n2]);
            }
            if (n2 != n5 || n3 == Integer.MAX_VALUE) continue;
            n = n3 - n4;
            for (n2 = 0; n2 < n5; ++n2) {
                if (nArray[n2] <= n4) continue;
                int n6 = n2;
                nArray[n6] = nArray[n6] - n;
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            StringBuilder stringBuilder = new StringBuilder("  squeezed: ");
            for (n3 = 0; n3 < nArray.length; ++n3) {
                stringBuilder.append(nArray[n3]);
                stringBuilder.append(", ");
            }
            stringBuilder.append("\b\b)");
            this.logger.fine(stringBuilder.toString());
        }
        int[] nArray2 = new int[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            int n7 = nArray[n3];
            nArray2[n7] = nArray2[n7] + 1;
            n2 = nArray2[n7];
            if (n2 <= 1) continue;
            n = nArray[n3];
            for (int i = 0; i < n5; ++i) {
                if (nArray[i] <= n && (nArray[i] != n || i < n3)) continue;
                if (i <= n3) {
                    int n8 = nArray[i];
                    nArray2[n8] = nArray2[n8] - 1;
                }
                int n9 = i;
                nArray[n9] = nArray[n9] + 1;
                if (i > n3) continue;
                int n10 = nArray[i];
                nArray2[n10] = nArray2[n10] + 1;
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            StringBuilder stringBuilder = new StringBuilder("  splitted: ");
            for (n2 = 0; n2 < nArray.length; ++n2) {
                stringBuilder.append(nArray[n2]);
                stringBuilder.append(", ");
            }
            stringBuilder.append("\b\b)");
            this.logger.fine(stringBuilder.toString());
        }
    }

    private void updateTableColumns(Node.Property[] propertyArray) {
        int n;
        TableColumnModel tableColumnModel = this.treeTable.getTable().getColumnModel();
        ETableColumnModel eTableColumnModel = (ETableColumnModel)tableColumnModel;
        int n2 = this.isDefaultColumnAdded ? 0 : 1;
        int n3 = 0;
        int n4 = n2;
        TableColumn[] tableColumnArray = new TableColumn[this.columns.length];
        for (n = 0; n < this.columns.length; ++n) {
            if (n3 < propertyArray.length && this.columns[n] == propertyArray[n3]) {
                TableColumn tableColumn;
                tableColumnArray[n] = tableColumn = tableColumnModel.getColumn(n4);
                if (this.columns[n].isHidden()) {
                    eTableColumnModel.setColumnHidden(tableColumn, true);
                } else {
                    ++n4;
                }
                ++n3;
                continue;
            }
            tableColumnArray[n] = tableColumnModel.getColumn(0);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("updateTableColumns(" + this.columns.length + "):");
            for (n = 0; n < this.columns.length; ++n) {
                this.logger.fine("Column[" + n + "] (" + this.columns[n].getDisplayName() + ") = " + tableColumnArray[n].getHeaderValue());
            }
        }
        this.setColumnsOrder();
        this.tableColumns = tableColumnArray;
    }

    private void setColumnsOrder() {
        int n;
        this.logger.fine("setColumnsOrder()");
        TableColumnModel tableColumnModel = this.treeTable.getTable().getColumnModel();
        int n2 = 0;
        for (n = 0; n < this.defaultColumnIndex; ++n) {
            if (this.columns[n].isHidden()) continue;
            ++n2;
        }
        if (n2 != 0) {
            this.logger.fine(" move default column(0, " + n2 + ")");
            tableColumnModel.moveColumn(0, n2);
        }
        n = tableColumnModel.getColumnCount();
        int[] nArray = new int[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            while (n3 < this.columns.length && this.columns[n3].isHidden()) {
                ++n3;
            }
            if (n3 >= this.columns.length) break;
            nArray[n4] = this.columnVisibleMap[n3];
            this.logger.fine("    order[" + n4 + "] = " + nArray[n4]);
            ++n4;
            ++n3;
        }
        for (n4 = 0; n4 < n; ++n4) {
            int n5;
            for (n5 = 0; n5 < n && nArray[n5] != n4; ++n5) {
            }
            this.logger.fine("  order[" + n5 + "] = " + n4);
            if (n5 == n4) continue;
            for (int i = n5; i > n4; --i) {
                nArray[i] = nArray[i - 1];
            }
            nArray[n4] = n4;
            this.logger.fine(" move column(" + n5 + ", " + n4 + ")");
            tableColumnModel.moveColumn(n5, n4);
        }
    }

    private boolean isHiddenColumn(int n) {
        if (this.tableColumns == null || this.tableColumns[n] == null) {
            return false;
        }
        ETableColumnModel eTableColumnModel = (ETableColumnModel)this.treeTable.getTable().getColumnModel();
        return eTableColumnModel.isColumnHidden(this.tableColumns[n]);
    }

    void updateColumnWidthsAndSorting() {
        this.logger.fine("\nupdateColumnWidthsAndSorting():");
        int n = this.columns.length;
        TableColumnModel tableColumnModel = this.treeTable.getTable().getColumnModel();
        ETableColumnModel eTableColumnModel = (ETableColumnModel)tableColumnModel;
        eTableColumnModel.clearSortedColumns();
        for (int i = 0; i < n; ++i) {
            ETableColumn eTableColumn;
            if (this.isHiddenColumn(i)) continue;
            int n2 = this.columnVisibleMap[i];
            this.logger.fine("  visibleOrder[" + i + "] = " + n2 + ", ");
            try {
                eTableColumn = (ETableColumn)tableColumnModel.getColumn(n2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.logger.log(Level.SEVERE, "Column(" + i + ") " + this.columns[i].getName() + " visible index = " + n2, arrayIndexOutOfBoundsException);
                continue;
            }
            this.logger.fine("  GUI column = " + eTableColumn.getHeaderValue());
            if (!(this.columns[i] instanceof Column)) continue;
            Column column = (Column)this.columns[i];
            this.logger.fine("    Retrieved width " + column.getColumnWidth() + " from " + this.columns[i].getDisplayName() + "[" + i + "] for " + eTableColumn.getHeaderValue());
            eTableColumn.setPreferredWidth(column.getColumnWidth());
            if (!column.isSorted()) continue;
            eTableColumnModel.setColumnSorted(eTableColumn, !column.isSortedDescending(), 1);
        }
    }

    private void saveWidths() {
        if (this.columns == null) {
            return;
        }
        int n = this.columns.length;
        if (n == 0) {
            return;
        }
        TableColumnModel tableColumnModel = this.treeTable.getTable().getColumnModel();
        ETableColumnModel eTableColumnModel = (ETableColumnModel)tableColumnModel;
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement().getWidth() == 75) continue;
            bl = false;
            break;
        }
        if (bl) {
            return;
        }
        this.logger.fine("\nsaveWidths():");
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn;
            if (this.isHiddenColumn(i)) continue;
            int n2 = this.columnVisibleMap[i];
            this.logger.fine("  visibleOrder[" + i + "] = " + n2 + ", ");
            try {
                tableColumn = tableColumnModel.getColumn(n2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.logger.log(Level.SEVERE, "Column(" + i + ") " + this.columns[i].getName() + " visible index = " + n2, arrayIndexOutOfBoundsException);
                continue;
            }
            this.logger.fine("  GUI column = " + tableColumn.getHeaderValue());
            if (!(this.columns[i] instanceof Column)) continue;
            this.logger.fine("    Setting width " + tableColumn.getWidth() + " from " + tableColumn.getHeaderValue() + " to " + this.columns[i].getDisplayName() + "[" + i + "]");
            ((Column)this.columns[i]).setColumnWidth(tableColumn.getWidth());
        }
    }

    private void saveSortedState() {
        if (this.columns == null) {
            return;
        }
        int n = this.columns.length;
        if (n == 0) {
            return;
        }
        TableColumnModel tableColumnModel = this.treeTable.getTable().getColumnModel();
        ETableColumnModel eTableColumnModel = (ETableColumnModel)tableColumnModel;
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        this.logger.fine("\nsaveSortedState():");
        for (int i = 0; i < n; ++i) {
            ETableColumn eTableColumn;
            if (this.isHiddenColumn(i)) continue;
            int n2 = this.columnVisibleMap[i];
            this.logger.fine("  visibleOrder[" + i + "] = " + n2 + ", ");
            try {
                eTableColumn = (ETableColumn)tableColumnModel.getColumn(n2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.logger.log(Level.SEVERE, "Column(" + i + ") " + this.columns[i].getName() + " visible index = " + n2, arrayIndexOutOfBoundsException);
                continue;
            }
            this.logger.fine("  GUI column = " + eTableColumn.getHeaderValue());
            if (!(this.columns[i] instanceof Column)) continue;
            this.logger.fine("    Setting sorted " + eTableColumn.isSorted() + " descending " + !eTableColumn.isAscending() + " to " + this.columns[i].getDisplayName() + "[" + i + "]");
            ((Column)this.columns[i]).setSorted(eTableColumn.isSorted());
            ((Column)this.columns[i]).setSortedDescending(!eTableColumn.isAscending());
        }
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.treeTable.requestFocusInWindow();
    }

    public void addNotify() {
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        ExplorerUtils.activateActions((ExplorerManager)this.getExplorerManager(), (boolean)true);
        this.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        ExplorerUtils.activateActions((ExplorerManager)this.getExplorerManager(), (boolean)false);
        this.getExplorerManager().removePropertyChangeListener((PropertyChangeListener)this);
    }

    public boolean isExpanded(Object object) {
        TreeModelNode[] treeModelNodeArray = this.currentTreeModelRoot.findNode(object);
        if (treeModelNodeArray.length == 0) {
            return false;
        }
        return this.treeTable.isExpanded((Node)treeModelNodeArray[0]);
    }

    public void expandNode(Object object) {
        TreeModelNode[] treeModelNodeArray;
        for (TreeModelNode treeModelNode : treeModelNodeArray = this.currentTreeModelRoot.findNode(object)) {
            this.treeTable.expandNode((Node)treeModelNode);
        }
    }

    public void collapseNode(Object object) {
        TreeModelNode[] treeModelNodeArray;
        for (TreeModelNode treeModelNode : treeModelNodeArray = this.currentTreeModelRoot.findNode(object)) {
            this.treeTable.collapseNode((Node)treeModelNode);
        }
    }

    private static final class F8FilterComponentInputMap
    extends ComponentInputMap {
        private KeyStroke f8 = KeyStroke.getKeyStroke(119, 0);

        public F8FilterComponentInputMap(JComponent jComponent, InputMap inputMap) {
            super(jComponent);
            this.setParent(inputMap);
        }

        public Object get(KeyStroke keyStroke) {
            if (this.f8.equals(keyStroke)) {
                return null;
            }
            return super.get(keyStroke);
        }
    }

    private static final class F8FilterInputMap
    extends InputMap {
        private KeyStroke f8 = KeyStroke.getKeyStroke(119, 0);

        public F8FilterInputMap(InputMap inputMap) {
            this.setParent(inputMap);
        }

        public Object get(KeyStroke keyStroke) {
            if (this.f8.equals(keyStroke)) {
                return null;
            }
            return super.get(keyStroke);
        }
    }

    private static class MyTreeTable
    extends OutlineView {
        MyTreeTable() {
            Outline outline = this.getOutline();
            outline.setShowHorizontalLines(true);
            outline.setShowVerticalLines(false);
            this.filterInputMap((JComponent)outline, 0);
            this.filterInputMap((JComponent)outline, 2);
            this.filterInputMap((JComponent)outline, 1);
        }

        private void filterInputMap(JComponent jComponent, int n) {
            InputMap inputMap = jComponent.getInputMap(n);
            inputMap = inputMap instanceof ComponentInputMap ? new F8FilterComponentInputMap(jComponent, inputMap) : new F8FilterInputMap(inputMap);
            jComponent.setInputMap(n, inputMap);
        }

        JTable getTable() {
            return this.getOutline();
        }

        void setNodesColumnName(String string) {
            OutlineModel outlineModel = this.getOutline().getOutlineModel();
            if (outlineModel instanceof DefaultOutlineModel) {
                ((DefaultOutlineModel)outlineModel).setNodesColumnLabel(string);
            }
        }

        public void expandNodes(List list) {
            for (String[] stringArray : list) {
                TreePath treePath = this.stringPath2TreePath(stringArray);
                if (treePath == null) continue;
                this.getOutline().expandPath(treePath);
                Rectangle rectangle = this.getOutline().getPathBounds(treePath);
                if (rectangle == null) continue;
                this.getOutline().scrollRectToVisible(rectangle);
            }
        }

        private TreePath stringPath2TreePath(String[] stringArray) {
            ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this));
            try {
                Node node = NodeOp.findPath((Node)explorerManager.getRootContext(), (String[])stringArray);
                Object[] objectArray = new TreeNode[stringArray.length + 1];
                for (int i = stringArray.length; i >= 0; --i) {
                    objectArray[i] = Visualizer.findVisualizer((Node)node);
                    node = node.getParentNode();
                }
                return new TreePath(objectArray);
            }
            catch (NodeNotFoundException nodeNotFoundException) {
                return null;
            }
        }
    }
}

