/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.nodes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.modules.hudson.api.HudsonChangeListener;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonVersion;
import org.netbeans.modules.hudson.api.HudsonView;
import org.netbeans.modules.hudson.api.UI;
import org.netbeans.modules.hudson.impl.HudsonInstanceImpl;
import org.netbeans.modules.hudson.ui.actions.OpenUrlAction;
import org.netbeans.modules.hudson.ui.actions.PersistInstanceAction;
import org.netbeans.modules.hudson.ui.actions.RemoveInstanceAction;
import org.netbeans.modules.hudson.ui.actions.SynchronizeAction;
import org.netbeans.modules.hudson.ui.nodes.HudsonJobNode;
import org.netbeans.modules.hudson.util.Utilities;
import org.openide.actions.PropertiesAction;
import org.openide.awt.DynamicMenuContent;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class HudsonInstanceNode
extends AbstractNode {
    private static final String ICON_BASE = "org/netbeans/modules/hudson/ui/resources/instance.png";
    private HudsonInstanceImpl instance;
    private InstanceNodeChildren children;
    private boolean warn = false;
    private boolean run = false;
    private boolean alive = false;
    private boolean version = false;
    private static final String SELECTED_VIEW = "view";

    public HudsonInstanceNode(HudsonInstanceImpl hudsonInstanceImpl) {
        super((Children)new Children.Array(), Lookups.singleton((Object)hudsonInstanceImpl));
        this.children = new InstanceNodeChildren(hudsonInstanceImpl);
        this.setName(hudsonInstanceImpl.getUrl());
        this.setDisplayName(hudsonInstanceImpl.getName());
        this.setShortDescription(hudsonInstanceImpl.getUrl());
        this.setIconBaseWithExtension(ICON_BASE);
        this.instance = hudsonInstanceImpl;
        hudsonInstanceImpl.addHudsonChangeListener(new HudsonChangeListener(){

            public void stateChanged() {
                HudsonInstanceNode.this.refreshState();
            }

            public void contentChanged() {
                HudsonInstanceNode.this.refreshContent();
            }
        });
        hudsonInstanceImpl.prefs().addPreferenceChangeListener(new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                HudsonInstanceNode.this.refreshContent();
            }
        });
        this.refreshState();
        this.refreshContent();
    }

    public String getHtmlDisplayName() {
        boolean bl = this.instance.isPersisted();
        String string = this.instance.prefs().get(SELECTED_VIEW, null);
        return (this.run ? "<b>" : "") + (this.warn ? "<font color=\"#A40000\">" : "") + this.instance.getName() + (this.warn ? "</font>" : "") + (this.run ? "</b>" : "") + (string != null ? " <font color='!controlShadow'>[" + string + "]</font>" : "") + (this.alive ? (this.version ? "" : " <font color=\"#A40000\">" + NbBundle.getMessage(HudsonInstanceNode.class, (String)"MSG_WrongVersion", (Object)HudsonVersion.SUPPORTED_VERSION) + "</font>") : " <font color=\"#A40000\">" + NbBundle.getMessage(HudsonInstanceNode.class, (String)"MSG_Disconnected") + "</font>") + (!bl ? " <font color='!controlShadow'>" + NbBundle.getMessage(HudsonInstanceNode.class, (String)"HudsonInstanceNode.from_open_project") + "</font>" : "");
    }

    public Action[] getActions(boolean bl) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        if (!this.instance.getViews().isEmpty()) {
            arrayList.add(new ViewSwitcher());
            arrayList.add(null);
        }
        arrayList.add(UI.createJobAction(this.instance));
        arrayList.add(null);
        arrayList.add((Action)SystemAction.get(SynchronizeAction.class));
        arrayList.add((Action)SystemAction.get(OpenUrlAction.class));
        if (!this.instance.isPersisted()) {
            arrayList.add((Action)SystemAction.get(PersistInstanceAction.class));
        } else {
            arrayList.add((Action)SystemAction.get(RemoveInstanceAction.class));
        }
        arrayList.add(null);
        arrayList.add((Action)SystemAction.get(PropertiesAction.class));
        return arrayList.toArray(new Action[0]);
    }

    public Node.PropertySet[] getPropertySets() {
        return new Node.PropertySet[]{this.instance.getProperties().getSheetSet()};
    }

    private synchronized void refreshState() {
        String string = "";
        this.alive = this.instance.isConnected();
        this.version = Utilities.isSupportedVersion(this.instance.getVersion());
        if (!this.alive || !this.version) {
            this.setChildren((Children)new Children.Array());
        } else if (this.getChildren().getNodesCount() == 0) {
            this.setChildren((Children)this.children);
        }
        this.fireDisplayNameChange(string, this.getHtmlDisplayName());
    }

    private synchronized void refreshContent() {
        String string = null;
        this.warn = false;
        this.run = false;
        for (HudsonJob hudsonJob : this.instance.getJobs()) {
            if (hudsonJob.getColor().equals((Object)HudsonJob.Color.red) || hudsonJob.getColor().equals((Object)HudsonJob.Color.red_anime)) {
                this.warn = true;
            }
            if (hudsonJob.getColor().equals((Object)HudsonJob.Color.blue_anime) || hudsonJob.getColor().equals((Object)HudsonJob.Color.grey_anime) || hudsonJob.getColor().equals((Object)HudsonJob.Color.red_anime) || hudsonJob.getColor().equals((Object)HudsonJob.Color.yellow_anime)) {
                this.run = true;
            }
            if (!this.warn || !this.run) continue;
            break;
        }
        this.fireDisplayNameChange(string, this.getHtmlDisplayName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstanceNodeChildren
    extends Children.Keys<HudsonJob>
    implements HudsonChangeListener {
        private final HudsonInstance instance;

        public InstanceNodeChildren(HudsonInstance hudsonInstance) {
            this.instance = hudsonInstance;
            hudsonInstance.addHudsonChangeListener(this);
            hudsonInstance.prefs().addPreferenceChangeListener(new PreferenceChangeListener(){

                public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                    InstanceNodeChildren.this.refreshKeys();
                }
            });
        }

        protected Node[] createNodes(HudsonJob hudsonJob) {
            return new Node[]{new HudsonJobNode(hudsonJob)};
        }

        protected void addNotify() {
            super.addNotify();
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            super.removeNotify();
        }

        private void refreshKeys() {
            ArrayList<HudsonJob> arrayList = new ArrayList<HudsonJob>();
            HudsonView object = null;
            String string = this.instance.prefs().get(HudsonInstanceNode.SELECTED_VIEW, null);
            if (string != null) {
                for (HudsonView object2 : this.instance.getViews()) {
                    if (!object2.getName().equals(string)) continue;
                    object = object2;
                    break;
                }
            }
            for (HudsonJob hudsonJob : this.instance.getJobs()) {
                if (object != null && !hudsonJob.getViews().contains(object)) continue;
                arrayList.add(hudsonJob);
            }
            this.setKeys(arrayList);
        }

        @Override
        public void stateChanged() {
        }

        @Override
        public void contentChanged() {
            this.refreshKeys();
        }
    }

    private class ViewSwitcher
    extends AbstractAction
    implements Presenter.Popup {
        private ViewSwitcher() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            assert (false);
        }

        public JMenuItem getPopupPresenter() {
            class Menu
            extends JMenu
            implements DynamicMenuContent {
                Menu() {
                    this.setText(NbBundle.getMessage(HudsonInstanceNode.class, (String)"HudsonInstanceNode.view"));
                }

                public JComponent[] getMenuPresenters() {
                    this.removeAll();
                    String string = HudsonInstanceNode.this.instance.prefs().get(HudsonInstanceNode.SELECTED_VIEW, null);
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(NbBundle.getMessage(HudsonInstanceNode.class, (String)"HudsonInstanceNode.all_view"));
                    jRadioButtonMenuItem.setSelected(string == null);
                    jRadioButtonMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            HudsonInstanceNode.this.instance.prefs().remove(HudsonInstanceNode.SELECTED_VIEW);
                        }
                    });
                    this.add(jRadioButtonMenuItem);
                    this.addSeparator();
                    for (final HudsonView hudsonView : HudsonInstanceNode.this.instance.getViews()) {
                        jRadioButtonMenuItem = new JRadioButtonMenuItem(hudsonView.getName());
                        jRadioButtonMenuItem.setSelected(hudsonView.getName().equals(string));
                        jRadioButtonMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                HudsonInstanceNode.this.instance.prefs().put(HudsonInstanceNode.SELECTED_VIEW, hudsonView.getName());
                            }
                        });
                        this.add(jRadioButtonMenuItem);
                    }
                    return new JComponent[]{this};
                }

                public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
                    return this.getMenuPresenters();
                }
            }
            return new Menu();
        }
    }
}

