/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.spi;

import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hudson.spi.HudsonSCM;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public interface ProjectHudsonJobCreatorFactory {
    public ProjectHudsonJobCreator forProject(Project var1);

    public static final class ConfigurationStatus {
        private String errorMessage;
        private String warningMessage;
        private JButton extraButton;

        private ConfigurationStatus() {
        }

        public static ConfigurationStatus valid() {
            return new ConfigurationStatus();
        }

        public static ConfigurationStatus withError(String string) {
            ConfigurationStatus configurationStatus = new ConfigurationStatus();
            configurationStatus.errorMessage = string;
            return configurationStatus;
        }

        public static ConfigurationStatus withWarning(String string) {
            ConfigurationStatus configurationStatus = new ConfigurationStatus();
            configurationStatus.warningMessage = string;
            return configurationStatus;
        }

        public ConfigurationStatus withExtraButton(JButton jButton) {
            if (this.extraButton != null) {
                throw new IllegalArgumentException();
            }
            ConfigurationStatus configurationStatus = new ConfigurationStatus();
            configurationStatus.errorMessage = this.errorMessage;
            configurationStatus.warningMessage = this.warningMessage;
            configurationStatus.extraButton = jButton;
            return configurationStatus;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getWarningMessage() {
            return this.warningMessage;
        }

        public JButton getExtraButton() {
            return this.extraButton;
        }
    }

    public static class Helper {
        private Helper() {
        }

        public static HudsonSCM.Configuration prepareSCM(File file) {
            for (HudsonSCM hudsonSCM : Lookup.getDefault().lookupAll(HudsonSCM.class)) {
                HudsonSCM.Configuration configuration = hudsonSCM.forFolder(file);
                if (configuration == null) continue;
                return configuration;
            }
            return null;
        }

        public static ConfigurationStatus noSCMError() {
            return ConfigurationStatus.withError(NbBundle.getMessage(ProjectHudsonJobCreatorFactory.class, (String)"ProjectHudsonJobCreatorFactory.no_vcs"));
        }

        public static void addLogRotator(Document document) {
            Element element = (Element)document.getDocumentElement().appendChild(document.createElement("logRotator"));
            element.appendChild(document.createElement("daysToKeep")).appendChild(document.createTextNode("-1"));
            element.appendChild(document.createElement("numToKeep")).appendChild(document.createTextNode("1"));
        }
    }

    public static interface ProjectHudsonJobCreator {
        public String jobName();

        public JComponent customizer();

        public ConfigurationStatus status();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);

        public Document configure() throws IOException;
    }
}

