/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.api;

import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.ui.actions.CreateJob;
import org.netbeans.modules.hudson.ui.actions.ShowBuildConsole;
import org.netbeans.modules.hudson.ui.actions.ShowChanges;
import org.netbeans.modules.hudson.ui.actions.ShowFailures;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class UI {
    private static final Logger LOG = Logger.getLogger(UI.class.getName());

    private UI() {
    }

    public static void selectNode(final String ... stringArray) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                TopComponent topComponent = WindowManager.getDefault().findTopComponent("services");
                if (topComponent == null) {
                    LOG.fine("No ServicesTab found");
                    return;
                }
                topComponent.open();
                topComponent.requestActive();
                if (!(topComponent instanceof ExplorerManager.Provider)) {
                    LOG.fine("ServicesTab not an ExplorerManager.Provider");
                    return;
                }
                final ExplorerManager explorerManager = ((ExplorerManager.Provider)topComponent).getExplorerManager();
                final Node node = explorerManager.getRootContext();
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        Node node4;
                        Node node2 = NodeOp.findChild((Node)node, (String)"hudson");
                        if (node2 == null) {
                            LOG.fine("ServicesTab does not contain hudson");
                            return;
                        }
                        try {
                            node4 = NodeOp.findPath((Node)node2, (String[])stringArray);
                        }
                        catch (NodeNotFoundException nodeNotFoundException) {
                            LOG.log(Level.FINE, "Could not find subnode", nodeNotFoundException);
                            node4 = nodeNotFoundException.getClosestNode();
                        }
                        final Node node3 = node4;
                        Mutex.EVENT.readAccess(new Runnable(){

                            public void run() {
                                try {
                                    explorerManager.setSelectedNodes(new Node[]{node3});
                                }
                                catch (PropertyVetoException propertyVetoException) {
                                    LOG.log(Level.FINE, "Could not select path", propertyVetoException);
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    public static Action showChangesAction(HudsonJobBuild hudsonJobBuild) {
        return new ShowChanges(hudsonJobBuild);
    }

    public static Action showConsoleAction(HudsonJobBuild hudsonJobBuild) {
        return new ShowBuildConsole(hudsonJobBuild);
    }

    public static Action showConsoleAction(HudsonMavenModuleBuild hudsonMavenModuleBuild) {
        return new ShowBuildConsole(hudsonMavenModuleBuild);
    }

    public static Action showFailuresAction(HudsonJobBuild hudsonJobBuild) {
        return new ShowFailures(hudsonJobBuild);
    }

    public static Action showFailuresAction(HudsonMavenModuleBuild hudsonMavenModuleBuild) {
        return new ShowFailures(hudsonMavenModuleBuild);
    }

    public static Action createJobAction(HudsonInstance hudsonInstance) {
        return new CreateJob(hudsonInstance);
    }
}

