/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class NbResourceStreamHandler
extends URLStreamHandler {
    public static final String PROTOCOL_SYSTEM_RESOURCE = "nbres";
    public static final String PROTOCOL_LOCALIZED_SYSTEM_RESOURCE = "nbresloc";

    public URLConnection openConnection(URL uRL) throws IOException {
        if (uRL.getProtocol().equals(PROTOCOL_SYSTEM_RESOURCE)) {
            return new Connection(uRL, false);
        }
        if (uRL.getProtocol().equals(PROTOCOL_LOCALIZED_SYSTEM_RESOURCE)) {
            return new Connection(uRL, true);
        }
        throw new IOException("Bad protocol: " + uRL.getProtocol());
    }

    private static class Connection
    extends URLConnection {
        private final boolean localized;
        private URLConnection real;
        private IOException exception = null;

        public Connection(URL uRL, boolean bl) {
            super(uRL);
            this.localized = bl;
        }

        public synchronized void connect() throws IOException {
            if (this.exception != null) {
                IOException iOException = this.exception;
                this.exception = null;
                throw iOException;
            }
            if (!this.connected) {
                URL uRL;
                String string = this.url.getPath();
                if (string.length() > 0 && string.charAt(0) == '/') {
                    string = string.substring(1);
                } else {
                    Logger.getLogger(NbResourceStreamHandler.class.getName()).log(Level.WARNING, "URL path should begin with a slash: " + this.url);
                }
                ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                URL uRL2 = classLoader.getResource(string);
                if (this.localized) {
                    String string2;
                    String string3;
                    String string4;
                    int n = string.lastIndexOf(46);
                    if (n < string.lastIndexOf(47)) {
                        n = -1;
                    }
                    if (n != -1) {
                        string4 = string.substring(0, n);
                        string3 = string.substring(n);
                    } else {
                        string4 = string;
                        string3 = "";
                    }
                    uRL = null;
                    Iterator iterator = NbBundle.getLocalizingSuffixes();
                    while (iterator.hasNext() && (uRL = "".equals(string2 = (String)iterator.next()) ? uRL2 : classLoader.getResource(string4 + string2 + string3)) == null) {
                    }
                } else {
                    uRL = uRL2;
                }
                if (uRL == null) {
                    throw new IOException(NbBundle.getMessage(NbResourceStreamHandler.class, (String)"EXC_nbres_cannot_connect", (Object)this.url));
                }
                this.real = uRL.openConnection();
                this.real.connect();
                this.connected = true;
            }
        }

        private void tryToConnect() {
            if (this.connected || this.exception != null) {
                return;
            }
            try {
                this.connect();
            }
            catch (IOException iOException) {
                this.exception = iOException;
            }
        }

        public String getHeaderField(int n) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderField(n);
            }
            return null;
        }

        public String getHeaderFieldKey(int n) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderFieldKey(n);
            }
            return null;
        }

        public String getHeaderField(String string) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderField(string);
            }
            return null;
        }

        public InputStream getInputStream() throws IOException {
            this.connect();
            return this.real.getInputStream();
        }

        public OutputStream getOutputStream() throws IOException {
            this.connect();
            return this.real.getOutputStream();
        }

        public String getContentType() {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getContentType();
            }
            return "application/octet-stream";
        }

        public int getContentLength() {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getContentLength();
            }
            return 0;
        }

        public long getLastModified() {
            if (this.connected && !this.real.getURL().toExternalForm().contains("http:")) {
                return this.real.getLastModified();
            }
            return 0L;
        }
    }
}

