/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.Events;
import org.netbeans.Module;
import org.netbeans.Util;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.NbProblemDisplayer;
import org.netbeans.core.startup.Splash;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.TopLogging;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NbEvents
extends Events {
    private Logger logger = Logger.getLogger(NbEvents.class.getName());
    private int moduleCount;
    private int counter;

    NbEvents() {
    }

    protected void logged(String string, Object[] objectArray) {
        if (string == "perfTick") {
            StartLog.logProgress((String)objectArray[0]);
        } else if (string == "perfStart") {
            StartLog.logStart((String)objectArray[0]);
        } else if (string == "perfEnd") {
            StartLog.logEnd((String)objectArray[0]);
        } else if (string == "startCreateBootModule") {
            Splash.getInstance().increment(1);
        } else if (string == "startLoadBootModules") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_start_load_boot_modules"));
            StartLog.logStart("ModuleSystem.loadBootModules");
        } else if (string == "startLoad") {
            StartLog.logStart("NbInstaller.load");
        } else if (string == "finishLoadBootModules") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_finish_load_boot_modules"));
            StartLog.logEnd("ModuleSystem.loadBootModules");
        } else if (string == "finishLoad") {
            StartLog.logEnd("NbInstaller.load");
        } else if (string == "startAutoRestore") {
            Set set = (Set)objectArray[0];
            if (!set.isEmpty()) {
                NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_start_auto_restore"));
            }
        } else if (string == "finishAutoRestore") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_finish_auto_restore"));
        } else if (string == "startEnableModules") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_start_enable_modules"));
        } else if (string == "finishEnableModules") {
            List list = NbCollections.checkedListByCopy((List)((List)objectArray[0]), Module.class, (boolean)true);
            if (!list.isEmpty()) {
                this.logger.log(Level.INFO, NbBundle.getMessage(NbEvents.class, (String)"TEXT_finish_enable_modules"));
                this.dumpModulesList(list);
            }
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_finish_enable_modules"));
            StartLog.logEnd("ModuleManager.enable");
        } else if (string == "startDisableModules") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_start_disable_modules"));
        } else if (string == "finishDisableModules") {
            List list = NbCollections.checkedListByCopy((List)((List)objectArray[0]), Module.class, (boolean)true);
            if (!list.isEmpty()) {
                this.logger.log(Level.INFO, NbBundle.getMessage(NbEvents.class, (String)"TEXT_finish_disable_modules"));
                this.dumpModulesList(list);
            }
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_finish_disable_modules"));
        } else if (string == "startDeployTestModule") {
            String string2 = MessageFormat.format(NbBundle.getMessage(NbEvents.class, (String)"TEXT_start_deploy_test_module"), (File)objectArray[0]);
            NbEvents.setStatusText(string2);
        } else if (string == "finishDeployTestModule") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"TEXT_finish_deploy_test_module"));
        } else if (string == "failedInstallNew") {
            Set set = NbCollections.checkedSetByCopy((Set)((Set)objectArray[0]), Module.class, (boolean)true);
            StringBuilder stringBuilder = new StringBuilder(NbBundle.getMessage(NbEvents.class, (String)"MSG_failed_install_new"));
            NbProblemDisplayer.problemMessagesForModules(stringBuilder, set, false);
            stringBuilder.append('\n');
            this.logger.log(Level.INFO, stringBuilder.toString());
            stringBuilder = new StringBuilder(NbBundle.getMessage(NbEvents.class, (String)"MSG_failed_install_new"));
            NbProblemDisplayer.problemMessagesForModules(stringBuilder, set, true);
            String string3 = stringBuilder.toString();
            this.notify(string3, true);
            NbEvents.setStatusText("");
        } else if (string == "failedInstallNewUnexpected") {
            Module module = (Module)objectArray[0];
            ArrayList<Module> arrayList = new ArrayList<Module>();
            arrayList.add(module);
            arrayList.addAll(NbCollections.checkedSetByCopy((Set)((Set)objectArray[1]), Module.class, (boolean)true));
            StringBuilder stringBuilder = new StringBuilder(NbBundle.getMessage(NbEvents.class, (String)"MSG_failed_install_new_unexpected", (Object)module.getDisplayName()));
            NbProblemDisplayer.problemMessagesForModules(stringBuilder, arrayList, false);
            stringBuilder.append('\n');
            this.logger.log(Level.INFO, stringBuilder.toString());
            this.notify(NbProblemDisplayer.messageForProblem(module, module.getProblems().iterator().next(), true), true);
            NbEvents.setStatusText("");
        } else if (string == "startRead") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_start_read"));
            StartLog.logStart("ModuleList.readInitial");
        } else if (string == "modulesFileScanned") {
            this.moduleCount = (Integer)objectArray[0];
            Splash.getInstance().addToMaxSteps(Math.max(this.moduleCount + this.moduleCount / 2 - 100, 0));
        } else if (string == "modulesFileProcessed") {
            Splash.getInstance().increment(1);
            if (StartLog.willLog()) {
                StartLog.logProgress("module " + objectArray[0] + " processed");
            }
        } else if (string == "finishRead") {
            if (this.moduleCount < 100) {
                Splash.getInstance().increment(this.moduleCount - 100);
            }
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_finish_read"));
            StartLog.logEnd("ModuleList.readInitial");
        } else if (string == "restore") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_restore"));
            if (++this.counter < this.moduleCount / 2) {
                Splash.getInstance().increment(1);
            }
        } else if (string == "install") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_install", (Object)((Module)objectArray[0]).getDisplayName()));
            this.logger.log(Level.INFO, NbBundle.getMessage(NbEvents.class, (String)"TEXT_install", (Object)((Module)objectArray[0]).getDisplayName()));
        } else if (string == "update") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_update", (Object)((Module)objectArray[0]).getDisplayName()));
            this.logger.log(Level.INFO, NbBundle.getMessage(NbEvents.class, (String)"TEXT_update", (Object)((Module)objectArray[0]).getDisplayName()));
        } else if (string == "uninstall") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_uninstall", (Object)((Module)objectArray[0]).getDisplayName()));
        } else if (string == "loadSection") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_load_section"));
            if (++this.counter < this.moduleCount / 4) {
                Splash.getInstance().increment(1);
            }
        } else if (string == "loadLayers") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_load_layers"));
        } else if (string == "wrongClassLoader") {
            if (!Boolean.getBoolean("netbeans.moduleitem.dontverifyclassloader") && Util.err.isLoggable(Level.WARNING)) {
                Class clazz = (Class)objectArray[1];
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("The module " + ((Module)objectArray[0]).getDisplayName() + " loaded the class " + clazz.getName() + "\n");
                stringBuilder.append("from the wrong classloader. The expected classloader was " + objectArray[2] + "\n");
                stringBuilder.append("whereas it was actually loaded from " + clazz.getClassLoader() + "\n");
                stringBuilder.append("Usually this means that some classes were in the startup classpath.\n");
                stringBuilder.append("To suppress this message, run with: -J-Dnetbeans.moduleitem.dontverifyclassloader=true");
                Util.err.warning(stringBuilder.toString());
            }
        } else if (string == "extensionMultiplyLoaded") {
            this.logger.log(Level.WARNING, "The extension " + (File)objectArray[0] + " may be multiply loaded by modules: " + (Set)objectArray[1] + "; see: http://www.netbeans.org/download/dev/javadoc/org-openide-modules/org/openide/modules/doc-files/classpath.html#class-path");
        } else if (string == "missingJarFile") {
            File file = (File)objectArray[0];
            Level level = Boolean.FALSE.equals(objectArray[1]) ? Level.FINE : Level.INFO;
            this.logger.log(level, NbBundle.getMessage(NbEvents.class, (String)"TEXT_missing_jar_file", (Object)file.getAbsolutePath()));
        } else if (string == "cantDeleteEnabledAutoload") {
            Module module = (Module)objectArray[0];
            this.logger.log(Level.INFO, NbBundle.getMessage(NbEvents.class, (String)"TEXT_cant_delete_enabled_autoload", (Object)module.getDisplayName()));
        } else if (string == "miscPropMismatch") {
            Module module = (Module)objectArray[0];
            String string4 = (String)objectArray[1];
            Object object = objectArray[2];
            Object object2 = objectArray[3];
            this.logger.log(Level.INFO, NbBundle.getMessage(NbEvents.class, (String)"TEXT_misc_prop_mismatch", (Object[])new Object[]{module.getDisplayName(), string4, object, object2}));
        } else if (string == "patch") {
            File file = (File)objectArray[0];
            this.logger.log(Level.INFO, NbBundle.getMessage(NbEvents.class, (String)"TEXT_patch", (Object)file.getAbsolutePath()));
        }
    }

    private void dumpModulesList(Collection<Module> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder(collection.size() * 100 + 1);
        String string = System.getProperty("line.separator");
        for (Module module : collection) {
            String string2;
            String string3;
            stringBuilder.append('\t');
            stringBuilder.append(module.getCodeName());
            stringBuilder.append(" [");
            SpecificationVersion specificationVersion = module.getSpecificationVersion();
            if (specificationVersion != null) {
                stringBuilder.append(specificationVersion);
            }
            if ((string3 = module.getImplementationVersion()) != null) {
                stringBuilder.append(' ');
                stringBuilder.append(string3);
            }
            if ((string2 = module.getBuildVersion()) != null && !string2.equals(string3)) {
                stringBuilder.append(' ');
                stringBuilder.append(string2);
            }
            stringBuilder.append(']');
            stringBuilder.append(string);
        }
        this.logger.log(Level.INFO, stringBuilder.toString());
    }

    private void notify(String string, boolean bl) {
        if (Boolean.getBoolean("netbeans.full.hack")) {
            this.logger.log(Level.WARNING, string + "\n");
        } else {
            new Notifier(string, bl);
        }
    }

    private static void setStatusText(String string) {
        Main.setStatusText(string);
    }

    private static void showUrl(URI uRI, Component component) throws Exception {
        SpecificationVersion specificationVersion = new SpecificationVersion(System.getProperty("java.specification.version"));
        if (specificationVersion.compareTo((Object)new SpecificationVersion("1.6")) >= 0) {
            Class<?> clazz = Class.forName("java.awt.Desktop");
            Method method = clazz.getMethod("getDesktop", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            Method method2 = clazz.getMethod("browse", URI.class);
            method2.invoke(object, uRI);
        }
    }

    private static final class Notifier
    implements Runnable {
        private static boolean showDialog = true;
        private boolean warn;
        private String text;
        private static RequestProcessor RP = new RequestProcessor("Notify About Module System");

        public Notifier(String string, boolean bl) {
            this.warn = bl;
            this.text = string;
            if (showDialog) {
                showDialog = false;
                RP.post((Runnable)this, 0, 1).waitFinished();
            }
        }

        public void run() {
            int n;
            JComponent jComponent;
            int n2 = this.warn ? 2 : 1;
            String string = NbBundle.getMessage(Notifier.class, (String)(this.warn ? "MSG_warning" : "MSG_info"));
            Splash splash = Splash.getInstance();
            final Component component = splash.getComponent() == null ? null : splash.getComponent();
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(NbBundle.class.getName()).log(Level.INFO, null, classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                Logger.getLogger(NbBundle.class.getName()).log(Level.INFO, null, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(NbBundle.class.getName()).log(Level.INFO, null, illegalAccessException);
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                Logger.getLogger(NbBundle.class.getName()).log(Level.INFO, null, unsupportedLookAndFeelException);
            }
            JTextPane jTextPane = new JTextPane();
            jTextPane.setContentType("text/html");
            this.text = this.text.replace("\n", "<br>");
            jTextPane.setEditable(false);
            jTextPane.setOpaque(false);
            jTextPane.setEnabled(true);
            jTextPane.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (HyperlinkEvent.EventType.ACTIVATED == hyperlinkEvent.getEventType()) {
                        assert (hyperlinkEvent.getURL() != null);
                        try {
                            NbEvents.showUrl(hyperlinkEvent.getURL().toURI(), component);
                        }
                        catch (Exception exception) {
                            Logger.getLogger(NbBundle.class.getName()).log(Level.INFO, null, exception);
                        }
                    }
                }
            });
            jTextPane.setText(this.text);
            if (jTextPane.getPreferredSize().width > 600 || jTextPane.getPreferredSize().height > 400) {
                jTextPane.setPreferredSize(new Dimension(600, 400));
                jComponent = new JScrollPane(jTextPane);
            } else {
                jComponent = jTextPane;
            }
            final JOptionPane jOptionPane = new JOptionPane(jComponent, n2, 0, null);
            JButton jButton = new JButton(NbBundle.getMessage(Notifier.class, (String)"MSG_continue"));
            jButton.setDisplayedMnemonicIndex(0);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jOptionPane.setValue(0);
                }
            });
            JButton jButton2 = new JButton(NbBundle.getMessage(Notifier.class, (String)"MSG_exit"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jOptionPane.setValue(1);
                }
            });
            Object[] objectArray = new JButton[]{jButton, jButton2};
            jOptionPane.setOptions(objectArray);
            jOptionPane.setInitialValue(objectArray[1]);
            JDialog jDialog = jOptionPane.createDialog(component, string);
            jDialog.setResizable(true);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && ((n = ((Integer)object).intValue()) == 1 || n == -1)) {
                TopLogging.exit(1);
            }
        }
    }
}

