/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.TabPainter;

final class AquaEditorTabCellRenderer
extends AbstractTabCellRenderer {
    private static final int TOP_INSET = 0;
    private static final int LEFT_INSET = 3;
    private static final int RIGHT_INSET = 0;
    static final int BOTTOM_INSET = 0;
    private static final TabPainter leftClip = new AquaLeftClipPainter();
    private static final TabPainter rightClip = new AquaRightClipPainter();
    private static final TabPainter normal = new AquaPainter();
    private Font txtFont;

    public AquaEditorTabCellRenderer() {
        super(leftClip, normal, rightClip, new Dimension(32, 42));
    }

    public Font getFont() {
        if (this.txtFont == null) {
            this.txtFont = (Font)UIManager.get("windowTitleFont");
            if (this.txtFont == null) {
                this.txtFont = new Font("Dialog", 0, 11);
            } else if (this.txtFont.isBold()) {
                this.txtFont = new Font(this.txtFont.getName(), 0, this.txtFont.getSize());
            }
        }
        return this.txtFont;
    }

    protected void paintIconAndText(Graphics graphics) {
        super.paintIconAndText(graphics);
    }

    public int getPixelsToAddToSelection() {
        return 0;
    }

    public Dimension getPadding() {
        Dimension dimension = super.getPadding();
        dimension.width = this.isShowCloseButton() && !Boolean.getBoolean("nb.tabs.suppressCloseButton") ? 32 : 16;
        return dimension;
    }

    private static final Color getTxtColor() {
        Color color = UIManager.getColor("TabbedPane.foreground");
        if (color == null) {
            color = new Color(0, 0, 0);
        }
        return color;
    }

    public Color getSelectedActivatedForeground() {
        return AquaEditorTabCellRenderer.getTxtColor();
    }

    public Color getSelectedForeground() {
        return AquaEditorTabCellRenderer.getTxtColor();
    }

    private static void paintTabGradient(Graphics graphics, AquaEditorTabCellRenderer aquaEditorTabCellRenderer, Polygon polygon) {
        Rectangle rectangle = polygon.getBounds();
        boolean bl = aquaEditorTabCellRenderer.isSelected();
        boolean bl2 = bl && aquaEditorTabCellRenderer.isActive();
        boolean bl3 = aquaEditorTabCellRenderer.isAttention();
        boolean bl4 = aquaEditorTabCellRenderer.isArmed();
        if (bl2 && !bl3) {
            ColorUtil.paintMacGradientFill((Graphics2D)graphics, rectangle, UIManager.getColor("NbTabControl.selectedTabBrighterBackground"), UIManager.getColor("NbTabControl.selectedTabDarkerBackground"));
        } else if (bl && !bl3) {
            ColorUtil.paintMacGradientFill((Graphics2D)graphics, rectangle, UIManager.getColor("NbTabControl.selectedTabBrighterBackground"), UIManager.getColor("NbTabControl.selectedTabDarkerBackground"));
        } else if (bl4 && !bl3) {
            ColorUtil.paintMacGradientFill((Graphics2D)graphics, rectangle, UIManager.getColor("NbTabControl.mouseoverTabBrighterBackground"), UIManager.getColor("NbTabControl.mouseoverTabDarkerBackground"));
        } else if (bl3) {
            Color color = new Color(255, 255, 128);
            Color color2 = new Color(230, 200, 64);
            ColorUtil.xpFillRectGradient((Graphics2D)graphics, rectangle, color, color2);
        } else {
            ColorUtil.paintMacGradientFill((Graphics2D)graphics, rectangle, UIManager.getColor("NbTabControl.inactiveTabBrighterBackground"), UIManager.getColor("NbTabControl.inactiveTabDarkerBackground"));
        }
    }

    protected int getCaptionYAdjustment() {
        return 0;
    }

    protected int getIconYAdjustment() {
        return -2;
    }

    private static class AquaLeftClipPainter
    implements TabPainter {
        private AquaLeftClipPainter() {
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(0, 3, 0, 0);
        }

        public Polygon getInteriorPolygon(Component component) {
            AquaEditorTabCellRenderer aquaEditorTabCellRenderer = (AquaEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = 0;
            int n2 = 0;
            int n3 = aquaEditorTabCellRenderer.isRightmost() ? component.getWidth() - 1 : component.getWidth();
            int n4 = component.getHeight() - insets.bottom;
            polygon.addPoint(n, n2 + insets.top);
            polygon.addPoint(n + n3, n2 + insets.top);
            polygon.addPoint(n + n3, n2 + n4 - 1);
            polygon.addPoint(n, n2 + n4 - 1);
            return polygon;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AquaEditorTabCellRenderer aquaEditorTabCellRenderer = (AquaEditorTabCellRenderer)component;
            Color color = UIManager.getColor("NbTabControl.borderColor");
            graphics.setColor(color);
            graphics.drawLine(n, n2, n3 - 1, n2);
            if (!aquaEditorTabCellRenderer.isSelected()) {
                graphics.setColor(color);
                graphics.drawLine(n, n2 + n4 - 1, n3, n2 + n4 - 1);
            } else {
                graphics.setColor(UIManager.getColor("NbTabControl.selectedTabDarkerBackground"));
                graphics.drawLine(n, n2 + n4 - 1, n3, n2 + n4 - 1);
            }
            if (aquaEditorTabCellRenderer.isRightmost() || !aquaEditorTabCellRenderer.isSelected()) {
                graphics.setColor(color);
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
                graphics.setColor(UIManager.getColor("NbTabControl.editorBorderShadowColor"));
                graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + n4 - (aquaEditorTabCellRenderer.isSelected() ? 1 : 2));
            }
            if (aquaEditorTabCellRenderer.isActive() && aquaEditorTabCellRenderer.isSelected()) {
                graphics.setColor(UIManager.getColor("NbTabControl.focusedTabBackground"));
                graphics.drawLine(n, n2 + 1, n + n3 - 1, n2 + 1);
                graphics.drawLine(n, n2 + 2, n + n3 - 1, n2 + 2);
            }
        }

        public void paintInterior(Graphics graphics, Component component) {
            AquaEditorTabCellRenderer aquaEditorTabCellRenderer = (AquaEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(aquaEditorTabCellRenderer);
            AquaEditorTabCellRenderer.paintTabGradient(graphics, aquaEditorTabCellRenderer, polygon);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public boolean supportsCloseButton(JComponent jComponent) {
            return false;
        }

        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            rectangle.setBounds(-20, -20, 0, 0);
        }
    }

    private static class AquaPainter
    implements TabPainter {
        private AquaPainter() {
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(0, 3, 0, 0);
        }

        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            AquaEditorTabCellRenderer aquaEditorTabCellRenderer = (AquaEditorTabCellRenderer)jComponent;
            if (!aquaEditorTabCellRenderer.isShowCloseButton()) {
                rectangle.x = -100;
                rectangle.y = -100;
                rectangle.width = 0;
                rectangle.height = 0;
                return;
            }
            String string = this.findIconPath(aquaEditorTabCellRenderer);
            Icon icon = TabControlButtonFactory.getIcon(string);
            int n = icon.getIconWidth();
            int n2 = icon.getIconHeight();
            rectangle.x = rectangle2.x + rectangle2.width - n - 5;
            rectangle.y = rectangle2.y + Math.max(0, rectangle2.height / 2 - n2 / 2);
            rectangle.width = n;
            rectangle.height = n2;
        }

        private String findIconPath(AquaEditorTabCellRenderer aquaEditorTabCellRenderer) {
            if (aquaEditorTabCellRenderer.inCloseButton() && aquaEditorTabCellRenderer.isPressed()) {
                return "org/netbeans/swing/tabcontrol/resources/mac_close_pressed.png";
            }
            if (aquaEditorTabCellRenderer.inCloseButton()) {
                return "org/netbeans/swing/tabcontrol/resources/mac_close_rollover.png";
            }
            return "org/netbeans/swing/tabcontrol/resources/mac_close_enabled.png";
        }

        public Polygon getInteriorPolygon(Component component) {
            AquaEditorTabCellRenderer aquaEditorTabCellRenderer = (AquaEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = 0;
            int n2 = 0;
            int n3 = aquaEditorTabCellRenderer.isRightmost() ? component.getWidth() - 1 : component.getWidth();
            int n4 = component.getHeight() - insets.bottom;
            polygon.addPoint(n, n2 + insets.top);
            polygon.addPoint(n + n3, n2 + insets.top);
            polygon.addPoint(n + n3, n2 + n4 - 1);
            polygon.addPoint(n, n2 + n4 - 1);
            return polygon;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AquaEditorTabCellRenderer aquaEditorTabCellRenderer = (AquaEditorTabCellRenderer)component;
            Color color = UIManager.getColor("NbTabControl.borderColor");
            Color color2 = UIManager.getColor("NbTabControl.borderShadowColor");
            graphics.setColor(color);
            graphics.drawLine(n, n2, n3 - 1, n2);
            if (!aquaEditorTabCellRenderer.isSelected()) {
                graphics.setColor(color);
                graphics.drawLine(n, n2 + n4 - 1, n3, n2 + n4 - 1);
            } else {
                graphics.setColor(UIManager.getColor("NbTabControl.selectedTabDarkerBackground"));
                graphics.drawLine(n, n2 + n4 - 1, n3, n2 + n4 - 1);
            }
            if (aquaEditorTabCellRenderer.isRightmost() || !aquaEditorTabCellRenderer.isSelected()) {
                graphics.setColor(color);
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
                graphics.setColor(color2);
                graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + n4 - (aquaEditorTabCellRenderer.isSelected() ? 1 : 2));
            } else if (aquaEditorTabCellRenderer.isSelected()) {
                graphics.setColor(color);
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
            }
            if (!aquaEditorTabCellRenderer.isLeftmost() && !aquaEditorTabCellRenderer.isSelected()) {
                graphics.setColor(color2);
                graphics.drawLine(n, n2 + 1, n, n2 + n4 - 2);
            }
        }

        public void paintInterior(Graphics graphics, Component component) {
            AquaEditorTabCellRenderer aquaEditorTabCellRenderer = (AquaEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(aquaEditorTabCellRenderer);
            AquaEditorTabCellRenderer.paintTabGradient(graphics, aquaEditorTabCellRenderer, polygon);
            Rectangle rectangle = new Rectangle();
            this.getCloseButtonRectangle(aquaEditorTabCellRenderer, rectangle, new Rectangle(0, 0, aquaEditorTabCellRenderer.getWidth(), aquaEditorTabCellRenderer.getHeight()));
            if (aquaEditorTabCellRenderer.isActive() && aquaEditorTabCellRenderer.isSelected()) {
                int n = 0;
                int n2 = 0;
                int n3 = aquaEditorTabCellRenderer.getWidth();
                graphics.setColor(UIManager.getColor("NbTabControl.focusedTabBackground"));
                graphics.drawLine(n, n2 + 1, n + n3 - 2, n2 + 1);
                graphics.drawLine(n, n2 + 2, n + n3 - 2, n2 + 2);
            }
            if (!graphics.hitClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                return;
            }
            String string = this.findIconPath(aquaEditorTabCellRenderer);
            Icon icon = TabControlButtonFactory.getIcon(string);
            icon.paintIcon(aquaEditorTabCellRenderer, graphics, rectangle.x, rectangle.y);
        }

        public boolean supportsCloseButton(JComponent jComponent) {
            return jComponent instanceof TabDisplayer ? ((TabDisplayer)jComponent).isShowCloseButton() : true;
        }
    }

    private static class AquaRightClipPainter
    implements TabPainter {
        private AquaRightClipPainter() {
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(0, 3, 0, 0);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Polygon getInteriorPolygon(Component component) {
            AquaEditorTabCellRenderer aquaEditorTabCellRenderer = (AquaEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = 0;
            int n2 = 0;
            int n3 = component.getWidth() + 1;
            int n4 = component.getHeight() - insets.bottom;
            polygon.addPoint(n, n2 + insets.top);
            polygon.addPoint(n + n3, n2 + insets.top);
            polygon.addPoint(n + n3, n2 + n4 - 1);
            polygon.addPoint(n, n2 + n4 - 1);
            return polygon;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AquaEditorTabCellRenderer aquaEditorTabCellRenderer = (AquaEditorTabCellRenderer)component;
            Color color = UIManager.getColor("NbTabControl.borderColor");
            graphics.setColor(color);
            graphics.drawLine(n, n2, n3, n2);
            if (!aquaEditorTabCellRenderer.isSelected()) {
                graphics.setColor(color);
                graphics.drawLine(n, n2 + n4 - 1, n3, n2 + n4 - 1);
            } else {
                graphics.setColor(UIManager.getColor("NbTabControl.selectedTabDarkerBackground"));
                graphics.drawLine(n, n2 + n4 - 1, n3, n2 + n4 - 1);
            }
            if (!aquaEditorTabCellRenderer.isLeftmost() && !aquaEditorTabCellRenderer.isSelected()) {
                graphics.setColor(UIManager.getColor("NbTabControl.editorBorderShadowColor"));
                graphics.drawLine(n, n2 + 1, n, n2 + n4 - 2);
            }
        }

        public void paintInterior(Graphics graphics, Component component) {
            AquaEditorTabCellRenderer aquaEditorTabCellRenderer = (AquaEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(aquaEditorTabCellRenderer);
            AquaEditorTabCellRenderer.paintTabGradient(graphics, aquaEditorTabCellRenderer, polygon);
            if (aquaEditorTabCellRenderer.isActive() && aquaEditorTabCellRenderer.isSelected()) {
                int n = 0;
                int n2 = 0;
                int n3 = aquaEditorTabCellRenderer.getWidth();
                graphics.setColor(UIManager.getColor("NbTabControl.focusedTabBackground"));
                graphics.drawLine(n, n2 + 1, n + n3, n2 + 1);
                graphics.drawLine(n, n2 + 2, n + n3, n2 + 2);
            }
        }

        public boolean supportsCloseButton(JComponent jComponent) {
            return false;
        }

        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            rectangle.setBounds(-20, -20, 0, 0);
        }
    }
}

