/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.codecoverage.api;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.util.Exceptions;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CoverageProviderHelper {
    private static final String COVERAGE_NAMESPACE_URI = "http://www.netbeans.org/ns/code-coverage/1";

    private CoverageProviderHelper() {
    }

    public static boolean isEnabled(Project project) {
        AuxiliaryConfiguration auxiliaryConfiguration = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        Element element = auxiliaryConfiguration.getConfigurationFragment("coverage", COVERAGE_NAMESPACE_URI, false);
        if (element == null) {
            return false;
        }
        return element.getAttribute("enabled").equals("true");
    }

    public static void setEnabled(Project project, boolean bl) {
        AuxiliaryConfiguration auxiliaryConfiguration = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        if (ProjectManager.getDefault().isValid(project)) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                Element element = document.createElementNS(COVERAGE_NAMESPACE_URI, "coverage");
                element.setAttribute("enabled", bl ? "true" : "false");
                auxiliaryConfiguration.putConfigurationFragment(element, false);
                ProjectManager.getDefault().saveProject(project);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Exceptions.printStackTrace((Throwable)illegalArgumentException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                Exceptions.printStackTrace((Throwable)parserConfigurationException);
            }
            catch (DOMException dOMException) {
                Exceptions.printStackTrace((Throwable)dOMException);
            }
        }
    }

    public static boolean isAggregating(Project project) {
        AuxiliaryConfiguration auxiliaryConfiguration = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        Element element = auxiliaryConfiguration.getConfigurationFragment("coverage", COVERAGE_NAMESPACE_URI, false);
        if (element == null) {
            return false;
        }
        return element.getAttribute("aggregating").equals("true");
    }

    public static void setAggregating(Project project, boolean bl) {
        AuxiliaryConfiguration auxiliaryConfiguration = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        if (ProjectManager.getDefault().isValid(project)) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                Element element = document.createElementNS(COVERAGE_NAMESPACE_URI, "coverage");
                element.setAttribute("aggregating", bl ? "true" : "false");
                auxiliaryConfiguration.putConfigurationFragment(element, false);
                ProjectManager.getDefault().saveProject(project);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Exceptions.printStackTrace((Throwable)illegalArgumentException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                Exceptions.printStackTrace((Throwable)parserConfigurationException);
            }
            catch (DOMException dOMException) {
                Exceptions.printStackTrace((Throwable)dOMException);
            }
        }
    }
}

