/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage.keybindings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.modules.editor.settings.storage.spi.StorageDescription;
import org.netbeans.modules.editor.settings.storage.spi.StorageReader;
import org.netbeans.modules.editor.settings.storage.spi.StorageWriter;
import org.netbeans.modules.editor.settings.storage.spi.support.StorageSupport;
import org.openide.filesystems.FileObject;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyMapsStorage
implements StorageDescription<Collection<KeyStroke>, MultiKeyBinding> {
    private static final Logger LOG = Logger.getLogger(KeyMapsStorage.class.getName());
    public static final String ID = "Keybindings";
    static final String MIME_TYPE = "text/x-nbeditor-keybindingsettings";
    private static final String ROOT = "bindings";
    private static final String E_BIND = "bind";
    private static final String A_ACTION_NAME = "actionName";
    private static final String A_KEY = "key";
    private static final String A_REMOVE = "remove";
    private static final String V_TRUE = "true";
    private static final String PUBLIC_ID = "-//NetBeans//DTD Editor KeyBindings settings 1.1//EN";
    private static final String SYSTEM_ID = "http://www.netbeans.org/dtds/EditorKeyBindings-1_1.dtd";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean isUsingProfiles() {
        return true;
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public String getLegacyFileName() {
        return "keybindings.xml";
    }

    @Override
    public StorageReader<Collection<KeyStroke>, MultiKeyBinding> createReader(FileObject fileObject, String string) {
        return new KeyMapsReader(fileObject, string);
    }

    @Override
    public StorageWriter<Collection<KeyStroke>, MultiKeyBinding> createWriter(FileObject fileObject, String string) {
        return new KeyMapsWriter();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyMapsReader
    extends StorageReader<Collection<KeyStroke>, MultiKeyBinding> {
        private Map<Collection<KeyStroke>, MultiKeyBinding> keyMap = new HashMap<Collection<KeyStroke>, MultiKeyBinding>();
        private Set<Collection<KeyStroke>> removedShortcuts = new HashSet<Collection<KeyStroke>>();

        public KeyMapsReader(FileObject fileObject, String string) {
            super(fileObject, string);
        }

        @Override
        public Map<Collection<KeyStroke>, MultiKeyBinding> getAdded() {
            return this.keyMap;
        }

        @Override
        public Set<Collection<KeyStroke>> getRemoved() {
            return this.removedShortcuts;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                if (!string3.equals(KeyMapsStorage.ROOT) && string3.equals(KeyMapsStorage.E_BIND)) {
                    String string4;
                    String string5 = attributes.getValue(KeyMapsStorage.A_KEY);
                    if (this.isModuleFile() && this.isDefaultProfile() && string5 != null && string5.length() > 0) {
                        int n = string5.indexOf(45);
                        string4 = this.getProcessedFile().getPath();
                        if (!(n == -1 || string5.charAt(0) != 'A' && string5.charAt(0) != 'C' || string4.endsWith("-mac.xml"))) {
                            LOG.warning("The keybinding '" + string5 + "' in " + string4 + " may not work correctly on Mac. " + "Keybindings starting with Alt or Ctrl should " + "be coded with latin capital letters 'O' " + "or 'D' respectively. For details see org.openide.util.Utilities.stringToKey().");
                        }
                    }
                    KeyStroke[] keyStrokeArray = StorageSupport.stringToKeyStrokes(string5, true);
                    string4 = attributes.getValue(KeyMapsStorage.A_REMOVE);
                    if (Boolean.valueOf(string4).booleanValue()) {
                        this.removedShortcuts.add(Arrays.asList(keyStrokeArray));
                    } else {
                        String string6 = attributes.getValue(KeyMapsStorage.A_ACTION_NAME);
                        if (string6 != null) {
                            MultiKeyBinding multiKeyBinding = new MultiKeyBinding(keyStrokeArray, string6);
                            LOG.fine("Adding: Key: '" + string5 + "' Action: '" + multiKeyBinding.getActionName() + "'");
                            MultiKeyBinding multiKeyBinding2 = this.keyMap.put(multiKeyBinding.getKeyStrokeList(), multiKeyBinding);
                            if (multiKeyBinding2 != null && !multiKeyBinding2.getActionName().equals(multiKeyBinding.getActionName())) {
                                LOG.warning("Duplicate shortcut '" + string5 + "' definition; rebound from '" + multiKeyBinding2.getActionName() + "' to '" + multiKeyBinding.getActionName() + "' in (" + this.getProcessedFile().getPath() + ").");
                            }
                        } else {
                            LOG.warning("Ignoring keybinding '" + string5 + "' with no action name.");
                        }
                    }
                }
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Can't parse keybindings file " + this.getProcessedFile().getPath(), exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class KeyMapsWriter
    extends StorageWriter<Collection<KeyStroke>, MultiKeyBinding> {
        private static final Comparator<MultiKeyBinding> ACTION_NAME_COMPARATOR = new Comparator<MultiKeyBinding>(){

            @Override
            public int compare(MultiKeyBinding multiKeyBinding, MultiKeyBinding multiKeyBinding2) {
                String string = multiKeyBinding.getActionName();
                String string2 = multiKeyBinding2.getActionName();
                return string.compareToIgnoreCase(string2);
            }
        };

        @Override
        public Document getDocument() {
            Object object;
            Document document = XMLUtil.createDocument((String)KeyMapsStorage.ROOT, null, (String)KeyMapsStorage.PUBLIC_ID, (String)KeyMapsStorage.SYSTEM_ID);
            Node node = document.getElementsByTagName(KeyMapsStorage.ROOT).item(0);
            ArrayList arrayList = new ArrayList(this.getAdded().values());
            Collections.sort(arrayList, ACTION_NAME_COMPARATOR);
            for (Object object2 : arrayList) {
                object = document.createElement(KeyMapsStorage.E_BIND);
                node.appendChild((Node)object);
                object.setAttribute(KeyMapsStorage.A_ACTION_NAME, object2.getActionName());
                object.setAttribute(KeyMapsStorage.A_KEY, StorageSupport.keyStrokesToString(object2.getKeyStrokeList(), true));
            }
            for (Object object2 : this.getRemoved()) {
                object = StorageSupport.keyStrokesToString((Collection<? extends KeyStroke>)object2, true);
                Element element = document.createElement(KeyMapsStorage.E_BIND);
                node.appendChild(element);
                element.setAttribute(KeyMapsStorage.A_KEY, (String)object);
                element.setAttribute(KeyMapsStorage.A_REMOVE, KeyMapsStorage.V_TRUE);
            }
            return document;
        }
    }
}

