/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage.fontscolors;

import java.awt.Color;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.editor.settings.storage.SettingsType;
import org.netbeans.modules.editor.settings.storage.StorageImpl;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.spi.StorageDescription;
import org.netbeans.modules.editor.settings.storage.spi.StorageReader;
import org.netbeans.modules.editor.settings.storage.spi.StorageWriter;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ColoringStorage
implements StorageDescription<String, AttributeSet>,
StorageImpl.Operations<String, AttributeSet> {
    private static final Logger LOG = Logger.getLogger(ColoringStorage.class.getName());
    public static final String ID = "FontsColors";
    static final String MIME_TYPE = "text/x-nbeditor-fontcolorsettings";
    private static final String HIGHLIGHTING_FILE_NAME = "editorColoring.xml";
    private static final String E_ROOT = "fontscolors";
    private static final String E_FONTCOLOR = "fontcolor";
    private static final String E_FONT = "font";
    private static final String A_NAME = "name";
    private static final String A_FOREGROUND = "foreColor";
    private static final String A_BACKGROUND = "bgColor";
    private static final String A_STRIKETHROUGH = "strikeThrough";
    private static final String A_WAVEUNDERLINE = "waveUnderlined";
    private static final String A_UNDERLINE = "underline";
    private static final String A_DEFAULT = "default";
    private static final String A_SIZE = "size";
    private static final String A_STYLE = "style";
    private static final String V_BOLD_ITALIC = "bold+italic";
    private static final String V_BOLD = "bold";
    private static final String V_ITALIC = "italic";
    private static final String V_PLAIN = "plain";
    private static final String PUBLIC_ID = "-//NetBeans//DTD Editor Fonts and Colors settings 1.1//EN";
    private static final String SYSTEM_ID = "http://www.netbeans.org/dtds/EditorFontsColors-1_1.dtd";
    private static final String FA_TYPE = "nbeditor-settings-ColoringType";
    private static final String FAV_TOKEN = "token";
    private static final String FAV_HIGHLIGHT = "highlight";
    private static final Object ATTR_MODULE_SUPPLIED = new Object();
    private final boolean tokenColoringStorage;
    private static final Map<Color, String> colorToName = new HashMap<Color, String>();
    private static final Map<String, Color> nameToColor = new HashMap<String, Color>();

    public ColoringStorage(boolean bl) {
        this.tokenColoringStorage = bl;
    }

    public ColoringStorage() {
        this(true);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean isUsingProfiles() {
        return true;
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public String getLegacyFileName() {
        return null;
    }

    @Override
    public StorageReader<String, AttributeSet> createReader(FileObject fileObject, String string) {
        throw new UnsupportedOperationException("Should not be called.");
    }

    @Override
    public StorageWriter<String, AttributeSet> createWriter(FileObject fileObject, String string) {
        throw new UnsupportedOperationException("Should not be called.");
    }

    @Override
    public Map<String, AttributeSet> load(MimePath mimePath, String string, boolean bl) {
        List<Object[]> list;
        HashMap<String, List<Object[]>> hashMap;
        assert (mimePath != null) : "The parameter mimePath must not be null";
        assert (string != null) : "The parameter profile must not be null";
        FileObject fileObject = FileUtil.getConfigFile((String)"Editors");
        HashMap<String, List<Object[]>> hashMap2 = new HashMap<String, List<Object[]>>();
        SettingsType.Locator locator = SettingsType.getLocator(this);
        locator.scan(fileObject, mimePath.getPath(), string, true, true, !bl, false, hashMap2);
        assert (hashMap2.size() <= 1) : "Too many results in the scan";
        List<Object[]> list2 = (List<Object[]>)hashMap2.get(string);
        if (list2 == null) {
            return Collections.emptyMap();
        }
        if (!string.equals("NetBeans")) {
            hashMap = new HashMap<String, List<Object[]>>();
            locator.scan(fileObject, mimePath.getPath(), "NetBeans", true, true, false, false, hashMap);
            list = (List)hashMap.get("NetBeans");
            if (list == null) {
                list = Collections.emptyList();
            }
        } else {
            list = list2;
        }
        hashMap = new HashMap();
        for (Object[] objectArray : list2) {
            assert (objectArray.length == 5);
            FileObject fileObject2 = (FileObject)objectArray[0];
            FileObject fileObject3 = (FileObject)objectArray[1];
            int n = ((Boolean)objectArray[2]).booleanValue();
            boolean bl2 = (Boolean)objectArray[4];
            boolean bl3 = ColoringStorage.isTokenColoringFile(fileObject3);
            if (bl3 != this.tokenColoringStorage) continue;
            ColoringsReader coloringsReader = new ColoringsReader(fileObject3, mimePath.getPath());
            Utils.load(fileObject3, coloringsReader, !bl2);
            Map<String, SimpleAttributeSet> map = coloringsReader.getAdded();
            for (SimpleAttributeSet simpleAttributeSet : map.values()) {
                int n2;
                String string2 = (String)simpleAttributeSet.getAttribute(StyleConstants.NameAttribute);
                String string3 = null;
                SimpleAttributeSet simpleAttributeSet2 = (SimpleAttributeSet)hashMap.get(string2);
                if (simpleAttributeSet2 == null && !n && this.tokenColoringStorage && (n2 = string2.indexOf(45)) != -1 && (simpleAttributeSet2 = (SimpleAttributeSet)hashMap.get(string3 = string2.substring(n2 + 1))) != null) {
                    simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, string3);
                    string2 = string3;
                }
                if (simpleAttributeSet2 == null) {
                    String string4 = ColoringStorage.findDisplayName(string2, fileObject3, list);
                    if (string4 == null && !n) {
                        if (string3 != null) {
                            string4 = ColoringStorage.findDisplayName(string3, fileObject3, list);
                        }
                        if (string4 == null) {
                            if (!LOG.isLoggable(Level.FINE)) continue;
                            LOG.fine("Ignoring an extra coloring '" + string2 + "' that was not defined by modules.");
                            continue;
                        }
                        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, string3);
                        string2 = string3;
                    }
                    if (string4 == null) {
                        string4 = string2;
                    }
                    simpleAttributeSet.addAttribute(EditorStyleConstants.DisplayName, string4);
                    simpleAttributeSet.addAttribute(ATTR_MODULE_SUPPLIED, n != 0);
                    hashMap.put(string2, (List<Object[]>)((Object)simpleAttributeSet));
                    continue;
                }
                n2 = ((Boolean)simpleAttributeSet2.getAttribute(ATTR_MODULE_SUPPLIED)).booleanValue();
                if (n2 == n) {
                    ColoringStorage.mergeAttributeSets(simpleAttributeSet2, simpleAttributeSet);
                    continue;
                }
                simpleAttributeSet.addAttribute(EditorStyleConstants.DisplayName, simpleAttributeSet2.getAttribute(EditorStyleConstants.DisplayName));
                Object object = simpleAttributeSet2.getAttribute(EditorStyleConstants.Default);
                if (object != null) {
                    simpleAttributeSet.addAttribute(EditorStyleConstants.Default, object);
                }
                simpleAttributeSet.addAttribute(ATTR_MODULE_SUPPLIED, n != 0);
                hashMap.put(string2, (List<Object[]>)((Object)simpleAttributeSet));
            }
        }
        return Utils.immutize(hashMap, ATTR_MODULE_SUPPLIED);
    }

    @Override
    public boolean save(MimePath mimePath, String string, boolean bl, final Map<String, AttributeSet> map, final Map<String, AttributeSet> map2) throws IOException {
        assert (mimePath != null) : "The parameter mimePath must not be null";
        assert (string != null) : "The parameter profile must not be null";
        final String string2 = SettingsType.getLocator(this).getWritableFileName(mimePath.getPath(), string, this.tokenColoringStorage ? "-tokenColorings" : "-highlights", bl);
        FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileObject fileObject = FileUtil.getConfigFile((String)"Editors");
                FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string2);
                fileObject2.setAttribute(ColoringStorage.FA_TYPE, (Object)(ColoringStorage.this.tokenColoringStorage ? ColoringStorage.FAV_TOKEN : ColoringStorage.FAV_HIGHLIGHT));
                HashMap hashMap = new HashMap();
                HashMap hashMap2 = new HashMap();
                Utils.diff(map2, map, hashMap, hashMap2);
                ColoringsWriter coloringsWriter = new ColoringsWriter();
                coloringsWriter.setAdded(hashMap);
                coloringsWriter.setRemoved(hashMap2.keySet());
                Utils.save(fileObject2, coloringsWriter);
            }
        });
        return true;
    }

    @Override
    public void delete(MimePath mimePath, String string, boolean bl) throws IOException {
        assert (mimePath != null) : "The parameter mimePath must not be null";
        assert (string != null) : "The parameter profile must not be null";
        FileObject fileObject = FileUtil.getConfigFile((String)"Editors");
        HashMap<String, List<Object[]>> hashMap = new HashMap<String, List<Object[]>>();
        SettingsType.getLocator(this).scan(fileObject, mimePath.getPath(), string, true, bl, !bl, false, hashMap);
        assert (hashMap.size() <= 1) : "Too many results in the scan";
        final List list = (List)hashMap.get(string);
        if (list != null) {
            FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    for (Object[] objectArray : list) {
                        FileObject fileObject = (FileObject)objectArray[1];
                        boolean bl = ColoringStorage.isTokenColoringFile(fileObject);
                        if (bl != ColoringStorage.this.tokenColoringStorage) continue;
                        fileObject.delete();
                    }
                }
            });
        }
    }

    private static String findDisplayName(String string, FileObject fileObject, List<Object[]> list) {
        String string2;
        block1: {
            Object[] objectArray;
            FileObject fileObject2;
            string2 = Utils.getLocalizedName(fileObject, string, null, true);
            if (string2 != null) break block1;
            Iterator<Object[]> iterator = list.iterator();
            while (iterator.hasNext() && (string2 = Utils.getLocalizedName(fileObject2 = (FileObject)(objectArray = iterator.next())[1], string, null, true)) == null) {
            }
        }
        return string2;
    }

    private static void mergeAttributeSets(SimpleAttributeSet simpleAttributeSet, AttributeSet attributeSet) {
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            Object object = attributeSet.getAttribute(obj);
            simpleAttributeSet.addAttribute(obj, object);
        }
    }

    private static boolean isTokenColoringFile(FileObject fileObject) {
        Object object = fileObject.getAttribute(FA_TYPE);
        if (object instanceof String) {
            return object.equals(FAV_TOKEN);
        }
        return !fileObject.getNameExt().equals(HIGHLIGHTING_FILE_NAME);
    }

    private static String colorToString(Color color) {
        if (colorToName.containsKey(color)) {
            return colorToName.get(color);
        }
        return Integer.toHexString(color.getRGB());
    }

    private static Color stringToColor(String string) throws Exception {
        if (nameToColor.containsKey(string)) {
            return nameToColor.get(string);
        }
        try {
            return new Color((int)Long.parseLong(string, 16));
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception();
        }
    }

    static {
        colorToName.put(Color.black, "black");
        nameToColor.put("black", Color.black);
        colorToName.put(Color.blue, "blue");
        nameToColor.put("blue", Color.blue);
        colorToName.put(Color.cyan, "cyan");
        nameToColor.put("cyan", Color.cyan);
        colorToName.put(Color.darkGray, "darkGray");
        nameToColor.put("darkGray", Color.darkGray);
        colorToName.put(Color.gray, "gray");
        nameToColor.put("gray", Color.gray);
        colorToName.put(Color.green, "green");
        nameToColor.put("green", Color.green);
        colorToName.put(Color.lightGray, "lightGray");
        nameToColor.put("lightGray", Color.lightGray);
        colorToName.put(Color.magenta, "magenta");
        nameToColor.put("magenta", Color.magenta);
        colorToName.put(Color.orange, "orange");
        nameToColor.put("orange", Color.orange);
        colorToName.put(Color.pink, "pink");
        nameToColor.put("pink", Color.pink);
        colorToName.put(Color.red, "red");
        nameToColor.put("red", Color.red);
        colorToName.put(Color.white, "white");
        nameToColor.put("white", Color.white);
        colorToName.put(Color.yellow, "yellow");
        nameToColor.put("yellow", Color.yellow);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColoringsReader
    extends StorageReader<String, SimpleAttributeSet> {
        private final Map<String, SimpleAttributeSet> colorings = new HashMap<String, SimpleAttributeSet>();
        private SimpleAttributeSet attribs = null;

        public ColoringsReader(FileObject fileObject, String string) {
            super(fileObject, string);
        }

        @Override
        public Map<String, SimpleAttributeSet> getAdded() {
            return this.colorings;
        }

        @Override
        public Set<String> getRemoved() {
            return Collections.emptySet();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            block16: {
                try {
                    if (string3.equals(ColoringStorage.E_ROOT)) break block16;
                    if (string3.equals(ColoringStorage.E_FONTCOLOR)) {
                        assert (this.attribs == null);
                        this.attribs = new SimpleAttributeSet();
                        String string4 = attributes.getValue(ColoringStorage.A_NAME);
                        this.attribs.addAttribute(StyleConstants.NameAttribute, string4);
                        String string5 = attributes.getValue(ColoringStorage.A_BACKGROUND);
                        if (string5 != null) {
                            this.attribs.addAttribute(StyleConstants.Background, ColoringStorage.stringToColor(string5));
                        }
                        if ((string5 = attributes.getValue(ColoringStorage.A_FOREGROUND)) != null) {
                            this.attribs.addAttribute(StyleConstants.Foreground, ColoringStorage.stringToColor(string5));
                        }
                        if ((string5 = attributes.getValue(ColoringStorage.A_UNDERLINE)) != null) {
                            this.attribs.addAttribute(StyleConstants.Underline, ColoringStorage.stringToColor(string5));
                        }
                        if ((string5 = attributes.getValue(ColoringStorage.A_STRIKETHROUGH)) != null) {
                            this.attribs.addAttribute(StyleConstants.StrikeThrough, ColoringStorage.stringToColor(string5));
                        }
                        if ((string5 = attributes.getValue(ColoringStorage.A_WAVEUNDERLINE)) != null) {
                            this.attribs.addAttribute(EditorStyleConstants.WaveUnderlineColor, ColoringStorage.stringToColor(string5));
                        }
                        if ((string5 = attributes.getValue(ColoringStorage.A_DEFAULT)) != null) {
                            this.attribs.addAttribute(EditorStyleConstants.Default, string5);
                        }
                        this.colorings.put(string4, this.attribs);
                        break block16;
                    }
                    if (!string3.equals(ColoringStorage.E_FONT)) break block16;
                    assert (this.attribs != null);
                    String string6 = attributes.getValue(ColoringStorage.A_NAME);
                    if (string6 != null) {
                        this.attribs.addAttribute(StyleConstants.FontFamily, string6);
                    }
                    if ((string6 = attributes.getValue(ColoringStorage.A_SIZE)) != null) {
                        try {
                            this.attribs.addAttribute(StyleConstants.FontSize, Integer.decode(string6));
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOG.log(Level.WARNING, string6 + " is not a valid Integer; parsing attribute " + ColoringStorage.A_SIZE + this.getProcessedFile().getPath(), numberFormatException);
                        }
                    }
                    if ((string6 = attributes.getValue(ColoringStorage.A_STYLE)) != null) {
                        this.attribs.addAttribute(StyleConstants.Bold, string6.indexOf(ColoringStorage.V_BOLD) >= 0);
                        this.attribs.addAttribute(StyleConstants.Italic, string6.indexOf(ColoringStorage.V_ITALIC) >= 0);
                    }
                }
                catch (Exception exception) {
                    LOG.log(Level.WARNING, "Can't parse colorings file " + this.getProcessedFile().getPath(), exception);
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals(ColoringStorage.E_FONTCOLOR)) {
                this.attribs = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ColoringsWriter
    extends StorageWriter<String, AttributeSet> {
        @Override
        public Document getDocument() {
            Document document = XMLUtil.createDocument((String)ColoringStorage.E_ROOT, null, (String)ColoringStorage.PUBLIC_ID, (String)ColoringStorage.SYSTEM_ID);
            Node node = document.getElementsByTagName(ColoringStorage.E_ROOT).item(0);
            for (AttributeSet attributeSet : this.getAdded().values()) {
                Element element = document.createElement(ColoringStorage.E_FONTCOLOR);
                node.appendChild(element);
                element.setAttribute(ColoringStorage.A_NAME, (String)attributeSet.getAttribute(StyleConstants.NameAttribute));
                if (attributeSet.isDefined(StyleConstants.Foreground)) {
                    element.setAttribute(ColoringStorage.A_FOREGROUND, ColoringStorage.colorToString((Color)attributeSet.getAttribute(StyleConstants.Foreground)));
                }
                if (attributeSet.isDefined(StyleConstants.Background)) {
                    element.setAttribute(ColoringStorage.A_BACKGROUND, ColoringStorage.colorToString((Color)attributeSet.getAttribute(StyleConstants.Background)));
                }
                if (attributeSet.isDefined(StyleConstants.StrikeThrough)) {
                    element.setAttribute(ColoringStorage.A_STRIKETHROUGH, ColoringStorage.colorToString((Color)attributeSet.getAttribute(StyleConstants.StrikeThrough)));
                }
                if (attributeSet.isDefined(EditorStyleConstants.WaveUnderlineColor)) {
                    element.setAttribute(ColoringStorage.A_WAVEUNDERLINE, ColoringStorage.colorToString((Color)attributeSet.getAttribute(EditorStyleConstants.WaveUnderlineColor)));
                }
                if (attributeSet.isDefined(StyleConstants.Underline)) {
                    element.setAttribute(ColoringStorage.A_UNDERLINE, ColoringStorage.colorToString((Color)attributeSet.getAttribute(StyleConstants.Underline)));
                }
                if (attributeSet.isDefined(EditorStyleConstants.Default)) {
                    element.setAttribute(ColoringStorage.A_DEFAULT, (String)attributeSet.getAttribute(EditorStyleConstants.Default));
                }
                if (!attributeSet.isDefined(StyleConstants.FontFamily) && !attributeSet.isDefined(StyleConstants.FontSize) && !attributeSet.isDefined(StyleConstants.Bold) && !attributeSet.isDefined(StyleConstants.Italic)) continue;
                Element element2 = document.createElement(ColoringStorage.E_FONT);
                element.appendChild(element2);
                if (attributeSet.isDefined(StyleConstants.FontFamily)) {
                    element2.setAttribute(ColoringStorage.A_NAME, (String)attributeSet.getAttribute(StyleConstants.FontFamily));
                }
                if (attributeSet.isDefined(StyleConstants.FontSize)) {
                    element2.setAttribute(ColoringStorage.A_SIZE, ((Integer)attributeSet.getAttribute(StyleConstants.FontSize)).toString());
                }
                if (!attributeSet.isDefined(StyleConstants.Bold) && !attributeSet.isDefined(StyleConstants.Italic)) continue;
                Boolean bl = Boolean.FALSE;
                Boolean bl2 = Boolean.FALSE;
                if (attributeSet.isDefined(StyleConstants.Bold)) {
                    bl = (Boolean)attributeSet.getAttribute(StyleConstants.Bold);
                }
                if (attributeSet.isDefined(StyleConstants.Italic)) {
                    bl2 = (Boolean)attributeSet.getAttribute(StyleConstants.Italic);
                }
                element2.setAttribute(ColoringStorage.A_STYLE, bl.booleanValue() ? (bl2.booleanValue() ? ColoringStorage.V_BOLD_ITALIC : ColoringStorage.V_BOLD) : (bl2 != false ? ColoringStorage.V_ITALIC : ColoringStorage.V_PLAIN));
            }
            return document;
        }
    }
}

